/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.swing;

import de.datomino.peppergis.area.action.CreateParcelAreaRelationsForLayerByGeometryAction;
import de.datomino.peppergis.client.auth.UserInformation;
import de.datomino.peppergis.client.autoupdate.AutoUpdater;
import de.datomino.peppergis.client.communication.AllCaller;
import de.datomino.peppergis.client.communication.GeoServerStub;
import de.datomino.peppergis.client.event.ApplicationMessage;
import de.datomino.peppergis.client.external.communication.ClientExternalRemoteService;
import de.datomino.peppergis.client.frey.FreyHandler;
import de.datomino.peppergis.client.frey.FreyHandlerImpl;
import de.datomino.peppergis.client.gui.exception.StaleStateExceptionDialog;
import de.datomino.peppergis.client.gui.login.LoginPane;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.admin.UserModel;
import de.datomino.peppergis.client.swing.AbstractPepperGisInternalFrame;
import de.datomino.peppergis.client.swing.PepperGisDesktopApplicationActions;
import de.datomino.peppergis.client.swing.action.configuration.ShowAttributeGroupDialogAction;
import de.datomino.peppergis.client.swing.action.configuration.ShowBranchConfigrationDialogAction;
import de.datomino.peppergis.client.swing.action.configuration.ShowImageConfigurationAction;
import de.datomino.peppergis.client.swing.action.configuration.ShowPdfConfigurationAction;
import de.datomino.peppergis.client.swing.action.configuration.ShowPrintConfigrationDialogAction;
import de.datomino.peppergis.client.swing.action.configuration.ShowPropertiesAction;
import de.datomino.peppergis.client.swing.action.configuration.area.ShowAreaAttributeValueDescriptorDialogAction;
import de.datomino.peppergis.client.swing.action.configuration.area.ShowAreaFilterConfigurationDialogAction;
import de.datomino.peppergis.client.swing.action.configuration.area.ShowAreaFilterPatternSetupDialogAction;
import de.datomino.peppergis.client.swing.action.configuration.area.ShowAreaLayerDialogAction;
import de.datomino.peppergis.client.swing.action.configuration.customer.ShowAgencyConfigurationAction;
import de.datomino.peppergis.client.swing.action.configuration.letter.ShowLetterAttributeValueDescriptorDialogAction;
import de.datomino.peppergis.client.swing.action.configuration.letter.ShowLetterFilterConfigurationDialogAction;
import de.datomino.peppergis.client.swing.action.configuration.letter.ShowLetterFilterPatternSetupDialogAction;
import de.datomino.peppergis.client.swing.action.configuration.parcel.ShowParcelAttributeValueDescriptorDialogAction;
import de.datomino.peppergis.client.swing.action.configuration.parcel.ShowParcelFilterConfigurationDialogAction;
import de.datomino.peppergis.client.swing.action.configuration.parcel.ShowParcelFilterPatternSetupDialogAction;
import de.datomino.peppergis.client.swing.action.configuration.poi.ShowPoiAttributeValueDescriptorDialogAction;
import de.datomino.peppergis.client.swing.action.configuration.poi.ShowPoiFilterConfigurationDialogAction;
import de.datomino.peppergis.client.swing.action.configuration.poi.ShowPoiFilterPatternSetupDialogAction;
import de.datomino.peppergis.client.swing.action.configuration.subscription.ShowSubscriptionAttributeValueDescriptorDialogAction;
import de.datomino.peppergis.client.swing.action.configuration.subscription.ShowSubscriptionFilterConfigurationDialogAction;
import de.datomino.peppergis.client.swing.action.configuration.subscription.ShowSubscriptionFilterPatternSetupDialogAction;
import de.datomino.peppergis.client.swing.action.export.ExportAreaLayerAction;
import de.datomino.peppergis.client.swing.action.tool.AggregateAreaAttributeValueAction;
import de.datomino.peppergis.client.swing.event.ApplicationGlobalEventHandlerImpl;
import de.datomino.peppergis.client.swing.license.LicenseManager;
import de.datomino.peppergis.client.swing.offer.OpenOfferAction;
import de.datomino.peppergis.clienttools.action.DeleteEmptyAreaAction;
import de.datomino.peppergis.clienttools.action.FindAloneInAreaAction;
import de.datomino.peppergis.clienttools.action.InternalSearchAddressAction;
import de.datomino.peppergis.clienttools.action.ParcelAreaMappingAction;
import de.datomino.peppergis.clienttools.action.RemoveParcelRoutingSegmentAction;
import de.datomino.peppergis.clienttools.action.RoutingSegmentEvaluationAction;
import de.datomino.peppergis.clienttools.action.geosearch.CoordinateSearchingAction;
import de.datomino.peppergis.clienttools.action.geosearch.HousenumberRangeSearchingAction;
import de.datomino.peppergis.clienttools.action.geosearch.HousenumberSearchingAction;
import de.datomino.peppergis.clienttools.action.geosearch.PostcodeDistrictReleationSearchingAction;
import de.datomino.peppergis.clienttools.action.geosearch.StreetSearchingAction;
import de.datomino.peppergis.clienttools.action.review.ReviewAreaToursAction;
import de.datomino.peppergis.configuration.gui.actions.ExportCityAliasAction;
import de.datomino.peppergis.configuration.gui.actions.ExportDistrictAliasAction;
import de.datomino.peppergis.configuration.gui.actions.ExportParcelAction;
import de.datomino.peppergis.configuration.gui.actions.ExportParcelsOfChangedAreasAction;
import de.datomino.peppergis.configuration.gui.actions.ExportParcelsWithBadSegmentAction;
import de.datomino.peppergis.configuration.gui.actions.ExportPoisAction;
import de.datomino.peppergis.configuration.gui.actions.ExportStreetAliasAction;
import de.datomino.peppergis.configuration.gui.actions.ExportSubscriptionsAction;
import de.datomino.peppergis.configuration.gui.actions.ProcessLettersWithoutParcelAction;
import de.datomino.peppergis.configuration.gui.actions.ProcessSubscriptionsWithoutParcelAction;
import de.datomino.peppergis.configuration.gui.actions.ShowJobControlAction;
import de.datomino.peppergis.configuration.gui.actions.ShowServerTaskAction;
import de.datomino.peppergis.configuration.gui.actions.ShowUserJobAction;
import de.datomino.peppergis.configuration.gui.actions.ShowUserManagementAction;
import de.datomino.peppergis.configuration.gui.actions.TriggerMapUpdateAction;
import de.datomino.peppergis.exception.StaleStateException;
import de.datomino.peppergis.importer.action.AreaFromConvexHullCsvImportAction;
import de.datomino.peppergis.importer.action.AreaFromShpImportAction;
import de.datomino.peppergis.importer.action.ImportAreaAttributeValueAction;
import de.datomino.peppergis.importer.action.ImportAreaDelivererAction;
import de.datomino.peppergis.importer.action.ImportDelivererAction;
import de.datomino.peppergis.importer.action.ImportGeoTrackCsvAction;
import de.datomino.peppergis.importer.action.ImportGeoTrackGpxAction;
import de.datomino.peppergis.importer.action.ImportLetterAttributeValueAction;
import de.datomino.peppergis.importer.action.ImportParcelAttributeValueAction;
import de.datomino.peppergis.importer.action.ImportPoiAction;
import de.datomino.peppergis.importer.action.ImportPoiAttributeValueAction;
import de.datomino.peppergis.importer.action.ImportSubscriptionAttributeValueAction;
import de.datomino.peppergis.importer.action.ImportTourAction;
import de.datomino.peppergis.importer.action.LetterImportAction;
import de.datomino.peppergis.importer.action.MultipleParcelEditorAction;
import de.datomino.peppergis.importer.action.ParcelAreaRelationImportAction;
import de.datomino.peppergis.importer.action.ParcelImportAction;
import de.datomino.peppergis.importer.action.RecalcAreaByParcelRelAction;
import de.datomino.peppergis.importer.action.SubscriptionImportAction;
import de.datomino.peppergis.importer.action.alias.ImportCityAliasAction;
import de.datomino.peppergis.importer.action.alias.ImportDistrictAliasAction;
import de.datomino.peppergis.importer.action.alias.ImportStreetAliasAction;
import de.datomino.peppergis.type.AttributeGroupType;
import de.datomino.peppergis.type.UserRole;
import de.datomino.peppergis.webportal.action.OpenWebportalControlAction;
import de.datomino.util.PropertyUtil;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.collection.Transformer;
import de.datomino.util.message.MessageResolver;
import de.datomino.util.message.MessageResolverImpl;
import de.datomino.util.swing.ExceptionMessageDialog;
import de.datomino.util.swing.SwingUtils;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import org.apache.commons.lang.math.NumberUtils;
import org.ktde.ee.layer.mgmt.ManagementBi;
import org.ktde.ee.rmi.AuthenticationException;
import org.ktde.ee.rmi.CommType;
import org.ktde.ee.rmi.KickedAuthenticationException;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.math.projection.Wgs84Factory;
import org.ktde.swing.DesktopClientApplication;
import org.ktde.swing.navigator.AbstractNavigatorRenderer;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.swing.navigator.NavigatorPanningAction;
import org.ktde.swing.navigator.NavigatorRenderer;
import org.ktde.swing.navigator.OnTopRendering;
import org.ktde.util.StringUtil;
import org.ktde.util.application.ClientApplicationProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

public class PepperGisDesktopApplication
extends DesktopClientApplication<AbstractPepperGisInternalFrame> {
    private static final long serialVersionUID = 6735868494240882715L;
    private static final Logger LOGGER = LoggerFactory.getLogger(PepperGisDesktopApplication.class);
    private static Thread LOGOUT_SHUTDOWN_HOOK;
    public static final String APPLICATION_NAME = "peppergis-client";
    private GeoServerStub geoServerStub;
    private ManagementBi managementBo;
    private NavigatorPanel currentNavigatorPanel;
    private ApplicationGlobalEventHandlerImpl applicationGlobalEventHandler;
    private FreyHandler freyHandler;
    private LicenseManager licenseManager;
    private NavigatorRenderer coordStatus = new AbstractNavigatorRenderer("CoordStatusRenderer"){

        @Override
        public Collection<OnTopRendering> paintOnto(Graphics2D g2d, Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
            CoordinateFactory factory = this.getCoordinateFactory();
            Coordinate bottomLeft = Wgs84Factory.INSTANCE.createCoordinate(factory.createCoordinate(realBoundaryBottomLeft.getX(), realBoundaryBottomLeft.getY()));
            Coordinate topRight = Wgs84Factory.INSTANCE.createCoordinate(factory.createCoordinate(realBoundaryTopRight.getX(), realBoundaryTopRight.getY()));
            PepperGisDesktopApplication.this.setStatus("(" + factory.getStringX(bottomLeft) + ", " + factory.getStringY(bottomLeft) + ") - (" + factory.getStringX(topRight) + ", " + factory.getStringY(topRight) + ")");
            return Collections.emptyList();
        }

        @Override
        public void prepare(Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
        }
    };

    public PepperGisDesktopApplication(Properties properties) throws Exception {
        super(ModelEnviroment.getMessageResolver().resolveMessage("gui.peppergis.client", new Serializable[0]) + PepperGisDesktopApplication.getVersion(properties), properties, new PepperGisDesktopApplicationActions(), 1);
        String disablePretty = System.getProperty("disablePretty");
        if (!StringUtil.isTrue(disablePretty)) {
            try {
                double osVersion;
                System.out.println("Setting icon image");
                this.setIconImage(ImageIO.read(PepperGisDesktopApplication.class.getResourceAsStream("/images/pepper.png")));
                System.out.println("Setting default look and feel decorated");
                JDialog.setDefaultLookAndFeelDecorated(true);
                double javaVersion = Double.parseDouble(System.getProperty("java.specification.version"));
                String[] osName = System.getProperty("os.name").toLowerCase().split(" ");
                double d = osVersion = NumberUtils.isNumber(osName[1]) ? Double.parseDouble(osName[1]) : 0.0;
                if (javaVersion < 1.9 && osName[0].equals("windows") && osVersion > 8.0) {
                    HashMap<String, String> iconMap = new HashMap<String, String>();
                    iconMap.put("OptionPane.errorIcon", "65581");
                    iconMap.put("OptionPane.warningIcon", "65577");
                    iconMap.put("OptionPane.questionIcon", null);
                    iconMap.put("OptionPane.informationIcon", "65583");
                    System.out.println("getting method");
                    Method method = Class.forName("sun.awt.shell.Win32ShellFolder2").getDeclaredMethod("getIconBits", Long.TYPE, Integer.TYPE);
                    method.setAccessible(true);
                    System.out.println("Calculating factor");
                    int screenResolution = Toolkit.getDefaultToolkit().getScreenResolution();
                    System.out.println("Calculating new size");
                    double factor = (double)screenResolution / 96.0;
                    int newSize = (int)(32.0 * factor);
                    BufferedImage pepperBi = ImageIO.read(PepperGisDesktopApplication.class.getResourceAsStream("/images/pepper.png"));
                    System.out.println("Setting icons");
                    for (String iconName : iconMap.keySet()) {
                        if (!(UIManager.get(iconName) instanceof ImageIcon)) continue;
                        String hiIcon = (String)iconMap.get(iconName);
                        Image img = pepperBi.getScaledInstance(newSize, newSize, 4);
                        if (hiIcon != null) {
                            int[] iconBits = (int[])method.invoke(null, Long.valueOf(hiIcon), newSize);
                            BufferedImage bi = new BufferedImage(newSize, newSize, 2);
                            bi.setRGB(0, 0, newSize, newSize, iconBits, 0, newSize);
                            img = bi;
                        }
                        ImageIcon newIcon = new ImageIcon(img);
                        UIManager.put(iconName, newIcon);
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    private static String getVersion(Properties properties) {
        String version = properties.getProperty("peppergis.client.version.show");
        version = version == null ? "" : "V" + version;
        return version;
    }

    private void doSslSettings() {
        block15: {
            File crtDir;
            File home = ClientApplicationProperties.getPropBase(APPLICATION_NAME);
            LinkedList<File> crtFiles = new LinkedList<File>();
            File crtFile = new File(home, "peppergis.crt");
            if (crtFile.exists()) {
                crtFiles.add(crtFile);
            }
            if ((crtDir = new File(home, "certs")).exists() && crtDir.isDirectory()) {
                File[] lFiles = crtDir.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith(".crt");
                    }
                });
                crtFiles.addAll(Arrays.asList(lFiles));
            }
            try {
                if (crtFiles.isEmpty()) break block15;
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                final X509Certificate[] c = new X509Certificate[crtFiles.size()];
                int i = 0;
                for (File file : crtFiles) {
                    FileInputStream in = new FileInputStream(file);
                    c[i++] = (X509Certificate)cf.generateCertificate(in);
                    in.close();
                }
                TrustManagerFactory defaultTrustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                TrustManager[] trustManagers = new TrustManager[]{};
                try {
                    defaultTrustManagerFactory.init((KeyStore)null);
                    trustManagers = defaultTrustManagerFactory.getTrustManagers();
                }
                catch (KeyStoreException e) {
                    LOGGER.warn(e.getMessage(), e);
                }
                X509TrustManager trustManager = null;
                int index = 0;
                if (trustManagers == null || trustManagers.length == 0) {
                    trustManagers = new TrustManager[1];
                    trustManager = null;
                    index = 0;
                } else {
                    i = 0;
                    boolean found = false;
                    for (TrustManager t : trustManagers) {
                        if (t instanceof X509TrustManager) {
                            trustManager = (X509TrustManager)t;
                            index = i;
                            found = true;
                            break;
                        }
                        ++i;
                    }
                    if (!found) {
                        TrustManager[] nTrustManagers = new TrustManager[trustManagers.length + 1];
                        System.arraycopy(trustManagers, 0, nTrustManagers, 0, trustManagers.length);
                        index = trustManagers.length;
                        trustManagers = nTrustManagers;
                        trustManager = null;
                    }
                }
                final X509TrustManager fTrustManager = trustManager;
                X509TrustManager mTrustManager = new X509TrustManager(){

                    @Override
                    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                        if (fTrustManager != null) {
                            try {
                                fTrustManager.checkClientTrusted(chain, authType);
                                return;
                            }
                            catch (CertificateException certificateException) {
                                // empty catch block
                            }
                        }
                        this.checkChain(chain);
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                        if (fTrustManager != null) {
                            try {
                                fTrustManager.checkServerTrusted(chain, authType);
                                return;
                            }
                            catch (CertificateException certificateException) {
                                // empty catch block
                            }
                        }
                        this.checkChain(chain);
                    }

                    private void checkChain(X509Certificate[] chain) throws CertificateException {
                        boolean found = false;
                        block0: for (X509Certificate x509Certificate : chain) {
                            for (X509Certificate sc : c) {
                                if (!x509Certificate.equals(sc)) continue;
                                found = true;
                                break block0;
                            }
                        }
                        if (!found) {
                            throw new CertificateException();
                        }
                    }

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        X509Certificate[] certs = fTrustManager.getAcceptedIssuers();
                        if (certs == null) {
                            certs = new X509Certificate[]{};
                        }
                        X509Certificate[] allCerts = new X509Certificate[certs.length + c.length];
                        System.arraycopy(certs, 0, allCerts, 0, certs.length);
                        System.arraycopy(c, 0, allCerts, certs.length, c.length);
                        return allCerts;
                    }
                };
                trustManagers[index] = mTrustManager;
                SSLContext sc = SSLContext.getInstance("SSL");
                sc.init(null, trustManagers, new SecureRandom());
                HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (CertificateException e) {
                e.printStackTrace();
            }
            catch (KeyManagementException e) {
                e.printStackTrace();
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
        }
    }

    private void doExceptionSettings() {
        final Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                try {
                    e.printStackTrace();
                    LOGGER.error(e.getMessage(), e);
                }
                catch (Exception ex) {
                    LOGGER.error(e.getMessage());
                }
                if (e instanceof StaleStateException) {
                    StaleStateException staleStateException = (StaleStateException)e;
                    StaleStateExceptionDialog staleStateExceptionDialog = new StaleStateExceptionDialog((Window)PepperGisDesktopApplication.this, staleStateException);
                    staleStateExceptionDialog.setVisible(true);
                } else {
                    KickedAuthenticationException kicked = null;
                    if (e instanceof KickedAuthenticationException) {
                        kicked = (KickedAuthenticationException)e;
                    }
                    if (kicked == null && e.getCause() instanceof KickedAuthenticationException) {
                        kicked = (KickedAuthenticationException)e.getCause();
                    }
                    AuthenticationException auth = null;
                    if (kicked == null) {
                        if (e instanceof AuthenticationException) {
                            auth = (AuthenticationException)e;
                        }
                        if (auth == null && e.getCause() instanceof AuthenticationException) {
                            auth = (AuthenticationException)e.getCause();
                        }
                    }
                    if (kicked != null) {
                        JOptionPane.showMessageDialog(null, ModelEnviroment.getMessageResolver().resolveMessage("messages.admin.kickUserAlreadyLoggedIn.kicked", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.information", new Serializable[0]), 0);
                        System.exit(0);
                    } else if (auth != null) {
                        JOptionPane.showMessageDialog(null, ModelEnviroment.getMessageResolver().resolveMessage("messages.admin.sessionTimeout", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.information", new Serializable[0]), 0);
                        System.exit(0);
                    } else {
                        BufferedImage image;
                        try {
                            image = ImageIO.read(PepperGisDesktopApplication.class.getResourceAsStream("/images/pepper.png"));
                        }
                        catch (IOException ioEx) {
                            throw new RuntimeException(ioEx);
                        }
                        ExceptionMessageDialog errorMessageDialog = new ExceptionMessageDialog((Window)PepperGisDesktopApplication.this, e, image);
                        errorMessageDialog.setVisible(true);
                    }
                }
                if (uncaughtExceptionHandler != null) {
                    uncaughtExceptionHandler.uncaughtException(t, e);
                }
            }
        });
    }

    private void doProxySettings(Properties properties) {
        String nonProxyHost;
        String useSystem = System.getProperty("java.net.useSystemProxies");
        if (!StringUtil.isBlank(useSystem) && StringUtil.isTrue(useSystem)) {
            ProxySelector sel = ProxySelector.getDefault();
            try {
                List<Proxy> pl = sel.select(new URI(properties.getProperty("url")));
                for (Proxy p : pl) {
                    InetSocketAddress addr = (InetSocketAddress)p.address();
                    if (addr == null) continue;
                    String proxyHost = addr.getHostName();
                    System.setProperty("proxyHost", proxyHost);
                    int proxyPort = addr.getPort();
                    System.setProperty("proxyPort", Integer.toString(proxyPort));
                    System.out.println("ProxyHost: " + proxyHost + ":" + proxyPort);
                }
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        String proxyHost = properties.getProperty("proxyHost");
        String proxyPort = properties.getProperty("proxyPort");
        if (proxyHost != null) {
            System.setProperty("proxyHost", proxyHost);
        }
        if (proxyPort != null) {
            System.setProperty("proxyPort", proxyPort);
        }
        String proxyUser = properties.getProperty("proxyUser");
        String proxyPassword = StringUtil.nullToEmpty(properties.getProperty("proxyPassword"));
        if (proxyUser != null) {
            System.setProperty("proxyUser", proxyUser);
            System.setProperty("proxyPassword", proxyPassword);
            ProxyAuthenticator proxyAuthenticator = new ProxyAuthenticator(proxyUser, proxyPassword);
            Authenticator.setDefault(proxyAuthenticator);
        }
        if ((nonProxyHost = properties.getProperty("nonProxyHost")) != null) {
            System.setProperty("nonProxyHost", nonProxyHost);
        }
    }

    @Override
    protected void initialize() {
        ModelEnviroment.setDesktopClientApplication(this);
        this.doSslSettings();
        this.doProxySettings(this.getProperties());
        this.doExceptionSettings();
        this.applicationGlobalEventHandler = new ApplicationGlobalEventHandlerImpl(this);
        ((PepperGisDesktopApplicationActions)this.actions).setApplication(this);
        try {
            ClientExternalRemoteService.getInstance(this.getProperties());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ModelEnviroment.setGeoServerStubContext(this);
        ModelEnviroment modelEnviroment = new ModelEnviroment(this);
        final AllCaller allCaller = modelEnviroment.getAllCaller();
        LOGOUT_SHUTDOWN_HOOK = new Thread(){

            @Override
            public void run() {
                super.run();
                try {
                    if (ModelEnviroment.getUserInformation() != null) {
                        allCaller.getUserCaller().logout();
                    }
                }
                catch (KickedAuthenticationException e) {
                    LOGGER.warn("User has already been kicked");
                }
                catch (Exception e) {
                    LOGGER.warn(e.getMessage(), e);
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(LOGOUT_SHUTDOWN_HOOK);
        AutoUpdater.checkVersionAndAskForUpdate(modelEnviroment);
        UserInformation userInformation = LoginPane.performLogin(allCaller, this.getProperties(), this);
        ModelEnviroment.setUserInformation(userInformation);
        this.loadPropertiesFromServer(modelEnviroment);
        this.licenseManager = new LicenseManager(this);
        new Thread(this.licenseManager).start();
        UserModel userModel = userInformation.getUserModel();
        String titleSuffix = userModel == null ? "" : " - " + userModel.getName();
        this.setTitle(this.getTitle() + titleSuffix);
        String zoomUppString = this.getProperties().getProperty("navigator.zoom.upps");
        if (!StringUtil.isBlank(zoomUppString)) {
            try {
                TreeSet<Double> zoomUpps = new TreeSet<Double>();
                StringTokenizer st = new StringTokenizer(zoomUppString, ",");
                while (st.hasMoreTokens()) {
                    String next = st.nextToken();
                    zoomUpps.add(Double.valueOf(next.trim()));
                }
                double[] zoomUppsArray = new double[zoomUpps.size()];
                int count = 0;
                for (Double zoomUpp : zoomUpps) {
                    zoomUppsArray[count++] = zoomUpp;
                }
                NavigatorPanningAction.setZoomUpps(zoomUppsArray);
            }
            catch (Exception ex) {
                System.out.println("Zoom upps not valid");
            }
        }
        this.doFreySettings();
    }

    private void loadPropertiesFromServer(ModelEnviroment modelEnviroment) {
        Properties properties = modelEnviroment.getAllCaller().getBaseCaller().getUserProperties();
        properties = properties == null ? PropertyUtil.mergeProperties(ModelEnviroment.getProperties()) : PropertyUtil.mergeProperties(ModelEnviroment.getProperties(), properties);
        ModelEnviroment.setProperties(new Properties(properties));
        modelEnviroment.getAllCaller().getBaseCaller().updateUserProperties(properties);
        this.setProperties(properties);
    }

    private void doFreySettings() {
        String freyPortString = ModelEnviroment.getProperties().getProperty("frey.port");
        if (freyPortString != null) {
            int port = Integer.parseInt(freyPortString);
            this.freyHandler = new FreyHandlerImpl(this);
        }
    }

    public GeoServerStub getGeoServerStub() {
        return this.geoServerStub;
    }

    public ModelEnviroment createModelEnviroment() {
        return new ModelEnviroment(this.geoServerStub, this);
    }

    @Override
    protected JToolBar createToolbar() {
        return ((PepperGisDesktopApplicationActions)this.actions).createToolbar();
    }

    @Override
    public Object getManagementBo() {
        if (this.managementBo == null) {
            this.managementBo = this.geoServerStub.getManagement();
        }
        return this.managementBo;
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("jsse.enableSNIExtension", "false");
        System.setProperty("http.maxRedirects", "100");
        System.setProperty("https.protocols", "TLSv1,TLSv1.1,TLSv1.2");
        String arg1 = args.length > 0 ? args[0] : null;
        MessageResolver messageResolver = PepperGisDesktopApplication.initializeMessageResolver(Locale.getDefault().getLanguage());
        if (ClientApplicationProperties.setupProperties(APPLICATION_NAME, messageResolver.resolveMessage("messages.start.choosePropertiesQuestion", new Serializable[0]), messageResolver.resolveMessage("messages.default.directoryNotFound", new Serializable[0]), messageResolver.resolveMessage("messages.default.error", new Serializable[0]))) {
            String messageLocale;
            Properties properties = ModelEnviroment.getProperties();
            String errors = PepperGisDesktopApplication.sanityCheck(properties, messageResolver = PepperGisDesktopApplication.initializeMessageResolver(messageLocale = PepperGisDesktopApplication.getMessageLocale(properties)));
            if (StringUtil.isBlank(errors)) {
                boolean freyAutoLogin = StringUtil.isTrue(properties.getProperty("frey.autoLogin.enabled"));
                if (freyAutoLogin && !StringUtil.isBlank(arg1)) {
                    properties.setProperty("frey.autoLogin.user", arg1);
                }
                new PepperGisDesktopApplication(properties);
            } else {
                JOptionPane.showMessageDialog(null, errors + "\n\n" + messageResolver.resolveMessage("messages.check_clientproperties", new Serializable[]{ClientApplicationProperties.getPropBase(APPLICATION_NAME) + "/default.properties"}), "Fehler", 0);
            }
        }
    }

    private static MessageResolver initializeMessageResolver(String messageLocale) {
        MessageResolverImpl messageResolverImpl = new MessageResolverImpl();
        messageResolverImpl.setLocale(messageLocale);
        messageResolverImpl.setLocaleFallback("en");
        messageResolverImpl.setResource(new ClassPathResource("/de/datomino/peppergis/i18n/messages/"));
        messageResolverImpl.setPrefixes(Arrays.asList("messages", "gui", "enums"));
        ModelEnviroment.setMessageResolver(messageResolverImpl);
        return messageResolverImpl;
    }

    private static String getMessageLocale(Properties properties) {
        String messageLocale = properties.getProperty("message.locale");
        if (StringUtil.isBlank(messageLocale)) {
            messageLocale = Locale.getDefault().getLanguage();
        } else {
            Locale.setDefault(new Locale(messageLocale));
        }
        return messageLocale;
    }

    private static String sanityCheck(Properties properties, MessageResolver messageResolver) {
        StringBuilder sb = new StringBuilder();
        String commTypeProp = properties.getProperty("commtype");
        Class<? extends CommType> commType = null;
        if (!StringUtil.isBlank(commTypeProp)) {
            for (Class<? extends CommType> clazz : CommType.COMMTYPES) {
                if (!clazz.getName().equals(commTypeProp)) continue;
                commType = clazz;
                break;
            }
        }
        if (commType == null) {
            ArrayList classNames = new ArrayList(CommType.COMMTYPES.size());
            CollectionUtil.transform(CommType.COMMTYPES, classNames, new Transformer<Class<? extends CommType>, String>(){

                @Override
                public String transform(Class<? extends CommType> t) {
                    return t.getName();
                }
            });
            sb.append(messageResolver.resolveMessage("errors.client.invalid_commtype", new Serializable[]{StringUtil.nullToEmpty(commTypeProp).trim(), StringUtil.implode(classNames, ", "), CommType.DEFAULT_COMMTYPE}));
        }
        return sb.toString();
    }

    @Override
    protected JMenu createFileMenu() {
        return null;
    }

    @Override
    protected JMenuBar createMenuBar() {
        JMenu webportalMenu;
        JMenu offerMenu;
        JMenu toolMenu;
        JMenuBar menuBar = super.createMenuBar();
        JMenu configMenu = this.createConfigMenu();
        if (configMenu != null) {
            menuBar.add(configMenu);
        }
        if ((toolMenu = this.createToolMenu()) != null) {
            menuBar.add(toolMenu);
        }
        if ((offerMenu = this.createOfferMenu()) != null) {
            menuBar.add(offerMenu);
        }
        if ((webportalMenu = this.createWebportalMenu()) != null) {
            menuBar.add(webportalMenu);
        }
        return menuBar;
    }

    private JMenu createWebportalMenu() {
        String webportalActive = ModelEnviroment.getProperties().getProperty("webportal.control.active");
        if (StringUtil.isTrue(webportalActive) && ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.ADMIN, UserRole.AREA_ADMIN, UserRole.DISPONENT_SUPER)) {
            JMenu menu = new JMenu(ModelEnviroment.getMessageResolver().resolveMessage("messages.webportalcontrol.title", new Serializable[0]));
            menu.add(new OpenWebportalControlAction(this));
            return menu;
        }
        return null;
    }

    private JMenu createOfferMenu() {
        if (ModelEnviroment.getProperties().getProperty("offer.specialType") != null) {
            JMenu menu = new JMenu(ModelEnviroment.getMessageResolver().resolveMessage("messages.offer", new Serializable[0]));
            boolean added = false;
            if (ModelEnviroment.getUserInformation().isAdmin() || ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.AREA_ADMIN, UserRole.AREA_EDITOR, UserRole.DISPONENT_SUPER)) {
                OpenOfferAction openOfferAction = new OpenOfferAction(this);
                menu.add(openOfferAction);
                added = true;
            }
            return added ? menu : null;
        }
        return null;
    }

    private JMenu createToolMenu() {
        boolean needsMenu = ModelEnviroment.getUserInformation().hasOtherRolesThan(UserRole.DELIVERER_ACTIVE, UserRole.DELIVERER_PASSIVE, UserRole.AREA_VIEWER);
        if (!needsMenu) {
            return null;
        }
        JMenu menu = new JMenu(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.tools", new Serializable[0]));
        if (ModelEnviroment.getUserInformation().hasOtherRolesThan(UserRole.DISPONENT_LOCAL_PASSIVE, UserRole.DELIVERER_ACTIVE, UserRole.DELIVERER_PASSIVE, UserRole.DISPONENT_LOCAL_ACTIVE)) {
            JMenu csvGeoCodingMenu = new JMenu("Abgleich");
            menu.add(csvGeoCodingMenu);
            csvGeoCodingMenu.add(new PostcodeDistrictReleationSearchingAction(this));
            csvGeoCodingMenu.add(new StreetSearchingAction(this));
            csvGeoCodingMenu.add(new HousenumberSearchingAction(this));
            csvGeoCodingMenu.add(new HousenumberRangeSearchingAction(this));
            csvGeoCodingMenu.add(new CoordinateSearchingAction(this));
        }
        boolean isAdminOrSuperUser = ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.ADMIN, UserRole.DISPONENT_SUPER);
        boolean isAreaAdmin = ModelEnviroment.getUserInformation().hasUserRole(UserRole.AREA_ADMIN);
        boolean isPostwork = ModelEnviroment.getUserInformation().hasUserRole(UserRole.POST_WORK);
        String segmentEvaluationActive = ModelEnviroment.getProperties().getProperty("segment.evaluation.active");
        if ((isAdminOrSuperUser || isAreaAdmin) && StringUtil.isTrue(segmentEvaluationActive)) {
            ParcelAreaMappingAction parcelAreaMappingAction = new ParcelAreaMappingAction(this);
            menu.add(parcelAreaMappingAction);
            menu.add(new RoutingSegmentEvaluationAction(this));
        }
        InternalSearchAddressAction searchAddressAction = new InternalSearchAddressAction(this);
        menu.add(searchAddressAction);
        if (isAdminOrSuperUser || isAreaAdmin || ModelEnviroment.getUserInformation().hasUserRole(UserRole.AREA_EDITOR)) {
            ReviewAreaToursAction reviewAreaTourAction = new ReviewAreaToursAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.tour.review", new Serializable[0]), this);
            menu.add(reviewAreaTourAction);
        }
        if (isAdminOrSuperUser || isAreaAdmin) {
            FindAloneInAreaAction findAloneInAreaAction = new FindAloneInAreaAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.tour.findDistance", new Serializable[0]), this);
            menu.add(findAloneInAreaAction);
            AggregateAreaAttributeValueAction aggregateAreaAttributeValueAction = new AggregateAreaAttributeValueAction(this);
            menu.add(aggregateAreaAttributeValueAction);
        }
        menu.addSeparator();
        if (isAdminOrSuperUser || ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.AREA_ADMIN, UserRole.AREA_EDITOR)) {
            CreateParcelAreaRelationsForLayerByGeometryAction createParcelAreaRelationsForLayerByGeometryAction = new CreateParcelAreaRelationsForLayerByGeometryAction(this);
            menu.add(createParcelAreaRelationsForLayerByGeometryAction);
        }
        if (isAdminOrSuperUser) {
            RemoveParcelRoutingSegmentAction removeParcelRoutingSegmentAction = new RemoveParcelRoutingSegmentAction(SwingUtils.findWindowParent(this));
            menu.add(removeParcelRoutingSegmentAction);
        }
        if (isAdminOrSuperUser) {
            DeleteEmptyAreaAction deleteEmptyAreaAction = new DeleteEmptyAreaAction(SwingUtils.findWindowParent(this));
            menu.add(deleteEmptyAreaAction);
        }
        if (isAdminOrSuperUser || isAreaAdmin || isPostwork) {
            RecalcAreaByParcelRelAction recalcAreaByParcelRelAction = new RecalcAreaByParcelRelAction(this);
            menu.add(recalcAreaByParcelRelAction);
        }
        return menu;
    }

    protected JMenu createImportMenu() {
        JMenu menu = new JMenu("Import");
        boolean isAdminOrSuperUser = ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.ADMIN, UserRole.DISPONENT_SUPER);
        boolean isAdminOrAreaAdmin = isAdminOrSuperUser || ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.AREA_ADMIN);
        boolean added = false;
        if (isAdminOrAreaAdmin) {
            AreaFromConvexHullCsvImportAction importAreaAction = new AreaFromConvexHullCsvImportAction(this);
            AreaFromShpImportAction importAreaAction4 = new AreaFromShpImportAction(this);
            ImportAreaAttributeValueAction importAreaAttributeValueAction = new ImportAreaAttributeValueAction(this);
            JMenu areaMenu = new JMenu(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.areas", new Serializable[0]));
            areaMenu.add(importAreaAction);
            areaMenu.add(importAreaAction4);
            areaMenu.add(importAreaAttributeValueAction);
            ImportAreaDelivererAction importAreaDelivererAction = new ImportAreaDelivererAction(this);
            areaMenu.add(importAreaDelivererAction);
            menu.add(areaMenu);
            added = true;
        }
        if (isAdminOrAreaAdmin) {
            JMenu subscriptionMenu = new JMenu(ModelEnviroment.getMessageResolver().resolveMessage("messages.subscription.subscriptions", new Serializable[0]));
            SubscriptionImportAction importSubscriptionAction = new SubscriptionImportAction(this);
            subscriptionMenu.add(importSubscriptionAction);
            ImportSubscriptionAttributeValueAction importSubscriptionAttributeValueAction = new ImportSubscriptionAttributeValueAction(this);
            subscriptionMenu.add(importSubscriptionAttributeValueAction);
            menu.add(subscriptionMenu);
            added = true;
        }
        if (isAdminOrAreaAdmin) {
            JMenu letterMenu = new JMenu(ModelEnviroment.getMessageResolver().resolveMessage("messages.letter.letters", new Serializable[0]));
            LetterImportAction letterImportAction = new LetterImportAction(this);
            letterMenu.add(letterImportAction);
            ImportLetterAttributeValueAction importLetterAttributeValueAction = new ImportLetterAttributeValueAction(this);
            letterMenu.add(importLetterAttributeValueAction);
            menu.add(letterMenu);
            added = true;
        }
        if (isAdminOrAreaAdmin) {
            JMenu parcelMenu = new JMenu(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.parcels", new Serializable[0]));
            ParcelImportAction parcelImportAction = new ParcelImportAction(this);
            parcelMenu.add(parcelImportAction);
            if (isAdminOrAreaAdmin) {
                ImportParcelAttributeValueAction importParcelAttributeValueAction = new ImportParcelAttributeValueAction(this);
                parcelMenu.add(importParcelAttributeValueAction);
                ParcelAreaRelationImportAction parcelAreaRelationImportAction = new ParcelAreaRelationImportAction(this);
                parcelMenu.add(parcelAreaRelationImportAction);
            }
            menu.add(parcelMenu);
            added = true;
        }
        if (isAdminOrAreaAdmin) {
            JMenu poiMenu = new JMenu(ModelEnviroment.getMessageResolver().resolveMessage("messages.poi.pois", new Serializable[0]));
            ImportPoiAttributeValueAction importPoiAttributeValueAction = new ImportPoiAttributeValueAction(this);
            ImportPoiAction importPoiAction = new ImportPoiAction(this);
            poiMenu.add(importPoiAction);
            poiMenu.add(importPoiAttributeValueAction);
            menu.add(poiMenu);
            added = true;
        }
        if (isAdminOrSuperUser) {
            JMenu stopMenu = new JMenu(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.tours", new Serializable[0]));
            ImportTourAction importTourAction = new ImportTourAction(this);
            stopMenu.add(importTourAction);
            ImportDelivererAction importDelivererAction = new ImportDelivererAction(this);
            stopMenu.add(importDelivererAction);
            ImportGeoTrackCsvAction importGeoTrackAction = new ImportGeoTrackCsvAction(this);
            stopMenu.add(importGeoTrackAction);
            ImportGeoTrackGpxAction importGeoTrackGpxAction = new ImportGeoTrackGpxAction(this);
            stopMenu.add(importGeoTrackGpxAction);
            menu.add(stopMenu);
            added = true;
        }
        if (isAdminOrSuperUser && StringUtil.isTrue(ModelEnviroment.getProperties().getProperty("alias.import.active"))) {
            JMenu aliasMenu = new JMenu(ModelEnviroment.getMessageResolver().resolveMessage("messages.aliases", new Serializable[0]));
            ImportStreetAliasAction importStreetAliasAction = new ImportStreetAliasAction(this);
            aliasMenu.add(importStreetAliasAction);
            ImportDistrictAliasAction importDistrictAliasAction = new ImportDistrictAliasAction(this);
            aliasMenu.add(importDistrictAliasAction);
            ImportCityAliasAction importCityAliasAction = new ImportCityAliasAction(this);
            aliasMenu.add(importCityAliasAction);
            menu.add(aliasMenu);
            added = true;
        }
        return added ? menu : null;
    }

    protected JMenu createExportMenu() {
        JMenu menu = new JMenu("Export");
        boolean isAdmin = ModelEnviroment.getUserInformation().hasUserRole(UserRole.ADMIN);
        boolean isAdminOrSuperUser = ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.ADMIN, UserRole.DISPONENT_SUPER);
        boolean isAreaAdmin = isAdminOrSuperUser || ModelEnviroment.getUserInformation().hasUserRole(UserRole.AREA_ADMIN);
        boolean added = false;
        if (isAreaAdmin) {
            JMenu parcelMenu = new JMenu(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.parcels", new Serializable[0]));
            parcelMenu.add(new ExportParcelAction(this));
            if (isAdmin) {
                parcelMenu.add(new ExportParcelsOfChangedAreasAction(this));
                parcelMenu.add(new ExportParcelsWithBadSegmentAction(this));
            }
            menu.add(parcelMenu);
            added = true;
        }
        if (isAreaAdmin) {
            JMenu aliasMenu = new JMenu(ModelEnviroment.getMessageResolver().resolveMessage("messages.aliases", new Serializable[0]));
            aliasMenu.add(new ExportStreetAliasAction(this));
            aliasMenu.add(new ExportDistrictAliasAction(this));
            aliasMenu.add(new ExportCityAliasAction(this));
            menu.add(aliasMenu);
            added = true;
        }
        if (isAreaAdmin) {
            ExportSubscriptionsAction subscriptionMenuAction = new ExportSubscriptionsAction(this);
            menu.add(subscriptionMenuAction);
            added = true;
        }
        if (isAreaAdmin) {
            ExportAreaLayerAction exportAreaLayerAction = new ExportAreaLayerAction(this);
            menu.add(exportAreaLayerAction);
            added = true;
        }
        if (isAreaAdmin) {
            ExportPoisAction poiMenuAction = new ExportPoisAction(this);
            menu.add(poiMenuAction);
            added = true;
        }
        if (isAreaAdmin) {
            MultipleParcelEditorAction multipleParcelEditorAction = new MultipleParcelEditorAction(this);
            menu.add(multipleParcelEditorAction);
            added = true;
        }
        return added ? menu : null;
    }

    private JMenu createConfigMenu() {
        String propertyMenu;
        boolean isPostwork;
        JMenu menu = new JMenu(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.config", new Serializable[0]));
        boolean added = false;
        boolean isAdmin = ModelEnviroment.getUserInformation().hasUserRole(UserRole.ADMIN);
        boolean isAdminOrSuperUser = isAdmin || ModelEnviroment.getUserInformation().hasUserRole(UserRole.DISPONENT_SUPER);
        boolean isAreaAdmin = isAdminOrSuperUser || ModelEnviroment.getUserInformation().hasUserRole(UserRole.AREA_ADMIN);
        boolean bl = isPostwork = isAdminOrSuperUser || ModelEnviroment.getUserInformation().hasUserRole(UserRole.POST_WORK);
        if (isAdmin) {
            menu.add(new ShowUserManagementAction(this));
            added = true;
        }
        if (isAdminOrSuperUser) {
            JMenu subMenu = new JMenu(ModelEnviroment.getMessageResolver().resolveMessage("messages.documents", new Serializable[0]));
            subMenu.add(new ShowImageConfigurationAction(this));
            subMenu.add(new ShowPdfConfigurationAction(this));
            menu.add(subMenu);
            subMenu = new JMenu(ModelEnviroment.getMessageResolver().resolveMessage("gui.server.management", new Serializable[0]));
            subMenu.add(new ShowJobControlAction(this));
            subMenu.add(new ShowUserJobAction(this));
            subMenu.add(new ShowServerTaskAction(this));
            subMenu.add(new ProcessSubscriptionsWithoutParcelAction(this));
            subMenu.add(new ProcessLettersWithoutParcelAction(this));
            menu.add(subMenu);
            added = true;
        }
        if (isAdmin) {
            menu.add(new TriggerMapUpdateAction(this));
            added = true;
        }
        if (isAreaAdmin || ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.AREA_EDITOR, UserRole.AREA_VIEWER)) {
            JMenu areaMenu = new JMenu(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.areas", new Serializable[0]));
            areaMenu.add(new ShowAreaLayerDialogAction(this));
            added = true;
            if (isAreaAdmin) {
                areaMenu.add(new ShowAttributeGroupDialogAction(this, AttributeGroupType.AREA));
                areaMenu.add(new ShowAreaAttributeValueDescriptorDialogAction(this));
                areaMenu.add(new ShowAreaFilterConfigurationDialogAction(this, this.getApplicationGlobalEventHandler()));
                areaMenu.add(new ShowAreaFilterPatternSetupDialogAction(this, this.getApplicationGlobalEventHandler()));
            }
            menu.add(areaMenu);
        }
        if (isAreaAdmin) {
            JMenu subscriptionMenu = new JMenu(ModelEnviroment.getMessageResolver().resolveMessage("messages.subscription.subscriptions", new Serializable[0]));
            subscriptionMenu.add(new ShowAttributeGroupDialogAction(this, AttributeGroupType.SUBSCRIPTION));
            subscriptionMenu.add(new ShowSubscriptionAttributeValueDescriptorDialogAction(this));
            subscriptionMenu.add(new ShowSubscriptionFilterConfigurationDialogAction(this, this.getApplicationGlobalEventHandler()));
            subscriptionMenu.add(new ShowSubscriptionFilterPatternSetupDialogAction(this, this.getApplicationGlobalEventHandler()));
            menu.add(subscriptionMenu);
            added = true;
        }
        if (isAreaAdmin) {
            JMenu letterMenu = new JMenu(ModelEnviroment.getMessageResolver().resolveMessage("messages.letter.letters", new Serializable[0]));
            letterMenu.add(new ShowAttributeGroupDialogAction(this, AttributeGroupType.LETTER));
            letterMenu.add(new ShowLetterAttributeValueDescriptorDialogAction(this));
            letterMenu.add(new ShowLetterFilterConfigurationDialogAction(this, this.getApplicationGlobalEventHandler()));
            letterMenu.add(new ShowLetterFilterPatternSetupDialogAction(this, this.getApplicationGlobalEventHandler()));
            menu.add(letterMenu);
            added = true;
        }
        if (isAreaAdmin) {
            JMenu parcelMenu = new JMenu(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.parcels", new Serializable[0]));
            parcelMenu.add(new ShowAttributeGroupDialogAction(this, AttributeGroupType.PARCEL));
            parcelMenu.add(new ShowParcelAttributeValueDescriptorDialogAction(this));
            parcelMenu.add(new ShowParcelFilterConfigurationDialogAction(this, this.getApplicationGlobalEventHandler()));
            parcelMenu.add(new ShowParcelFilterPatternSetupDialogAction(this, this.getApplicationGlobalEventHandler()));
            menu.add(parcelMenu);
            added = true;
        }
        if (isAreaAdmin) {
            JMenu poiMenu = new JMenu(ModelEnviroment.getMessageResolver().resolveMessage("messages.poi.pois", new Serializable[0]));
            poiMenu.add(new ShowAttributeGroupDialogAction(this, AttributeGroupType.POI));
            poiMenu.add(new ShowPoiAttributeValueDescriptorDialogAction(this));
            poiMenu.add(new ShowPoiFilterConfigurationDialogAction(this, this.getApplicationGlobalEventHandler()));
            poiMenu.add(new ShowPoiFilterPatternSetupDialogAction(this, this.getApplicationGlobalEventHandler()));
            menu.add(poiMenu);
            added = true;
        }
        if (isAreaAdmin && ModelEnviroment.getProperties().getProperty("offer.specialType") != null) {
            JMenu customerMenu = new JMenu(ModelEnviroment.getMessageResolver().resolveMessage("messages.customer.customers", new Serializable[0]));
            customerMenu.add(new ShowAgencyConfigurationAction(this));
            menu.add(customerMenu);
            added = true;
        }
        if (isAdminOrSuperUser) {
            JMenu branchMenu = new JMenu(ModelEnviroment.getMessageResolver().resolveMessage("messages.importer.branch", new Serializable[0]));
            branchMenu.add(new ShowBranchConfigrationDialogAction(this));
            menu.add(branchMenu);
            JMenu printMenu = new JMenu(ModelEnviroment.getMessageResolver().resolveMessage("gui.print.print", new Serializable[0]));
            printMenu.add(new ShowPrintConfigrationDialogAction(this));
            menu.add(printMenu);
            added = true;
        }
        if (StringUtil.isTrue(propertyMenu = StringUtil.nullToEmpty(ModelEnviroment.getProperties().getProperty("propertyMenu")))) {
            ShowPropertiesAction showPropertiesAction = new ShowPropertiesAction(this);
            menu.add(showPropertiesAction);
            added = true;
        }
        return added ? menu : null;
    }

    protected JMenu createInfoMenu() {
        JMenu infoMenu = new JMenu("Infomation");
        infoMenu.add(new AbstractAction("Version"){
            private static final long serialVersionUID = 4554591545618463591L;

            @Override
            public void actionPerformed(ActionEvent e) {
                String info = PepperGisDesktopApplication.this.getSystemProperties();
                JTextArea textArea = new JTextArea(info);
                JScrollPane scrollPane = new JScrollPane(textArea);
                scrollPane.setMaximumSize(new Dimension(500, 300));
                JDialog dialog = new JDialog();
                try {
                    dialog.setIconImage(ImageIO.read(PepperGisDesktopApplication.class.getResourceAsStream("/images/pepper.png")));
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
                dialog.setPreferredSize(new Dimension(500, 300));
                dialog.add(scrollPane);
                dialog.pack();
                dialog.setVisible(true);
            }
        });
        return infoMenu;
    }

    private String getSystemProperties() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<Object, Object> key : System.getProperties().entrySet()) {
            builder.append(key.getKey()).append("=").append(key.getValue()).append("\n");
        }
        return builder.toString();
    }

    public ApplicationGlobalEventHandlerImpl getApplicationGlobalEventHandler() {
        return this.applicationGlobalEventHandler;
    }

    public void setNavigatorPanel(NavigatorPanel navigatorPanel) {
        if (this.currentNavigatorPanel != null) {
            this.currentNavigatorPanel.removeRenderer(this.coordStatus);
        }
        this.currentNavigatorPanel = navigatorPanel;
        if (navigatorPanel != null) {
            navigatorPanel.addRenderer(this.coordStatus);
        }
    }

    public void unsetNavigatorPanel(NavigatorPanel navigatorPanel) {
        if (this.currentNavigatorPanel == navigatorPanel) {
            if (this.currentNavigatorPanel != null) {
                this.currentNavigatorPanel.removeRenderer(this.coordStatus);
            }
            this.currentNavigatorPanel = null;
            this.setStatus("");
        }
    }

    public FreyHandler getFreyHandler() {
        return this.freyHandler;
    }

    @Override
    public Action getAction(String name) {
        if (name.equals("datamanager")) {
            return (Action)this.actions.getInstance(6);
        }
        return null;
    }

    public void addWindow(String name, AbstractPepperGisInternalFrame window) {
        super.addWindow(name, window, this.licenseManager);
    }

    @Override
    public void dispatchApplicationMessage(Object object) {
        if (!(object instanceof ApplicationMessage)) {
            throw new RuntimeException("object must be instance of application message");
        }
        ApplicationMessage message = (ApplicationMessage)object;
        this.getApplicationGlobalEventHandler().fireApplicationMessage(message);
    }

    private static class ProxyAuthenticator
    extends Authenticator {
        private String user;
        private String password;

        public ProxyAuthenticator(String user, String password) {
            this.user = user;
            this.password = password;
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.user, this.password.toCharArray());
        }
    }
}

