/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.swing;

import de.datomino.peppergis.client.event.ApplicationMessage;
import de.datomino.peppergis.client.gui.Pausable;
import de.datomino.peppergis.client.gui.PausableInternalFrame;
import de.datomino.peppergis.client.swing.PepperGisDesktopApplication;
import de.datomino.peppergis.license.LicenseType;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Deque;
import java.util.LinkedList;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import org.ktde.swing.DesktopClientApplication;
import org.ktde.swing.InternalFrame;
import org.ktde.swing.navigator.NavigatorPanel;

public abstract class AbstractPepperGisInternalFrame
extends InternalFrame
implements PausableInternalFrame {
    private static final long serialVersionUID = -7845915500327137600L;
    private Deque<Pausable> pausedDialogs;
    private boolean resumeUnlocked;
    private boolean resuming;

    public AbstractPepperGisInternalFrame(DesktopClientApplication<AbstractPepperGisInternalFrame> application, String title, boolean resizable, boolean maximizable, boolean iconifiable) {
        super(application, title, resizable, maximizable, iconifiable);
        this.setIcon();
        this.addListener();
    }

    public AbstractPepperGisInternalFrame(DesktopClientApplication<AbstractPepperGisInternalFrame> application, String title, boolean resizable, boolean maximizable) {
        super(application, title, resizable, maximizable);
        this.setIcon();
        this.addListener();
    }

    public AbstractPepperGisInternalFrame(DesktopClientApplication<AbstractPepperGisInternalFrame> application, String title, boolean resizable) {
        super(application, title, resizable);
        this.setIcon();
        this.addListener();
    }

    public AbstractPepperGisInternalFrame(DesktopClientApplication<AbstractPepperGisInternalFrame> application, String title) {
        super(application, title);
        this.setIcon();
        this.addListener();
    }

    public AbstractPepperGisInternalFrame(DesktopClientApplication<AbstractPepperGisInternalFrame> application) {
        super(application);
        this.setIcon();
        this.addListener();
    }

    private void setIcon() {
        try {
            BufferedImage image = ImageIO.read(AbstractPepperGisInternalFrame.class.getResourceAsStream("/images/pepper.png"));
            BufferedImage resizedImage = new BufferedImage(16, 16, 2);
            Graphics2D g = resizedImage.createGraphics();
            g.drawImage(image, 0, 0, 16, 16, null);
            g.dispose();
            this.setFrameIcon(new ImageIcon(resizedImage));
            Dimension size = this.getDesktopIcon().getSize();
            size.setSize(size.getWidth() * 2.0, size.getHeight());
            this.getDesktopIcon().setSize(size);
            this.getDesktopIcon().setPreferredSize(size);
            this.getDesktopIcon().setMinimumSize(size);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void addListener() {
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameOpened(InternalFrameEvent e) {
                super.internalFrameOpened(e);
                AbstractPepperGisInternalFrame.this.navigatorPanelChanged();
            }

            @Override
            public void internalFrameActivated(InternalFrameEvent e) {
                super.internalFrameActivated(e);
                AbstractPepperGisInternalFrame.this.navigatorPanelChanged();
                AbstractPepperGisInternalFrame.this.resume();
            }

            @Override
            public void internalFrameDeactivated(InternalFrameEvent e) {
                super.internalFrameDeactivated(e);
                AbstractPepperGisInternalFrame.this.navigatorPanelClear();
            }

            @Override
            public void internalFrameClosing(InternalFrameEvent e) {
                super.internalFrameClosing(e);
                AbstractPepperGisInternalFrame.this.navigatorPanelClear();
            }
        });
    }

    public NavigatorPanel getCurrentNavigatorPanel() {
        return null;
    }

    public void navigatorPanelChanged() {
        ((PepperGisDesktopApplication)this.application).setNavigatorPanel(this.getCurrentNavigatorPanel());
    }

    public void navigatorPanelClear() {
        ((PepperGisDesktopApplication)this.application).unsetNavigatorPanel(this.getCurrentNavigatorPanel());
    }

    public void consumeApplicationMessage(ApplicationMessage<?> message) {
    }

    @Override
    public void pause(Pausable pausable) {
        if (this.pausedDialogs == null) {
            this.pausedDialogs = new LinkedList<Pausable>();
        }
        if (pausable != null && !this.pausedDialogs.contains(pausable)) {
            this.resuming = false;
            this.resumeUnlocked = false;
            pausable.pause();
            this.pausedDialogs.push(pausable);
        }
    }

    @Override
    public void unlockResume() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractPepperGisInternalFrame.this.resumeUnlocked = true;
            }
        });
    }

    protected void resume() {
        if (this.resumeUnlocked && this.pausedDialogs != null) {
            this.resuming = true;
            while (!this.pausedDialogs.isEmpty() && this.resuming) {
                this.pausedDialogs.pop().resume();
            }
        }
    }

    @Override
    public boolean close() {
        return false;
    }

    public abstract LicenseType getLicenseType();
}

