/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.swing;

import de.datomino.peppergis.client.gui.AbstractMapEditorPanel;
import de.datomino.peppergis.client.model.UndoManager;
import de.datomino.peppergis.client.swing.AbstractPepperGisInternalFrame;
import de.datomino.peppergis.client.swing.PepperGisDesktopApplication;
import de.datomino.peppergis.exception.ValidateException;
import java.awt.Component;
import java.io.IOException;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import org.ktde.swing.navigator.NavigatorPanel;

public abstract class AbstractEditorInternalFrame<C, P extends AbstractMapEditorPanel>
extends AbstractPepperGisInternalFrame {
    private static final long serialVersionUID = 3489688755080050296L;
    protected P panel;

    public AbstractEditorInternalFrame(PepperGisDesktopApplication application, C constructorArgs, String title, boolean resizable, boolean maximizable, boolean iconifiable) throws IOException {
        super(application, title, resizable, maximizable, iconifiable);
        this.panel = this.createEditorPanel(constructorArgs);
        this.getContentPane().add((Component)this.panel);
        this.setSize(600, 400);
        JMenuBar menuBar = this.createMenuBar();
        if (menuBar != null) {
            this.setJMenuBar(menuBar);
        }
    }

    protected abstract void extendToolBar(JToolBar var1);

    protected abstract P createEditorPanel(C var1);

    protected abstract JMenuBar createMenuBar();

    @Override
    public boolean close() {
        UndoManager manager = ((AbstractMapEditorPanel)this.panel).getUndoManager();
        boolean c = true;
        if (manager.canUndo()) {
            int save = JOptionPane.showConfirmDialog(this.application, "Es gibt ungespeicherte \u00c4nderungen in '" + this.getTitle() + "',\nwollen Sie die \u00c4nderungen speichern?", "Ungespeicherte \u00c4nderungen", 1);
            switch (save) {
                case 0: {
                    try {
                        manager.storeTransactions();
                        c = true;
                    }
                    catch (ValidateException e) {
                        manager.handleValidateException(e);
                        c = false;
                    }
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    c = false;
                }
            }
        }
        return c;
    }

    @Override
    public NavigatorPanel getCurrentNavigatorPanel() {
        return ((AbstractMapEditorPanel)this.panel).getNavigatorPanel();
    }

    public P getEditorPanel() {
        return this.panel;
    }

    protected abstract boolean isSaveActionAllowed();

    protected boolean isRevertActionAllowed() {
        return true;
    }

    protected boolean isUndoActionAllowed() {
        return true;
    }

    protected boolean isRedoActionAllowed() {
        return true;
    }
}

