/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.print;

import de.datomino.peppergis.client.gui.DefaultPointRenderer;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.map.RendererNode;
import de.datomino.peppergis.client.model.map.SegmentAttributeModel;
import de.datomino.peppergis.client.model.map.SegmentModel;
import de.datomino.util.common.CacheUtil;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.model.BucketsFetchCallback;
import de.datomino.util.geo.model.DefaultGeoObjectBucketsModel;
import de.datomino.util.geo.model.GeomExtractor;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.ktde.math.projection.Coordinate;
import org.ktde.swing.navigator.AbstractNavigatorRenderer;
import org.ktde.swing.navigator.OnTopRendering;
import org.ktde.util.datatypes.Tupel;

public class StreetNameRenderer
extends AbstractNavigatorRenderer {
    private static String[] ATTRIBUTE_TAGS = new String[]{"name", "ref", "addr:street", "reg_name", "loc_name"};
    private static boolean[] ATTRIBUTE_DECODE = new boolean[]{true, false, false, false, false};
    private DefaultGeoObjectBucketsModel<SegmentModel, ImmutablePoint> segmentBucketsModel;
    private ModelEnviroment modelEnviroment;
    private int maxZoom = 18;
    private int minZoom = 0;
    private int maxSegmentZoom = 18;
    private int minSegmentZoom = 14;
    private Font defaultFont;

    public StreetNameRenderer(ModelEnviroment modelEnviroment, Font defaultFont) {
        super("street name renderer");
        this.modelEnviroment = modelEnviroment;
        this.defaultFont = defaultFont;
    }

    @Override
    public Collection<OnTopRendering> paintOnto(Graphics2D g2d, Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
        Coordinate bottomLeft = this.getCoordinateFactory().createCoordinate(realBoundaryBottomLeft.getX(), realBoundaryBottomLeft.getY());
        Coordinate topRight = this.getCoordinateFactory().createCoordinate(realBoundaryTopRight.getX(), realBoundaryTopRight.getY());
        int zoom = this.computeZoom(upp);
        if (zoom <= this.maxSegmentZoom && zoom >= this.minSegmentZoom) {
            String name;
            ArrayList<Tupel<RendererNode, Integer>> nodes = new ArrayList<Tupel<RendererNode, Integer>>();
            Collection segments = this.segmentBucketsModel.findObjects(bottomLeft, topRight);
            HashMap<String, SegmentModel> nameMap = new HashMap<String, SegmentModel>();
            for (SegmentModel segment : segments) {
                name = this.getName(segment);
                if (name == null) continue;
                if (nameMap.keySet().contains(name)) {
                    SegmentModel segmentModel = (SegmentModel)nameMap.get(name);
                    if (segmentModel.getSegmentType().compare(segment.getSegmentType()) >= 0) continue;
                    nameMap.put(name, segment);
                    continue;
                }
                nameMap.put(name, segment);
            }
            for (SegmentModel segment : nameMap.values()) {
                name = this.getName(segment);
                RendererNode rendererNode = new RendererNode(name, segment.getGeom().getCentroid().getCoordinate(), upp);
                rendererNode.setFontground(Color.BLACK);
                rendererNode.setFontStyle(0);
                rendererNode.setFontSize(12);
                if (this.defaultFont != null) {
                    rendererNode.setFontName(this.defaultFont.getName());
                    rendererNode.setFontStyle(this.defaultFont.getStyle());
                    rendererNode.setFontSize(this.defaultFont.getSize());
                }
                nodes.add(new Tupel<RendererNode, Integer>(rendererNode, 0));
            }
            DefaultPointRenderer pointRenderer = new DefaultPointRenderer(g2d, upp, this.getCoordinateFactory());
            HashSet<Rectangle2D.Double> drawedRectangles = new HashSet<Rectangle2D.Double>();
            for (Tupel tupel : nodes) {
                RendererNode node = (RendererNode)tupel.getElement1();
                Rectangle2D.Double rectangle = this.getRectangle(node);
                if (this.isOverlapped(rectangle, drawedRectangles)) continue;
                drawedRectangles.add(rectangle);
                pointRenderer.drawShape(rectangle, node, 0.0);
                pointRenderer.drawText(node, true, false);
            }
        }
        return Collections.emptyList();
    }

    private String getName(SegmentModel segment) {
        String name = null;
        String ref = null;
        for (SegmentAttributeModel attribute : segment.iterableAttributes()) {
            for (String string : ATTRIBUTE_TAGS) {
            }
            if (attribute.getKey().equals("name")) {
                try {
                    name = URLDecoder.decode(attribute.getValue(), "UTF_8");
                }
                catch (Exception e) {
                    name = attribute.getValue();
                }
                continue;
            }
            if (!attribute.getKey().equals("ref")) continue;
            ref = attribute.getValue();
        }
        name = name == null ? ref : name;
        return name;
    }

    private Rectangle2D.Double getRectangle(RendererNode node) {
        double d = node.getMargin() * (double)node.getFontSize();
        Coordinate reformed = this.getCoordinateFactory().createCoordinate(node.getCoordinate());
        double textX = reformed.getX() - (double)node.getText().length() * d / 2.0;
        double textY = reformed.getY() - d;
        Rectangle2D.Double rectangle = new Rectangle2D.Double();
        rectangle.x = textX - node.getMargin() - d / 8.0;
        rectangle.y = textY - node.getMargin();
        rectangle.width = (double)node.getText().length() * d * 0.9;
        rectangle.height = d * 1.5;
        return rectangle;
    }

    private boolean isOverlapped(Rectangle2D.Double rectangle, Set<Rectangle2D.Double> drawedRectangles) {
        for (Rectangle2D.Double r : drawedRectangles) {
            if (!r.contains(rectangle) && !r.intersects(rectangle)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void prepare(Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
        if (this.segmentBucketsModel == null) {
            this.segmentBucketsModel = new DefaultGeoObjectBucketsModel<SegmentModel, ImmutablePoint>(CacheUtil.FACTORY.getRefScale() * 10000.0, this.getCoordinateFactory(), new GeomExtractor<SegmentModel, ImmutablePoint>(){

                @Override
                public ImmutablePoint getGeom(SegmentModel placeModel) {
                    ImmutablePoint point = placeModel.getGeom().getCentroid();
                    return point;
                }
            });
            this.segmentBucketsModel.setFetchCallback(new BucketsFetchCallback<SegmentModel, ImmutablePoint>(){

                @Override
                public Collection<SegmentModel> fetch(Coordinate topLeft, Coordinate bottomRight) {
                    return StreetNameRenderer.this.modelEnviroment.getAllCaller().getStreetNetCaller().fetchSegments(topLeft, bottomRight);
                }
            });
        }
    }

    private int computeZoom(double upp) {
        double upp0 = 140625.0;
        double zoomD = Math.log(upp0 / upp) / Math.log(2.0);
        int zoom = Math.min(Math.max((int)zoomD, this.minZoom), this.maxZoom);
        return zoom;
    }
}

