/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.print;

import de.datomino.pdf.engine.Format;
import de.datomino.peppergis.client.gui.common.font.FontChooserComboBox;
import de.datomino.peppergis.client.gui.common.font.FontResource;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.print.FormatComboBox;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import de.datomino.util.swing.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.SpringLayout;
import org.ktde.util.StringUtil;

public class PrintOptionPane<T>
extends JPanel {
    private static final long serialVersionUID = -550739282031359681L;
    private static final List<Format> ALLOWED_FORMATS;
    protected ModelEnviroment modelEnviroment;
    private JTextArea specialMessage;
    private JRadioButton portrait;
    private JRadioButton landscape;
    private FormatComboBox formatComboBox;
    private JComboBox styleBox;
    private JCheckBox optimalZoom;
    private JSpinner dpi;
    private JSpinner scale;
    private JRadioButton vector;
    private JRadioButton bitmap;
    private JSpinner xMargin;
    private JSpinner yMargin;
    private JCheckBox fillupSpace;
    private FontChooserComboBox fontBox;
    private JSpinner fontSize;
    private JCheckBox fontBold;
    private JCheckBox fontItalic;
    private JCheckBox fontUnderline;
    private JCheckBox printStreets;
    private FontChooserComboBox streetFontBox;
    private JSpinner streetFontSize;
    private JCheckBox printPlaces;
    private FontChooserComboBox placeFontBox;
    private JSpinner placeFontSize;
    private JCheckBox whiteBackgroundForScale;
    private JSpinner footerFontSize;

    public PrintOptionPane(ModelEnviroment modelEnviroment, boolean specialMessage, boolean printStyleChoosable, boolean objectPrint, boolean isAreaGen, String propertyPrefix, T specialComponentOptions) {
        this(modelEnviroment, specialMessage, printStyleChoosable, objectPrint, isAreaGen, FontResource.FOP, propertyPrefix, specialComponentOptions);
    }

    public PrintOptionPane(ModelEnviroment modelEnviroment, boolean specialMessage, boolean printStyleChoosable, boolean objectPrint, boolean isAreaGen, FontResource fontResource, String propertyPrefix, T specialComponentOptions) {
        this(modelEnviroment, specialMessage, printStyleChoosable, objectPrint, isAreaGen, fontResource, propertyPrefix, false, specialComponentOptions);
    }

    public PrintOptionPane(ModelEnviroment modelEnviroment, boolean specialMessage, boolean printStyleChoosable, boolean objectPrint, boolean isAreaGen, String propertyPrefix, boolean showFooterFontSize, T specialComponentOptions) {
        this(modelEnviroment, specialMessage, printStyleChoosable, objectPrint, isAreaGen, FontResource.FOP, propertyPrefix, showFooterFontSize, specialComponentOptions);
    }

    public PrintOptionPane(ModelEnviroment modelEnviroment, boolean specialMessage, boolean printStyleChoosable, boolean objectPrint, boolean isAreaGen, FontResource fontResource, String propertyPrefix, boolean showFooterFontSize, T specialComponentOptions) {
        super(new BorderLayout());
        this.modelEnviroment = modelEnviroment;
        this.buildLayout(specialMessage, printStyleChoosable, objectPrint, isAreaGen, fontResource, propertyPrefix, showFooterFontSize, specialComponentOptions);
    }

    private void buildLayout(boolean specialMessage, boolean printStyleChoosable, boolean objectPrint, boolean isAreaGen, FontResource fontResource, String propertyPrefix, boolean showFooterFontSize, T specialComponentOptions) {
        Component specialComponent;
        JPanel subFormatPane;
        JPanel formatPane;
        JPanel subPane = new JPanel(new BorderLayout());
        JPanel subSubPane = new JPanel(new SpringLayout());
        if (printStyleChoosable) {
            formatPane = new JPanel(new BorderLayout());
            subFormatPane = new JPanel(new SpringLayout());
            subFormatPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.print.style", new Serializable[0])));
            this.styleBox = this.createStyleBox();
            subFormatPane.add(this.styleBox);
            SpringUtilities.makeCompactGrid(subFormatPane, 1, 2, 2, 2, 5, 2);
            formatPane.add((Component)subFormatPane, "West");
            subSubPane.add(formatPane);
        }
        formatPane = new JPanel(new BorderLayout());
        subFormatPane = new JPanel(new SpringLayout());
        int defaultDpi = 150;
        try {
            defaultDpi = Integer.parseInt(ModelEnviroment.getProperties().getProperty("print." + propertyPrefix + ".defaultDpi"));
            defaultDpi = Math.max(defaultDpi, 72);
            defaultDpi = Math.min(defaultDpi, 300);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.dpi = new JSpinner(new SpinnerNumberModel(defaultDpi, 72, 300, 1));
        subFormatPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.print.dpi", new Serializable[0])));
        subFormatPane.add(this.dpi);
        SpringUtilities.makeCompactGrid(subFormatPane, 1, 2, 2, 2, 2, 2);
        formatPane.add((Component)subFormatPane, "West");
        subSubPane.add(formatPane);
        formatPane = new JPanel(new BorderLayout());
        subFormatPane = new JPanel(new SpringLayout());
        ButtonGroup buttonGroup = new ButtonGroup();
        Format.Type defaultType = Format.Type.PORTRAIT;
        try {
            defaultType = Format.Type.valueOf(ModelEnviroment.getProperties().getProperty("print." + propertyPrefix + ".defaultFormatType").toUpperCase());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.portrait = new JRadioButton(ModelEnviroment.getMessageResolver().resolveMessage("messages.print.portrait", new Serializable[0]));
        buttonGroup.add(this.portrait);
        subFormatPane.add(this.portrait);
        this.landscape = new JRadioButton(ModelEnviroment.getMessageResolver().resolveMessage("messages.print.landscape", new Serializable[0]));
        buttonGroup.add(this.landscape);
        subFormatPane.add(this.landscape);
        switch (defaultType) {
            case PORTRAIT: {
                this.portrait.setSelected(true);
                break;
            }
            case LANDSCAPE: {
                this.landscape.setSelected(true);
            }
        }
        Format defaultFormat = null;
        String formatString = ModelEnviroment.getProperties().getProperty("print." + propertyPrefix + ".defaultFormat");
        try {
            char dinRowChar = Character.toUpperCase(formatString.charAt(0));
            int clazz = Integer.parseInt(formatString.substring(1).trim());
            defaultFormat = new Format(Format.DinRow.valueOf(Character.toString(dinRowChar)), Format.Type.PORTRAIT, clazz);
        }
        catch (Exception dinRowChar) {
            // empty catch block
        }
        this.formatComboBox = new FormatComboBox(ALLOWED_FORMATS);
        this.formatComboBox.setShowType(false);
        if (defaultFormat != null) {
            this.formatComboBox.setSelectedFormat(defaultFormat);
        } else {
            this.formatComboBox.setSelectedFormat(new Format(Format.DinRow.A, Format.Type.PORTRAIT, 4));
        }
        subFormatPane.add(this.formatComboBox);
        SpringUtilities.makeCompactGrid(subFormatPane, 1, 3, 2, 2, 5, 2);
        formatPane.add((Component)subFormatPane, "West");
        subSubPane.add(formatPane);
        String defaultImageType = ModelEnviroment.getProperties().getProperty("print." + propertyPrefix + ".defaultImageType");
        buttonGroup = new ButtonGroup();
        formatPane = new JPanel(new BorderLayout());
        subFormatPane = new JPanel(new SpringLayout());
        this.bitmap = new JRadioButton(ModelEnviroment.getMessageResolver().resolveMessage("messages.print.bitmap", new Serializable[0]));
        buttonGroup.add(this.bitmap);
        subFormatPane.add(this.bitmap);
        SpringUtilities.makeCompactGrid(subFormatPane, 1, 1, 2, 2, 2, 2);
        formatPane.add((Component)subFormatPane, "West");
        subSubPane.add(formatPane);
        if (objectPrint) {
            boolean defaultOptimalZoom = StringUtil.isTrue(ModelEnviroment.getProperties().getProperty("print." + propertyPrefix + ".defaultOptimalZoom"));
            formatPane = new JPanel(new BorderLayout());
            subFormatPane = new JPanel(new SpringLayout());
            this.optimalZoom = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("messages.print.optimalZoom", new Serializable[0]));
            this.optimalZoom.setSelected(defaultOptimalZoom);
            subFormatPane.add(this.optimalZoom);
            subFormatPane.add(new JLabel());
            double defaultBitmapScale = 1.2;
            try {
                defaultBitmapScale = Double.parseDouble(ModelEnviroment.getProperties().getProperty("print." + propertyPrefix + ".defaultBitmapScale"));
                defaultBitmapScale = Math.max(defaultBitmapScale, 0.1);
                defaultBitmapScale = Math.min(defaultBitmapScale, 5.0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.scale = new JSpinner(new SpinnerNumberModel(defaultBitmapScale, 0.1, 5.0, 0.1));
            subFormatPane.add(this.scale);
            subFormatPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.print.scale", new Serializable[0])));
            this.printStreets = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.print.streets", new Serializable[0]));
            boolean defaultPrintStreets = StringUtil.isTrue(ModelEnviroment.getProperties().getProperty("print." + propertyPrefix + ". defaultPrintStreets"));
            this.printStreets.setSelected(defaultPrintStreets);
            subFormatPane.add(this.printStreets);
            JPanel printStreetPane = new JPanel(new FlowLayout());
            this.streetFontBox = new FontChooserComboBox(fontResource, ModelEnviroment.getProperties().getProperty("print." + propertyPrefix + ".defaultStreetFont"));
            int defaultPrintStreetSize = 12;
            try {
                defaultPrintStreetSize = Integer.parseInt(ModelEnviroment.getProperties().getProperty("print." + propertyPrefix + ".defaultPrintStreetSize"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.streetFontSize = new JSpinner(new SpinnerNumberModel((Number)defaultPrintStreetSize, Integer.valueOf(1), null, (Number)1));
            Dimension dim = this.streetFontSize.getPreferredSize();
            this.streetFontSize.setPreferredSize(new Dimension((int)Math.round(dim.getWidth() * 1.3), (int)dim.getHeight()));
            printStreetPane.add(this.streetFontBox);
            printStreetPane.add(this.streetFontSize);
            subFormatPane.add(printStreetPane);
            this.printPlaces = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.print.places", new Serializable[0]));
            boolean defaultPrintPlaces = StringUtil.isTrue(ModelEnviroment.getProperties().getProperty("print." + propertyPrefix + ". defaultPrintPlaces"));
            this.printPlaces.setSelected(defaultPrintPlaces);
            subFormatPane.add(this.printPlaces);
            JPanel printPlacePane = new JPanel(new FlowLayout());
            this.placeFontBox = new FontChooserComboBox(fontResource, ModelEnviroment.getProperties().getProperty("print." + propertyPrefix + ".defaultPlacesFont"));
            int defaultPrintPlacetSize = 12;
            try {
                defaultPrintPlacetSize = Integer.parseInt(ModelEnviroment.getProperties().getProperty("print." + propertyPrefix + ".defaultPrintPlacetSize"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.placeFontSize = new JSpinner(new SpinnerNumberModel((Number)defaultPrintPlacetSize, Integer.valueOf(1), null, (Number)1));
            dim = this.placeFontSize.getPreferredSize();
            this.placeFontSize.setPreferredSize(new Dimension((int)Math.round(dim.getWidth() * 1.3), (int)dim.getHeight()));
            printPlacePane.add(this.placeFontBox);
            printPlacePane.add(this.placeFontSize);
            subFormatPane.add(printPlacePane);
            this.whiteBackgroundForScale = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.print.whiteBackgroundForScale", new Serializable[0]));
            subFormatPane.add(this.whiteBackgroundForScale);
            subFormatPane.add(new JLabel());
            SpringUtilities.makeCompactGrid(subFormatPane, 5, 2, 30, 2, 10, 2);
            formatPane.add((Component)subFormatPane, "West");
            subSubPane.add(formatPane);
        }
        this.vector = new JRadioButton(ModelEnviroment.getMessageResolver().resolveMessage("messages.print.vector", new Serializable[0]));
        formatPane = new JPanel(new BorderLayout());
        subFormatPane = new JPanel(new SpringLayout());
        subFormatPane.add(this.vector);
        SpringUtilities.makeCompactGrid(subFormatPane, 1, 1, 2, 2, 2, 2);
        formatPane.add((Component)subFormatPane, "West");
        boolean vectorActive = StringUtil.isTrue(ModelEnviroment.getProperties().getProperty("print.vector.active"));
        if (vectorActive) {
            buttonGroup.add(this.vector);
            subSubPane.add(formatPane);
        }
        if (objectPrint) {
            boolean defaultVectorFillUpSpace = StringUtil.isTrue(ModelEnviroment.getProperties().getProperty("print." + propertyPrefix + ".defaultVectorFillUpSpace"));
            formatPane = new JPanel(new BorderLayout());
            subFormatPane = new JPanel(new SpringLayout());
            this.fillupSpace = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("messages.print.fillUpSpace", new Serializable[0]));
            this.fillupSpace.setEnabled(false);
            this.fillupSpace.setSelected(defaultVectorFillUpSpace);
            subFormatPane.add(this.fillupSpace);
            subFormatPane.add(new JLabel());
            int defaultVectorXMargin = 50;
            try {
                defaultVectorXMargin = Integer.parseInt(ModelEnviroment.getProperties().getProperty("print." + propertyPrefix + ".defaultVectorXMargin"));
                defaultVectorXMargin = Math.max(defaultVectorXMargin, 0);
                defaultVectorXMargin = Math.min(defaultVectorXMargin, 1000);
            }
            catch (Exception defaultPrintStreets) {
                // empty catch block
            }
            this.xMargin = new JSpinner(new SpinnerNumberModel(defaultVectorXMargin, 0, 1000, 1));
            this.xMargin.setEnabled(false);
            subFormatPane.add(this.xMargin);
            subFormatPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.print.xMargin", new Serializable[0])));
            int defaultVectorYMargin = 50;
            try {
                defaultVectorYMargin = Integer.parseInt(ModelEnviroment.getProperties().getProperty("print." + propertyPrefix + ".defaultVectorYMargin"));
                defaultVectorYMargin = Math.max(defaultVectorYMargin, 0);
                defaultVectorYMargin = Math.min(defaultVectorYMargin, 1000);
            }
            catch (Exception printStreetPane) {
                // empty catch block
            }
            this.yMargin = new JSpinner(new SpinnerNumberModel(defaultVectorYMargin, 0, 1000, 1));
            this.yMargin.setEnabled(false);
            subFormatPane.add(this.yMargin);
            subFormatPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.print.yMargin", new Serializable[0])));
            SpringUtilities.makeCompactGrid(subFormatPane, 3, 2, 30, 2, 10, 2);
            formatPane.add((Component)subFormatPane, "West");
            if (vectorActive) {
                subSubPane.add(formatPane);
            }
        }
        ActionListener bitmapVectorActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean bitMapSelected = PrintOptionPane.this.bitmap.isSelected();
                if (PrintOptionPane.this.optimalZoom != null) {
                    PrintOptionPane.this.optimalZoom.setEnabled(bitMapSelected);
                }
                if (PrintOptionPane.this.scale != null) {
                    PrintOptionPane.this.scale.setEnabled(bitMapSelected);
                }
                boolean vectorSelected = PrintOptionPane.this.vector.isSelected();
                if (PrintOptionPane.this.fillupSpace != null) {
                    PrintOptionPane.this.fillupSpace.setEnabled(vectorSelected);
                }
                if (PrintOptionPane.this.xMargin != null) {
                    PrintOptionPane.this.xMargin.setEnabled(vectorSelected);
                }
                if (PrintOptionPane.this.yMargin != null) {
                    PrintOptionPane.this.yMargin.setEnabled(vectorSelected);
                }
            }
        };
        this.bitmap.addActionListener(bitmapVectorActionListener);
        this.vector.addActionListener(bitmapVectorActionListener);
        if (defaultImageType == null || !defaultImageType.toUpperCase().equals("VECTOR")) {
            this.bitmap.setSelected(true);
        } else {
            this.vector.setSelected(true);
        }
        bitmapVectorActionListener.actionPerformed(null);
        if (objectPrint) {
            formatPane = new JPanel(new BorderLayout());
            subFormatPane = new JPanel(new SpringLayout());
            this.fontBox = new FontChooserComboBox(fontResource, ModelEnviroment.getProperties().getProperty("print." + propertyPrefix + ".defaultFont"));
            JLabel fontLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.font", new Serializable[0]));
            Font font = fontLabel.getFont();
            subFormatPane.add(fontLabel);
            subFormatPane.add(this.fontBox);
            if (showFooterFontSize) {
                subFormatPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.fontSizeGraphic", new Serializable[0])));
            } else {
                subFormatPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.fontSize", new Serializable[0])));
            }
            JPanel subSubFormatPane = new JPanel(new SpringLayout());
            int defaultFontSize = 11;
            try {
                defaultFontSize = Integer.parseInt(ModelEnviroment.getProperties().getProperty("print." + propertyPrefix + ".defaultFontSize"));
            }
            catch (Exception dim) {
                // empty catch block
            }
            this.fontSize = new JSpinner(new SpinnerNumberModel((Number)defaultFontSize, Integer.valueOf(1), null, (Number)1));
            subSubFormatPane.add(this.fontSize);
            this.fontBold = new JCheckBox();
            boolean defaultBold = StringUtil.isTrue(ModelEnviroment.getProperties().getProperty("print." + propertyPrefix + ".defaultFontBold"));
            this.fontBold.setSelected(defaultBold);
            subSubFormatPane.add(this.fontBold);
            JLabel fontBoldLabel = new JLabel("A");
            fontBoldLabel.setFont(new Font(font.getFontName(), 1, font.getSize()));
            subSubFormatPane.add(fontBoldLabel);
            this.fontItalic = new JCheckBox();
            boolean defaultItalic = StringUtil.isTrue(ModelEnviroment.getProperties().getProperty("print." + propertyPrefix + ".defaultFontItalic"));
            this.fontItalic.setSelected(defaultItalic);
            subSubFormatPane.add(this.fontItalic);
            JLabel fontItalicLabel = new JLabel("A");
            fontItalicLabel.setFont(new Font(font.getFontName(), 2, font.getSize()));
            subSubFormatPane.add(fontItalicLabel);
            this.fontUnderline = new JCheckBox();
            boolean defaultUnderline = StringUtil.isTrue(ModelEnviroment.getProperties().getProperty("print." + propertyPrefix + ".defaultFontUnderline"));
            this.fontUnderline.setSelected(defaultUnderline);
            subSubFormatPane.add(this.fontUnderline);
            JLabel fontUnderlineLabel = new JLabel("<html><u>A</u></html>");
            subSubFormatPane.add(fontUnderlineLabel);
            SpringUtilities.makeCompactGrid(subSubFormatPane, 1, 7, 2, 2, 2, 2);
            subFormatPane.add(subSubFormatPane);
            this.footerFontSize = new JSpinner(new SpinnerNumberModel((Number)defaultFontSize, Integer.valueOf(1), null, (Number)1));
            if (showFooterFontSize) {
                subFormatPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.footerFontSize", new Serializable[0])));
                this.footerFontSize = new JSpinner(new SpinnerNumberModel((Number)defaultFontSize, Integer.valueOf(1), null, (Number)1));
                subFormatPane.add(this.footerFontSize);
                SpringUtilities.makeCompactGrid(subFormatPane, 3, 2, 2, 2, 2, 2);
            } else {
                SpringUtilities.makeCompactGrid(subFormatPane, 2, 2, 2, 2, 2, 2);
            }
            formatPane.add((Component)subFormatPane, "West");
            subSubPane.add(formatPane);
        }
        if ((specialComponent = this.createSpecialComponent(specialComponentOptions)) != null) {
            subSubPane.add(specialComponent);
        }
        if (specialMessage) {
            this.specialMessage = new JTextArea(5, 30);
            subSubPane.add(new JScrollPane(this.specialMessage));
        }
        int rows = 3 + (objectPrint ? 2 : 0) + (specialMessage ? 1 : 0) + (printStyleChoosable ? 1 : 0) + (specialComponent == null ? 0 : 1);
        SpringUtilities.makeCompactGrid(subSubPane, rows += (vectorActive ? 1 : 0) + (vectorActive && objectPrint ? 1 : 0), 1, 5, 5, 2, 2);
        subPane.add((Component)subSubPane, "West");
        this.add((Component)subPane, "North");
    }

    protected Component createSpecialComponent(T specialComponentOptions) {
        return null;
    }

    private JComboBox createStyleBox() {
        String title;
        DefaultComboBoxModel<Style> model = new DefaultComboBoxModel<Style>();
        JComboBox styleBox = new JComboBox(model);
        model.addElement(new Style("Standard", null));
        Collection<AreaLayerModel> areaLayers = this.modelEnviroment.getAllCaller().getAreaCaller().getAreaLayersForType(AreaObjectGenInfoDiscriminator.values());
        for (AreaLayerModel areaLayerModel : areaLayers) {
            model.addElement(new Style(areaLayerModel.getDisplayname(), areaLayerModel.getId().toString()));
        }
        Properties properties = ModelEnviroment.getProperties();
        int i = 1;
        while ((title = properties.getProperty("layerstyle.print." + i + ".title")) != null) {
            model.addElement(new Style(title, "print." + i));
            ++i;
        }
        return styleBox;
    }

    public String getSpecialMessage() {
        return this.specialMessage == null ? null : this.specialMessage.getText();
    }

    public Format getFormat() {
        Format.Type type = Format.Type.PORTRAIT;
        if (this.portrait.isSelected()) {
            type = Format.Type.PORTRAIT;
        } else if (this.landscape.isSelected()) {
            type = Format.Type.LANDSCAPE;
        }
        Format format = this.formatComboBox.getSelectedFormat();
        return new Format(format.getDinRow(), type, format.getClazz());
    }

    public String getSelectedStylePrefix() {
        return this.styleBox == null ? null : ((Style)this.styleBox.getSelectedItem()).getPrefix();
    }

    public boolean isOptimalZoom() {
        return this.optimalZoom != null && this.optimalZoom.isSelected();
    }

    public Integer getDpi() {
        return (Integer)this.dpi.getValue();
    }

    public Double getScale() {
        return this.scale == null ? 1.0 : (Double)this.scale.getValue();
    }

    public boolean isVector() {
        return this.vector.isSelected();
    }

    public Integer getXMargin() {
        return this.xMargin == null ? 0 : (Integer)this.xMargin.getValue();
    }

    public Integer getYMargin() {
        return this.yMargin == null ? 0 : (Integer)this.yMargin.getValue();
    }

    public boolean isFillUpSpace() {
        return this.fillupSpace != null && this.fillupSpace.isSelected();
    }

    public Font getPrintFont() {
        if (this.fontBox == null) {
            return null;
        }
        int style = 0;
        if (this.fontBold.isSelected()) {
            style |= 1;
        }
        if (this.fontItalic.isSelected()) {
            style |= 2;
        }
        Integer size = (Integer)this.fontSize.getValue();
        return new Font(this.fontBox.getSelectedFontName(), style, size);
    }

    public Font getFooterFont() {
        if (this.fontBox == null) {
            return null;
        }
        int style = 0;
        if (this.fontBold.isSelected()) {
            style |= 1;
        }
        if (this.fontItalic.isSelected()) {
            style |= 2;
        }
        Integer size = (Integer)this.footerFontSize.getValue();
        return new Font(this.fontBox.getSelectedFontName(), style, size);
    }

    public boolean isUnderline() {
        return this.fontUnderline != null && this.fontUnderline.isSelected();
    }

    public void setPreferredPrintFont(String fontName, Integer fontSize) {
        if (this.fontBox != null && this.fontSize != null) {
            this.fontBox.setSelectedFont(fontName);
            this.fontSize.setValue(fontSize);
        }
    }

    public Font getPrintPlacesFont() {
        if (this.printPlaces != null && this.printPlaces.isSelected() && this.placeFontBox != null) {
            Integer size = (Integer)this.placeFontSize.getValue();
            return new Font(this.placeFontBox.getSelectedFontName(), 1, size);
        }
        return null;
    }

    public Font getPrintStreetsFont() {
        if (this.printStreets != null && this.printStreets.isSelected() && this.streetFontBox != null) {
            Integer size = (Integer)this.streetFontSize.getValue();
            return new Font(this.streetFontBox.getSelectedFontName(), 0, size);
        }
        return null;
    }

    public boolean isWhiteBackgroundForScale() {
        return this.whiteBackgroundForScale != null && this.whiteBackgroundForScale.isSelected();
    }

    static {
        ArrayList<Format> formats = new ArrayList<Format>();
        formats.add(new Format(Format.DinRow.A, Format.Type.PORTRAIT, 0));
        formats.add(new Format(Format.DinRow.A, Format.Type.PORTRAIT, 1));
        formats.add(new Format(Format.DinRow.A, Format.Type.PORTRAIT, 2));
        formats.add(new Format(Format.DinRow.A, Format.Type.PORTRAIT, 3));
        formats.add(new Format(Format.DinRow.A, Format.Type.PORTRAIT, 4));
        formats.add(new Format(Format.DinRow.A, Format.Type.PORTRAIT, 5));
        ALLOWED_FORMATS = Collections.unmodifiableList(formats);
    }

    private class Style {
        private String name;
        private String prefix;

        public Style(String name, String prefix) {
            this.name = name;
            this.prefix = prefix;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String toString() {
            return this.name;
        }
    }
}

