/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.print;

import de.datomino.peppergis.client.gui.DefaultPointRenderer;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.map.RendererNode;
import de.datomino.peppergis.client.model.map.PlaceModel;
import de.datomino.util.common.CacheUtil;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.model.BucketsFetchCallback;
import de.datomino.util.geo.model.DefaultGeoObjectBucketsModel;
import de.datomino.util.geo.model.GeomExtractor;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.ktde.math.projection.Coordinate;
import org.ktde.swing.navigator.AbstractNavigatorRenderer;
import org.ktde.swing.navigator.OnTopRendering;
import org.ktde.util.datatypes.Tupel;

public class PlaceNameRenderer
extends AbstractNavigatorRenderer {
    private DefaultGeoObjectBucketsModel<PlaceModel, ImmutablePoint> placeBucketsModel;
    private ModelEnviroment modelEnviroment;
    private int maxZoom = 18;
    private int minZoom = 0;
    private int maxCityZoom = 14;
    private int minCityZoom = 6;
    private int maxTownZoom = 18;
    private int minTownZoom = 9;
    private int maxVillageZoom = 18;
    private int minVillageZoom = 12;
    private Font defaultFont;

    public PlaceNameRenderer(ModelEnviroment modelEnviroment, Font defaultFont) {
        super("place name renderer");
        this.modelEnviroment = modelEnviroment;
        this.defaultFont = defaultFont;
    }

    @Override
    public Collection<OnTopRendering> paintOnto(Graphics2D g2d, Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
        DefaultPointRenderer pointRenderer = new DefaultPointRenderer(g2d, upp, this.getCoordinateFactory());
        Coordinate bottomLeft = this.getCoordinateFactory().createCoordinate(realBoundaryBottomLeft.getX(), realBoundaryBottomLeft.getY());
        Coordinate topRight = this.getCoordinateFactory().createCoordinate(realBoundaryTopRight.getX(), realBoundaryTopRight.getY());
        Collection places = this.placeBucketsModel.findObjects(bottomLeft, topRight);
        ArrayList<Tupel<RendererNode, Integer>> nodes = new ArrayList<Tupel<RendererNode, Integer>>();
        ArrayList<Tupel<RendererNode, Integer>> townNodes = new ArrayList<Tupel<RendererNode, Integer>>();
        ArrayList<Tupel<RendererNode, Integer>> villageNodes = new ArrayList<Tupel<RendererNode, Integer>>();
        int zoom = this.computeZoom(upp);
        block6: for (PlaceModel place : places) {
            if (place.getPolygon() != null) continue;
            RendererNode rendererNode = new RendererNode(place.getName(), place.getPoint().getCoordinate(), upp);
            rendererNode.setFontground(Color.BLACK);
            rendererNode.setFontStyle(0);
            int fontSize = 9;
            if (this.defaultFont != null) {
                rendererNode.setFontName(this.defaultFont.getName());
                rendererNode.setFontStyle(this.defaultFont.getStyle());
                fontSize = this.defaultFont.getSize();
            }
            switch (place.getPlaceType()) {
                case STATE: {
                    continue block6;
                }
                case CITY: {
                    if (zoom > this.maxCityZoom || zoom < this.minCityZoom) continue block6;
                    rendererNode.setFontSize((int)((double)fontSize * 2.2));
                    nodes.add(new Tupel<RendererNode, Integer>(rendererNode, place.getPopulation()));
                    continue block6;
                }
                case TOWN: {
                    if (zoom > this.maxTownZoom || zoom < this.minTownZoom) continue block6;
                    rendererNode.setFontSize(fontSize * 2);
                    townNodes.add(new Tupel<RendererNode, Integer>(rendererNode, place.getPopulation()));
                    continue block6;
                }
                case VILLAGE: {
                    if (zoom >= this.maxVillageZoom || zoom < this.minVillageZoom) continue block6;
                    rendererNode.setFontSize((int)((double)fontSize * 1.8));
                    villageNodes.add(new Tupel<RendererNode, Integer>(rendererNode, place.getPopulation()));
                    continue block6;
                }
            }
        }
        Collections.sort(nodes, new PopulationComparator());
        Collections.sort(townNodes, new PopulationComparator());
        Collections.sort(villageNodes, new PopulationComparator());
        nodes.addAll(townNodes);
        nodes.addAll(villageNodes);
        HashSet<Rectangle2D.Double> drawedRectangles = new HashSet<Rectangle2D.Double>();
        for (Tupel tupel : nodes) {
            RendererNode node = (RendererNode)tupel.getElement1();
            Rectangle2D.Double rectangle = this.getRectangle(node);
            if (this.isOverlapped(rectangle, drawedRectangles)) continue;
            drawedRectangles.add(rectangle);
            pointRenderer.drawShape(rectangle, node, 0.0);
            pointRenderer.drawText(node, true, false);
        }
        return Collections.emptyList();
    }

    private Rectangle2D.Double getRectangle(RendererNode node) {
        double d = node.getMargin() * (double)node.getFontSize();
        Coordinate reformed = this.getCoordinateFactory().createCoordinate(node.getCoordinate());
        double textX = reformed.getX() - (double)node.getText().length() * d / 2.0;
        double textY = reformed.getY() - d;
        Rectangle2D.Double rectangle = new Rectangle2D.Double();
        rectangle.x = textX - node.getMargin() - d / 8.0;
        rectangle.y = textY - node.getMargin();
        rectangle.width = (double)node.getText().length() * d * 0.9;
        rectangle.height = d * 1.5;
        return rectangle;
    }

    private boolean isOverlapped(Rectangle2D.Double rectangle, Set<Rectangle2D.Double> drawedRectangles) {
        for (Rectangle2D.Double r : drawedRectangles) {
            if (!r.contains(rectangle) && !r.intersects(rectangle)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void prepare(Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
        if (this.placeBucketsModel == null) {
            this.placeBucketsModel = new DefaultGeoObjectBucketsModel<PlaceModel, ImmutablePoint>(CacheUtil.FACTORY.getRefScale() * 100000.0, this.getCoordinateFactory(), new GeomExtractor<PlaceModel, ImmutablePoint>(){

                @Override
                public ImmutablePoint getGeom(PlaceModel placeModel) {
                    ImmutablePoint point = placeModel.getPoint();
                    if (point == null && placeModel.getPolygon() != null) {
                        point = placeModel.getPolygon().getCentroid();
                    }
                    return point;
                }
            });
            this.placeBucketsModel.setFetchCallback(new BucketsFetchCallback<PlaceModel, ImmutablePoint>(){

                @Override
                public Collection<PlaceModel> fetch(Coordinate topLeft, Coordinate bottomRight) {
                    return PlaceNameRenderer.this.modelEnviroment.getAllCaller().getStreetNetCaller().fetchPlaces(topLeft, bottomRight);
                }
            });
        }
    }

    private int computeZoom(double upp) {
        double upp0 = 140625.0;
        double zoomD = Math.log(upp0 / upp) / Math.log(2.0);
        int zoom = Math.min(Math.max((int)zoomD, this.minZoom), this.maxZoom);
        return zoom;
    }

    private class PopulationComparator
    implements Comparator<Tupel<RendererNode, Integer>> {
        private PopulationComparator() {
        }

        @Override
        public int compare(Tupel<RendererNode, Integer> arg0, Tupel<RendererNode, Integer> arg1) {
            Integer population0 = arg0.getElement2() == null ? Integer.valueOf(-1) : arg0.getElement2();
            Integer population1 = arg1.getElement2() == null ? Integer.valueOf(-1) : arg1.getElement2();
            return population0.compareTo(population1) * -1;
        }
    }
}

