/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.print;

import de.datomino.logistic.dto.LogisticLocationDto;
import de.datomino.logistic.dto.LogisticStopDto;
import de.datomino.pdf.engine.Format;
import de.datomino.pdf.printer.PrinterInformation;
import de.datomino.pdf.printer.PrintingInformation;
import de.datomino.pdf.printer.PrintingObject;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.manager.legend.LegendObject;
import de.datomino.peppergis.client.model.base.LetterAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.base.LetterModel;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.client.model.base.SubscriptionAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.base.SubscriptionModel;
import de.datomino.peppergis.client.model.map.ParcelAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.print.HeaderType;
import de.datomino.peppergis.client.util.AttributeValueDescriptorComparator;
import de.datomino.peppergis.client.util.LetterModelUtil;
import de.datomino.peppergis.client.util.ParcelModelUtil;
import de.datomino.peppergis.client.util.PoiModelUtil;
import de.datomino.peppergis.client.util.StopModelUtil;
import de.datomino.peppergis.client.util.SubscriptionModelUtil;
import de.datomino.peppergis.client.util.wrapper.common.attribute.AttributeValueDescriptorModel;
import de.datomino.peppergis.client.util.wrapper.letter.attribute.LetterAttributeValueDescriptorModelAttributeWrapper;
import de.datomino.peppergis.client.util.wrapper.parcel.attribute.ParcelAttributeValueDescriptorModelAttributeWrapper;
import de.datomino.peppergis.client.util.wrapper.subscription.attribute.SubscriptionAttributeValueDescriptorModelAttributeWrapper;
import de.datomino.peppergis.helper.PointEntityId;
import de.datomino.peppergis.print.PrintContentValue;
import de.datomino.peppergis.print.PrintProperties;
import de.datomino.peppergis.print.PrintPropertyKey;
import de.datomino.peppergis.print.TableRowEntity;
import de.datomino.peppergis.type.AttributeValueType;
import de.datomino.peppergis.type.PrintContentKey;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.util.collection.CollectionUtil;
import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tripel;
import org.ktde.util.datatypes.Tupel;

public class DefaultPrintingInformation<O>
extends PrintingInformation<O> {
    protected ModelEnviroment modelEnviroment;
    private boolean top = false;
    private boolean down = false;
    protected List<PrintingObject> printingObjects = new LinkedList<PrintingObject>();
    private List<SubscriptionAttributeValueDescriptorModelAttributeWrapper> subscriptionDescriptors = new ArrayList<SubscriptionAttributeValueDescriptorModelAttributeWrapper>();
    private List<ParcelAttributeValueDescriptorModelAttributeWrapper> parcelDescriptors = new ArrayList<ParcelAttributeValueDescriptorModelAttributeWrapper>();
    private List<LetterAttributeValueDescriptorModelAttributeWrapper> letterDescriptors = new ArrayList<LetterAttributeValueDescriptorModelAttributeWrapper>();
    private List<Tupel<String, Integer>> mixedDescriptors = new ArrayList<Tupel<String, Integer>>();

    public DefaultPrintingInformation(List<O> os, String imagePath, Format imageFormat, ModelEnviroment modelEnviroment) {
        super(os, imagePath, imageFormat);
        AttributeValueDescriptorModel[] attributeValueDescriptorModels;
        this.modelEnviroment = modelEnviroment;
        Collection<SubscriptionAttributeValueDescriptorModel> subDescriptors = this.modelEnviroment.getAllCaller().getSubscriptionCaller().getAllSubscriptionAttributeValueDescriptors();
        for (SubscriptionAttributeValueDescriptorModel descriptor : subDescriptors) {
            if (descriptor == null || descriptor.getCanPrint() == null || !descriptor.getCanPrint().booleanValue()) continue;
            this.subscriptionDescriptors.add(new SubscriptionAttributeValueDescriptorModelAttributeWrapper(descriptor));
        }
        AttributeValueDescriptorComparator subComparator = new AttributeValueDescriptorComparator();
        Collections.sort(this.subscriptionDescriptors, subComparator);
        Collection<ParcelAttributeValueDescriptorModel> parcelDescriptors = this.modelEnviroment.getAllCaller().getStreetNetCaller().fetchAllParcelAttributeValueDescriptors();
        for (ParcelAttributeValueDescriptorModel descriptor : parcelDescriptors) {
            if (descriptor == null || descriptor.getCanPrint() == null || !descriptor.getCanPrint().booleanValue()) continue;
            this.parcelDescriptors.add(new ParcelAttributeValueDescriptorModelAttributeWrapper(descriptor));
        }
        AttributeValueDescriptorComparator parcelComparator = new AttributeValueDescriptorComparator();
        Collections.sort(this.parcelDescriptors, parcelComparator);
        Collection<LetterAttributeValueDescriptorModel> letterDescriptors = this.modelEnviroment.getAllCaller().getLetterCaller().getAllLetterAttributeValueDescriptors();
        for (LetterAttributeValueDescriptorModel descriptor : letterDescriptors) {
            if (descriptor == null || descriptor.getCanPrint() == null || !descriptor.getCanPrint().booleanValue()) continue;
            this.letterDescriptors.add(new LetterAttributeValueDescriptorModelAttributeWrapper(descriptor));
        }
        AttributeValueDescriptorComparator letterComparator = new AttributeValueDescriptorComparator();
        Collections.sort(this.letterDescriptors, letterComparator);
        HashMap<String, AttributeValueDescriptorModel[]> mixedMap = new HashMap<String, AttributeValueDescriptorModel[]>();
        for (ParcelAttributeValueDescriptorModel parcelAttributeValueDescriptorModel : parcelDescriptors) {
            if (parcelAttributeValueDescriptorModel == null || parcelAttributeValueDescriptorModel.getCanPrint() == null || !parcelAttributeValueDescriptorModel.getCanPrint().booleanValue()) continue;
            String string = parcelAttributeValueDescriptorModel.getKey();
            attributeValueDescriptorModels = (AttributeValueDescriptorModel[])mixedMap.get(string);
            if (attributeValueDescriptorModels == null) {
                attributeValueDescriptorModels = new AttributeValueDescriptorModel[3];
                mixedMap.put(string, attributeValueDescriptorModels);
            }
            attributeValueDescriptorModels[0] = new ParcelAttributeValueDescriptorModelAttributeWrapper(parcelAttributeValueDescriptorModel);
        }
        for (SubscriptionAttributeValueDescriptorModel subscriptionAttributeValueDescriptorModel : subDescriptors) {
            if (subscriptionAttributeValueDescriptorModel == null || subscriptionAttributeValueDescriptorModel.getCanPrint() == null || !subscriptionAttributeValueDescriptorModel.getCanPrint().booleanValue()) continue;
            String string = subscriptionAttributeValueDescriptorModel.getKey();
            attributeValueDescriptorModels = (AttributeValueDescriptorModel[])mixedMap.get(string);
            if (attributeValueDescriptorModels == null) {
                attributeValueDescriptorModels = new AttributeValueDescriptorModel[3];
                mixedMap.put(string, attributeValueDescriptorModels);
            }
            attributeValueDescriptorModels[1] = new SubscriptionAttributeValueDescriptorModelAttributeWrapper(subscriptionAttributeValueDescriptorModel);
        }
        for (LetterAttributeValueDescriptorModel letterAttributeValueDescriptorModel : letterDescriptors) {
            if (letterAttributeValueDescriptorModel == null || letterAttributeValueDescriptorModel.getCanPrint() == null || !letterAttributeValueDescriptorModel.getCanPrint().booleanValue()) continue;
            String string = letterAttributeValueDescriptorModel.getKey();
            attributeValueDescriptorModels = (AttributeValueDescriptorModel[])mixedMap.get(string);
            if (attributeValueDescriptorModels == null) {
                attributeValueDescriptorModels = new AttributeValueDescriptorModel[3];
                mixedMap.put(string, attributeValueDescriptorModels);
            }
            attributeValueDescriptorModels[2] = new LetterAttributeValueDescriptorModelAttributeWrapper(letterAttributeValueDescriptorModel);
        }
        ArrayList mixedList = new ArrayList(mixedMap.size());
        block6: for (Map.Entry entry : mixedMap.entrySet()) {
            AttributeValueDescriptorModel[] value = (AttributeValueDescriptorModel[])entry.getValue();
            Integer maxPrintLength = null;
            for (AttributeValueDescriptorModel a : value) {
                if (a == null) continue block6;
                Integer printLength = a.getPrintLength();
                if (maxPrintLength != null && (printLength == null || printLength <= maxPrintLength)) continue;
                maxPrintLength = printLength;
            }
            mixedList.add(new Tripel(entry.getKey(), new Integer[]{value[0].getSortOrder(), value[1].getSortOrder(), value[3].getSortOrder()}, maxPrintLength));
        }
        Collections.sort(mixedList, new Comparator<Tripel<String, Integer[], Integer>>(){

            @Override
            public int compare(Tripel<String, Integer[], Integer> o1, Tripel<String, Integer[], Integer> o2) {
                Integer[] i1 = o1.getElement2();
                Integer[] i2 = o2.getElement2();
                for (int i = 0; i < 3; ++i) {
                    Integer v1 = i1[i];
                    Integer v2 = i2[i];
                    if (v1 == v2) continue;
                    if (v1 == null) {
                        return 1;
                    }
                    if (v2 == null) {
                        return -1;
                    }
                    return v1.compareTo(v2);
                }
                return 0;
            }
        });
        for (Tripel tripel : mixedList) {
            this.mixedDescriptors.add(new Tupel(tripel.getElement1(), tripel.getElement3()));
        }
    }

    protected Tripel<List<String>, List<String>, Color> getRow(LegendObject<? extends Object> legendObject, PrinterInformation.LineGroupType lineGroupType, boolean mixed) {
        Object model = legendObject.getM();
        Color color = legendObject.getColor();
        PrintProperties printProperties = this.modelEnviroment.getPrintProperties();
        TableRowEntity row = new TableRowEntity();
        if (model instanceof StopModel) {
            StopModelUtil.getPrintingInformation((StopModel)model, color, row, printProperties.getTourProperties());
        } else if (model instanceof SubscriptionModel) {
            SubscriptionModelUtil.getPrintInformation(legendObject, this.subscriptionDescriptors, color, lineGroupType, row, mixed ? printProperties.getMixedProperties() : printProperties.getSubscriptionProperties(), mixed);
        } else if (model instanceof ParcelModel) {
            ParcelModelUtil.getPrintingInformation(legendObject, this.parcelDescriptors, color, lineGroupType, row, mixed ? printProperties.getMixedProperties() : printProperties.getParcelProperties(), mixed);
        } else if (model instanceof LetterModel) {
            LetterModelUtil.getPrintInformation(legendObject, this.letterDescriptors, color, lineGroupType, row, mixed ? printProperties.getMixedProperties() : printProperties.getLetterProperties(), mixed);
        } else if (model instanceof PoiModel) {
            PoiModelUtil.getPrintingInformation((PoiModel)model, color, PrinterInformation.LineGroupType.NORMAL, row, mixed ? printProperties.getMixedProperties() : printProperties.getSubscriptionProperties(), mixed);
        } else if (model instanceof LogisticStopDto) {
            LogisticStopDto stop = (LogisticStopDto)model;
            Object id = stop.getId();
            if (id instanceof PointEntityId) {
                PointEntityId entityId = (PointEntityId)id;
                switch (entityId.getPointEnityType()) {
                    case LETTER: {
                        Collection<LetterModel> letters = this.modelEnviroment.getAllCaller().getLetterCaller().fetchLettersByIds(CollectionUtil.buildArrayList(entityId.getId()));
                        LegendObject<LetterModel> letterLegendObject = this.cloneLegendObject(legendObject, letters.iterator().next());
                        LetterModelUtil.getPrintInformation(letterLegendObject, this.letterDescriptors, color, lineGroupType, row, mixed ? printProperties.getMixedProperties() : printProperties.getLetterProperties(), mixed);
                        break;
                    }
                    case PARCEL: {
                        ParcelModel parcel = this.modelEnviroment.getAllCaller().getStreetNetCaller().fetchParcelById(entityId.getId());
                        LegendObject<ParcelModel> parcelLegendObject = this.cloneLegendObject(legendObject, parcel);
                        ParcelModelUtil.getPrintingInformation(parcelLegendObject, this.parcelDescriptors, color, lineGroupType, row, mixed ? printProperties.getMixedProperties() : printProperties.getParcelProperties(), mixed);
                        break;
                    }
                    case SUBSCRIPTION: {
                        List<SubscriptionModel> subscriptions = this.modelEnviroment.getAllCaller().getSubscriptionCaller().fetchSubscriptionsByIds(CollectionUtil.buildArrayList(entityId.getId()));
                        LegendObject<SubscriptionModel> subscriptionLegendObject = this.cloneLegendObject(legendObject, subscriptions.iterator().next());
                        SubscriptionModelUtil.getPrintInformation(subscriptionLegendObject, this.subscriptionDescriptors, color, lineGroupType, row, mixed ? printProperties.getMixedProperties() : printProperties.getSubscriptionProperties(), mixed);
                        break;
                    }
                    case POI: {
                        Collection<PoiModel> pois = this.modelEnviroment.getAllCaller().getBaseCaller().fetchPoiByIds(Collections.singletonList(entityId.getId()));
                        PoiModelUtil.getPrintingInformation(pois.iterator().next(), color, PrinterInformation.LineGroupType.NORMAL, row, mixed ? printProperties.getMixedProperties() : printProperties.getSubscriptionProperties(), mixed);
                        break;
                    }
                }
            } else {
                LogisticLocationDto location = stop.getLocation();
                String countryString = location.getCountry() == null ? null : location.getCountry().getVehicleSign();
                String cityString = location.getCity() == null ? "" : FormUtil.getStringDisplay(location.getCity());
                String districtString = location.getDistrict() == null ? "" : FormUtil.getStringDisplay(location.getDistrict());
                String postcodeString = location.getPostcode() == null ? "" : FormUtil.getStringDisplay(location.getPostcode());
                String streetName = location.getStreet() == null ? null : FormUtil.getStringDisplay(location.getStreet());
                String hausNumberString = location.getHousenumber() == null ? "" : location.getHousenumber();
                String hausNumberExString = location.getExtension() == null ? "" : location.getExtension();
                DefaultPrintingInformation.addAddressRow(countryString, cityString, districtString, postcodeString, streetName, hausNumberString, hausNumberExString, printProperties.getParcelProperties(), row, color, lineGroupType);
            }
        }
        return row.getRow(color);
    }

    private <T> LegendObject<T> cloneLegendObject(LegendObject<?> legendObject, T t) {
        LegendObject<T> sLegendObject = new LegendObject<T>(t, legendObject.getColor(), legendObject.getSortOrder());
        sLegendObject.setInfo(legendObject.getInfo());
        sLegendObject.setEstimatedDurationSeconds(legendObject.getEstimatedDurationSeconds());
        sLegendObject.setEstimatedTimeOfArrival(legendObject.getEstimatedTimeOfArrival());
        sLegendObject.setStreetMileageMetersFromTourStart(legendObject.getStreetMileageMetersFromTourStart());
        return sLegendObject;
    }

    protected List<Tripel<Integer, String, Color>> getPrintingTableHeader(HeaderType headerType, PrinterInformation.LineGroupType lineGroupType) {
        PrintProperties printProperties = this.modelEnviroment.getPrintProperties();
        TableRowEntity header = new TableRowEntity();
        switch (headerType) {
            case SUBSCRIPTION: {
                Map<PrintPropertyKey, Serializable> subscriptionProperties = printProperties.getSubscriptionProperties();
                this.addAddressHeader(subscriptionProperties, header, Color.BLACK, lineGroupType);
                ((PrintContentValue)subscriptionProperties.get(PrintContentKey.INDEX)).addCell("", Color.BLACK, header);
                if (lineGroupType != PrinterInformation.LineGroupType.NORMAL) break;
                for (SubscriptionAttributeValueDescriptorModelAttributeWrapper descriptor : this.subscriptionDescriptors) {
                    if (descriptor == null || descriptor.getAttributeValueType() == AttributeValueType.TEXT) continue;
                    Integer printLength = descriptor.getPrintLength() == null ? 10 : descriptor.getPrintLength();
                    header.addCell(printLength, descriptor.getKey().split(" ")[0], Color.BLACK, descriptor.getPrintSortOrder());
                }
                ((PrintContentValue)subscriptionProperties.get(PrintContentKey.CUSTOMER)).addCell(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.clientname", new Serializable[0]), Color.BLACK, header);
                ((PrintContentValue)subscriptionProperties.get(PrintContentKey.DISTANCE_FROM_START)).addCell(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.distance", new Serializable[0]), Color.BLACK, header);
                ((PrintContentValue)subscriptionProperties.get(PrintContentKey.DURATION_FROM_START)).addCell(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.duration", new Serializable[0]), Color.BLACK, header);
                break;
            }
            case PARCEL: {
                Map<PrintPropertyKey, Serializable> parcelProperties = printProperties.getParcelProperties();
                this.addAddressHeader(parcelProperties, header, Color.BLACK, lineGroupType);
                ((PrintContentValue)parcelProperties.get(PrintContentKey.INDEX)).addCell("", Color.BLACK, header);
                if (lineGroupType != PrinterInformation.LineGroupType.NORMAL) break;
                for (ParcelAttributeValueDescriptorModelAttributeWrapper descriptor : this.parcelDescriptors) {
                    if (descriptor == null || descriptor.getAttributeValueType() == AttributeValueType.TEXT) continue;
                    Integer printLength = descriptor.getPrintLength() == null ? 10 : descriptor.getPrintLength();
                    header.addCell(printLength, descriptor.getKey().split(" ")[0], Color.BLACK, descriptor.getPrintSortOrder());
                }
                ((PrintContentValue)parcelProperties.get(PrintContentKey.DISTANCE_FROM_START)).addCell(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.distance", new Serializable[0]), Color.BLACK, header);
                ((PrintContentValue)parcelProperties.get(PrintContentKey.DURATION_FROM_START)).addCell(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.duration", new Serializable[0]), Color.BLACK, header);
                break;
            }
            case STOP: {
                Map<PrintPropertyKey, Serializable> tourProperties = printProperties.getTourProperties();
                this.addTableHeaderForTour(tourProperties, header);
                break;
            }
            case LETTER: {
                Map<PrintPropertyKey, Serializable> letterProperties = printProperties.getLetterProperties();
                this.addAddressHeader(letterProperties, header, Color.BLACK, lineGroupType);
                ((PrintContentValue)letterProperties.get(PrintContentKey.INDEX)).addCell("", Color.BLACK, header);
                if (lineGroupType != PrinterInformation.LineGroupType.NORMAL) break;
                for (LetterAttributeValueDescriptorModelAttributeWrapper descriptor : this.letterDescriptors) {
                    if (descriptor == null || descriptor.getAttributeValueType() == AttributeValueType.TEXT) continue;
                    Integer printLength = descriptor.getPrintLength() == null ? 10 : descriptor.getPrintLength();
                    header.addCell(printLength, descriptor.getKey().split(" ")[0], Color.BLACK, descriptor.getPrintSortOrder());
                }
                ((PrintContentValue)letterProperties.get(PrintContentKey.CUSTOMER)).addCell(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.clientname", new Serializable[0]), Color.BLACK, header);
                ((PrintContentValue)letterProperties.get(PrintContentKey.DISTANCE_FROM_START)).addCell(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.distance", new Serializable[0]), Color.BLACK, header);
                ((PrintContentValue)letterProperties.get(PrintContentKey.DURATION_FROM_START)).addCell(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.duration", new Serializable[0]), Color.BLACK, header);
                break;
            }
            case MIXED: {
                Map<PrintPropertyKey, Serializable> mixedProperties = printProperties.getLetterProperties();
                this.addAddressHeader(mixedProperties, header, Color.BLACK, lineGroupType);
                ((PrintContentValue)mixedProperties.get(PrintContentKey.INDEX)).addCell("", Color.BLACK, header);
                if (lineGroupType != PrinterInformation.LineGroupType.NORMAL) break;
                int sortOrder = 0;
                for (Tupel<String, Integer> descriptor : this.mixedDescriptors) {
                    Integer printLength = descriptor.getElement2() == null ? Integer.valueOf(10) : descriptor.getElement2();
                    header.addCell(printLength, descriptor.getElement1().split(" ")[0], Color.BLACK, sortOrder++);
                }
                ((PrintContentValue)mixedProperties.get(PrintContentKey.CUSTOMER)).addCell(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.clientname", new Serializable[0]), Color.BLACK, header);
                ((PrintContentValue)mixedProperties.get(PrintContentKey.DISTANCE_FROM_START)).addCell(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.distance", new Serializable[0]), Color.BLACK, header);
                ((PrintContentValue)mixedProperties.get(PrintContentKey.DURATION_FROM_START)).addCell(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.duration", new Serializable[0]), Color.BLACK, header);
                break;
            }
        }
        return header.getHeader();
    }

    protected List<String> extractLines(String specialMessageText) {
        List<String> lines;
        List<String> list = lines = StringUtil.isBlank(specialMessageText) ? null : StringUtil.explode(specialMessageText, '\n');
        if (lines != null) {
            ArrayList<String> transformed = new ArrayList<String>(lines.size());
            for (String line : lines) {
                if (line.isEmpty()) {
                    transformed.add("\n");
                    continue;
                }
                transformed.add(line);
            }
            return transformed;
        }
        return lines;
    }

    protected int addRow(List<Tripel<List<String>, List<String>, Color>> table, Tripel<List<String>, List<String>, Color> currentRow, int objectIndex, boolean isPoi, PrinterInformation.LineGroupType lineGroupType, LineGroupIndex lineGroupIndex, HeaderType headerType) {
        List<String> currentLine = currentRow.getElement1();
        if (isPoi) {
            currentLine.add(0, "0");
            table.add(currentRow);
            return objectIndex;
        }
        PrintProperties printProperties = this.modelEnviroment.getPrintProperties();
        boolean withIndex = true;
        switch (headerType) {
            case PARCEL: {
                withIndex = ((PrintContentValue)printProperties.getParcelProperties().get(PrintContentKey.INDEX)).isPrint();
                break;
            }
            case STOP: {
                withIndex = ((PrintContentValue)printProperties.getTourProperties().get(PrintContentKey.INDEX)).isPrint();
                break;
            }
            case SUBSCRIPTION: {
                withIndex = ((PrintContentValue)printProperties.getSubscriptionProperties().get(PrintContentKey.INDEX)).isPrint();
                break;
            }
            case LETTER: {
                withIndex = ((PrintContentValue)printProperties.getLetterProperties().get(PrintContentKey.INDEX)).isPrint();
                break;
            }
            case MIXED: {
                withIndex = ((PrintContentValue)printProperties.getMixedProperties().get(PrintContentKey.INDEX)).isPrint();
            }
        }
        if (withIndex) {
            currentLine.add(0, String.valueOf(objectIndex));
        }
        ++objectIndex;
        List<String> lastLine = null;
        switch (lineGroupType) {
            case ADDRESS: 
            case STREET: {
                switch (lineGroupIndex.type) {
                    case PARCEL: {
                        lastLine = this.groupLineForParcel(table, currentRow, lineGroupIndex, currentLine);
                        break;
                    }
                    case SUBSCRIPTION: {
                        lastLine = this.groupLineForSubscription(table, currentRow, lineGroupIndex, currentLine);
                        break;
                    }
                    case STOP: {
                        break;
                    }
                    case LETTER: {
                        lastLine = this.groupLineForLetter(table, currentRow, lineGroupIndex, currentLine);
                        break;
                    }
                    case MIXED: {
                        lastLine = this.groupLineForMixed(table, currentRow, lineGroupIndex, currentLine);
                    }
                }
                break;
            }
        }
        if (lastLine == null) {
            table.add(currentRow);
        }
        return objectIndex;
    }

    private List<String> groupLineForMixed(List<Tripel<List<String>, List<String>, Color>> table, Tripel<List<String>, List<String>, Color> currentRow, LineGroupIndex lineGroupIndex, List<String> currentLine) {
        String currentHnEx;
        List lastLine;
        Tripel<List<String>, List<String>, Color> lastRow = table.isEmpty() ? null : table.get(table.size() - 1);
        List list = lastLine = lastRow == null ? null : (List)lastRow.getElement1();
        if (lastLine == null || StringUtil.isEmpty((String)lastLine.get(0))) {
            lastLine = null;
            return lastLine;
        }
        String lastPostcode = lineGroupIndex.postcodeIndex == -1 ? "" : (String)lastLine.get(lineGroupIndex.postcodeIndex);
        String lastStreet = lineGroupIndex.streetIndex == -1 ? "" : (String)lastLine.get(lineGroupIndex.streetIndex);
        String lastHn = lineGroupIndex.hnGroupIndex == -1 ? "" : (String)lastLine.get(lineGroupIndex.hnGroupIndex);
        String lastHnEx = lineGroupIndex.hnExGroupIndex == -1 ? "" : (String)lastLine.get(lineGroupIndex.hnExGroupIndex);
        String currentPostcode = lineGroupIndex.postcodeIndex == -1 ? "" : currentLine.get(lineGroupIndex.postcodeIndex);
        String currentStreet = lineGroupIndex.streetIndex == -1 ? "" : currentLine.get(lineGroupIndex.streetIndex);
        String currentHn = lineGroupIndex.hnGroupIndex == -1 ? "" : currentLine.get(lineGroupIndex.hnGroupIndex);
        String string = currentHnEx = lineGroupIndex.hnExGroupIndex == -1 ? "" : currentLine.get(lineGroupIndex.hnExGroupIndex);
        if (!(lastPostcode.equals(currentPostcode) && lastStreet.equals(currentStreet) && lastHn.equals(currentHn) && lastHnEx.equals(currentHnEx))) {
            lastLine = null;
            return lastLine;
        }
        this.mergeRows(currentRow, lastRow);
        return lastLine;
    }

    private List<String> groupLineForLetter(List<Tripel<List<String>, List<String>, Color>> table, Tripel<List<String>, List<String>, Color> currentRow, LineGroupIndex lineGroupIndex, List<String> currentLine) {
        String currentHnEx;
        List lastLine;
        Tripel<List<String>, List<String>, Color> lastRow = table.isEmpty() ? null : table.get(table.size() - 1);
        List list = lastLine = lastRow == null ? null : (List)lastRow.getElement1();
        if (lastLine == null || StringUtil.isEmpty((String)lastLine.get(0))) {
            lastLine = null;
            return lastLine;
        }
        String lastPostcode = lineGroupIndex.postcodeIndex == -1 ? "" : (String)lastLine.get(lineGroupIndex.postcodeIndex);
        String lastStreet = lineGroupIndex.streetIndex == -1 ? "" : (String)lastLine.get(lineGroupIndex.streetIndex);
        String lastHn = lineGroupIndex.hnGroupIndex == -1 ? "" : (String)lastLine.get(lineGroupIndex.hnGroupIndex);
        String lastHnEx = lineGroupIndex.hnExGroupIndex == -1 ? "" : (String)lastLine.get(lineGroupIndex.hnExGroupIndex);
        String currentPostcode = lineGroupIndex.postcodeIndex == -1 ? "" : currentLine.get(lineGroupIndex.postcodeIndex);
        String currentStreet = lineGroupIndex.streetIndex == -1 ? "" : currentLine.get(lineGroupIndex.streetIndex);
        String currentHn = lineGroupIndex.hnGroupIndex == -1 ? "" : currentLine.get(lineGroupIndex.hnGroupIndex);
        String string = currentHnEx = lineGroupIndex.hnExGroupIndex == -1 ? "" : currentLine.get(lineGroupIndex.hnExGroupIndex);
        if (!(lastPostcode.equals(currentPostcode) && lastStreet.equals(currentStreet) && lastHn.equals(currentHn) && lastHnEx.equals(currentHnEx))) {
            lastLine = null;
            return lastLine;
        }
        this.mergeRows(currentRow, lastRow);
        return lastLine;
    }

    protected void checkRow(List<Tripel<Integer, String, Color>> header, Tripel<List<String>, List<String>, Color> row) {
        block4: {
            int size;
            List<String> cells;
            block3: {
                cells = row.getElement1();
                size = cells.size();
                if (size >= header.size()) break block3;
                for (int i = size; i < header.size(); ++i) {
                    cells.add("");
                }
                break block4;
            }
            if (size <= header.size()) break block4;
            ListIterator<String> iter = cells.listIterator(header.size() - 1);
            StringBuilder sb = new StringBuilder((String)iter.next());
            while (iter.hasNext()) {
                sb.append(", ").append((String)iter.next());
            }
            cells.set(header.size() - 1, sb.toString());
            for (int i = size - 1; i >= header.size(); --i) {
                cells.remove(i);
            }
        }
    }

    private List<String> groupLineForSubscription(List<Tripel<List<String>, List<String>, Color>> table, Tripel<List<String>, List<String>, Color> currentRow, LineGroupIndex lineGroupIndex, List<String> currentLine) {
        String currentHnEx;
        List lastLine;
        Tripel<List<String>, List<String>, Color> lastRow = table.isEmpty() ? null : table.get(table.size() - 1);
        List list = lastLine = lastRow == null ? null : (List)lastRow.getElement1();
        if (lastLine == null || StringUtil.isEmpty((String)lastLine.get(0))) {
            lastLine = null;
            return lastLine;
        }
        String lastPostcode = lineGroupIndex.postcodeIndex == -1 ? "" : (String)lastLine.get(lineGroupIndex.postcodeIndex);
        String lastStreet = lineGroupIndex.streetIndex == -1 ? "" : (String)lastLine.get(lineGroupIndex.streetIndex);
        String lastHn = lineGroupIndex.hnGroupIndex == -1 ? "" : (String)lastLine.get(lineGroupIndex.hnGroupIndex);
        String lastHnEx = lineGroupIndex.hnExGroupIndex == -1 ? "" : (String)lastLine.get(lineGroupIndex.hnExGroupIndex);
        String currentPostcode = lineGroupIndex.postcodeIndex == -1 ? "" : currentLine.get(lineGroupIndex.postcodeIndex);
        String currentStreet = lineGroupIndex.streetIndex == -1 ? "" : currentLine.get(lineGroupIndex.streetIndex);
        String currentHn = lineGroupIndex.hnGroupIndex == -1 ? "" : currentLine.get(lineGroupIndex.hnGroupIndex);
        String string = currentHnEx = lineGroupIndex.hnExGroupIndex == -1 ? "" : currentLine.get(lineGroupIndex.hnExGroupIndex);
        if (!(lastPostcode.equals(currentPostcode) && lastStreet.equals(currentStreet) && lastHn.equals(currentHn) && lastHnEx.equals(currentHnEx))) {
            lastLine = null;
            return lastLine;
        }
        this.mergeRows(currentRow, lastRow);
        return lastLine;
    }

    private List<String> groupLineForParcel(List<Tripel<List<String>, List<String>, Color>> table, Tripel<List<String>, List<String>, Color> currentRow, LineGroupIndex streetGroupIndex, List<String> currentLine) {
        String currentStreet;
        List lastLine;
        Tripel<List<String>, List<String>, Color> lastRow = table.isEmpty() ? null : table.get(table.size() - 1);
        List list = lastLine = lastRow == null ? null : (List)lastRow.getElement1();
        if (lastLine == null || StringUtil.isEmpty((String)lastLine.get(0))) {
            lastLine = null;
            return lastLine;
        }
        String lastPostcode = streetGroupIndex.postcodeIndex == -1 ? "" : (String)lastLine.get(streetGroupIndex.postcodeIndex);
        String lastStreetGroup = streetGroupIndex.streetGroupIndex < 0 || lastLine.get(streetGroupIndex.streetGroupIndex) == null ? "" : (String)lastLine.get(streetGroupIndex.streetGroupIndex);
        int parenthesisIndex = lastStreetGroup.indexOf("(");
        String lastStreet = parenthesisIndex >= 0 ? lastStreetGroup.substring(0, parenthesisIndex) : lastStreetGroup;
        String currentPostcode = streetGroupIndex.postcodeIndex == -1 ? "" : currentLine.get(streetGroupIndex.postcodeIndex);
        String currentStreetGroup = streetGroupIndex.streetGroupIndex < 0 || currentLine.get(streetGroupIndex.streetGroupIndex) == null ? "" : currentLine.get(streetGroupIndex.streetGroupIndex);
        parenthesisIndex = currentStreetGroup.indexOf("(");
        String string = currentStreet = parenthesisIndex >= 0 ? currentStreetGroup.substring(0, parenthesisIndex) : currentStreetGroup;
        if (!lastPostcode.equals(currentPostcode) || !lastStreet.equals(currentStreet)) {
            lastLine = null;
            return lastLine;
        }
        lastStreetGroup = lastStreetGroup.replaceAll(lastStreet, "").replaceAll("\\(", "").replaceAll("\\)", "");
        currentStreetGroup = currentStreetGroup.replaceAll(lastStreet, "").replaceAll("\\(", "").replaceAll("\\)", "");
        lastStreetGroup = lastStreetGroup + ", " + (StringUtil.isEmpty(currentStreetGroup) ? "Null" : currentStreetGroup);
        if (streetGroupIndex.streetGroupIndex >= 0) {
            lastLine.set(streetGroupIndex.streetGroupIndex, lastStreet + "(" + lastStreetGroup + ")");
        }
        this.mergeRows(currentRow, lastRow);
        return lastLine;
    }

    private void mergeRows(Tripel<List<String>, List<String>, Color> row1, Tripel<List<String>, List<String>, Color> row2) {
        Color currentColor;
        List<String> currentInfo = row1.getElement2();
        if (currentInfo != null && !currentInfo.isEmpty()) {
            List<String> lastInfo = row2.getElement2();
            if (lastInfo == null) {
                lastInfo = new ArrayList<String>();
                row2.setElement2(lastInfo);
            }
            lastInfo.addAll(currentInfo);
        }
        if ((currentColor = row1.getElement3()) != null && currentColor != Color.BLACK) {
            row2.setElement3(currentColor);
        }
    }

    protected LineGroupIndex getLineGroupIndex(List<Tripel<Integer, String, Color>> header, PrinterInformation printerInformation, HeaderType headerType) {
        LineGroupIndex streetGroupIndex = new LineGroupIndex(headerType);
        if (printerInformation.getLineGroupType() != null && printerInformation.getLineGroupType() != PrinterInformation.LineGroupType.NORMAL) {
            PrintProperties printProperties = this.modelEnviroment.getPrintProperties();
            Map<PrintPropertyKey, Serializable> properties = null;
            switch (headerType) {
                case PARCEL: {
                    properties = printProperties.getParcelProperties();
                    break;
                }
                case STOP: {
                    properties = printProperties.getTourProperties();
                    break;
                }
                case SUBSCRIPTION: {
                    properties = printProperties.getSubscriptionProperties();
                }
            }
            int i = 0;
            String postcodeHead = FormUtil.getStringWithLength(ModelEnviroment.getMessageResolver().resolveMessage("address.postcode", new Serializable[0]), ((PrintContentValue)properties.get(PrintContentKey.POSTCODE)).getWidth());
            String streetHead = FormUtil.getStringWithLength(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.street", new Serializable[0]), ((PrintContentValue)properties.get(PrintContentKey.STREET)).getWidth());
            String streetGroupHead = headerType == HeaderType.SUBSCRIPTION ? null : FormUtil.getStringWithLength(ModelEnviroment.getMessageResolver().resolveMessage("gui.location.useAddress", new Serializable[0]), ((PrintContentValue)properties.get(PrintContentKey.ADDRESS_GROUP)).getWidth());
            String hnGroupHead = FormUtil.getStringWithLength(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.print.housenumber", new Serializable[0]), ((PrintContentValue)properties.get(PrintContentKey.HOUSE_NUMBER)).getWidth());
            String hnExGroupHead = FormUtil.getStringWithLength(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.housenumberExtension", new Serializable[0]), ((PrintContentValue)properties.get(PrintContentKey.HOUSE_NUMBER_EX)).getWidth());
            for (Tripel<Integer, String, Color> column : header) {
                if (column.getElement2().equals(postcodeHead)) {
                    streetGroupIndex.postcodeIndex = i;
                } else if (column.getElement2().equals(streetHead)) {
                    streetGroupIndex.streetIndex = i;
                } else if (column.getElement2().equals(streetGroupHead)) {
                    streetGroupIndex.streetGroupIndex = i;
                } else if (column.getElement2().equals(hnGroupHead)) {
                    streetGroupIndex.hnGroupIndex = i;
                } else if (column.getElement2().equals(hnExGroupHead)) {
                    streetGroupIndex.hnExGroupIndex = i;
                }
                ++i;
            }
        }
        return streetGroupIndex;
    }

    public static void addAddressRow(String country, String city, String district, String postcode, String street, String houseNumber, String houseNumberEx, Map<PrintPropertyKey, Serializable> properties, TableRowEntity row, Color color, PrinterInformation.LineGroupType group) {
        switch (group) {
            case ADDRESS: {
                ((PrintContentValue)properties.get(PrintContentKey.GROUP_COUNTRY)).addCell(country, color, row);
                ((PrintContentValue)properties.get(PrintContentKey.GROUP_CITY)).addCell(city, color, row);
                ((PrintContentValue)properties.get(PrintContentKey.GROUP_DISTRICT)).addCell(district, color, row);
                ((PrintContentValue)properties.get(PrintContentKey.GROUP_POSTCODE)).addCell(postcode, color, row);
                ((PrintContentValue)properties.get(PrintContentKey.GROUP_STREET)).addCell(street, color, row);
                ((PrintContentValue)properties.get(PrintContentKey.GROUP_HOUSE_NUMBER)).addCell(houseNumber, color, row);
                ((PrintContentValue)properties.get(PrintContentKey.GROUP_HOUSE_NUMBER_EX)).addCell(houseNumberEx, color, row);
                break;
            }
            case NORMAL: {
                ((PrintContentValue)properties.get(PrintContentKey.COUNTRY)).addCell(country, color, row);
                ((PrintContentValue)properties.get(PrintContentKey.CITY)).addCell(city, color, row);
                ((PrintContentValue)properties.get(PrintContentKey.DISTRICT)).addCell(district, color, row);
                ((PrintContentValue)properties.get(PrintContentKey.POSTCODE)).addCell(postcode, color, row);
                ((PrintContentValue)properties.get(PrintContentKey.STREET)).addCell(street, color, row);
                ((PrintContentValue)properties.get(PrintContentKey.HOUSE_NUMBER)).addCell(houseNumber, color, row);
                ((PrintContentValue)properties.get(PrintContentKey.HOUSE_NUMBER_EX)).addCell(houseNumberEx, color, row);
                break;
            }
            case STREET: {
                ((PrintContentValue)properties.get(PrintContentKey.GROUP_COUNTRY)).addCell(country, color, row);
                ((PrintContentValue)properties.get(PrintContentKey.GROUP_CITY)).addCell(city, color, row);
                ((PrintContentValue)properties.get(PrintContentKey.GROUP_DISTRICT)).addCell(district, color, row);
                ((PrintContentValue)properties.get(PrintContentKey.GROUP_POSTCODE)).addCell(postcode, color, row);
                ((PrintContentValue)properties.get(PrintContentKey.ADDRESS_GROUP)).addCell(StringUtil.getNotNull(street).trim() + "(" + StringUtil.getNotNull(houseNumber).trim() + StringUtil.getNotNull(houseNumberEx).trim() + ")", color, row);
            }
        }
    }

    private void addAddressHeader(Map<PrintPropertyKey, Serializable> properties, TableRowEntity row, Color color, PrinterInformation.LineGroupType group) {
        switch (group) {
            case ADDRESS: {
                ((PrintContentValue)properties.get(PrintContentKey.GROUP_COUNTRY)).addCell(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.country", new Serializable[0]), color, row);
                ((PrintContentValue)properties.get(PrintContentKey.GROUP_CITY)).addCell(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.city", new Serializable[0]), color, row);
                ((PrintContentValue)properties.get(PrintContentKey.GROUP_DISTRICT)).addCell(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.district", new Serializable[0]), color, row);
                ((PrintContentValue)properties.get(PrintContentKey.GROUP_POSTCODE)).addCell(ModelEnviroment.getMessageResolver().resolveMessage("address.postcode", new Serializable[0]), color, row);
                ((PrintContentValue)properties.get(PrintContentKey.GROUP_STREET)).addCell(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.street", new Serializable[0]), color, row);
                ((PrintContentValue)properties.get(PrintContentKey.GROUP_HOUSE_NUMBER)).addCell(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.print.housenumber", new Serializable[0]), color, row);
                ((PrintContentValue)properties.get(PrintContentKey.GROUP_HOUSE_NUMBER_EX)).addCell(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.housenumberExtension", new Serializable[0]), color, row);
                break;
            }
            case NORMAL: {
                ((PrintContentValue)properties.get(PrintContentKey.COUNTRY)).addCell(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.country", new Serializable[0]), color, row);
                ((PrintContentValue)properties.get(PrintContentKey.CITY)).addCell(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.city", new Serializable[0]), color, row);
                ((PrintContentValue)properties.get(PrintContentKey.DISTRICT)).addCell(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.district", new Serializable[0]), color, row);
                ((PrintContentValue)properties.get(PrintContentKey.POSTCODE)).addCell(ModelEnviroment.getMessageResolver().resolveMessage("address.postcode", new Serializable[0]), color, row);
                ((PrintContentValue)properties.get(PrintContentKey.STREET)).addCell(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.street", new Serializable[0]), color, row);
                ((PrintContentValue)properties.get(PrintContentKey.HOUSE_NUMBER)).addCell(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.print.housenumber", new Serializable[0]), color, row);
                ((PrintContentValue)properties.get(PrintContentKey.HOUSE_NUMBER_EX)).addCell(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.housenumberExtension", new Serializable[0]), color, row);
                break;
            }
            case STREET: {
                ((PrintContentValue)properties.get(PrintContentKey.GROUP_COUNTRY)).addCell(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.country", new Serializable[0]), color, row);
                ((PrintContentValue)properties.get(PrintContentKey.GROUP_CITY)).addCell(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.city", new Serializable[0]), color, row);
                ((PrintContentValue)properties.get(PrintContentKey.GROUP_DISTRICT)).addCell(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.district", new Serializable[0]), color, row);
                ((PrintContentValue)properties.get(PrintContentKey.GROUP_POSTCODE)).addCell(ModelEnviroment.getMessageResolver().resolveMessage("address.postcode", new Serializable[0]), color, row);
                ((PrintContentValue)properties.get(PrintContentKey.ADDRESS_GROUP)).addCell(ModelEnviroment.getMessageResolver().resolveMessage("gui.location.useAddress", new Serializable[0]), color, row);
            }
        }
    }

    protected void addTableHeaderForTour(Map<PrintPropertyKey, Serializable> tourProperties, TableRowEntity header) {
        this.addAddressHeader(tourProperties, header, Color.BLACK, PrinterInformation.LineGroupType.NORMAL);
        ((PrintContentValue)tourProperties.get(PrintContentKey.INDEX)).addCell("", Color.BLACK, header);
        ((PrintContentValue)tourProperties.get(PrintContentKey.NAME)).addCell(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.stop", new Serializable[0]), Color.BLACK, header);
        ((PrintContentValue)tourProperties.get(PrintContentKey.CUSTOMER)).addCell(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.clientname", new Serializable[0]), Color.BLACK, header);
        ((PrintContentValue)tourProperties.get(PrintContentKey.COMPANY)).addCell(ModelEnviroment.getMessageResolver().resolveMessage("messages.customer.companyName", new Serializable[0]), Color.BLACK, header);
        ((PrintContentValue)tourProperties.get(PrintContentKey.ESTIMATED_TIME)).addCell(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.estimatedTime", new Serializable[0]), Color.BLACK, header);
        ((PrintContentValue)tourProperties.get(PrintContentKey.ACTUAL_TIME)).addCell(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.actualTime", new Serializable[0]), Color.BLACK, header);
    }

    public boolean isTop() {
        return this.top;
    }

    public void setTop(boolean top) {
        this.top = top;
    }

    public boolean isDown() {
        return this.down;
    }

    public void setDown(boolean down) {
        this.down = down;
    }

    public List<PrintingObject> getPrintingObjects() {
        return this.printingObjects;
    }

    public void setPrintingObjects(List<PrintingObject> printingObjects) {
        this.printingObjects = printingObjects;
    }

    protected class LineGroupIndex {
        protected HeaderType type;
        protected int postcodeIndex = -1;
        protected int streetIndex = -1;
        protected int streetGroupIndex = -1;
        protected int hnGroupIndex = -1;
        protected int hnExGroupIndex = -1;

        public LineGroupIndex(HeaderType type) {
            this.type = type;
        }
    }
}

