/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.pdf;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.base.CustomerModel;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.util.model.location.LocationWrapper;
import de.datomino.peppergis.client.util.model.location.LocationWrapperFactory;
import de.datomino.peppergis.type.Salutation;
import de.datomino.util.common.PrimitiveUtil;
import org.ktde.util.StringUtil;

public class PeppergisCommonPdfHelper {
    public String getCustomerAddressText(CustomerModel customer) {
        StringBuilder sb = new StringBuilder();
        boolean company = PrimitiveUtil.nullToFalse(customer.getCompany());
        if (company) {
            sb.append(customer.getCompanyName());
        } else {
            this.getNaturalPersonSalutation(customer, sb);
        }
        return sb.toString();
    }

    public void getNaturalPersonSalutation(CustomerModel customer, StringBuilder sb) {
        String firstName;
        Salutation salutation = customer.getSalutation();
        if (salutation != null) {
            switch (salutation) {
                case COMPANY: {
                    break;
                }
                case MR: 
                case MRS: {
                    sb.append(ModelEnviroment.getMessageResolver().resolveMessageForEnum(salutation)).append(" ");
                }
            }
        }
        if (!StringUtil.isBlank(firstName = customer.getFirstName())) {
            sb.append(firstName.trim()).append(" ");
        }
        String lastName = StringUtil.nullToEmpty(customer.getLastName());
        sb.append(lastName.trim());
    }

    public String getCustomerAddressTextSecondLine(CustomerModel customer) {
        StringBuilder sb = new StringBuilder();
        boolean company = PrimitiveUtil.nullToFalse(customer.getCompany());
        Salutation salutation = customer.getSalutation();
        if (company && !StringUtil.isBlank(customer.getLastName()) && (salutation == Salutation.MR || salutation == Salutation.MRS)) {
            this.getNaturalPersonSalutation(customer, sb);
        }
        return sb.toString();
    }

    public String getStreetForLetterFromLocation(LocationModel location) {
        if (location == null) {
            return "";
        }
        LocationWrapper locationWrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(location);
        StringBuilder sb = new StringBuilder(StringUtil.nullToEmpty(locationWrapper.getStreet())).append(" ").append(StringUtil.nullToEmpty(locationWrapper.getHousenumber())).append(StringUtil.nullToEmpty(locationWrapper.getHousenumberExtension()));
        return sb.toString().trim();
    }

    public String getCityForLetterFromLocation(LocationModel location) {
        if (location == null) {
            return "";
        }
        LocationWrapper locationWrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(location);
        StringBuilder sb = new StringBuilder(StringUtil.nullToEmpty(locationWrapper.getPostcode())).append(" ").append(StringUtil.nullToEmpty(locationWrapper.getCity()));
        return sb.toString().trim();
    }

    public String getCustomerSaluation(CustomerModel customer) {
        Salutation salutation = customer.getSalutation();
        if (salutation == null || salutation == Salutation.COMPANY || StringUtil.isBlank(customer.getLastName())) {
            return "Sehr geehrte Damen und Herren,";
        }
        StringBuilder sb = new StringBuilder("Sehr geehrte");
        switch (salutation) {
            case MR: {
                sb.append("r Herr ");
                break;
            }
            case MRS: {
                sb.append(" Frau ");
                break;
            }
        }
        sb.append(StringUtil.nullToEmpty(customer.getLastName())).append(",");
        return sb.toString();
    }
}

