/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.wage;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.wage.ThrowLeafletScalingModel;
import de.datomino.peppergis.client.model.wage.WageParameterModel;
import de.datomino.peppergis.client.model.wage.WageParameterModelImpl;
import de.datomino.peppergis.dto.wage.ThrowLeafletScalingFullDto;
import de.datomino.peppergis.dto.wage.ThrowLeafletScalingProxyDto;
import de.datomino.peppergis.dto.wage.WageParameterDto;
import de.datomino.peppergis.exception.StaleStateException;
import de.datomino.peppergis.type.ThrowLeafletType;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;

public class ThrowLeafletScalingModelImpl
extends AbstractModel<ThrowLeafletScalingFullDto, ThrowLeafletScalingProxyDto>
implements ThrowLeafletScalingModel {
    private Integer minVolume;
    private Integer maxVolume;
    private Double pieceTime;
    private ThrowLeafletType type;
    private WageParameterModel wageParameter;

    public ThrowLeafletScalingModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public ThrowLeafletScalingModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public Integer getMinVolume() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.minVolume;
    }

    @Override
    public void setMinVolume(Integer minVolume) {
        this.setMinVolume(minVolume, true);
    }

    private void setMinVolume(Integer minVolume, boolean setDirty) {
        Integer oldMinVolume = this.getMinVolume();
        if (new EqualsBuilder().append(oldMinVolume, minVolume).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ThrowLeafletScalingModelEnum.MIN_VOLUME.getPropertyName());
        }
        this.minVolume = minVolume;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ThrowLeafletScalingModelEnum.MIN_VOLUME, minVolume, oldMinVolume);
    }

    @Override
    public Integer getMaxVolume() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.maxVolume;
    }

    @Override
    public void setMaxVolume(Integer maxVolume) {
        this.setMaxVolume(maxVolume, true);
    }

    private void setMaxVolume(Integer maxVolume, boolean setDirty) {
        Integer oldMaxVolume = this.getMaxVolume();
        if (new EqualsBuilder().append(oldMaxVolume, maxVolume).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ThrowLeafletScalingModelEnum.MAX_VOLUME.getPropertyName());
        }
        this.maxVolume = maxVolume;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ThrowLeafletScalingModelEnum.MAX_VOLUME, maxVolume, oldMaxVolume);
    }

    @Override
    public Double getPieceTime() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.pieceTime;
    }

    @Override
    public void setPieceTime(Double pieceTime) {
        this.setPieceTime(pieceTime, true);
    }

    private void setPieceTime(Double pieceTime, boolean setDirty) {
        Double oldPieceTime = this.getPieceTime();
        if (new EqualsBuilder().append(oldPieceTime, pieceTime).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ThrowLeafletScalingModelEnum.PIECE_TIME.getPropertyName());
        }
        this.pieceTime = pieceTime;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ThrowLeafletScalingModelEnum.PIECE_TIME, pieceTime, oldPieceTime);
    }

    @Override
    public ThrowLeafletType getType() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.type;
    }

    @Override
    public void setType(ThrowLeafletType type) {
        this.setType(type, true);
    }

    private void setType(ThrowLeafletType type, boolean setDirty) {
        ThrowLeafletType oldType = this.getType();
        if (new EqualsBuilder().append((Object)oldType, (Object)type).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ThrowLeafletScalingModelEnum.TYPE.getPropertyName());
        }
        this.type = type;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ThrowLeafletScalingModelEnum.TYPE, (Object)type, (Object)oldType);
    }

    @Override
    public WageParameterModel getWageParameter() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.wageParameter;
    }

    @Override
    public void setWageParameter(WageParameterModel wageParameter) {
        this.setWageParameter(wageParameter, true);
    }

    private void setWageParameter(WageParameterModel wageParameter, boolean setDirty) {
        WageParameterModel oldWageParameter = this.getWageParameter();
        if (oldWageParameter == wageParameter) {
            return;
        }
        if (oldWageParameter != null) {
            oldWageParameter.removeThrowLeafletScaling(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ThrowLeafletScalingModelEnum.WAGE_PARAMETER.getPropertyName());
        }
        this.wageParameter = wageParameter;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ThrowLeafletScalingModelEnum.WAGE_PARAMETER, wageParameter, oldWageParameter);
        if (this.wageParameter != null) {
            this.wageParameter.addThrowLeafletScaling(this);
        }
    }

    @Override
    protected void updateByDto(ThrowLeafletScalingFullDto throwLeafletScalingDto) {
        this.minVolume = throwLeafletScalingDto.getMinVolume();
        this.maxVolume = throwLeafletScalingDto.getMaxVolume();
        this.pieceTime = throwLeafletScalingDto.getPieceTime();
        this.type = throwLeafletScalingDto.getType();
        this.wageParameter = (WageParameterModel)this.getModelCache().getModel(throwLeafletScalingDto.getWageParameter());
    }

    @Override
    protected void updateMasterRelationsByDto(ThrowLeafletScalingFullDto throwLeafletScalingDto) {
    }

    @Override
    protected void checkStaleByDto(ThrowLeafletScalingFullDto throwLeafletScalingDto) throws StaleStateException {
        WageParameterModelImpl wageParameterModel;
        WageParameterDto wageParameterDto = throwLeafletScalingDto.getWageParameter();
        if (wageParameterDto != null && wageParameterDto.getId() != null && (wageParameterModel = (WageParameterModelImpl)this.getModelCache().getModel(WageParameterModel.class, wageParameterDto.getId())) != null) {
            wageParameterModel.checkStaleState(wageParameterDto);
        }
    }

    @Override
    public ThrowLeafletScalingFullDto createDto() {
        Long id = this.getId();
        ThrowLeafletScalingFullDto throwLeafletScalingDto = id == null ? new ThrowLeafletScalingFullDto(this.getTempUUID()) : new ThrowLeafletScalingFullDto(id, this.getVersion());
        throwLeafletScalingDto.setMinVolume(this.getMinVolume());
        throwLeafletScalingDto.setMaxVolume(this.getMaxVolume());
        throwLeafletScalingDto.setPieceTime(this.getPieceTime());
        throwLeafletScalingDto.setType(this.getType());
        WageParameterModelImpl wageParameter = (WageParameterModelImpl)this.getWageParameter();
        if (wageParameter != null) {
            throwLeafletScalingDto.setWageParameter(wageParameter.createProxy());
        }
        return throwLeafletScalingDto;
    }

    @Override
    public ThrowLeafletScalingProxyDto createProxy() {
        Long id = this.getId();
        ThrowLeafletScalingProxyDto throwLeafletScalingDto = id == null ? new ThrowLeafletScalingProxyDto(this.getTempUUID()) : new ThrowLeafletScalingProxyDto(id, this.getVersion());
        return throwLeafletScalingDto;
    }

    public static enum ThrowLeafletScalingModelEnum {
        MIN_VOLUME("minVolume"),
        MAX_VOLUME("maxVolume"),
        PIECE_TIME("pieceTime"),
        TYPE("type"),
        WAGE_PARAMETER("wageParameter");

        private String propertyName;

        private ThrowLeafletScalingModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

