/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.wage;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.wage.SortVolumeScalingModel;
import de.datomino.peppergis.client.model.wage.WageParameterModel;
import de.datomino.peppergis.client.model.wage.WageParameterModelImpl;
import de.datomino.peppergis.dto.wage.SortVolumeScalingFullDto;
import de.datomino.peppergis.dto.wage.SortVolumeScalingProxyDto;
import de.datomino.peppergis.dto.wage.WageParameterDto;
import de.datomino.peppergis.exception.StaleStateException;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;

public class SortVolumeScalingModelImpl
extends AbstractModel<SortVolumeScalingFullDto, SortVolumeScalingProxyDto>
implements SortVolumeScalingModel {
    private Integer minVolume;
    private Integer maxVolume;
    private Double pieceTime;
    private WageParameterModel wageParameter;

    public SortVolumeScalingModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public SortVolumeScalingModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public Integer getMinVolume() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.minVolume;
    }

    @Override
    public void setMinVolume(Integer minVolume) {
        this.setMinVolume(minVolume, true);
    }

    private void setMinVolume(Integer minVolume, boolean setDirty) {
        Integer oldMinVolume = this.getMinVolume();
        if (new EqualsBuilder().append(oldMinVolume, minVolume).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, SortVolumeScalingModelEnum.MIN_VOLUME.getPropertyName());
        }
        this.minVolume = minVolume;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(SortVolumeScalingModelEnum.MIN_VOLUME, minVolume, oldMinVolume);
    }

    @Override
    public Integer getMaxVolume() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.maxVolume;
    }

    @Override
    public void setMaxVolume(Integer maxVolume) {
        this.setMaxVolume(maxVolume, true);
    }

    private void setMaxVolume(Integer maxVolume, boolean setDirty) {
        Integer oldMaxVolume = this.getMaxVolume();
        if (new EqualsBuilder().append(oldMaxVolume, maxVolume).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, SortVolumeScalingModelEnum.MAX_VOLUME.getPropertyName());
        }
        this.maxVolume = maxVolume;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(SortVolumeScalingModelEnum.MAX_VOLUME, maxVolume, oldMaxVolume);
    }

    @Override
    public Double getPieceTime() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.pieceTime;
    }

    @Override
    public void setPieceTime(Double pieceTime) {
        this.setPieceTime(pieceTime, true);
    }

    private void setPieceTime(Double pieceTime, boolean setDirty) {
        Double oldPieceTime = this.getPieceTime();
        if (new EqualsBuilder().append(oldPieceTime, pieceTime).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, SortVolumeScalingModelEnum.PIECE_TIME.getPropertyName());
        }
        this.pieceTime = pieceTime;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(SortVolumeScalingModelEnum.PIECE_TIME, pieceTime, oldPieceTime);
    }

    @Override
    public WageParameterModel getWageParameter() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.wageParameter;
    }

    @Override
    public void setWageParameter(WageParameterModel wageParameter) {
        this.setWageParameter(wageParameter, true);
    }

    private void setWageParameter(WageParameterModel wageParameter, boolean setDirty) {
        WageParameterModel oldWageParameter = this.getWageParameter();
        if (oldWageParameter == wageParameter) {
            return;
        }
        if (oldWageParameter != null) {
            oldWageParameter.removeSortVolumeScaling(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, SortVolumeScalingModelEnum.WAGE_PARAMETER.getPropertyName());
        }
        this.wageParameter = wageParameter;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(SortVolumeScalingModelEnum.WAGE_PARAMETER, wageParameter, oldWageParameter);
        if (this.wageParameter != null) {
            this.wageParameter.addSortVolumeScaling(this);
        }
    }

    @Override
    protected void updateByDto(SortVolumeScalingFullDto sortVolumeScalingDto) {
        this.minVolume = sortVolumeScalingDto.getMinVolume();
        this.maxVolume = sortVolumeScalingDto.getMaxVolume();
        this.pieceTime = sortVolumeScalingDto.getPieceTime();
        this.wageParameter = (WageParameterModel)this.getModelCache().getModel(sortVolumeScalingDto.getWageParameter());
    }

    @Override
    protected void updateMasterRelationsByDto(SortVolumeScalingFullDto sortVolumeScalingDto) {
    }

    @Override
    protected void checkStaleByDto(SortVolumeScalingFullDto sortVolumeScalingDto) throws StaleStateException {
        WageParameterModelImpl wageParameterModel;
        WageParameterDto wageParameterDto = sortVolumeScalingDto.getWageParameter();
        if (wageParameterDto != null && wageParameterDto.getId() != null && (wageParameterModel = (WageParameterModelImpl)this.getModelCache().getModel(WageParameterModel.class, wageParameterDto.getId())) != null) {
            wageParameterModel.checkStaleState(wageParameterDto);
        }
    }

    @Override
    public SortVolumeScalingFullDto createDto() {
        Long id = this.getId();
        SortVolumeScalingFullDto sortVolumeScalingDto = id == null ? new SortVolumeScalingFullDto(this.getTempUUID()) : new SortVolumeScalingFullDto(id, this.getVersion());
        sortVolumeScalingDto.setMinVolume(this.getMinVolume());
        sortVolumeScalingDto.setMaxVolume(this.getMaxVolume());
        sortVolumeScalingDto.setPieceTime(this.getPieceTime());
        WageParameterModelImpl wageParameter = (WageParameterModelImpl)this.getWageParameter();
        if (wageParameter != null) {
            sortVolumeScalingDto.setWageParameter(wageParameter.createProxy());
        }
        return sortVolumeScalingDto;
    }

    @Override
    public SortVolumeScalingProxyDto createProxy() {
        Long id = this.getId();
        SortVolumeScalingProxyDto sortVolumeScalingDto = id == null ? new SortVolumeScalingProxyDto(this.getTempUUID()) : new SortVolumeScalingProxyDto(id, this.getVersion());
        return sortVolumeScalingDto;
    }

    public static enum SortVolumeScalingModelEnum {
        MIN_VOLUME("minVolume"),
        MAX_VOLUME("maxVolume"),
        PIECE_TIME("pieceTime"),
        WAGE_PARAMETER("wageParameter");

        private String propertyName;

        private SortVolumeScalingModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

