/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.tour;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.tour.DelivererModel;
import de.datomino.peppergis.client.model.tour.DelivererModelImpl;
import de.datomino.peppergis.client.model.tour.VehicleModel;
import de.datomino.peppergis.dto.tour.DelivererDto;
import de.datomino.peppergis.dto.tour.VehicleFullDto;
import de.datomino.peppergis.dto.tour.VehicleProxyDto;
import de.datomino.peppergis.exception.StaleStateException;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;

public class VehicleModelImpl
extends AbstractModel<VehicleFullDto, VehicleProxyDto>
implements VehicleModel {
    private String name;
    private String licensePlate;
    private Integer mileageKilometers;
    private DelivererModel deliverer;

    public VehicleModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public VehicleModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public String getName() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.setName(name, true);
    }

    private void setName(String name, boolean setDirty) {
        String oldName = this.getName();
        if (new EqualsBuilder().append(oldName, name).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, VehicleModelEnum.NAME.getPropertyName());
        }
        this.name = name;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(VehicleModelEnum.NAME, name, oldName);
    }

    @Override
    public String getLicensePlate() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.licensePlate;
    }

    @Override
    public void setLicensePlate(String licensePlate) {
        this.setLicensePlate(licensePlate, true);
    }

    private void setLicensePlate(String licensePlate, boolean setDirty) {
        String oldLicensePlate = this.getLicensePlate();
        if (new EqualsBuilder().append(oldLicensePlate, licensePlate).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, VehicleModelEnum.LICENSE_PLATE.getPropertyName());
        }
        this.licensePlate = licensePlate;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(VehicleModelEnum.LICENSE_PLATE, licensePlate, oldLicensePlate);
    }

    @Override
    public Integer getMileageKilometers() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.mileageKilometers;
    }

    @Override
    public void setMileageKilometers(Integer mileageKilometers) {
        this.setMileageKilometers(mileageKilometers, true);
    }

    private void setMileageKilometers(Integer mileageKilometers, boolean setDirty) {
        Integer oldMileageKilometers = this.getMileageKilometers();
        if (new EqualsBuilder().append(oldMileageKilometers, mileageKilometers).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, VehicleModelEnum.MILEAGE_KILOMETERS.getPropertyName());
        }
        this.mileageKilometers = mileageKilometers;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(VehicleModelEnum.MILEAGE_KILOMETERS, mileageKilometers, oldMileageKilometers);
    }

    @Override
    public DelivererModel getDeliverer() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.deliverer;
    }

    @Override
    public void setDeliverer(DelivererModel deliverer) {
        this.setDeliverer(deliverer, true);
    }

    private void setDeliverer(DelivererModel deliverer, boolean setDirty) {
        DelivererModel oldDeliverer = this.getDeliverer();
        if (oldDeliverer == deliverer) {
            return;
        }
        if (oldDeliverer != null) {
            oldDeliverer.setVehicle(null);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, VehicleModelEnum.DELIVERER.getPropertyName());
        }
        this.deliverer = deliverer;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(VehicleModelEnum.DELIVERER, deliverer, oldDeliverer);
        if (this.deliverer != null) {
            this.deliverer.setVehicle(this);
        }
    }

    @Override
    protected void updateByDto(VehicleFullDto vehicleDto) {
        this.name = vehicleDto.getName();
        this.licensePlate = vehicleDto.getLicensePlate();
        this.mileageKilometers = vehicleDto.getMileageKilometers();
        this.deliverer = (DelivererModel)this.getModelCache().getModel(vehicleDto.getDeliverer());
    }

    @Override
    protected void updateMasterRelationsByDto(VehicleFullDto vehicleDto) {
    }

    @Override
    protected void checkStaleByDto(VehicleFullDto vehicleDto) throws StaleStateException {
        DelivererModelImpl delivererModel;
        DelivererDto delivererDto = vehicleDto.getDeliverer();
        if (delivererDto != null && delivererDto.getId() != null && (delivererModel = (DelivererModelImpl)this.getModelCache().getModel(DelivererModel.class, delivererDto.getId())) != null) {
            delivererModel.checkStaleState(delivererDto);
        }
    }

    @Override
    public VehicleFullDto createDto() {
        Long id = this.getId();
        VehicleFullDto vehicleDto = id == null ? new VehicleFullDto(this.getTempUUID()) : new VehicleFullDto(id, this.getVersion());
        vehicleDto.setName(this.getName());
        vehicleDto.setLicensePlate(this.getLicensePlate());
        vehicleDto.setMileageKilometers(this.getMileageKilometers());
        DelivererModelImpl deliverer = (DelivererModelImpl)this.getDeliverer();
        if (deliverer != null) {
            vehicleDto.setDeliverer(deliverer.createProxy());
        }
        return vehicleDto;
    }

    @Override
    public VehicleProxyDto createProxy() {
        Long id = this.getId();
        VehicleProxyDto vehicleDto = id == null ? new VehicleProxyDto(this.getTempUUID()) : new VehicleProxyDto(id, this.getVersion());
        return vehicleDto;
    }

    public static enum VehicleModelEnum {
        NAME("name"),
        LICENSE_PLATE("licensePlate"),
        MILEAGE_KILOMETERS("mileageKilometers"),
        DELIVERER("deliverer");

        private String propertyName;

        private VehicleModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

