/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.tour;

import de.datomino.logistic.dto.TourPartType;
import de.datomino.logistic.type.RouteType;
import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.model.tour.StopModelImpl;
import de.datomino.peppergis.client.model.tour.TourDifficultyLevelModel;
import de.datomino.peppergis.client.model.tour.TourDifficultyLevelModelImpl;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.client.model.tour.TourModelImpl;
import de.datomino.peppergis.client.model.tour.TourPartModel;
import de.datomino.peppergis.dto.tour.StopDto;
import de.datomino.peppergis.dto.tour.TourDifficultyLevelDto;
import de.datomino.peppergis.dto.tour.TourDto;
import de.datomino.peppergis.dto.tour.TourPartFullDto;
import de.datomino.peppergis.dto.tour.TourPartProxyDto;
import de.datomino.peppergis.exception.StaleStateException;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.dto.ImmutableLineStringDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;
import org.ktde.util.conversions.ImmutableIterator;
import org.ktde.util.conversions.IteratorIterable;

public class TourPartModelImpl
extends AbstractModel<TourPartFullDto, TourPartProxyDto>
implements TourPartModel {
    private String name;
    private String information;
    private List<StopModel> stops = null;
    private TourModel tour;
    private Integer sortOrder;
    private ImmutableLineString lineString;
    private RouteType routeType;
    private RouteVehicleType routeVehicleType;
    private TourPartType tourPartType;
    private TourDifficultyLevelModel difficultyLevel;

    public TourPartModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public TourPartModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public String getName() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.setName(name, true);
    }

    private void setName(String name, boolean setDirty) {
        String oldName = this.getName();
        if (new EqualsBuilder().append(oldName, name).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, TourPartModelEnum.NAME.getPropertyName());
        }
        this.name = name;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(TourPartModelEnum.NAME, name, oldName);
    }

    @Override
    public String getInformation() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.information;
    }

    @Override
    public void setInformation(String information) {
        this.setInformation(information, true);
    }

    private void setInformation(String information, boolean setDirty) {
        String oldInformation = this.getInformation();
        if (new EqualsBuilder().append(oldInformation, information).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, TourPartModelEnum.INFORMATION.getPropertyName());
        }
        this.information = information;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(TourPartModelEnum.INFORMATION, information, oldInformation);
    }

    @Override
    public int countStops() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.stops == null) {
            this.stops = new ArrayList<StopModel>();
            if (this.getId() != null) {
                Collection stopsCollection = this.commonCaller.fetchChildren(this, TourPartModelEnum.STOPS.getPropertyName());
                this.stops.addAll(stopsCollection);
            }
        }
        return this.stops.size();
    }

    @Override
    public Iterator<StopModel> iterateStops() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.stops == null) {
            this.stops = new ArrayList<StopModel>();
            if (this.getId() != null) {
                Collection stopsCollection = this.commonCaller.fetchChildren(this, TourPartModelEnum.STOPS.getPropertyName());
                this.stops.addAll(stopsCollection);
            }
        }
        return new ImmutableIterator<StopModel>(this.stops);
    }

    @Override
    public Iterable<StopModel> iterableStops() {
        return new IteratorIterable<StopModel>(this.iterateStops());
    }

    @Override
    public void addStop(StopModel stop) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.stops == null) {
            this.stops = new ArrayList<StopModel>();
            if (this.getId() != null) {
                Collection stopsCollection = this.commonCaller.fetchChildren(this, TourPartModelEnum.STOPS.getPropertyName());
                this.stops.addAll(stopsCollection);
            }
        }
        if (this.stops.contains(stop)) {
            return;
        }
        this.stops.add(stop);
        this.fireValueChanged(TourPartModelEnum.STOPS, stop, null);
        if (stop != null) {
            stop.setTourPart(this);
            stop.setSortOrder(this.stops.size() - 1);
        }
    }

    @Override
    public void removeStop(StopModel stop) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.stops == null) {
            this.stops = new ArrayList<StopModel>();
            if (this.getId() != null) {
                Collection stopsCollection = this.commonCaller.fetchChildren(this, TourPartModelEnum.STOPS.getPropertyName());
                this.stops.addAll(stopsCollection);
            }
        }
        if (!this.stops.contains(stop)) {
            return;
        }
        this.stops.remove(stop);
        this.fireValueChanged(TourPartModelEnum.STOPS, stop, null);
        if (stop != null) {
            stop.setTourPart(null);
            stop.setSortOrder(null);
        }
        this.reorderStops(0);
    }

    @Override
    public StopModel getStopAt(int index) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.stops == null) {
            this.stops = new ArrayList<StopModel>();
            if (this.getId() != null) {
                Collection stopsCollection = this.commonCaller.fetchChildren(this, TourPartModelEnum.STOPS.getPropertyName());
                this.stops.addAll(stopsCollection);
            }
        }
        return this.stops.get(index);
    }

    @Override
    public void insertStop(StopModel stop, int index) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.stops == null) {
            this.stops = new ArrayList<StopModel>();
            if (this.getId() != null) {
                Collection stopsCollection = this.commonCaller.fetchChildren(this, TourPartModelEnum.STOPS.getPropertyName());
                this.stops.addAll(stopsCollection);
            }
        }
        if (this.stops.contains(stop)) {
            this.removeStop(stop);
        }
        this.stops.add(index, stop);
        this.fireValueChanged(TourPartModelEnum.STOPS, stop, null);
        if (stop != null) {
            stop.setTourPart(this);
        }
        this.reorderStops(index);
    }

    @Override
    public void removeStopAt(int index) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.stops == null) {
            this.stops = new ArrayList<StopModel>();
            if (this.getId() != null) {
                Collection stopsCollection = this.commonCaller.fetchChildren(this, TourPartModelEnum.STOPS.getPropertyName());
                this.stops.addAll(stopsCollection);
            }
        }
        StopModel oldStop = this.stops.get(index);
        this.stops.remove(index);
        this.fireValueChanged(TourPartModelEnum.STOPS, oldStop, null);
        if (oldStop != null) {
            oldStop.setTourPart(null);
            oldStop.setSortOrder(null);
        }
        this.reorderStops(index);
    }

    @Override
    public void setStopAt(StopModel stop, int index) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.stops == null) {
            this.stops = new ArrayList<StopModel>();
            if (this.getId() != null) {
                Collection stopsCollection = this.commonCaller.fetchChildren(this, TourPartModelEnum.STOPS.getPropertyName());
                this.stops.addAll(stopsCollection);
            }
        }
        StopModel oldStop = this.stops.get(index);
        this.stops.set(index, stop);
        this.fireValueChanged(TourPartModelEnum.STOPS, stop, oldStop);
        if (oldStop != null) {
            oldStop.setTourPart(null);
            oldStop.setSortOrder(null);
        }
        if (stop != null) {
            stop.setTourPart(this);
            stop.setSortOrder(index);
        }
    }

    @Override
    public void clearStops() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.stops == null) {
            this.stops = new ArrayList<StopModel>();
            if (this.getId() != null) {
                Collection stopsCollection = this.commonCaller.fetchChildren(this, TourPartModelEnum.STOPS.getPropertyName());
                this.stops.addAll(stopsCollection);
            }
        }
        ArrayList<StopModel> oldStops = new ArrayList<StopModel>(this.stops);
        this.stops.clear();
        this.fireValueChanged(TourPartModelEnum.STOPS, null, null);
        for (StopModel oldStop : oldStops) {
            if (oldStop == null) continue;
            oldStop.setTourPart(null);
            oldStop.setSortOrder(null);
        }
    }

    @Override
    public boolean isStopsEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.stops == null) {
            this.stops = new ArrayList<StopModel>();
            if (this.getId() != null) {
                Collection stopsCollection = this.commonCaller.fetchChildren(this, TourPartModelEnum.STOPS.getPropertyName());
                this.stops.addAll(stopsCollection);
            }
        }
        return this.stops.isEmpty();
    }

    @Override
    public boolean containsStop(StopModel stop) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.stops == null) {
            this.stops = new ArrayList<StopModel>();
            if (this.getId() != null) {
                Collection stopsCollection = this.commonCaller.fetchChildren(this, TourPartModelEnum.STOPS.getPropertyName());
                this.stops.addAll(stopsCollection);
            }
        }
        return this.stops.contains(stop);
    }

    @Override
    public int indexOfStop(StopModel stop) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.stops == null) {
            this.stops = new ArrayList<StopModel>();
            if (this.getId() != null) {
                Collection stopsCollection = this.commonCaller.fetchChildren(this, TourPartModelEnum.STOPS.getPropertyName());
                this.stops.addAll(stopsCollection);
            }
        }
        return this.stops.indexOf(stop);
    }

    @Override
    public boolean isStopsInitialized() {
        return this.stops != null;
    }

    private void reorderStops(int startIndex) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.stops == null) {
            this.stops = new ArrayList<StopModel>();
            if (this.getId() != null) {
                Collection stopsCollection = this.commonCaller.fetchChildren(this, TourPartModelEnum.STOPS.getPropertyName());
                this.stops.addAll(stopsCollection);
            }
        }
        ListIterator<StopModel> listIterator = this.stops.listIterator(startIndex);
        int index = startIndex;
        while (listIterator.hasNext()) {
            StopModel stop = listIterator.next();
            stop.setSortOrder(index++);
        }
    }

    @Override
    public TourModel getTour() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.tour;
    }

    @Override
    public void setTour(TourModel tour) {
        this.setTour(tour, true);
    }

    private void setTour(TourModel tour, boolean setDirty) {
        TourModel oldTour = this.getTour();
        if (oldTour == tour) {
            return;
        }
        if (oldTour != null) {
            oldTour.removeTourPart(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, TourPartModelEnum.TOUR.getPropertyName());
        }
        this.tour = tour;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(TourPartModelEnum.TOUR, tour, oldTour);
        if (this.tour != null) {
            this.tour.addTourPart(this);
        }
    }

    @Override
    public Integer getSortOrder() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.sortOrder;
    }

    @Override
    public void setSortOrder(Integer sortOrder) {
        this.setSortOrder(sortOrder, true);
    }

    private void setSortOrder(Integer sortOrder, boolean setDirty) {
        Integer oldSortOrder = this.getSortOrder();
        if (new EqualsBuilder().append(oldSortOrder, sortOrder).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, TourPartModelEnum.SORT_ORDER.getPropertyName());
        }
        this.sortOrder = sortOrder;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(TourPartModelEnum.SORT_ORDER, sortOrder, oldSortOrder);
    }

    @Override
    public ImmutableLineString getLineString() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.lineString;
    }

    @Override
    public void setLineString(ImmutableLineString lineString) {
        this.setLineString(lineString, true);
    }

    private void setLineString(ImmutableLineString lineString, boolean setDirty) {
        ImmutableLineString oldLineString = this.getLineString();
        if (new EqualsBuilder().append(oldLineString, lineString).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, TourPartModelEnum.LINE_STRING.getPropertyName());
        }
        this.lineString = lineString;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(TourPartModelEnum.LINE_STRING, lineString, oldLineString);
    }

    @Override
    public RouteType getRouteType() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.routeType;
    }

    @Override
    public void setRouteType(RouteType routeType) {
        this.setRouteType(routeType, true);
    }

    private void setRouteType(RouteType routeType, boolean setDirty) {
        RouteType oldRouteType = this.getRouteType();
        if (new EqualsBuilder().append((Object)oldRouteType, (Object)routeType).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, TourPartModelEnum.ROUTE_TYPE.getPropertyName());
        }
        this.routeType = routeType;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(TourPartModelEnum.ROUTE_TYPE, (Object)routeType, (Object)oldRouteType);
    }

    @Override
    public RouteVehicleType getRouteVehicleType() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.routeVehicleType;
    }

    @Override
    public void setRouteVehicleType(RouteVehicleType routeVehicleType) {
        this.setRouteVehicleType(routeVehicleType, true);
    }

    private void setRouteVehicleType(RouteVehicleType routeVehicleType, boolean setDirty) {
        RouteVehicleType oldRouteVehicleType = this.getRouteVehicleType();
        if (new EqualsBuilder().append((Object)oldRouteVehicleType, (Object)routeVehicleType).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, TourPartModelEnum.ROUTE_VEHICLE_TYPE.getPropertyName());
        }
        this.routeVehicleType = routeVehicleType;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(TourPartModelEnum.ROUTE_VEHICLE_TYPE, (Object)routeVehicleType, (Object)oldRouteVehicleType);
    }

    @Override
    public TourPartType getTourPartType() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.tourPartType;
    }

    @Override
    public void setTourPartType(TourPartType tourPartType) {
        this.setTourPartType(tourPartType, true);
    }

    private void setTourPartType(TourPartType tourPartType, boolean setDirty) {
        TourPartType oldTourPartType = this.getTourPartType();
        if (new EqualsBuilder().append((Object)oldTourPartType, (Object)tourPartType).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, TourPartModelEnum.TOUR_PART_TYPE.getPropertyName());
        }
        this.tourPartType = tourPartType;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(TourPartModelEnum.TOUR_PART_TYPE, (Object)tourPartType, (Object)oldTourPartType);
    }

    @Override
    public TourDifficultyLevelModel getDifficultyLevel() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.difficultyLevel;
    }

    @Override
    public void setDifficultyLevel(TourDifficultyLevelModel difficultyLevel) {
        this.setDifficultyLevel(difficultyLevel, true);
    }

    private void setDifficultyLevel(TourDifficultyLevelModel difficultyLevel, boolean setDirty) {
        TourDifficultyLevelModel oldDifficultyLevel = this.getDifficultyLevel();
        if (oldDifficultyLevel == difficultyLevel) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, TourPartModelEnum.DIFFICULTY_LEVEL.getPropertyName());
        }
        this.difficultyLevel = difficultyLevel;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(TourPartModelEnum.DIFFICULTY_LEVEL, difficultyLevel, oldDifficultyLevel);
    }

    @Override
    public void setProxy(boolean proxy) {
        super.setProxy(proxy);
        if (proxy) {
            this.stops = null;
        }
    }

    @Override
    protected void updateByDto(TourPartFullDto tourPartDto) {
        this.name = tourPartDto.getName();
        this.information = tourPartDto.getInformation();
        StopDto[] stops = tourPartDto.getStops();
        if (stops != null) {
            if (this.stops == null) {
                this.stops = new ArrayList<StopModel>();
            } else {
                this.stops.clear();
            }
        }
        this.tour = (TourModel)this.getModelCache().getModel(tourPartDto.getTour());
        this.sortOrder = tourPartDto.getSortOrder();
        ImmutableLineStringDto lineString = tourPartDto.getLineString();
        this.lineString = lineString == null ? null : (ImmutableLineString)lineString.getGeoObject();
        this.routeType = tourPartDto.getRouteType();
        this.routeVehicleType = tourPartDto.getRouteVehicleType();
        this.tourPartType = tourPartDto.getTourPartType();
        this.difficultyLevel = (TourDifficultyLevelModel)this.getModelCache().getModel(tourPartDto.getDifficultyLevel());
    }

    @Override
    protected void updateMasterRelationsByDto(TourPartFullDto tourPartDto) {
        StopDto[] stops = tourPartDto.getStops();
        if (stops != null) {
            if (this.stops == null) {
                this.stops = new ArrayList<StopModel>();
            } else {
                this.stops.clear();
            }
            for (StopDto stopDto : stops) {
                StopModel stopModel = (StopModel)this.getModelCache().getModel(stopDto);
                this.stops.add(stopModel);
            }
        } else {
            this.stops = null;
        }
    }

    @Override
    protected void checkStaleByDto(TourPartFullDto tourPartDto) throws StaleStateException {
        TourDifficultyLevelModelImpl difficultyLevelModel;
        TourDifficultyLevelDto difficultyLevelDto;
        TourModelImpl tourModel;
        TourDto tourDto;
        StopDto[] stopDtos = tourPartDto.getStops();
        if (stopDtos != null) {
            for (StopDto stopDto : stopDtos) {
                StopModelImpl stopModel = (StopModelImpl)this.getModelCache().getModel(StopModel.class, stopDto.getId());
                if (stopModel == null) continue;
                stopModel.checkStaleState(stopDto);
            }
        }
        if ((tourDto = tourPartDto.getTour()) != null && tourDto.getId() != null && (tourModel = (TourModelImpl)this.getModelCache().getModel(TourModel.class, tourDto.getId())) != null) {
            tourModel.checkStaleState(tourDto);
        }
        if ((difficultyLevelDto = tourPartDto.getDifficultyLevel()) != null && difficultyLevelDto.getId() != null && (difficultyLevelModel = (TourDifficultyLevelModelImpl)this.getModelCache().getModel(TourDifficultyLevelModel.class, difficultyLevelDto.getId())) != null) {
            difficultyLevelModel.checkStaleState(difficultyLevelDto);
        }
    }

    @Override
    public TourPartFullDto createDto() {
        Long id = this.getId();
        TourPartFullDto tourPartDto = id == null ? new TourPartFullDto(this.getTempUUID()) : new TourPartFullDto(id, this.getVersion());
        tourPartDto.setName(this.getName());
        tourPartDto.setInformation(this.getInformation());
        TourModelImpl tour = (TourModelImpl)this.getTour();
        if (tour != null) {
            tourPartDto.setTour(tour.createProxy());
        }
        tourPartDto.setSortOrder(this.getSortOrder());
        ImmutableLineString lineString = this.getLineString();
        tourPartDto.setLineString(ImmutableLineStringDto.create(lineString));
        tourPartDto.setRouteType(this.getRouteType());
        tourPartDto.setRouteVehicleType(this.getRouteVehicleType());
        tourPartDto.setTourPartType(this.getTourPartType());
        TourDifficultyLevelModelImpl difficultyLevel = (TourDifficultyLevelModelImpl)this.getDifficultyLevel();
        if (difficultyLevel != null) {
            tourPartDto.setDifficultyLevel(difficultyLevel.createProxy());
        }
        return tourPartDto;
    }

    @Override
    public TourPartProxyDto createProxy() {
        Long id = this.getId();
        TourPartProxyDto tourPartDto = id == null ? new TourPartProxyDto(this.getTempUUID()) : new TourPartProxyDto(id, this.getVersion());
        return tourPartDto;
    }

    public static enum TourPartModelEnum {
        NAME("name"),
        INFORMATION("information"),
        STOPS("stops"),
        TOUR("tour"),
        SORT_ORDER("sortOrder"),
        LINE_STRING("lineString"),
        ROUTE_TYPE("routeType"),
        ROUTE_VEHICLE_TYPE("routeVehicleType"),
        TOUR_PART_TYPE("tourPartType"),
        DIFFICULTY_LEVEL("difficultyLevel");

        private String propertyName;

        private TourPartModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

