/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.tour;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.tour.TourDifficultyLevelModel;
import de.datomino.peppergis.dto.tour.TourDifficultyLevelFullDto;
import de.datomino.peppergis.dto.tour.TourDifficultyLevelProxyDto;
import de.datomino.peppergis.exception.StaleStateException;
import de.datomino.peppergis.type.TourDifficultyLevelType;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;

public class TourDifficultyLevelModelImpl
extends AbstractModel<TourDifficultyLevelFullDto, TourDifficultyLevelProxyDto>
implements TourDifficultyLevelModel {
    private Double value;
    private Double lowerLimit;
    private Double upperLimit;
    private TourDifficultyLevelType type;

    public TourDifficultyLevelModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public TourDifficultyLevelModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public Double getValue() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.value;
    }

    @Override
    public void setValue(Double value) {
        this.setValue(value, true);
    }

    private void setValue(Double value, boolean setDirty) {
        Double oldValue = this.getValue();
        if (new EqualsBuilder().append(oldValue, value).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, TourDifficultyLevelModelEnum.VALUE.getPropertyName());
        }
        this.value = value;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(TourDifficultyLevelModelEnum.VALUE, value, oldValue);
    }

    @Override
    public Double getLowerLimit() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.lowerLimit;
    }

    @Override
    public void setLowerLimit(Double lowerLimit) {
        this.setLowerLimit(lowerLimit, true);
    }

    private void setLowerLimit(Double lowerLimit, boolean setDirty) {
        Double oldLowerLimit = this.getLowerLimit();
        if (new EqualsBuilder().append(oldLowerLimit, lowerLimit).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, TourDifficultyLevelModelEnum.LOWER_LIMIT.getPropertyName());
        }
        this.lowerLimit = lowerLimit;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(TourDifficultyLevelModelEnum.LOWER_LIMIT, lowerLimit, oldLowerLimit);
    }

    @Override
    public Double getUpperLimit() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.upperLimit;
    }

    @Override
    public void setUpperLimit(Double upperLimit) {
        this.setUpperLimit(upperLimit, true);
    }

    private void setUpperLimit(Double upperLimit, boolean setDirty) {
        Double oldUpperLimit = this.getUpperLimit();
        if (new EqualsBuilder().append(oldUpperLimit, upperLimit).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, TourDifficultyLevelModelEnum.UPPER_LIMIT.getPropertyName());
        }
        this.upperLimit = upperLimit;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(TourDifficultyLevelModelEnum.UPPER_LIMIT, upperLimit, oldUpperLimit);
    }

    @Override
    public TourDifficultyLevelType getType() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.type;
    }

    @Override
    public void setType(TourDifficultyLevelType type) {
        this.setType(type, true);
    }

    private void setType(TourDifficultyLevelType type, boolean setDirty) {
        TourDifficultyLevelType oldType = this.getType();
        if (new EqualsBuilder().append((Object)oldType, (Object)type).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, TourDifficultyLevelModelEnum.TYPE.getPropertyName());
        }
        this.type = type;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(TourDifficultyLevelModelEnum.TYPE, (Object)type, (Object)oldType);
    }

    @Override
    protected void updateByDto(TourDifficultyLevelFullDto tourDifficultyLevelDto) {
        this.value = tourDifficultyLevelDto.getValue();
        this.lowerLimit = tourDifficultyLevelDto.getLowerLimit();
        this.upperLimit = tourDifficultyLevelDto.getUpperLimit();
        this.type = tourDifficultyLevelDto.getType();
    }

    @Override
    protected void updateMasterRelationsByDto(TourDifficultyLevelFullDto tourDifficultyLevelDto) {
    }

    @Override
    protected void checkStaleByDto(TourDifficultyLevelFullDto tourDifficultyLevelDto) throws StaleStateException {
    }

    @Override
    public TourDifficultyLevelFullDto createDto() {
        Long id = this.getId();
        TourDifficultyLevelFullDto tourDifficultyLevelDto = id == null ? new TourDifficultyLevelFullDto(this.getTempUUID()) : new TourDifficultyLevelFullDto(id, this.getVersion());
        tourDifficultyLevelDto.setValue(this.getValue());
        tourDifficultyLevelDto.setLowerLimit(this.getLowerLimit());
        tourDifficultyLevelDto.setUpperLimit(this.getUpperLimit());
        tourDifficultyLevelDto.setType(this.getType());
        return tourDifficultyLevelDto;
    }

    @Override
    public TourDifficultyLevelProxyDto createProxy() {
        Long id = this.getId();
        TourDifficultyLevelProxyDto tourDifficultyLevelDto = id == null ? new TourDifficultyLevelProxyDto(this.getTempUUID()) : new TourDifficultyLevelProxyDto(id, this.getVersion());
        return tourDifficultyLevelDto;
    }

    public static enum TourDifficultyLevelModelEnum {
        VALUE("value"),
        LOWER_LIMIT("lowerLimit"),
        UPPER_LIMIT("upperLimit"),
        TYPE("type");

        private String propertyName;

        private TourDifficultyLevelModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

