/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.tour;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.tour.DeliveryProductModel;
import de.datomino.peppergis.client.model.tour.DeliveryRoundModel;
import de.datomino.peppergis.client.model.tour.DeliveryRoundModelImpl;
import de.datomino.peppergis.dto.tour.DeliveryProductFullDto;
import de.datomino.peppergis.dto.tour.DeliveryProductProxyDto;
import de.datomino.peppergis.dto.tour.DeliveryRoundDto;
import de.datomino.peppergis.exception.StaleStateException;
import de.datomino.peppergis.type.Product;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;

public class DeliveryProductModelImpl
extends AbstractModel<DeliveryProductFullDto, DeliveryProductProxyDto>
implements DeliveryProductModel {
    private Product product;
    private DeliveryRoundModel deliveryRound;

    public DeliveryProductModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public DeliveryProductModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public Product getProduct() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.product;
    }

    @Override
    public void setProduct(Product product) {
        this.setProduct(product, true);
    }

    private void setProduct(Product product, boolean setDirty) {
        Product oldProduct = this.getProduct();
        if (new EqualsBuilder().append((Object)oldProduct, (Object)product).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, DeliveryProductModelEnum.PRODUCT.getPropertyName());
        }
        this.product = product;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(DeliveryProductModelEnum.PRODUCT, (Object)product, (Object)oldProduct);
    }

    @Override
    public DeliveryRoundModel getDeliveryRound() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.deliveryRound;
    }

    @Override
    public void setDeliveryRound(DeliveryRoundModel deliveryRound) {
        this.setDeliveryRound(deliveryRound, true);
    }

    private void setDeliveryRound(DeliveryRoundModel deliveryRound, boolean setDirty) {
        DeliveryRoundModel oldDeliveryRound = this.getDeliveryRound();
        if (oldDeliveryRound == deliveryRound) {
            return;
        }
        if (oldDeliveryRound != null) {
            oldDeliveryRound.removeDeliveryProduct(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, DeliveryProductModelEnum.DELIVERY_ROUND.getPropertyName());
        }
        this.deliveryRound = deliveryRound;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(DeliveryProductModelEnum.DELIVERY_ROUND, deliveryRound, oldDeliveryRound);
        if (this.deliveryRound != null) {
            this.deliveryRound.addDeliveryProduct(this);
        }
    }

    @Override
    protected void updateByDto(DeliveryProductFullDto deliveryProductDto) {
        this.product = deliveryProductDto.getProduct();
        this.deliveryRound = (DeliveryRoundModel)this.getModelCache().getModel(deliveryProductDto.getDeliveryRound());
    }

    @Override
    protected void updateMasterRelationsByDto(DeliveryProductFullDto deliveryProductDto) {
    }

    @Override
    protected void checkStaleByDto(DeliveryProductFullDto deliveryProductDto) throws StaleStateException {
        DeliveryRoundModelImpl deliveryRoundModel;
        DeliveryRoundDto deliveryRoundDto = deliveryProductDto.getDeliveryRound();
        if (deliveryRoundDto != null && deliveryRoundDto.getId() != null && (deliveryRoundModel = (DeliveryRoundModelImpl)this.getModelCache().getModel(DeliveryRoundModel.class, deliveryRoundDto.getId())) != null) {
            deliveryRoundModel.checkStaleState(deliveryRoundDto);
        }
    }

    @Override
    public DeliveryProductFullDto createDto() {
        Long id = this.getId();
        DeliveryProductFullDto deliveryProductDto = id == null ? new DeliveryProductFullDto(this.getTempUUID()) : new DeliveryProductFullDto(id, this.getVersion());
        deliveryProductDto.setProduct(this.getProduct());
        DeliveryRoundModelImpl deliveryRound = (DeliveryRoundModelImpl)this.getDeliveryRound();
        if (deliveryRound != null) {
            deliveryProductDto.setDeliveryRound(deliveryRound.createProxy());
        }
        return deliveryProductDto;
    }

    @Override
    public DeliveryProductProxyDto createProxy() {
        Long id = this.getId();
        DeliveryProductProxyDto deliveryProductDto = id == null ? new DeliveryProductProxyDto(this.getTempUUID()) : new DeliveryProductProxyDto(id, this.getVersion());
        return deliveryProductDto;
    }

    public static enum DeliveryProductModelEnum {
        PRODUCT("product"),
        DELIVERY_ROUND("deliveryRound");

        private String propertyName;

        private DeliveryProductModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

