/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.tour;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.tour.DelivererModel;
import de.datomino.peppergis.client.model.tour.DelivererModelImpl;
import de.datomino.peppergis.client.model.tour.DelivererRewardModel;
import de.datomino.peppergis.dto.tour.DelivererDto;
import de.datomino.peppergis.dto.tour.DelivererRewardFullDto;
import de.datomino.peppergis.dto.tour.DelivererRewardProxyDto;
import de.datomino.peppergis.exception.StaleStateException;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;

public class DelivererRewardModelImpl
extends AbstractModel<DelivererRewardFullDto, DelivererRewardProxyDto>
implements DelivererRewardModel {
    private Double hourReward;
    private Double kilometerReward;
    private DelivererModel deliverer;

    public DelivererRewardModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public DelivererRewardModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public Double getHourReward() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.hourReward;
    }

    @Override
    public void setHourReward(Double hourReward) {
        this.setHourReward(hourReward, true);
    }

    private void setHourReward(Double hourReward, boolean setDirty) {
        Double oldHourReward = this.getHourReward();
        if (new EqualsBuilder().append(oldHourReward, hourReward).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, DelivererRewardModelEnum.HOUR_REWARD.getPropertyName());
        }
        this.hourReward = hourReward;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(DelivererRewardModelEnum.HOUR_REWARD, hourReward, oldHourReward);
    }

    @Override
    public Double getKilometerReward() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.kilometerReward;
    }

    @Override
    public void setKilometerReward(Double kilometerReward) {
        this.setKilometerReward(kilometerReward, true);
    }

    private void setKilometerReward(Double kilometerReward, boolean setDirty) {
        Double oldKilometerReward = this.getKilometerReward();
        if (new EqualsBuilder().append(oldKilometerReward, kilometerReward).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, DelivererRewardModelEnum.KILOMETER_REWARD.getPropertyName());
        }
        this.kilometerReward = kilometerReward;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(DelivererRewardModelEnum.KILOMETER_REWARD, kilometerReward, oldKilometerReward);
    }

    @Override
    public DelivererModel getDeliverer() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.deliverer;
    }

    @Override
    public void setDeliverer(DelivererModel deliverer) {
        this.setDeliverer(deliverer, true);
    }

    private void setDeliverer(DelivererModel deliverer, boolean setDirty) {
        DelivererModel oldDeliverer = this.getDeliverer();
        if (oldDeliverer == deliverer) {
            return;
        }
        if (oldDeliverer != null) {
            oldDeliverer.setReward(null);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, DelivererRewardModelEnum.DELIVERER.getPropertyName());
        }
        this.deliverer = deliverer;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(DelivererRewardModelEnum.DELIVERER, deliverer, oldDeliverer);
        if (this.deliverer != null) {
            this.deliverer.setReward(this);
        }
    }

    @Override
    protected void updateByDto(DelivererRewardFullDto delivererRewardDto) {
        this.hourReward = delivererRewardDto.getHourReward();
        this.kilometerReward = delivererRewardDto.getKilometerReward();
        this.deliverer = (DelivererModel)this.getModelCache().getModel(delivererRewardDto.getDeliverer());
    }

    @Override
    protected void updateMasterRelationsByDto(DelivererRewardFullDto delivererRewardDto) {
    }

    @Override
    protected void checkStaleByDto(DelivererRewardFullDto delivererRewardDto) throws StaleStateException {
        DelivererModelImpl delivererModel;
        DelivererDto delivererDto = delivererRewardDto.getDeliverer();
        if (delivererDto != null && delivererDto.getId() != null && (delivererModel = (DelivererModelImpl)this.getModelCache().getModel(DelivererModel.class, delivererDto.getId())) != null) {
            delivererModel.checkStaleState(delivererDto);
        }
    }

    @Override
    public DelivererRewardFullDto createDto() {
        Long id = this.getId();
        DelivererRewardFullDto delivererRewardDto = id == null ? new DelivererRewardFullDto(this.getTempUUID()) : new DelivererRewardFullDto(id, this.getVersion());
        delivererRewardDto.setHourReward(this.getHourReward());
        delivererRewardDto.setKilometerReward(this.getKilometerReward());
        DelivererModelImpl deliverer = (DelivererModelImpl)this.getDeliverer();
        if (deliverer != null) {
            delivererRewardDto.setDeliverer(deliverer.createProxy());
        }
        return delivererRewardDto;
    }

    @Override
    public DelivererRewardProxyDto createProxy() {
        Long id = this.getId();
        DelivererRewardProxyDto delivererRewardDto = id == null ? new DelivererRewardProxyDto(this.getTempUUID()) : new DelivererRewardProxyDto(id, this.getVersion());
        return delivererRewardDto;
    }

    public static enum DelivererRewardModelEnum {
        HOUR_REWARD("hourReward"),
        KILOMETER_REWARD("kilometerReward"),
        DELIVERER("deliverer");

        private String propertyName;

        private DelivererRewardModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

