/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.tour;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.base.BranchModel;
import de.datomino.peppergis.client.model.base.BranchModelImpl;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.client.model.base.PoiModelImpl;
import de.datomino.peppergis.client.model.mobile.AccountModel;
import de.datomino.peppergis.client.model.mobile.AccountModelImpl;
import de.datomino.peppergis.client.model.tour.DelivererEmploymentModel;
import de.datomino.peppergis.client.model.tour.DelivererEmploymentModelImpl;
import de.datomino.peppergis.client.model.tour.DelivererModel;
import de.datomino.peppergis.client.model.tour.DelivererRewardModel;
import de.datomino.peppergis.client.model.tour.DelivererRewardModelImpl;
import de.datomino.peppergis.client.model.tour.DelivererStatusTimeWindowModel;
import de.datomino.peppergis.client.model.tour.DelivererStatusTimeWindowModelImpl;
import de.datomino.peppergis.client.model.tour.VehicleModel;
import de.datomino.peppergis.client.model.tour.VehicleModelImpl;
import de.datomino.peppergis.dto.base.BranchDto;
import de.datomino.peppergis.dto.base.PoiDto;
import de.datomino.peppergis.dto.mobile.AccountDto;
import de.datomino.peppergis.dto.tour.DelivererEmploymentDto;
import de.datomino.peppergis.dto.tour.DelivererFullDto;
import de.datomino.peppergis.dto.tour.DelivererProxyDto;
import de.datomino.peppergis.dto.tour.DelivererRewardDto;
import de.datomino.peppergis.dto.tour.DelivererStatusTimeWindowDto;
import de.datomino.peppergis.dto.tour.VehicleDto;
import de.datomino.peppergis.exception.StaleStateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;
import org.ktde.util.conversions.ImmutableIterator;
import org.ktde.util.conversions.IteratorIterable;
import org.ktde.util.datatypes.Holder;

public class DelivererModelImpl
extends AbstractModel<DelivererFullDto, DelivererProxyDto>
implements DelivererModel {
    private String delivererNumber;
    private String name;
    private BranchModel branch;
    private PoiModel poi;
    private Set<AccountModel> mobileAccounts = null;
    private Holder<VehicleModel> vehicle;
    private Set<DelivererStatusTimeWindowModel> statusTimeWindows = null;
    private Date birthday;
    private String phoneNumber;
    private String mobileNumber;
    private String email;
    private Holder<DelivererEmploymentModel> employment;
    private Holder<DelivererRewardModel> reward;
    private Boolean blockMobileData;
    private Integer mobilePauseTime;
    private String gpsDeactivationCode;

    public DelivererModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public DelivererModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public String getDelivererNumber() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.delivererNumber;
    }

    @Override
    public void setDelivererNumber(String delivererNumber) {
        this.setDelivererNumber(delivererNumber, true);
    }

    private void setDelivererNumber(String delivererNumber, boolean setDirty) {
        String oldDelivererNumber = this.getDelivererNumber();
        if (new EqualsBuilder().append(oldDelivererNumber, delivererNumber).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, DelivererModelEnum.DELIVERER_NUMBER.getPropertyName());
        }
        this.delivererNumber = delivererNumber;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(DelivererModelEnum.DELIVERER_NUMBER, delivererNumber, oldDelivererNumber);
    }

    @Override
    public String getName() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.setName(name, true);
    }

    private void setName(String name, boolean setDirty) {
        String oldName = this.getName();
        if (new EqualsBuilder().append(oldName, name).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, DelivererModelEnum.NAME.getPropertyName());
        }
        this.name = name;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(DelivererModelEnum.NAME, name, oldName);
    }

    @Override
    public BranchModel getBranch() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.branch;
    }

    @Override
    public void setBranch(BranchModel branch) {
        this.setBranch(branch, true);
    }

    private void setBranch(BranchModel branch, boolean setDirty) {
        BranchModel oldBranch = this.getBranch();
        if (oldBranch == branch) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, DelivererModelEnum.BRANCH.getPropertyName());
        }
        this.branch = branch;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(DelivererModelEnum.BRANCH, branch, oldBranch);
    }

    @Override
    public PoiModel getPoi() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.poi;
    }

    @Override
    public void setPoi(PoiModel poi) {
        this.setPoi(poi, true);
    }

    private void setPoi(PoiModel poi, boolean setDirty) {
        PoiModel oldPoi = this.getPoi();
        if (oldPoi == poi) {
            return;
        }
        if (oldPoi != null) {
            oldPoi.removeDeliverer(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, DelivererModelEnum.POI.getPropertyName());
        }
        this.poi = poi;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(DelivererModelEnum.POI, poi, oldPoi);
        if (this.poi != null) {
            this.poi.addDeliverer(this);
        }
    }

    @Override
    public int countMobileAccounts() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.mobileAccounts == null) {
            this.mobileAccounts = new LinkedHashSet<AccountModel>();
            if (this.getId() != null) {
                Collection mobileAccountsCollection = this.commonCaller.fetchChildren(this, DelivererModelEnum.MOBILE_ACCOUNTS.getPropertyName());
                this.mobileAccounts.addAll(mobileAccountsCollection);
            }
        }
        return this.mobileAccounts.size();
    }

    @Override
    public Iterator<AccountModel> iterateMobileAccounts() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.mobileAccounts == null) {
            this.mobileAccounts = new LinkedHashSet<AccountModel>();
            if (this.getId() != null) {
                Collection mobileAccountsCollection = this.commonCaller.fetchChildren(this, DelivererModelEnum.MOBILE_ACCOUNTS.getPropertyName());
                this.mobileAccounts.addAll(mobileAccountsCollection);
            }
        }
        return new ImmutableIterator<AccountModel>(this.mobileAccounts);
    }

    @Override
    public Iterable<AccountModel> iterableMobileAccounts() {
        return new IteratorIterable<AccountModel>(this.iterateMobileAccounts());
    }

    @Override
    public void addMobileAccount(AccountModel mobileAccount) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.mobileAccounts == null) {
            this.mobileAccounts = new LinkedHashSet<AccountModel>();
            if (this.getId() != null) {
                Collection mobileAccountsCollection = this.commonCaller.fetchChildren(this, DelivererModelEnum.MOBILE_ACCOUNTS.getPropertyName());
                this.mobileAccounts.addAll(mobileAccountsCollection);
            }
        }
        if (this.mobileAccounts.contains(mobileAccount)) {
            return;
        }
        this.mobileAccounts.add(mobileAccount);
        this.fireValueChanged(DelivererModelEnum.MOBILE_ACCOUNTS, mobileAccount, null);
        if (mobileAccount != null) {
            mobileAccount.setDeliverer(this);
        }
    }

    @Override
    public void removeMobileAccount(AccountModel mobileAccount) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.mobileAccounts == null) {
            this.mobileAccounts = new LinkedHashSet<AccountModel>();
            if (this.getId() != null) {
                Collection mobileAccountsCollection = this.commonCaller.fetchChildren(this, DelivererModelEnum.MOBILE_ACCOUNTS.getPropertyName());
                this.mobileAccounts.addAll(mobileAccountsCollection);
            }
        }
        if (!this.mobileAccounts.contains(mobileAccount)) {
            return;
        }
        this.mobileAccounts.remove(mobileAccount);
        this.fireValueChanged(DelivererModelEnum.MOBILE_ACCOUNTS, mobileAccount, null);
        if (mobileAccount != null) {
            mobileAccount.setDeliverer(null);
        }
    }

    @Override
    public void clearMobileAccounts() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.mobileAccounts == null) {
            this.mobileAccounts = new LinkedHashSet<AccountModel>();
            if (this.getId() != null) {
                Collection mobileAccountsCollection = this.commonCaller.fetchChildren(this, DelivererModelEnum.MOBILE_ACCOUNTS.getPropertyName());
                this.mobileAccounts.addAll(mobileAccountsCollection);
            }
        }
        ArrayList<AccountModel> oldMobileAccounts = new ArrayList<AccountModel>(this.mobileAccounts);
        this.mobileAccounts.clear();
        this.fireValueChanged(DelivererModelEnum.MOBILE_ACCOUNTS, null, null);
        for (AccountModel oldMobileAccount : oldMobileAccounts) {
            if (oldMobileAccount == null) continue;
            oldMobileAccount.setDeliverer(null);
        }
    }

    @Override
    public boolean isMobileAccountsEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.mobileAccounts == null) {
            this.mobileAccounts = new LinkedHashSet<AccountModel>();
            if (this.getId() != null) {
                Collection mobileAccountsCollection = this.commonCaller.fetchChildren(this, DelivererModelEnum.MOBILE_ACCOUNTS.getPropertyName());
                this.mobileAccounts.addAll(mobileAccountsCollection);
            }
        }
        return this.mobileAccounts.isEmpty();
    }

    @Override
    public boolean containsMobileAccount(AccountModel mobileAccount) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.mobileAccounts == null) {
            this.mobileAccounts = new LinkedHashSet<AccountModel>();
            if (this.getId() != null) {
                Collection mobileAccountsCollection = this.commonCaller.fetchChildren(this, DelivererModelEnum.MOBILE_ACCOUNTS.getPropertyName());
                this.mobileAccounts.addAll(mobileAccountsCollection);
            }
        }
        return this.mobileAccounts.contains(mobileAccount);
    }

    @Override
    public boolean isMobileAccountsInitialized() {
        return this.mobileAccounts != null;
    }

    @Override
    public VehicleModel getVehicle() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.vehicle == null) {
            this.vehicle = new Holder();
            if (this.getId() != null) {
                this.vehicle.setElement((VehicleModel)this.commonCaller.fetchChild(this, DelivererModelEnum.VEHICLE.getPropertyName()));
            }
        }
        return this.vehicle.getElement();
    }

    @Override
    public void setVehicle(VehicleModel vehicle) {
        VehicleModel oldVehicle = this.getVehicle();
        if (oldVehicle == vehicle) {
            return;
        }
        this.vehicle.setElement(vehicle);
        this.fireValueChanged(DelivererModelEnum.VEHICLE, vehicle, oldVehicle);
        if (oldVehicle != null) {
            oldVehicle.setDeliverer(null);
        }
        if (vehicle != null) {
            vehicle.setDeliverer(this);
        }
    }

    @Override
    public int countStatusTimeWindows() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.statusTimeWindows == null) {
            this.statusTimeWindows = new LinkedHashSet<DelivererStatusTimeWindowModel>();
            if (this.getId() != null) {
                Collection statusTimeWindowsCollection = this.commonCaller.fetchChildren(this, DelivererModelEnum.STATUS_TIME_WINDOWS.getPropertyName());
                this.statusTimeWindows.addAll(statusTimeWindowsCollection);
            }
        }
        return this.statusTimeWindows.size();
    }

    @Override
    public Iterator<DelivererStatusTimeWindowModel> iterateStatusTimeWindows() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.statusTimeWindows == null) {
            this.statusTimeWindows = new LinkedHashSet<DelivererStatusTimeWindowModel>();
            if (this.getId() != null) {
                Collection statusTimeWindowsCollection = this.commonCaller.fetchChildren(this, DelivererModelEnum.STATUS_TIME_WINDOWS.getPropertyName());
                this.statusTimeWindows.addAll(statusTimeWindowsCollection);
            }
        }
        return new ImmutableIterator<DelivererStatusTimeWindowModel>(this.statusTimeWindows);
    }

    @Override
    public Iterable<DelivererStatusTimeWindowModel> iterableStatusTimeWindows() {
        return new IteratorIterable<DelivererStatusTimeWindowModel>(this.iterateStatusTimeWindows());
    }

    @Override
    public void addStatusTimeWindow(DelivererStatusTimeWindowModel statusTimeWindow) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.statusTimeWindows == null) {
            this.statusTimeWindows = new LinkedHashSet<DelivererStatusTimeWindowModel>();
            if (this.getId() != null) {
                Collection statusTimeWindowsCollection = this.commonCaller.fetchChildren(this, DelivererModelEnum.STATUS_TIME_WINDOWS.getPropertyName());
                this.statusTimeWindows.addAll(statusTimeWindowsCollection);
            }
        }
        if (this.statusTimeWindows.contains(statusTimeWindow)) {
            return;
        }
        this.statusTimeWindows.add(statusTimeWindow);
        this.fireValueChanged(DelivererModelEnum.STATUS_TIME_WINDOWS, statusTimeWindow, null);
        if (statusTimeWindow != null) {
            statusTimeWindow.setDeliverer(this);
        }
    }

    @Override
    public void removeStatusTimeWindow(DelivererStatusTimeWindowModel statusTimeWindow) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.statusTimeWindows == null) {
            this.statusTimeWindows = new LinkedHashSet<DelivererStatusTimeWindowModel>();
            if (this.getId() != null) {
                Collection statusTimeWindowsCollection = this.commonCaller.fetchChildren(this, DelivererModelEnum.STATUS_TIME_WINDOWS.getPropertyName());
                this.statusTimeWindows.addAll(statusTimeWindowsCollection);
            }
        }
        if (!this.statusTimeWindows.contains(statusTimeWindow)) {
            return;
        }
        this.statusTimeWindows.remove(statusTimeWindow);
        this.fireValueChanged(DelivererModelEnum.STATUS_TIME_WINDOWS, statusTimeWindow, null);
        if (statusTimeWindow != null) {
            statusTimeWindow.setDeliverer(null);
        }
    }

    @Override
    public void clearStatusTimeWindows() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.statusTimeWindows == null) {
            this.statusTimeWindows = new LinkedHashSet<DelivererStatusTimeWindowModel>();
            if (this.getId() != null) {
                Collection statusTimeWindowsCollection = this.commonCaller.fetchChildren(this, DelivererModelEnum.STATUS_TIME_WINDOWS.getPropertyName());
                this.statusTimeWindows.addAll(statusTimeWindowsCollection);
            }
        }
        ArrayList<DelivererStatusTimeWindowModel> oldStatusTimeWindows = new ArrayList<DelivererStatusTimeWindowModel>(this.statusTimeWindows);
        this.statusTimeWindows.clear();
        this.fireValueChanged(DelivererModelEnum.STATUS_TIME_WINDOWS, null, null);
        for (DelivererStatusTimeWindowModel oldStatusTimeWindow : oldStatusTimeWindows) {
            if (oldStatusTimeWindow == null) continue;
            oldStatusTimeWindow.setDeliverer(null);
        }
    }

    @Override
    public boolean isStatusTimeWindowsEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.statusTimeWindows == null) {
            this.statusTimeWindows = new LinkedHashSet<DelivererStatusTimeWindowModel>();
            if (this.getId() != null) {
                Collection statusTimeWindowsCollection = this.commonCaller.fetchChildren(this, DelivererModelEnum.STATUS_TIME_WINDOWS.getPropertyName());
                this.statusTimeWindows.addAll(statusTimeWindowsCollection);
            }
        }
        return this.statusTimeWindows.isEmpty();
    }

    @Override
    public boolean containsStatusTimeWindow(DelivererStatusTimeWindowModel statusTimeWindow) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.statusTimeWindows == null) {
            this.statusTimeWindows = new LinkedHashSet<DelivererStatusTimeWindowModel>();
            if (this.getId() != null) {
                Collection statusTimeWindowsCollection = this.commonCaller.fetchChildren(this, DelivererModelEnum.STATUS_TIME_WINDOWS.getPropertyName());
                this.statusTimeWindows.addAll(statusTimeWindowsCollection);
            }
        }
        return this.statusTimeWindows.contains(statusTimeWindow);
    }

    @Override
    public boolean isStatusTimeWindowsInitialized() {
        return this.statusTimeWindows != null;
    }

    @Override
    public Date getBirthday() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.birthday;
    }

    @Override
    public void setBirthday(Date birthday) {
        this.setBirthday(birthday, true);
    }

    private void setBirthday(Date birthday, boolean setDirty) {
        Date oldBirthday = this.getBirthday();
        if (new EqualsBuilder().append(oldBirthday, birthday).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, DelivererModelEnum.BIRTHDAY.getPropertyName());
        }
        this.birthday = birthday;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(DelivererModelEnum.BIRTHDAY, birthday, oldBirthday);
    }

    @Override
    public String getPhoneNumber() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.phoneNumber;
    }

    @Override
    public void setPhoneNumber(String phoneNumber) {
        this.setPhoneNumber(phoneNumber, true);
    }

    private void setPhoneNumber(String phoneNumber, boolean setDirty) {
        String oldPhoneNumber = this.getPhoneNumber();
        if (new EqualsBuilder().append(oldPhoneNumber, phoneNumber).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, DelivererModelEnum.PHONE_NUMBER.getPropertyName());
        }
        this.phoneNumber = phoneNumber;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(DelivererModelEnum.PHONE_NUMBER, phoneNumber, oldPhoneNumber);
    }

    @Override
    public String getMobileNumber() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.mobileNumber;
    }

    @Override
    public void setMobileNumber(String mobileNumber) {
        this.setMobileNumber(mobileNumber, true);
    }

    private void setMobileNumber(String mobileNumber, boolean setDirty) {
        String oldMobileNumber = this.getMobileNumber();
        if (new EqualsBuilder().append(oldMobileNumber, mobileNumber).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, DelivererModelEnum.MOBILE_NUMBER.getPropertyName());
        }
        this.mobileNumber = mobileNumber;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(DelivererModelEnum.MOBILE_NUMBER, mobileNumber, oldMobileNumber);
    }

    @Override
    public String getEmail() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.email;
    }

    @Override
    public void setEmail(String email) {
        this.setEmail(email, true);
    }

    private void setEmail(String email, boolean setDirty) {
        String oldEmail = this.getEmail();
        if (new EqualsBuilder().append(oldEmail, email).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, DelivererModelEnum.EMAIL.getPropertyName());
        }
        this.email = email;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(DelivererModelEnum.EMAIL, email, oldEmail);
    }

    @Override
    public DelivererEmploymentModel getEmployment() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.employment == null) {
            this.employment = new Holder();
            if (this.getId() != null) {
                this.employment.setElement((DelivererEmploymentModel)this.commonCaller.fetchChild(this, DelivererModelEnum.EMPLOYMENT.getPropertyName()));
            }
        }
        return this.employment.getElement();
    }

    @Override
    public void setEmployment(DelivererEmploymentModel employment) {
        DelivererEmploymentModel oldEmployment = this.getEmployment();
        if (oldEmployment == employment) {
            return;
        }
        this.employment.setElement(employment);
        this.fireValueChanged(DelivererModelEnum.EMPLOYMENT, employment, oldEmployment);
        if (oldEmployment != null) {
            oldEmployment.setDeliverer(null);
        }
        if (employment != null) {
            employment.setDeliverer(this);
        }
    }

    @Override
    public DelivererRewardModel getReward() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.reward == null) {
            this.reward = new Holder();
            if (this.getId() != null) {
                this.reward.setElement((DelivererRewardModel)this.commonCaller.fetchChild(this, DelivererModelEnum.REWARD.getPropertyName()));
            }
        }
        return this.reward.getElement();
    }

    @Override
    public void setReward(DelivererRewardModel reward) {
        DelivererRewardModel oldReward = this.getReward();
        if (oldReward == reward) {
            return;
        }
        this.reward.setElement(reward);
        this.fireValueChanged(DelivererModelEnum.REWARD, reward, oldReward);
        if (oldReward != null) {
            oldReward.setDeliverer(null);
        }
        if (reward != null) {
            reward.setDeliverer(this);
        }
    }

    @Override
    public Boolean getBlockMobileData() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.blockMobileData;
    }

    @Override
    public void setBlockMobileData(Boolean blockMobileData) {
        this.setBlockMobileData(blockMobileData, true);
    }

    private void setBlockMobileData(Boolean blockMobileData, boolean setDirty) {
        Boolean oldBlockMobileData = this.getBlockMobileData();
        if (new EqualsBuilder().append(oldBlockMobileData, blockMobileData).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, DelivererModelEnum.BLOCK_MOBILE_DATA.getPropertyName());
        }
        this.blockMobileData = blockMobileData;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(DelivererModelEnum.BLOCK_MOBILE_DATA, blockMobileData, oldBlockMobileData);
    }

    @Override
    public Integer getMobilePauseTime() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.mobilePauseTime;
    }

    @Override
    public void setMobilePauseTime(Integer mobilePauseTime) {
        this.setMobilePauseTime(mobilePauseTime, true);
    }

    private void setMobilePauseTime(Integer mobilePauseTime, boolean setDirty) {
        Integer oldMobilePauseTime = this.getMobilePauseTime();
        if (new EqualsBuilder().append(oldMobilePauseTime, mobilePauseTime).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, DelivererModelEnum.MOBILE_PAUSE_TIME.getPropertyName());
        }
        this.mobilePauseTime = mobilePauseTime;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(DelivererModelEnum.MOBILE_PAUSE_TIME, mobilePauseTime, oldMobilePauseTime);
    }

    @Override
    public String getGpsDeactivationCode() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.gpsDeactivationCode;
    }

    @Override
    public void setGpsDeactivationCode(String gpsDeactivationCode) {
        this.setGpsDeactivationCode(gpsDeactivationCode, true);
    }

    private void setGpsDeactivationCode(String gpsDeactivationCode, boolean setDirty) {
        String oldGpsDeactivationCode = this.getGpsDeactivationCode();
        if (new EqualsBuilder().append(oldGpsDeactivationCode, gpsDeactivationCode).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, DelivererModelEnum.GPS_DEACTIVATION_CODE.getPropertyName());
        }
        this.gpsDeactivationCode = gpsDeactivationCode;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(DelivererModelEnum.GPS_DEACTIVATION_CODE, gpsDeactivationCode, oldGpsDeactivationCode);
    }

    @Override
    public void setProxy(boolean proxy) {
        super.setProxy(proxy);
        if (proxy) {
            this.mobileAccounts = null;
            this.vehicle = null;
            this.statusTimeWindows = null;
            this.employment = null;
            this.reward = null;
        }
    }

    @Override
    protected void updateByDto(DelivererFullDto delivererDto) {
        DelivererRewardDto rewardDto;
        DelivererStatusTimeWindowDto[] statusTimeWindows;
        VehicleDto vehicleDto;
        this.delivererNumber = delivererDto.getDelivererNumber();
        this.name = delivererDto.getName();
        this.branch = (BranchModel)this.getModelCache().getModel(delivererDto.getBranch());
        this.poi = (PoiModel)this.getModelCache().getModel(delivererDto.getPoi());
        AccountDto[] mobileAccounts = delivererDto.getMobileAccounts();
        if (mobileAccounts != null) {
            if (this.mobileAccounts == null) {
                this.mobileAccounts = new LinkedHashSet<AccountModel>();
            } else {
                this.mobileAccounts.clear();
            }
        }
        if ((vehicleDto = delivererDto.getVehicle()) != null && this.vehicle == null) {
            this.vehicle = new Holder();
        }
        if ((statusTimeWindows = delivererDto.getStatusTimeWindows()) != null) {
            if (this.statusTimeWindows == null) {
                this.statusTimeWindows = new LinkedHashSet<DelivererStatusTimeWindowModel>();
            } else {
                this.statusTimeWindows.clear();
            }
        }
        this.birthday = delivererDto.getBirthday();
        this.phoneNumber = delivererDto.getPhoneNumber();
        this.mobileNumber = delivererDto.getMobileNumber();
        this.email = delivererDto.getEmail();
        DelivererEmploymentDto employmentDto = delivererDto.getEmployment();
        if (employmentDto != null && this.employment == null) {
            this.employment = new Holder();
        }
        if ((rewardDto = delivererDto.getReward()) != null && this.reward == null) {
            this.reward = new Holder();
        }
        this.blockMobileData = delivererDto.getBlockMobileData();
        this.mobilePauseTime = delivererDto.getMobilePauseTime();
        this.gpsDeactivationCode = delivererDto.getGpsDeactivationCode();
    }

    @Override
    protected void updateMasterRelationsByDto(DelivererFullDto delivererDto) {
        DelivererRewardDto rewardDto;
        DelivererEmploymentDto employmentDto;
        DelivererStatusTimeWindowDto[] statusTimeWindows;
        VehicleDto vehicleDto;
        AccountDto[] mobileAccounts = delivererDto.getMobileAccounts();
        if (mobileAccounts != null) {
            if (this.mobileAccounts == null) {
                this.mobileAccounts = new LinkedHashSet<AccountModel>();
            } else {
                this.mobileAccounts.clear();
            }
            for (AccountDto mobileAccountDto : mobileAccounts) {
                AccountModel mobileAccountModel = (AccountModel)this.getModelCache().getModel(mobileAccountDto);
                this.mobileAccounts.add(mobileAccountModel);
            }
        } else {
            this.mobileAccounts = null;
        }
        if ((vehicleDto = delivererDto.getVehicle()) != null) {
            this.vehicle.setElement((VehicleModel)this.getModelCache().getModel(vehicleDto));
        }
        if ((statusTimeWindows = delivererDto.getStatusTimeWindows()) != null) {
            if (this.statusTimeWindows == null) {
                this.statusTimeWindows = new LinkedHashSet<DelivererStatusTimeWindowModel>();
            } else {
                this.statusTimeWindows.clear();
            }
            for (DelivererStatusTimeWindowDto statusTimeWindowDto : statusTimeWindows) {
                DelivererStatusTimeWindowModel statusTimeWindowModel = (DelivererStatusTimeWindowModel)this.getModelCache().getModel(statusTimeWindowDto);
                this.statusTimeWindows.add(statusTimeWindowModel);
            }
        } else {
            this.statusTimeWindows = null;
        }
        if ((employmentDto = delivererDto.getEmployment()) != null) {
            this.employment.setElement((DelivererEmploymentModel)this.getModelCache().getModel(employmentDto));
        }
        if ((rewardDto = delivererDto.getReward()) != null) {
            this.reward.setElement((DelivererRewardModel)this.getModelCache().getModel(rewardDto));
        }
    }

    @Override
    protected void checkStaleByDto(DelivererFullDto delivererDto) throws StaleStateException {
        DelivererRewardModelImpl rewardModel;
        DelivererRewardDto rewardDto;
        DelivererEmploymentModelImpl employmentModel;
        DelivererEmploymentDto employmentDto;
        DelivererStatusTimeWindowDto[] statusTimeWindowDtos;
        VehicleModelImpl vehicleModel;
        VehicleDto vehicleDto;
        AccountDto[] mobileAccountDtos;
        PoiModelImpl poiModel;
        PoiDto poiDto;
        BranchModelImpl branchModel;
        BranchDto branchDto = delivererDto.getBranch();
        if (branchDto != null && branchDto.getId() != null && (branchModel = (BranchModelImpl)this.getModelCache().getModel(BranchModel.class, branchDto.getId())) != null) {
            branchModel.checkStaleState(branchDto);
        }
        if ((poiDto = delivererDto.getPoi()) != null && poiDto.getId() != null && (poiModel = (PoiModelImpl)this.getModelCache().getModel(PoiModel.class, poiDto.getId())) != null) {
            poiModel.checkStaleState(poiDto);
        }
        if ((mobileAccountDtos = delivererDto.getMobileAccounts()) != null) {
            for (AccountDto mobileAccountDto : mobileAccountDtos) {
                AccountModelImpl mobileAccountModel = (AccountModelImpl)this.getModelCache().getModel(AccountModel.class, mobileAccountDto.getId());
                if (mobileAccountModel == null) continue;
                mobileAccountModel.checkStaleState(mobileAccountDto);
            }
        }
        if ((vehicleDto = delivererDto.getVehicle()) != null && vehicleDto.getId() != null && (vehicleModel = (VehicleModelImpl)this.getModelCache().getModel(VehicleModel.class, vehicleDto.getId())) != null) {
            vehicleModel.checkStaleState(vehicleDto);
        }
        if ((statusTimeWindowDtos = delivererDto.getStatusTimeWindows()) != null) {
            for (DelivererStatusTimeWindowDto statusTimeWindowDto : statusTimeWindowDtos) {
                DelivererStatusTimeWindowModelImpl statusTimeWindowModel = (DelivererStatusTimeWindowModelImpl)this.getModelCache().getModel(DelivererStatusTimeWindowModel.class, statusTimeWindowDto.getId());
                if (statusTimeWindowModel == null) continue;
                statusTimeWindowModel.checkStaleState(statusTimeWindowDto);
            }
        }
        if ((employmentDto = delivererDto.getEmployment()) != null && employmentDto.getId() != null && (employmentModel = (DelivererEmploymentModelImpl)this.getModelCache().getModel(DelivererEmploymentModel.class, employmentDto.getId())) != null) {
            employmentModel.checkStaleState(employmentDto);
        }
        if ((rewardDto = delivererDto.getReward()) != null && rewardDto.getId() != null && (rewardModel = (DelivererRewardModelImpl)this.getModelCache().getModel(DelivererRewardModel.class, rewardDto.getId())) != null) {
            rewardModel.checkStaleState(rewardDto);
        }
    }

    @Override
    public DelivererFullDto createDto() {
        PoiModelImpl poi;
        Long id = this.getId();
        DelivererFullDto delivererDto = id == null ? new DelivererFullDto(this.getTempUUID()) : new DelivererFullDto(id, this.getVersion());
        delivererDto.setDelivererNumber(this.getDelivererNumber());
        delivererDto.setName(this.getName());
        BranchModelImpl branch = (BranchModelImpl)this.getBranch();
        if (branch != null) {
            delivererDto.setBranch(branch.createProxy());
        }
        if ((poi = (PoiModelImpl)this.getPoi()) != null) {
            delivererDto.setPoi(poi.createProxy());
        }
        delivererDto.setBirthday(this.getBirthday());
        delivererDto.setPhoneNumber(this.getPhoneNumber());
        delivererDto.setMobileNumber(this.getMobileNumber());
        delivererDto.setEmail(this.getEmail());
        delivererDto.setBlockMobileData(this.getBlockMobileData());
        delivererDto.setMobilePauseTime(this.getMobilePauseTime());
        delivererDto.setGpsDeactivationCode(this.getGpsDeactivationCode());
        return delivererDto;
    }

    @Override
    public DelivererProxyDto createProxy() {
        Long id = this.getId();
        DelivererProxyDto delivererDto = id == null ? new DelivererProxyDto(this.getTempUUID()) : new DelivererProxyDto(id, this.getVersion());
        return delivererDto;
    }

    public static enum DelivererModelEnum {
        DELIVERER_NUMBER("delivererNumber"),
        NAME("name"),
        BRANCH("branch"),
        POI("poi"),
        MOBILE_ACCOUNTS("mobileAccounts"),
        VEHICLE("vehicle"),
        STATUS_TIME_WINDOWS("statusTimeWindows"),
        BIRTHDAY("birthday"),
        PHONE_NUMBER("phoneNumber"),
        MOBILE_NUMBER("mobileNumber"),
        EMAIL("email"),
        EMPLOYMENT("employment"),
        REWARD("reward"),
        BLOCK_MOBILE_DATA("blockMobileData"),
        MOBILE_PAUSE_TIME("mobilePauseTime"),
        GPS_DEACTIVATION_CODE("gpsDeactivationCode");

        private String propertyName;

        private DelivererModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

