/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.tour;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.tour.DelivererEmploymentModel;
import de.datomino.peppergis.client.model.tour.DelivererFactorModel;
import de.datomino.peppergis.client.model.tour.DelivererFactorModelImpl;
import de.datomino.peppergis.client.model.tour.DelivererModel;
import de.datomino.peppergis.client.model.tour.DelivererModelImpl;
import de.datomino.peppergis.dto.tour.DelivererDto;
import de.datomino.peppergis.dto.tour.DelivererEmploymentFullDto;
import de.datomino.peppergis.dto.tour.DelivererEmploymentProxyDto;
import de.datomino.peppergis.dto.tour.DelivererFactorDto;
import de.datomino.peppergis.exception.StaleStateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;
import org.ktde.util.conversions.ImmutableIterator;
import org.ktde.util.conversions.IteratorIterable;

public class DelivererEmploymentModelImpl
extends AbstractModel<DelivererEmploymentFullDto, DelivererEmploymentProxyDto>
implements DelivererEmploymentModel {
    private Integer employmentRadius;
    private Set<DelivererFactorModel> factors = null;
    private DelivererModel deliverer;

    public DelivererEmploymentModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public DelivererEmploymentModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public Integer getEmploymentRadius() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.employmentRadius;
    }

    @Override
    public void setEmploymentRadius(Integer employmentRadius) {
        this.setEmploymentRadius(employmentRadius, true);
    }

    private void setEmploymentRadius(Integer employmentRadius, boolean setDirty) {
        Integer oldEmploymentRadius = this.getEmploymentRadius();
        if (new EqualsBuilder().append(oldEmploymentRadius, employmentRadius).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, DelivererEmploymentModelEnum.EMPLOYMENT_RADIUS.getPropertyName());
        }
        this.employmentRadius = employmentRadius;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(DelivererEmploymentModelEnum.EMPLOYMENT_RADIUS, employmentRadius, oldEmploymentRadius);
    }

    @Override
    public int countFactors() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.factors == null) {
            this.factors = new LinkedHashSet<DelivererFactorModel>();
            if (this.getId() != null) {
                Collection factorsCollection = this.commonCaller.fetchChildren(this, DelivererEmploymentModelEnum.FACTORS.getPropertyName());
                this.factors.addAll(factorsCollection);
            }
        }
        return this.factors.size();
    }

    @Override
    public Iterator<DelivererFactorModel> iterateFactors() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.factors == null) {
            this.factors = new LinkedHashSet<DelivererFactorModel>();
            if (this.getId() != null) {
                Collection factorsCollection = this.commonCaller.fetchChildren(this, DelivererEmploymentModelEnum.FACTORS.getPropertyName());
                this.factors.addAll(factorsCollection);
            }
        }
        return new ImmutableIterator<DelivererFactorModel>(this.factors);
    }

    @Override
    public Iterable<DelivererFactorModel> iterableFactors() {
        return new IteratorIterable<DelivererFactorModel>(this.iterateFactors());
    }

    @Override
    public void addFactor(DelivererFactorModel factor) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.factors == null) {
            this.factors = new LinkedHashSet<DelivererFactorModel>();
            if (this.getId() != null) {
                Collection factorsCollection = this.commonCaller.fetchChildren(this, DelivererEmploymentModelEnum.FACTORS.getPropertyName());
                this.factors.addAll(factorsCollection);
            }
        }
        if (this.factors.contains(factor)) {
            return;
        }
        this.factors.add(factor);
        this.fireValueChanged(DelivererEmploymentModelEnum.FACTORS, factor, null);
        if (factor != null) {
            factor.setDelivererEmployment(this);
        }
    }

    @Override
    public void removeFactor(DelivererFactorModel factor) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.factors == null) {
            this.factors = new LinkedHashSet<DelivererFactorModel>();
            if (this.getId() != null) {
                Collection factorsCollection = this.commonCaller.fetchChildren(this, DelivererEmploymentModelEnum.FACTORS.getPropertyName());
                this.factors.addAll(factorsCollection);
            }
        }
        if (!this.factors.contains(factor)) {
            return;
        }
        this.factors.remove(factor);
        this.fireValueChanged(DelivererEmploymentModelEnum.FACTORS, factor, null);
        if (factor != null) {
            factor.setDelivererEmployment(null);
        }
    }

    @Override
    public void clearFactors() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.factors == null) {
            this.factors = new LinkedHashSet<DelivererFactorModel>();
            if (this.getId() != null) {
                Collection factorsCollection = this.commonCaller.fetchChildren(this, DelivererEmploymentModelEnum.FACTORS.getPropertyName());
                this.factors.addAll(factorsCollection);
            }
        }
        ArrayList<DelivererFactorModel> oldFactors = new ArrayList<DelivererFactorModel>(this.factors);
        this.factors.clear();
        this.fireValueChanged(DelivererEmploymentModelEnum.FACTORS, null, null);
        for (DelivererFactorModel oldFactor : oldFactors) {
            if (oldFactor == null) continue;
            oldFactor.setDelivererEmployment(null);
        }
    }

    @Override
    public boolean isFactorsEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.factors == null) {
            this.factors = new LinkedHashSet<DelivererFactorModel>();
            if (this.getId() != null) {
                Collection factorsCollection = this.commonCaller.fetchChildren(this, DelivererEmploymentModelEnum.FACTORS.getPropertyName());
                this.factors.addAll(factorsCollection);
            }
        }
        return this.factors.isEmpty();
    }

    @Override
    public boolean containsFactor(DelivererFactorModel factor) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.factors == null) {
            this.factors = new LinkedHashSet<DelivererFactorModel>();
            if (this.getId() != null) {
                Collection factorsCollection = this.commonCaller.fetchChildren(this, DelivererEmploymentModelEnum.FACTORS.getPropertyName());
                this.factors.addAll(factorsCollection);
            }
        }
        return this.factors.contains(factor);
    }

    @Override
    public boolean isFactorsInitialized() {
        return this.factors != null;
    }

    @Override
    public DelivererModel getDeliverer() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.deliverer;
    }

    @Override
    public void setDeliverer(DelivererModel deliverer) {
        this.setDeliverer(deliverer, true);
    }

    private void setDeliverer(DelivererModel deliverer, boolean setDirty) {
        DelivererModel oldDeliverer = this.getDeliverer();
        if (oldDeliverer == deliverer) {
            return;
        }
        if (oldDeliverer != null) {
            oldDeliverer.setEmployment(null);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, DelivererEmploymentModelEnum.DELIVERER.getPropertyName());
        }
        this.deliverer = deliverer;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(DelivererEmploymentModelEnum.DELIVERER, deliverer, oldDeliverer);
        if (this.deliverer != null) {
            this.deliverer.setEmployment(this);
        }
    }

    @Override
    public void setProxy(boolean proxy) {
        super.setProxy(proxy);
        if (proxy) {
            this.factors = null;
        }
    }

    @Override
    protected void updateByDto(DelivererEmploymentFullDto delivererEmploymentDto) {
        this.employmentRadius = delivererEmploymentDto.getEmploymentRadius();
        DelivererFactorDto[] factors = delivererEmploymentDto.getFactors();
        if (factors != null) {
            if (this.factors == null) {
                this.factors = new LinkedHashSet<DelivererFactorModel>();
            } else {
                this.factors.clear();
            }
        }
        this.deliverer = (DelivererModel)this.getModelCache().getModel(delivererEmploymentDto.getDeliverer());
    }

    @Override
    protected void updateMasterRelationsByDto(DelivererEmploymentFullDto delivererEmploymentDto) {
        DelivererFactorDto[] factors = delivererEmploymentDto.getFactors();
        if (factors != null) {
            if (this.factors == null) {
                this.factors = new LinkedHashSet<DelivererFactorModel>();
            } else {
                this.factors.clear();
            }
            for (DelivererFactorDto factorDto : factors) {
                DelivererFactorModel factorModel = (DelivererFactorModel)this.getModelCache().getModel(factorDto);
                this.factors.add(factorModel);
            }
        } else {
            this.factors = null;
        }
    }

    @Override
    protected void checkStaleByDto(DelivererEmploymentFullDto delivererEmploymentDto) throws StaleStateException {
        DelivererModelImpl delivererModel;
        DelivererDto delivererDto;
        DelivererFactorDto[] factorDtos = delivererEmploymentDto.getFactors();
        if (factorDtos != null) {
            for (DelivererFactorDto factorDto : factorDtos) {
                DelivererFactorModelImpl factorModel = (DelivererFactorModelImpl)this.getModelCache().getModel(DelivererFactorModel.class, factorDto.getId());
                if (factorModel == null) continue;
                factorModel.checkStaleState(factorDto);
            }
        }
        if ((delivererDto = delivererEmploymentDto.getDeliverer()) != null && delivererDto.getId() != null && (delivererModel = (DelivererModelImpl)this.getModelCache().getModel(DelivererModel.class, delivererDto.getId())) != null) {
            delivererModel.checkStaleState(delivererDto);
        }
    }

    @Override
    public DelivererEmploymentFullDto createDto() {
        Long id = this.getId();
        DelivererEmploymentFullDto delivererEmploymentDto = id == null ? new DelivererEmploymentFullDto(this.getTempUUID()) : new DelivererEmploymentFullDto(id, this.getVersion());
        delivererEmploymentDto.setEmploymentRadius(this.getEmploymentRadius());
        DelivererModelImpl deliverer = (DelivererModelImpl)this.getDeliverer();
        if (deliverer != null) {
            delivererEmploymentDto.setDeliverer(deliverer.createProxy());
        }
        return delivererEmploymentDto;
    }

    @Override
    public DelivererEmploymentProxyDto createProxy() {
        Long id = this.getId();
        DelivererEmploymentProxyDto delivererEmploymentDto = id == null ? new DelivererEmploymentProxyDto(this.getTempUUID()) : new DelivererEmploymentProxyDto(id, this.getVersion());
        return delivererEmploymentDto;
    }

    public static enum DelivererEmploymentModelEnum {
        EMPLOYMENT_RADIUS("employmentRadius"),
        FACTORS("factors"),
        DELIVERER("deliverer");

        private String propertyName;

        private DelivererEmploymentModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

