/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.tour;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.area.AreaObjectModelImpl;
import de.datomino.peppergis.client.model.area.DeliveryRoundRelationModel;
import de.datomino.peppergis.client.model.area.DeliveryRoundRelationModelImpl;
import de.datomino.peppergis.client.model.tour.AreaDelivererModel;
import de.datomino.peppergis.client.model.tour.AreaDelivererModelImpl;
import de.datomino.peppergis.client.model.tour.AreaTourScheduleModel;
import de.datomino.peppergis.dto.area.AreaObjectDto;
import de.datomino.peppergis.dto.area.DeliveryRoundRelationDto;
import de.datomino.peppergis.dto.tour.AreaDelivererDto;
import de.datomino.peppergis.dto.tour.AreaTourScheduleFullDto;
import de.datomino.peppergis.dto.tour.AreaTourScheduleProxyDto;
import de.datomino.peppergis.exception.StaleStateException;
import java.util.Date;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;

public class AreaTourScheduleModelImpl
extends AbstractModel<AreaTourScheduleFullDto, AreaTourScheduleProxyDto>
implements AreaTourScheduleModel {
    private AreaObjectModel areaObject;
    private DeliveryRoundRelationModel deliveryRound;
    private Date plannedStartTime;
    private Date actualStartTime;
    private AreaDelivererModel deliverer;
    private Boolean mobileActive;
    private Boolean mobileAlreadySynced;

    public AreaTourScheduleModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public AreaTourScheduleModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public AreaObjectModel getAreaObject() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.areaObject;
    }

    @Override
    public void setAreaObject(AreaObjectModel areaObject) {
        this.setAreaObject(areaObject, true);
    }

    private void setAreaObject(AreaObjectModel areaObject, boolean setDirty) {
        AreaObjectModel oldAreaObject = this.getAreaObject();
        if (oldAreaObject == areaObject) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaTourScheduleModelEnum.AREA_OBJECT.getPropertyName());
        }
        this.areaObject = areaObject;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaTourScheduleModelEnum.AREA_OBJECT, areaObject, oldAreaObject);
    }

    @Override
    public DeliveryRoundRelationModel getDeliveryRound() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.deliveryRound;
    }

    @Override
    public void setDeliveryRound(DeliveryRoundRelationModel deliveryRound) {
        this.setDeliveryRound(deliveryRound, true);
    }

    private void setDeliveryRound(DeliveryRoundRelationModel deliveryRound, boolean setDirty) {
        DeliveryRoundRelationModel oldDeliveryRound = this.getDeliveryRound();
        if (oldDeliveryRound == deliveryRound) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaTourScheduleModelEnum.DELIVERY_ROUND.getPropertyName());
        }
        this.deliveryRound = deliveryRound;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaTourScheduleModelEnum.DELIVERY_ROUND, deliveryRound, oldDeliveryRound);
    }

    @Override
    public Date getPlannedStartTime() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.plannedStartTime;
    }

    @Override
    public void setPlannedStartTime(Date plannedStartTime) {
        this.setPlannedStartTime(plannedStartTime, true);
    }

    private void setPlannedStartTime(Date plannedStartTime, boolean setDirty) {
        Date oldPlannedStartTime = this.getPlannedStartTime();
        if (new EqualsBuilder().append(oldPlannedStartTime, plannedStartTime).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaTourScheduleModelEnum.PLANNED_START_TIME.getPropertyName());
        }
        this.plannedStartTime = plannedStartTime;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaTourScheduleModelEnum.PLANNED_START_TIME, plannedStartTime, oldPlannedStartTime);
    }

    @Override
    public Date getActualStartTime() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.actualStartTime;
    }

    @Override
    public void setActualStartTime(Date actualStartTime) {
        this.setActualStartTime(actualStartTime, true);
    }

    private void setActualStartTime(Date actualStartTime, boolean setDirty) {
        Date oldActualStartTime = this.getActualStartTime();
        if (new EqualsBuilder().append(oldActualStartTime, actualStartTime).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaTourScheduleModelEnum.ACTUAL_START_TIME.getPropertyName());
        }
        this.actualStartTime = actualStartTime;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaTourScheduleModelEnum.ACTUAL_START_TIME, actualStartTime, oldActualStartTime);
    }

    @Override
    public AreaDelivererModel getDeliverer() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.deliverer;
    }

    @Override
    public void setDeliverer(AreaDelivererModel deliverer) {
        this.setDeliverer(deliverer, true);
    }

    private void setDeliverer(AreaDelivererModel deliverer, boolean setDirty) {
        AreaDelivererModel oldDeliverer = this.getDeliverer();
        if (oldDeliverer == deliverer) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaTourScheduleModelEnum.DELIVERER.getPropertyName());
        }
        this.deliverer = deliverer;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaTourScheduleModelEnum.DELIVERER, deliverer, oldDeliverer);
    }

    @Override
    public Boolean getMobileActive() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.mobileActive;
    }

    @Override
    public void setMobileActive(Boolean mobileActive) {
        this.setMobileActive(mobileActive, true);
    }

    private void setMobileActive(Boolean mobileActive, boolean setDirty) {
        Boolean oldMobileActive = this.getMobileActive();
        if (new EqualsBuilder().append(oldMobileActive, mobileActive).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaTourScheduleModelEnum.MOBILE_ACTIVE.getPropertyName());
        }
        this.mobileActive = mobileActive;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaTourScheduleModelEnum.MOBILE_ACTIVE, mobileActive, oldMobileActive);
    }

    @Override
    public Boolean getMobileAlreadySynced() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.mobileAlreadySynced;
    }

    @Override
    public void setMobileAlreadySynced(Boolean mobileAlreadySynced) {
        this.setMobileAlreadySynced(mobileAlreadySynced, true);
    }

    private void setMobileAlreadySynced(Boolean mobileAlreadySynced, boolean setDirty) {
        Boolean oldMobileAlreadySynced = this.getMobileAlreadySynced();
        if (new EqualsBuilder().append(oldMobileAlreadySynced, mobileAlreadySynced).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaTourScheduleModelEnum.MOBILE_ALREADY_SYNCED.getPropertyName());
        }
        this.mobileAlreadySynced = mobileAlreadySynced;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaTourScheduleModelEnum.MOBILE_ALREADY_SYNCED, mobileAlreadySynced, oldMobileAlreadySynced);
    }

    @Override
    protected void updateByDto(AreaTourScheduleFullDto areaTourScheduleDto) {
        this.areaObject = (AreaObjectModel)this.getModelCache().getModel(areaTourScheduleDto.getAreaObject());
        this.deliveryRound = (DeliveryRoundRelationModel)this.getModelCache().getModel(areaTourScheduleDto.getDeliveryRound());
        this.plannedStartTime = areaTourScheduleDto.getPlannedStartTime();
        this.actualStartTime = areaTourScheduleDto.getActualStartTime();
        this.deliverer = (AreaDelivererModel)this.getModelCache().getModel(areaTourScheduleDto.getDeliverer());
        this.mobileActive = areaTourScheduleDto.getMobileActive();
        this.mobileAlreadySynced = areaTourScheduleDto.getMobileAlreadySynced();
    }

    @Override
    protected void updateMasterRelationsByDto(AreaTourScheduleFullDto areaTourScheduleDto) {
    }

    @Override
    protected void checkStaleByDto(AreaTourScheduleFullDto areaTourScheduleDto) throws StaleStateException {
        AreaDelivererModelImpl delivererModel;
        AreaDelivererDto delivererDto;
        DeliveryRoundRelationModelImpl deliveryRoundModel;
        DeliveryRoundRelationDto deliveryRoundDto;
        AreaObjectModelImpl areaObjectModel;
        AreaObjectDto areaObjectDto = areaTourScheduleDto.getAreaObject();
        if (areaObjectDto != null && areaObjectDto.getId() != null && (areaObjectModel = (AreaObjectModelImpl)this.getModelCache().getModel(AreaObjectModel.class, areaObjectDto.getId())) != null) {
            areaObjectModel.checkStaleState(areaObjectDto);
        }
        if ((deliveryRoundDto = areaTourScheduleDto.getDeliveryRound()) != null && deliveryRoundDto.getId() != null && (deliveryRoundModel = (DeliveryRoundRelationModelImpl)this.getModelCache().getModel(DeliveryRoundRelationModel.class, deliveryRoundDto.getId())) != null) {
            deliveryRoundModel.checkStaleState(deliveryRoundDto);
        }
        if ((delivererDto = areaTourScheduleDto.getDeliverer()) != null && delivererDto.getId() != null && (delivererModel = (AreaDelivererModelImpl)this.getModelCache().getModel(AreaDelivererModel.class, delivererDto.getId())) != null) {
            delivererModel.checkStaleState(delivererDto);
        }
    }

    @Override
    public AreaTourScheduleFullDto createDto() {
        DeliveryRoundRelationModelImpl deliveryRound;
        Long id = this.getId();
        AreaTourScheduleFullDto areaTourScheduleDto = id == null ? new AreaTourScheduleFullDto(this.getTempUUID()) : new AreaTourScheduleFullDto(id, this.getVersion());
        AreaObjectModelImpl areaObject = (AreaObjectModelImpl)this.getAreaObject();
        if (areaObject != null) {
            areaTourScheduleDto.setAreaObject(areaObject.createProxy());
        }
        if ((deliveryRound = (DeliveryRoundRelationModelImpl)this.getDeliveryRound()) != null) {
            areaTourScheduleDto.setDeliveryRound(deliveryRound.createProxy());
        }
        areaTourScheduleDto.setPlannedStartTime(this.getPlannedStartTime());
        areaTourScheduleDto.setActualStartTime(this.getActualStartTime());
        AreaDelivererModelImpl deliverer = (AreaDelivererModelImpl)this.getDeliverer();
        if (deliverer != null) {
            areaTourScheduleDto.setDeliverer(deliverer.createProxy());
        }
        areaTourScheduleDto.setMobileActive(this.getMobileActive());
        areaTourScheduleDto.setMobileAlreadySynced(this.getMobileAlreadySynced());
        return areaTourScheduleDto;
    }

    @Override
    public AreaTourScheduleProxyDto createProxy() {
        Long id = this.getId();
        AreaTourScheduleProxyDto areaTourScheduleDto = id == null ? new AreaTourScheduleProxyDto(this.getTempUUID()) : new AreaTourScheduleProxyDto(id, this.getVersion());
        return areaTourScheduleDto;
    }

    public static enum AreaTourScheduleModelEnum {
        AREA_OBJECT("areaObject"),
        DELIVERY_ROUND("deliveryRound"),
        PLANNED_START_TIME("plannedStartTime"),
        ACTUAL_START_TIME("actualStartTime"),
        DELIVERER("deliverer"),
        MOBILE_ACTIVE("mobileActive"),
        MOBILE_ALREADY_SYNCED("mobileAlreadySynced");

        private String propertyName;

        private AreaTourScheduleModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

