/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.tour;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.area.AreaObjectModelImpl;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.client.model.base.PoiModelImpl;
import de.datomino.peppergis.client.model.tour.AreaTourModel;
import de.datomino.peppergis.client.model.tour.AreaTourPartModel;
import de.datomino.peppergis.client.model.tour.AreaTourPartModelImpl;
import de.datomino.peppergis.dto.area.AreaObjectDto;
import de.datomino.peppergis.dto.base.PoiDto;
import de.datomino.peppergis.dto.tour.AreaTourFullDto;
import de.datomino.peppergis.dto.tour.AreaTourPartDto;
import de.datomino.peppergis.dto.tour.AreaTourProxyDto;
import de.datomino.peppergis.exception.StaleStateException;
import de.datomino.peppergis.type.areatourtype.AreaTourType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;
import org.ktde.util.conversions.ImmutableIterator;
import org.ktde.util.conversions.IteratorIterable;

public class AreaTourModelImpl
extends AbstractModel<AreaTourFullDto, AreaTourProxyDto>
implements AreaTourModel {
    private String name;
    private String information;
    private AreaObjectModel areaObject;
    private AreaTourType areaTourType;
    private PoiModel poi;
    private List<AreaTourPartModel> areaTourParts = null;
    private Integer distanceSum;
    private Integer accessSum;
    private Integer durationSum;

    public AreaTourModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public AreaTourModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public String getName() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.setName(name, true);
    }

    private void setName(String name, boolean setDirty) {
        String oldName = this.getName();
        if (new EqualsBuilder().append(oldName, name).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaTourModelEnum.NAME.getPropertyName());
        }
        this.name = name;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaTourModelEnum.NAME, name, oldName);
    }

    @Override
    public String getInformation() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.information;
    }

    @Override
    public void setInformation(String information) {
        this.setInformation(information, true);
    }

    private void setInformation(String information, boolean setDirty) {
        String oldInformation = this.getInformation();
        if (new EqualsBuilder().append(oldInformation, information).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaTourModelEnum.INFORMATION.getPropertyName());
        }
        this.information = information;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaTourModelEnum.INFORMATION, information, oldInformation);
    }

    @Override
    public AreaObjectModel getAreaObject() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.areaObject;
    }

    @Override
    public void setAreaObject(AreaObjectModel areaObject) {
        this.setAreaObject(areaObject, true);
    }

    private void setAreaObject(AreaObjectModel areaObject, boolean setDirty) {
        AreaObjectModel oldAreaObject = this.getAreaObject();
        if (oldAreaObject == areaObject) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaTourModelEnum.AREA_OBJECT.getPropertyName());
        }
        this.areaObject = areaObject;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaTourModelEnum.AREA_OBJECT, areaObject, oldAreaObject);
    }

    @Override
    public AreaTourType getAreaTourType() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.areaTourType;
    }

    @Override
    public void setAreaTourType(AreaTourType areaTourType) {
        this.setAreaTourType(areaTourType, true);
    }

    private void setAreaTourType(AreaTourType areaTourType, boolean setDirty) {
        AreaTourType oldAreaTourType = this.getAreaTourType();
        if (new EqualsBuilder().append(oldAreaTourType, areaTourType).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaTourModelEnum.AREA_TOUR_TYPE.getPropertyName());
        }
        this.areaTourType = areaTourType;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaTourModelEnum.AREA_TOUR_TYPE, areaTourType, oldAreaTourType);
    }

    @Override
    public PoiModel getPoi() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.poi;
    }

    @Override
    public void setPoi(PoiModel poi) {
        this.setPoi(poi, true);
    }

    private void setPoi(PoiModel poi, boolean setDirty) {
        PoiModel oldPoi = this.getPoi();
        if (oldPoi == poi) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaTourModelEnum.POI.getPropertyName());
        }
        this.poi = poi;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaTourModelEnum.POI, poi, oldPoi);
    }

    @Override
    public int countAreaTourParts() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaTourParts == null) {
            this.areaTourParts = new ArrayList<AreaTourPartModel>();
            if (this.getId() != null) {
                Collection areaTourPartsCollection = this.commonCaller.fetchChildren(this, AreaTourModelEnum.AREA_TOUR_PARTS.getPropertyName());
                this.areaTourParts.addAll(areaTourPartsCollection);
            }
        }
        return this.areaTourParts.size();
    }

    @Override
    public Iterator<AreaTourPartModel> iterateAreaTourParts() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaTourParts == null) {
            this.areaTourParts = new ArrayList<AreaTourPartModel>();
            if (this.getId() != null) {
                Collection areaTourPartsCollection = this.commonCaller.fetchChildren(this, AreaTourModelEnum.AREA_TOUR_PARTS.getPropertyName());
                this.areaTourParts.addAll(areaTourPartsCollection);
            }
        }
        return new ImmutableIterator<AreaTourPartModel>(this.areaTourParts);
    }

    @Override
    public Iterable<AreaTourPartModel> iterableAreaTourParts() {
        return new IteratorIterable<AreaTourPartModel>(this.iterateAreaTourParts());
    }

    @Override
    public void addAreaTourPart(AreaTourPartModel areaTourPart) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaTourParts == null) {
            this.areaTourParts = new ArrayList<AreaTourPartModel>();
            if (this.getId() != null) {
                Collection areaTourPartsCollection = this.commonCaller.fetchChildren(this, AreaTourModelEnum.AREA_TOUR_PARTS.getPropertyName());
                this.areaTourParts.addAll(areaTourPartsCollection);
            }
        }
        if (this.areaTourParts.contains(areaTourPart)) {
            return;
        }
        this.areaTourParts.add(areaTourPart);
        this.fireValueChanged(AreaTourModelEnum.AREA_TOUR_PARTS, areaTourPart, null);
        if (areaTourPart != null) {
            areaTourPart.setAreaTour(this);
            areaTourPart.setSortOrder(this.areaTourParts.size() - 1);
        }
    }

    @Override
    public void removeAreaTourPart(AreaTourPartModel areaTourPart) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaTourParts == null) {
            this.areaTourParts = new ArrayList<AreaTourPartModel>();
            if (this.getId() != null) {
                Collection areaTourPartsCollection = this.commonCaller.fetchChildren(this, AreaTourModelEnum.AREA_TOUR_PARTS.getPropertyName());
                this.areaTourParts.addAll(areaTourPartsCollection);
            }
        }
        if (!this.areaTourParts.contains(areaTourPart)) {
            return;
        }
        this.areaTourParts.remove(areaTourPart);
        this.fireValueChanged(AreaTourModelEnum.AREA_TOUR_PARTS, areaTourPart, null);
        if (areaTourPart != null) {
            areaTourPart.setAreaTour(null);
            areaTourPart.setSortOrder(null);
        }
        this.reorderAreaTourParts(0);
    }

    @Override
    public AreaTourPartModel getAreaTourPartAt(int index) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaTourParts == null) {
            this.areaTourParts = new ArrayList<AreaTourPartModel>();
            if (this.getId() != null) {
                Collection areaTourPartsCollection = this.commonCaller.fetchChildren(this, AreaTourModelEnum.AREA_TOUR_PARTS.getPropertyName());
                this.areaTourParts.addAll(areaTourPartsCollection);
            }
        }
        return this.areaTourParts.get(index);
    }

    @Override
    public void insertAreaTourPart(AreaTourPartModel areaTourPart, int index) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaTourParts == null) {
            this.areaTourParts = new ArrayList<AreaTourPartModel>();
            if (this.getId() != null) {
                Collection areaTourPartsCollection = this.commonCaller.fetchChildren(this, AreaTourModelEnum.AREA_TOUR_PARTS.getPropertyName());
                this.areaTourParts.addAll(areaTourPartsCollection);
            }
        }
        if (this.areaTourParts.contains(areaTourPart)) {
            this.removeAreaTourPart(areaTourPart);
        }
        this.areaTourParts.add(index, areaTourPart);
        this.fireValueChanged(AreaTourModelEnum.AREA_TOUR_PARTS, areaTourPart, null);
        if (areaTourPart != null) {
            areaTourPart.setAreaTour(this);
        }
        this.reorderAreaTourParts(index);
    }

    @Override
    public void removeAreaTourPartAt(int index) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaTourParts == null) {
            this.areaTourParts = new ArrayList<AreaTourPartModel>();
            if (this.getId() != null) {
                Collection areaTourPartsCollection = this.commonCaller.fetchChildren(this, AreaTourModelEnum.AREA_TOUR_PARTS.getPropertyName());
                this.areaTourParts.addAll(areaTourPartsCollection);
            }
        }
        AreaTourPartModel oldAreaTourPart = this.areaTourParts.get(index);
        this.areaTourParts.remove(index);
        this.fireValueChanged(AreaTourModelEnum.AREA_TOUR_PARTS, oldAreaTourPart, null);
        if (oldAreaTourPart != null) {
            oldAreaTourPart.setAreaTour(null);
            oldAreaTourPart.setSortOrder(null);
        }
        this.reorderAreaTourParts(index);
    }

    @Override
    public void setAreaTourPartAt(AreaTourPartModel areaTourPart, int index) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaTourParts == null) {
            this.areaTourParts = new ArrayList<AreaTourPartModel>();
            if (this.getId() != null) {
                Collection areaTourPartsCollection = this.commonCaller.fetchChildren(this, AreaTourModelEnum.AREA_TOUR_PARTS.getPropertyName());
                this.areaTourParts.addAll(areaTourPartsCollection);
            }
        }
        AreaTourPartModel oldAreaTourPart = this.areaTourParts.get(index);
        this.areaTourParts.set(index, areaTourPart);
        this.fireValueChanged(AreaTourModelEnum.AREA_TOUR_PARTS, areaTourPart, oldAreaTourPart);
        if (oldAreaTourPart != null) {
            oldAreaTourPart.setAreaTour(null);
            oldAreaTourPart.setSortOrder(null);
        }
        if (areaTourPart != null) {
            areaTourPart.setAreaTour(this);
            areaTourPart.setSortOrder(index);
        }
    }

    @Override
    public void clearAreaTourParts() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaTourParts == null) {
            this.areaTourParts = new ArrayList<AreaTourPartModel>();
            if (this.getId() != null) {
                Collection areaTourPartsCollection = this.commonCaller.fetchChildren(this, AreaTourModelEnum.AREA_TOUR_PARTS.getPropertyName());
                this.areaTourParts.addAll(areaTourPartsCollection);
            }
        }
        ArrayList<AreaTourPartModel> oldAreaTourParts = new ArrayList<AreaTourPartModel>(this.areaTourParts);
        this.areaTourParts.clear();
        this.fireValueChanged(AreaTourModelEnum.AREA_TOUR_PARTS, null, null);
        for (AreaTourPartModel oldAreaTourPart : oldAreaTourParts) {
            if (oldAreaTourPart == null) continue;
            oldAreaTourPart.setAreaTour(null);
            oldAreaTourPart.setSortOrder(null);
        }
    }

    @Override
    public boolean isAreaTourPartsEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaTourParts == null) {
            this.areaTourParts = new ArrayList<AreaTourPartModel>();
            if (this.getId() != null) {
                Collection areaTourPartsCollection = this.commonCaller.fetchChildren(this, AreaTourModelEnum.AREA_TOUR_PARTS.getPropertyName());
                this.areaTourParts.addAll(areaTourPartsCollection);
            }
        }
        return this.areaTourParts.isEmpty();
    }

    @Override
    public boolean containsAreaTourPart(AreaTourPartModel areaTourPart) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaTourParts == null) {
            this.areaTourParts = new ArrayList<AreaTourPartModel>();
            if (this.getId() != null) {
                Collection areaTourPartsCollection = this.commonCaller.fetchChildren(this, AreaTourModelEnum.AREA_TOUR_PARTS.getPropertyName());
                this.areaTourParts.addAll(areaTourPartsCollection);
            }
        }
        return this.areaTourParts.contains(areaTourPart);
    }

    @Override
    public int indexOfAreaTourPart(AreaTourPartModel areaTourPart) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaTourParts == null) {
            this.areaTourParts = new ArrayList<AreaTourPartModel>();
            if (this.getId() != null) {
                Collection areaTourPartsCollection = this.commonCaller.fetchChildren(this, AreaTourModelEnum.AREA_TOUR_PARTS.getPropertyName());
                this.areaTourParts.addAll(areaTourPartsCollection);
            }
        }
        return this.areaTourParts.indexOf(areaTourPart);
    }

    @Override
    public boolean isAreaTourPartsInitialized() {
        return this.areaTourParts != null;
    }

    private void reorderAreaTourParts(int startIndex) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaTourParts == null) {
            this.areaTourParts = new ArrayList<AreaTourPartModel>();
            if (this.getId() != null) {
                Collection areaTourPartsCollection = this.commonCaller.fetchChildren(this, AreaTourModelEnum.AREA_TOUR_PARTS.getPropertyName());
                this.areaTourParts.addAll(areaTourPartsCollection);
            }
        }
        ListIterator<AreaTourPartModel> listIterator = this.areaTourParts.listIterator(startIndex);
        int index = startIndex;
        while (listIterator.hasNext()) {
            AreaTourPartModel areaTourPart = listIterator.next();
            areaTourPart.setSortOrder(index++);
        }
    }

    @Override
    public Integer getDistanceSum() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.distanceSum;
    }

    @Override
    public void setDistanceSum(Integer distanceSum) {
        this.setDistanceSum(distanceSum, true);
    }

    private void setDistanceSum(Integer distanceSum, boolean setDirty) {
        Integer oldDistanceSum = this.getDistanceSum();
        if (new EqualsBuilder().append(oldDistanceSum, distanceSum).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaTourModelEnum.DISTANCE_SUM.getPropertyName());
        }
        this.distanceSum = distanceSum;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaTourModelEnum.DISTANCE_SUM, distanceSum, oldDistanceSum);
    }

    @Override
    public Integer getAccessSum() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.accessSum;
    }

    @Override
    public void setAccessSum(Integer accessSum) {
        this.setAccessSum(accessSum, true);
    }

    private void setAccessSum(Integer accessSum, boolean setDirty) {
        Integer oldAccessSum = this.getAccessSum();
        if (new EqualsBuilder().append(oldAccessSum, accessSum).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaTourModelEnum.ACCESS_SUM.getPropertyName());
        }
        this.accessSum = accessSum;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaTourModelEnum.ACCESS_SUM, accessSum, oldAccessSum);
    }

    @Override
    public Integer getDurationSum() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.durationSum;
    }

    @Override
    public void setDurationSum(Integer durationSum) {
        this.setDurationSum(durationSum, true);
    }

    private void setDurationSum(Integer durationSum, boolean setDirty) {
        Integer oldDurationSum = this.getDurationSum();
        if (new EqualsBuilder().append(oldDurationSum, durationSum).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaTourModelEnum.DURATION_SUM.getPropertyName());
        }
        this.durationSum = durationSum;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaTourModelEnum.DURATION_SUM, durationSum, oldDurationSum);
    }

    @Override
    public void setProxy(boolean proxy) {
        super.setProxy(proxy);
        if (proxy) {
            this.areaTourParts = null;
        }
    }

    @Override
    protected void updateByDto(AreaTourFullDto areaTourDto) {
        this.name = areaTourDto.getName();
        this.information = areaTourDto.getInformation();
        this.areaObject = (AreaObjectModel)this.getModelCache().getModel(areaTourDto.getAreaObject());
        AreaTourType areaTourType = areaTourDto.getAreaTourType();
        this.areaTourType = areaTourType == null ? null : areaTourType.getAreaTourType();
        this.poi = (PoiModel)this.getModelCache().getModel(areaTourDto.getPoi());
        AreaTourPartDto[] areaTourParts = areaTourDto.getAreaTourParts();
        if (areaTourParts != null) {
            if (this.areaTourParts == null) {
                this.areaTourParts = new ArrayList<AreaTourPartModel>();
            } else {
                this.areaTourParts.clear();
            }
        }
        this.distanceSum = areaTourDto.getDistanceSum();
        this.accessSum = areaTourDto.getAccessSum();
        this.durationSum = areaTourDto.getDurationSum();
    }

    @Override
    protected void updateMasterRelationsByDto(AreaTourFullDto areaTourDto) {
        AreaTourPartDto[] areaTourParts = areaTourDto.getAreaTourParts();
        if (areaTourParts != null) {
            if (this.areaTourParts == null) {
                this.areaTourParts = new ArrayList<AreaTourPartModel>();
            } else {
                this.areaTourParts.clear();
            }
            for (AreaTourPartDto areaTourPartDto : areaTourParts) {
                AreaTourPartModel areaTourPartModel = (AreaTourPartModel)this.getModelCache().getModel(areaTourPartDto);
                this.areaTourParts.add(areaTourPartModel);
            }
        } else {
            this.areaTourParts = null;
        }
    }

    @Override
    protected void checkStaleByDto(AreaTourFullDto areaTourDto) throws StaleStateException {
        AreaTourPartDto[] areaTourPartDtos;
        PoiModelImpl poiModel;
        PoiDto poiDto;
        AreaObjectModelImpl areaObjectModel;
        AreaObjectDto areaObjectDto = areaTourDto.getAreaObject();
        if (areaObjectDto != null && areaObjectDto.getId() != null && (areaObjectModel = (AreaObjectModelImpl)this.getModelCache().getModel(AreaObjectModel.class, areaObjectDto.getId())) != null) {
            areaObjectModel.checkStaleState(areaObjectDto);
        }
        if ((poiDto = areaTourDto.getPoi()) != null && poiDto.getId() != null && (poiModel = (PoiModelImpl)this.getModelCache().getModel(PoiModel.class, poiDto.getId())) != null) {
            poiModel.checkStaleState(poiDto);
        }
        if ((areaTourPartDtos = areaTourDto.getAreaTourParts()) != null) {
            for (AreaTourPartDto areaTourPartDto : areaTourPartDtos) {
                AreaTourPartModelImpl areaTourPartModel = (AreaTourPartModelImpl)this.getModelCache().getModel(AreaTourPartModel.class, areaTourPartDto.getId());
                if (areaTourPartModel == null) continue;
                areaTourPartModel.checkStaleState(areaTourPartDto);
            }
        }
    }

    @Override
    public AreaTourFullDto createDto() {
        Long id = this.getId();
        AreaTourFullDto areaTourDto = id == null ? new AreaTourFullDto(this.getTempUUID()) : new AreaTourFullDto(id, this.getVersion());
        areaTourDto.setName(this.getName());
        areaTourDto.setInformation(this.getInformation());
        AreaObjectModelImpl areaObject = (AreaObjectModelImpl)this.getAreaObject();
        if (areaObject != null) {
            areaTourDto.setAreaObject(areaObject.createProxy());
        }
        areaTourDto.setAreaTourType(this.getAreaTourType());
        PoiModelImpl poi = (PoiModelImpl)this.getPoi();
        if (poi != null) {
            areaTourDto.setPoi(poi.createProxy());
        }
        areaTourDto.setDistanceSum(this.getDistanceSum());
        areaTourDto.setAccessSum(this.getAccessSum());
        areaTourDto.setDurationSum(this.getDurationSum());
        return areaTourDto;
    }

    @Override
    public AreaTourProxyDto createProxy() {
        Long id = this.getId();
        AreaTourProxyDto areaTourDto = id == null ? new AreaTourProxyDto(this.getTempUUID()) : new AreaTourProxyDto(id, this.getVersion());
        return areaTourDto;
    }

    public static enum AreaTourModelEnum {
        NAME("name"),
        INFORMATION("information"),
        AREA_OBJECT("areaObject"),
        AREA_TOUR_TYPE("areaTourType"),
        POI("poi"),
        AREA_TOUR_PARTS("areaTourParts"),
        DISTANCE_SUM("distanceSum"),
        ACCESS_SUM("accessSum"),
        DURATION_SUM("durationSum");

        private String propertyName;

        private AreaTourModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

