/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.tour;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.tour.AreaDelivererModel;
import de.datomino.peppergis.client.model.tour.AreaDelivererModelImpl;
import de.datomino.peppergis.client.model.tour.AreaDelivererVehicleModel;
import de.datomino.peppergis.dto.tour.AreaDelivererDto;
import de.datomino.peppergis.dto.tour.AreaDelivererVehicleFullDto;
import de.datomino.peppergis.dto.tour.AreaDelivererVehicleProxyDto;
import de.datomino.peppergis.exception.StaleStateException;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;

public class AreaDelivererVehicleModelImpl
extends AbstractModel<AreaDelivererVehicleFullDto, AreaDelivererVehicleProxyDto>
implements AreaDelivererVehicleModel {
    private String name;
    private String licensePlate;
    private Integer mileageKilometers;
    private AreaDelivererModel deliverer;

    public AreaDelivererVehicleModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public AreaDelivererVehicleModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public String getName() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.setName(name, true);
    }

    private void setName(String name, boolean setDirty) {
        String oldName = this.getName();
        if (new EqualsBuilder().append(oldName, name).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaDelivererVehicleModelEnum.NAME.getPropertyName());
        }
        this.name = name;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaDelivererVehicleModelEnum.NAME, name, oldName);
    }

    @Override
    public String getLicensePlate() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.licensePlate;
    }

    @Override
    public void setLicensePlate(String licensePlate) {
        this.setLicensePlate(licensePlate, true);
    }

    private void setLicensePlate(String licensePlate, boolean setDirty) {
        String oldLicensePlate = this.getLicensePlate();
        if (new EqualsBuilder().append(oldLicensePlate, licensePlate).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaDelivererVehicleModelEnum.LICENSE_PLATE.getPropertyName());
        }
        this.licensePlate = licensePlate;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaDelivererVehicleModelEnum.LICENSE_PLATE, licensePlate, oldLicensePlate);
    }

    @Override
    public Integer getMileageKilometers() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.mileageKilometers;
    }

    @Override
    public void setMileageKilometers(Integer mileageKilometers) {
        this.setMileageKilometers(mileageKilometers, true);
    }

    private void setMileageKilometers(Integer mileageKilometers, boolean setDirty) {
        Integer oldMileageKilometers = this.getMileageKilometers();
        if (new EqualsBuilder().append(oldMileageKilometers, mileageKilometers).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaDelivererVehicleModelEnum.MILEAGE_KILOMETERS.getPropertyName());
        }
        this.mileageKilometers = mileageKilometers;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaDelivererVehicleModelEnum.MILEAGE_KILOMETERS, mileageKilometers, oldMileageKilometers);
    }

    @Override
    public AreaDelivererModel getDeliverer() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.deliverer;
    }

    @Override
    public void setDeliverer(AreaDelivererModel deliverer) {
        this.setDeliverer(deliverer, true);
    }

    private void setDeliverer(AreaDelivererModel deliverer, boolean setDirty) {
        AreaDelivererModel oldDeliverer = this.getDeliverer();
        if (oldDeliverer == deliverer) {
            return;
        }
        if (oldDeliverer != null) {
            oldDeliverer.setVehicle(null);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaDelivererVehicleModelEnum.DELIVERER.getPropertyName());
        }
        this.deliverer = deliverer;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaDelivererVehicleModelEnum.DELIVERER, deliverer, oldDeliverer);
        if (this.deliverer != null) {
            this.deliverer.setVehicle(this);
        }
    }

    @Override
    protected void updateByDto(AreaDelivererVehicleFullDto areaDelivererVehicleDto) {
        this.name = areaDelivererVehicleDto.getName();
        this.licensePlate = areaDelivererVehicleDto.getLicensePlate();
        this.mileageKilometers = areaDelivererVehicleDto.getMileageKilometers();
        this.deliverer = (AreaDelivererModel)this.getModelCache().getModel(areaDelivererVehicleDto.getDeliverer());
    }

    @Override
    protected void updateMasterRelationsByDto(AreaDelivererVehicleFullDto areaDelivererVehicleDto) {
    }

    @Override
    protected void checkStaleByDto(AreaDelivererVehicleFullDto areaDelivererVehicleDto) throws StaleStateException {
        AreaDelivererModelImpl delivererModel;
        AreaDelivererDto delivererDto = areaDelivererVehicleDto.getDeliverer();
        if (delivererDto != null && delivererDto.getId() != null && (delivererModel = (AreaDelivererModelImpl)this.getModelCache().getModel(AreaDelivererModel.class, delivererDto.getId())) != null) {
            delivererModel.checkStaleState(delivererDto);
        }
    }

    @Override
    public AreaDelivererVehicleFullDto createDto() {
        Long id = this.getId();
        AreaDelivererVehicleFullDto areaDelivererVehicleDto = id == null ? new AreaDelivererVehicleFullDto(this.getTempUUID()) : new AreaDelivererVehicleFullDto(id, this.getVersion());
        areaDelivererVehicleDto.setName(this.getName());
        areaDelivererVehicleDto.setLicensePlate(this.getLicensePlate());
        areaDelivererVehicleDto.setMileageKilometers(this.getMileageKilometers());
        AreaDelivererModelImpl deliverer = (AreaDelivererModelImpl)this.getDeliverer();
        if (deliverer != null) {
            areaDelivererVehicleDto.setDeliverer(deliverer.createProxy());
        }
        return areaDelivererVehicleDto;
    }

    @Override
    public AreaDelivererVehicleProxyDto createProxy() {
        Long id = this.getId();
        AreaDelivererVehicleProxyDto areaDelivererVehicleDto = id == null ? new AreaDelivererVehicleProxyDto(this.getTempUUID()) : new AreaDelivererVehicleProxyDto(id, this.getVersion());
        return areaDelivererVehicleDto;
    }

    public static enum AreaDelivererVehicleModelEnum {
        NAME("name"),
        LICENSE_PLATE("licensePlate"),
        MILEAGE_KILOMETERS("mileageKilometers"),
        DELIVERER("deliverer");

        private String propertyName;

        private AreaDelivererVehicleModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

