/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.tour;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.tour.AreaDelivererEmploymentModel;
import de.datomino.peppergis.client.model.tour.AreaDelivererFactorModel;
import de.datomino.peppergis.client.model.tour.AreaDelivererFactorModelImpl;
import de.datomino.peppergis.client.model.tour.AreaDelivererModel;
import de.datomino.peppergis.client.model.tour.AreaDelivererModelImpl;
import de.datomino.peppergis.client.model.tour.AreaDelivererRadiusAreaModel;
import de.datomino.peppergis.client.model.tour.AreaDelivererRadiusAreaModelImpl;
import de.datomino.peppergis.client.model.tour.AreaDelivererRegularAreaModel;
import de.datomino.peppergis.client.model.tour.AreaDelivererRegularAreaModelImpl;
import de.datomino.peppergis.dto.tour.AreaDelivererDto;
import de.datomino.peppergis.dto.tour.AreaDelivererEmploymentFullDto;
import de.datomino.peppergis.dto.tour.AreaDelivererEmploymentProxyDto;
import de.datomino.peppergis.dto.tour.AreaDelivererFactorDto;
import de.datomino.peppergis.dto.tour.AreaDelivererRadiusAreaDto;
import de.datomino.peppergis.dto.tour.AreaDelivererRegularAreaDto;
import de.datomino.peppergis.exception.StaleStateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;
import org.ktde.util.conversions.ImmutableIterator;
import org.ktde.util.conversions.IteratorIterable;

public class AreaDelivererEmploymentModelImpl
extends AbstractModel<AreaDelivererEmploymentFullDto, AreaDelivererEmploymentProxyDto>
implements AreaDelivererEmploymentModel {
    private Integer employmentRadius;
    private Set<AreaDelivererFactorModel> factors = null;
    private Set<AreaDelivererRadiusAreaModel> radiusAreas = null;
    private Set<AreaDelivererRegularAreaModel> regularAreas = null;
    private AreaDelivererModel deliverer;

    public AreaDelivererEmploymentModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public AreaDelivererEmploymentModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public Integer getEmploymentRadius() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.employmentRadius;
    }

    @Override
    public void setEmploymentRadius(Integer employmentRadius) {
        this.setEmploymentRadius(employmentRadius, true);
    }

    private void setEmploymentRadius(Integer employmentRadius, boolean setDirty) {
        Integer oldEmploymentRadius = this.getEmploymentRadius();
        if (new EqualsBuilder().append(oldEmploymentRadius, employmentRadius).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaDelivererEmploymentModelEnum.EMPLOYMENT_RADIUS.getPropertyName());
        }
        this.employmentRadius = employmentRadius;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaDelivererEmploymentModelEnum.EMPLOYMENT_RADIUS, employmentRadius, oldEmploymentRadius);
    }

    @Override
    public int countFactors() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.factors == null) {
            this.factors = new LinkedHashSet<AreaDelivererFactorModel>();
            if (this.getId() != null) {
                Collection factorsCollection = this.commonCaller.fetchChildren(this, AreaDelivererEmploymentModelEnum.FACTORS.getPropertyName());
                this.factors.addAll(factorsCollection);
            }
        }
        return this.factors.size();
    }

    @Override
    public Iterator<AreaDelivererFactorModel> iterateFactors() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.factors == null) {
            this.factors = new LinkedHashSet<AreaDelivererFactorModel>();
            if (this.getId() != null) {
                Collection factorsCollection = this.commonCaller.fetchChildren(this, AreaDelivererEmploymentModelEnum.FACTORS.getPropertyName());
                this.factors.addAll(factorsCollection);
            }
        }
        return new ImmutableIterator<AreaDelivererFactorModel>(this.factors);
    }

    @Override
    public Iterable<AreaDelivererFactorModel> iterableFactors() {
        return new IteratorIterable<AreaDelivererFactorModel>(this.iterateFactors());
    }

    @Override
    public void addFactor(AreaDelivererFactorModel factor) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.factors == null) {
            this.factors = new LinkedHashSet<AreaDelivererFactorModel>();
            if (this.getId() != null) {
                Collection factorsCollection = this.commonCaller.fetchChildren(this, AreaDelivererEmploymentModelEnum.FACTORS.getPropertyName());
                this.factors.addAll(factorsCollection);
            }
        }
        if (this.factors.contains(factor)) {
            return;
        }
        this.factors.add(factor);
        this.fireValueChanged(AreaDelivererEmploymentModelEnum.FACTORS, factor, null);
        if (factor != null) {
            factor.setDelivererEmployment(this);
        }
    }

    @Override
    public void removeFactor(AreaDelivererFactorModel factor) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.factors == null) {
            this.factors = new LinkedHashSet<AreaDelivererFactorModel>();
            if (this.getId() != null) {
                Collection factorsCollection = this.commonCaller.fetchChildren(this, AreaDelivererEmploymentModelEnum.FACTORS.getPropertyName());
                this.factors.addAll(factorsCollection);
            }
        }
        if (!this.factors.contains(factor)) {
            return;
        }
        this.factors.remove(factor);
        this.fireValueChanged(AreaDelivererEmploymentModelEnum.FACTORS, factor, null);
        if (factor != null) {
            factor.setDelivererEmployment(null);
        }
    }

    @Override
    public void clearFactors() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.factors == null) {
            this.factors = new LinkedHashSet<AreaDelivererFactorModel>();
            if (this.getId() != null) {
                Collection factorsCollection = this.commonCaller.fetchChildren(this, AreaDelivererEmploymentModelEnum.FACTORS.getPropertyName());
                this.factors.addAll(factorsCollection);
            }
        }
        ArrayList<AreaDelivererFactorModel> oldFactors = new ArrayList<AreaDelivererFactorModel>(this.factors);
        this.factors.clear();
        this.fireValueChanged(AreaDelivererEmploymentModelEnum.FACTORS, null, null);
        for (AreaDelivererFactorModel oldFactor : oldFactors) {
            if (oldFactor == null) continue;
            oldFactor.setDelivererEmployment(null);
        }
    }

    @Override
    public boolean isFactorsEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.factors == null) {
            this.factors = new LinkedHashSet<AreaDelivererFactorModel>();
            if (this.getId() != null) {
                Collection factorsCollection = this.commonCaller.fetchChildren(this, AreaDelivererEmploymentModelEnum.FACTORS.getPropertyName());
                this.factors.addAll(factorsCollection);
            }
        }
        return this.factors.isEmpty();
    }

    @Override
    public boolean containsFactor(AreaDelivererFactorModel factor) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.factors == null) {
            this.factors = new LinkedHashSet<AreaDelivererFactorModel>();
            if (this.getId() != null) {
                Collection factorsCollection = this.commonCaller.fetchChildren(this, AreaDelivererEmploymentModelEnum.FACTORS.getPropertyName());
                this.factors.addAll(factorsCollection);
            }
        }
        return this.factors.contains(factor);
    }

    @Override
    public boolean isFactorsInitialized() {
        return this.factors != null;
    }

    @Override
    public int countRadiusAreas() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.radiusAreas == null) {
            this.radiusAreas = new LinkedHashSet<AreaDelivererRadiusAreaModel>();
            if (this.getId() != null) {
                Collection radiusAreasCollection = this.commonCaller.fetchChildren(this, AreaDelivererEmploymentModelEnum.RADIUS_AREAS.getPropertyName());
                this.radiusAreas.addAll(radiusAreasCollection);
            }
        }
        return this.radiusAreas.size();
    }

    @Override
    public Iterator<AreaDelivererRadiusAreaModel> iterateRadiusAreas() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.radiusAreas == null) {
            this.radiusAreas = new LinkedHashSet<AreaDelivererRadiusAreaModel>();
            if (this.getId() != null) {
                Collection radiusAreasCollection = this.commonCaller.fetchChildren(this, AreaDelivererEmploymentModelEnum.RADIUS_AREAS.getPropertyName());
                this.radiusAreas.addAll(radiusAreasCollection);
            }
        }
        return new ImmutableIterator<AreaDelivererRadiusAreaModel>(this.radiusAreas);
    }

    @Override
    public Iterable<AreaDelivererRadiusAreaModel> iterableRadiusAreas() {
        return new IteratorIterable<AreaDelivererRadiusAreaModel>(this.iterateRadiusAreas());
    }

    @Override
    public void addRadiusArea(AreaDelivererRadiusAreaModel radiusArea) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.radiusAreas == null) {
            this.radiusAreas = new LinkedHashSet<AreaDelivererRadiusAreaModel>();
            if (this.getId() != null) {
                Collection radiusAreasCollection = this.commonCaller.fetchChildren(this, AreaDelivererEmploymentModelEnum.RADIUS_AREAS.getPropertyName());
                this.radiusAreas.addAll(radiusAreasCollection);
            }
        }
        if (this.radiusAreas.contains(radiusArea)) {
            return;
        }
        this.radiusAreas.add(radiusArea);
        this.fireValueChanged(AreaDelivererEmploymentModelEnum.RADIUS_AREAS, radiusArea, null);
        if (radiusArea != null) {
            radiusArea.setDelivererEmployment(this);
        }
    }

    @Override
    public void removeRadiusArea(AreaDelivererRadiusAreaModel radiusArea) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.radiusAreas == null) {
            this.radiusAreas = new LinkedHashSet<AreaDelivererRadiusAreaModel>();
            if (this.getId() != null) {
                Collection radiusAreasCollection = this.commonCaller.fetchChildren(this, AreaDelivererEmploymentModelEnum.RADIUS_AREAS.getPropertyName());
                this.radiusAreas.addAll(radiusAreasCollection);
            }
        }
        if (!this.radiusAreas.contains(radiusArea)) {
            return;
        }
        this.radiusAreas.remove(radiusArea);
        this.fireValueChanged(AreaDelivererEmploymentModelEnum.RADIUS_AREAS, radiusArea, null);
        if (radiusArea != null) {
            radiusArea.setDelivererEmployment(null);
        }
    }

    @Override
    public void clearRadiusAreas() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.radiusAreas == null) {
            this.radiusAreas = new LinkedHashSet<AreaDelivererRadiusAreaModel>();
            if (this.getId() != null) {
                Collection radiusAreasCollection = this.commonCaller.fetchChildren(this, AreaDelivererEmploymentModelEnum.RADIUS_AREAS.getPropertyName());
                this.radiusAreas.addAll(radiusAreasCollection);
            }
        }
        ArrayList<AreaDelivererRadiusAreaModel> oldRadiusAreas = new ArrayList<AreaDelivererRadiusAreaModel>(this.radiusAreas);
        this.radiusAreas.clear();
        this.fireValueChanged(AreaDelivererEmploymentModelEnum.RADIUS_AREAS, null, null);
        for (AreaDelivererRadiusAreaModel oldRadiusArea : oldRadiusAreas) {
            if (oldRadiusArea == null) continue;
            oldRadiusArea.setDelivererEmployment(null);
        }
    }

    @Override
    public boolean isRadiusAreasEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.radiusAreas == null) {
            this.radiusAreas = new LinkedHashSet<AreaDelivererRadiusAreaModel>();
            if (this.getId() != null) {
                Collection radiusAreasCollection = this.commonCaller.fetchChildren(this, AreaDelivererEmploymentModelEnum.RADIUS_AREAS.getPropertyName());
                this.radiusAreas.addAll(radiusAreasCollection);
            }
        }
        return this.radiusAreas.isEmpty();
    }

    @Override
    public boolean containsRadiusArea(AreaDelivererRadiusAreaModel radiusArea) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.radiusAreas == null) {
            this.radiusAreas = new LinkedHashSet<AreaDelivererRadiusAreaModel>();
            if (this.getId() != null) {
                Collection radiusAreasCollection = this.commonCaller.fetchChildren(this, AreaDelivererEmploymentModelEnum.RADIUS_AREAS.getPropertyName());
                this.radiusAreas.addAll(radiusAreasCollection);
            }
        }
        return this.radiusAreas.contains(radiusArea);
    }

    @Override
    public boolean isRadiusAreasInitialized() {
        return this.radiusAreas != null;
    }

    @Override
    public int countRegularAreas() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.regularAreas == null) {
            this.regularAreas = new LinkedHashSet<AreaDelivererRegularAreaModel>();
            if (this.getId() != null) {
                Collection regularAreasCollection = this.commonCaller.fetchChildren(this, AreaDelivererEmploymentModelEnum.REGULAR_AREAS.getPropertyName());
                this.regularAreas.addAll(regularAreasCollection);
            }
        }
        return this.regularAreas.size();
    }

    @Override
    public Iterator<AreaDelivererRegularAreaModel> iterateRegularAreas() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.regularAreas == null) {
            this.regularAreas = new LinkedHashSet<AreaDelivererRegularAreaModel>();
            if (this.getId() != null) {
                Collection regularAreasCollection = this.commonCaller.fetchChildren(this, AreaDelivererEmploymentModelEnum.REGULAR_AREAS.getPropertyName());
                this.regularAreas.addAll(regularAreasCollection);
            }
        }
        return new ImmutableIterator<AreaDelivererRegularAreaModel>(this.regularAreas);
    }

    @Override
    public Iterable<AreaDelivererRegularAreaModel> iterableRegularAreas() {
        return new IteratorIterable<AreaDelivererRegularAreaModel>(this.iterateRegularAreas());
    }

    @Override
    public void addRegularArea(AreaDelivererRegularAreaModel regularArea) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.regularAreas == null) {
            this.regularAreas = new LinkedHashSet<AreaDelivererRegularAreaModel>();
            if (this.getId() != null) {
                Collection regularAreasCollection = this.commonCaller.fetchChildren(this, AreaDelivererEmploymentModelEnum.REGULAR_AREAS.getPropertyName());
                this.regularAreas.addAll(regularAreasCollection);
            }
        }
        if (this.regularAreas.contains(regularArea)) {
            return;
        }
        this.regularAreas.add(regularArea);
        this.fireValueChanged(AreaDelivererEmploymentModelEnum.REGULAR_AREAS, regularArea, null);
        if (regularArea != null) {
            regularArea.setDelivererEmployment(this);
        }
    }

    @Override
    public void removeRegularArea(AreaDelivererRegularAreaModel regularArea) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.regularAreas == null) {
            this.regularAreas = new LinkedHashSet<AreaDelivererRegularAreaModel>();
            if (this.getId() != null) {
                Collection regularAreasCollection = this.commonCaller.fetchChildren(this, AreaDelivererEmploymentModelEnum.REGULAR_AREAS.getPropertyName());
                this.regularAreas.addAll(regularAreasCollection);
            }
        }
        if (!this.regularAreas.contains(regularArea)) {
            return;
        }
        this.regularAreas.remove(regularArea);
        this.fireValueChanged(AreaDelivererEmploymentModelEnum.REGULAR_AREAS, regularArea, null);
        if (regularArea != null) {
            regularArea.setDelivererEmployment(null);
        }
    }

    @Override
    public void clearRegularAreas() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.regularAreas == null) {
            this.regularAreas = new LinkedHashSet<AreaDelivererRegularAreaModel>();
            if (this.getId() != null) {
                Collection regularAreasCollection = this.commonCaller.fetchChildren(this, AreaDelivererEmploymentModelEnum.REGULAR_AREAS.getPropertyName());
                this.regularAreas.addAll(regularAreasCollection);
            }
        }
        ArrayList<AreaDelivererRegularAreaModel> oldRegularAreas = new ArrayList<AreaDelivererRegularAreaModel>(this.regularAreas);
        this.regularAreas.clear();
        this.fireValueChanged(AreaDelivererEmploymentModelEnum.REGULAR_AREAS, null, null);
        for (AreaDelivererRegularAreaModel oldRegularArea : oldRegularAreas) {
            if (oldRegularArea == null) continue;
            oldRegularArea.setDelivererEmployment(null);
        }
    }

    @Override
    public boolean isRegularAreasEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.regularAreas == null) {
            this.regularAreas = new LinkedHashSet<AreaDelivererRegularAreaModel>();
            if (this.getId() != null) {
                Collection regularAreasCollection = this.commonCaller.fetchChildren(this, AreaDelivererEmploymentModelEnum.REGULAR_AREAS.getPropertyName());
                this.regularAreas.addAll(regularAreasCollection);
            }
        }
        return this.regularAreas.isEmpty();
    }

    @Override
    public boolean containsRegularArea(AreaDelivererRegularAreaModel regularArea) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.regularAreas == null) {
            this.regularAreas = new LinkedHashSet<AreaDelivererRegularAreaModel>();
            if (this.getId() != null) {
                Collection regularAreasCollection = this.commonCaller.fetchChildren(this, AreaDelivererEmploymentModelEnum.REGULAR_AREAS.getPropertyName());
                this.regularAreas.addAll(regularAreasCollection);
            }
        }
        return this.regularAreas.contains(regularArea);
    }

    @Override
    public boolean isRegularAreasInitialized() {
        return this.regularAreas != null;
    }

    @Override
    public AreaDelivererModel getDeliverer() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.deliverer;
    }

    @Override
    public void setDeliverer(AreaDelivererModel deliverer) {
        this.setDeliverer(deliverer, true);
    }

    private void setDeliverer(AreaDelivererModel deliverer, boolean setDirty) {
        AreaDelivererModel oldDeliverer = this.getDeliverer();
        if (oldDeliverer == deliverer) {
            return;
        }
        if (oldDeliverer != null) {
            oldDeliverer.setEmployment(null);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaDelivererEmploymentModelEnum.DELIVERER.getPropertyName());
        }
        this.deliverer = deliverer;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaDelivererEmploymentModelEnum.DELIVERER, deliverer, oldDeliverer);
        if (this.deliverer != null) {
            this.deliverer.setEmployment(this);
        }
    }

    @Override
    public void setProxy(boolean proxy) {
        super.setProxy(proxy);
        if (proxy) {
            this.factors = null;
            this.radiusAreas = null;
            this.regularAreas = null;
        }
    }

    @Override
    protected void updateByDto(AreaDelivererEmploymentFullDto areaDelivererEmploymentDto) {
        AreaDelivererRegularAreaDto[] regularAreas;
        AreaDelivererRadiusAreaDto[] radiusAreas;
        this.employmentRadius = areaDelivererEmploymentDto.getEmploymentRadius();
        AreaDelivererFactorDto[] factors = areaDelivererEmploymentDto.getFactors();
        if (factors != null) {
            if (this.factors == null) {
                this.factors = new LinkedHashSet<AreaDelivererFactorModel>();
            } else {
                this.factors.clear();
            }
        }
        if ((radiusAreas = areaDelivererEmploymentDto.getRadiusAreas()) != null) {
            if (this.radiusAreas == null) {
                this.radiusAreas = new LinkedHashSet<AreaDelivererRadiusAreaModel>();
            } else {
                this.radiusAreas.clear();
            }
        }
        if ((regularAreas = areaDelivererEmploymentDto.getRegularAreas()) != null) {
            if (this.regularAreas == null) {
                this.regularAreas = new LinkedHashSet<AreaDelivererRegularAreaModel>();
            } else {
                this.regularAreas.clear();
            }
        }
        this.deliverer = (AreaDelivererModel)this.getModelCache().getModel(areaDelivererEmploymentDto.getDeliverer());
    }

    @Override
    protected void updateMasterRelationsByDto(AreaDelivererEmploymentFullDto areaDelivererEmploymentDto) {
        AreaDelivererRegularAreaDto[] regularAreas;
        AreaDelivererRadiusAreaDto[] radiusAreas;
        AreaDelivererFactorDto[] factors = areaDelivererEmploymentDto.getFactors();
        if (factors != null) {
            if (this.factors == null) {
                this.factors = new LinkedHashSet<AreaDelivererFactorModel>();
            } else {
                this.factors.clear();
            }
            for (AreaDelivererFactorDto factorDto : factors) {
                AreaDelivererFactorModel factorModel = (AreaDelivererFactorModel)this.getModelCache().getModel(factorDto);
                this.factors.add(factorModel);
            }
        } else {
            this.factors = null;
        }
        if ((radiusAreas = areaDelivererEmploymentDto.getRadiusAreas()) != null) {
            if (this.radiusAreas == null) {
                this.radiusAreas = new LinkedHashSet<AreaDelivererRadiusAreaModel>();
            } else {
                this.radiusAreas.clear();
            }
            for (AreaDelivererRadiusAreaDto radiusAreaDto : radiusAreas) {
                AreaDelivererRadiusAreaModel radiusAreaModel = (AreaDelivererRadiusAreaModel)this.getModelCache().getModel(radiusAreaDto);
                this.radiusAreas.add(radiusAreaModel);
            }
        } else {
            this.radiusAreas = null;
        }
        if ((regularAreas = areaDelivererEmploymentDto.getRegularAreas()) != null) {
            if (this.regularAreas == null) {
                this.regularAreas = new LinkedHashSet<AreaDelivererRegularAreaModel>();
            } else {
                this.regularAreas.clear();
            }
            for (AreaDelivererRegularAreaDto regularAreaDto : regularAreas) {
                AreaDelivererRegularAreaModel regularAreaModel = (AreaDelivererRegularAreaModel)this.getModelCache().getModel(regularAreaDto);
                this.regularAreas.add(regularAreaModel);
            }
        } else {
            this.regularAreas = null;
        }
    }

    @Override
    protected void checkStaleByDto(AreaDelivererEmploymentFullDto areaDelivererEmploymentDto) throws StaleStateException {
        AreaDelivererModelImpl delivererModel;
        AreaDelivererDto delivererDto;
        AreaDelivererRegularAreaDto[] regularAreaDtos;
        AreaDelivererRadiusAreaDto[] radiusAreaDtos;
        AreaDelivererFactorDto[] factorDtos = areaDelivererEmploymentDto.getFactors();
        if (factorDtos != null) {
            for (AreaDelivererFactorDto factorDto : factorDtos) {
                AreaDelivererFactorModelImpl factorModel = (AreaDelivererFactorModelImpl)this.getModelCache().getModel(AreaDelivererFactorModel.class, factorDto.getId());
                if (factorModel == null) continue;
                factorModel.checkStaleState(factorDto);
            }
        }
        if ((radiusAreaDtos = areaDelivererEmploymentDto.getRadiusAreas()) != null) {
            for (AreaDelivererRadiusAreaDto radiusAreaDto : radiusAreaDtos) {
                AreaDelivererRadiusAreaModelImpl radiusAreaModel = (AreaDelivererRadiusAreaModelImpl)this.getModelCache().getModel(AreaDelivererRadiusAreaModel.class, radiusAreaDto.getId());
                if (radiusAreaModel == null) continue;
                radiusAreaModel.checkStaleState(radiusAreaDto);
            }
        }
        if ((regularAreaDtos = areaDelivererEmploymentDto.getRegularAreas()) != null) {
            for (AreaDelivererRegularAreaDto regularAreaDto : regularAreaDtos) {
                AreaDelivererRegularAreaModelImpl regularAreaModel = (AreaDelivererRegularAreaModelImpl)this.getModelCache().getModel(AreaDelivererRegularAreaModel.class, regularAreaDto.getId());
                if (regularAreaModel == null) continue;
                regularAreaModel.checkStaleState(regularAreaDto);
            }
        }
        if ((delivererDto = areaDelivererEmploymentDto.getDeliverer()) != null && delivererDto.getId() != null && (delivererModel = (AreaDelivererModelImpl)this.getModelCache().getModel(AreaDelivererModel.class, delivererDto.getId())) != null) {
            delivererModel.checkStaleState(delivererDto);
        }
    }

    @Override
    public AreaDelivererEmploymentFullDto createDto() {
        Long id = this.getId();
        AreaDelivererEmploymentFullDto areaDelivererEmploymentDto = id == null ? new AreaDelivererEmploymentFullDto(this.getTempUUID()) : new AreaDelivererEmploymentFullDto(id, this.getVersion());
        areaDelivererEmploymentDto.setEmploymentRadius(this.getEmploymentRadius());
        AreaDelivererModelImpl deliverer = (AreaDelivererModelImpl)this.getDeliverer();
        if (deliverer != null) {
            areaDelivererEmploymentDto.setDeliverer(deliverer.createProxy());
        }
        return areaDelivererEmploymentDto;
    }

    @Override
    public AreaDelivererEmploymentProxyDto createProxy() {
        Long id = this.getId();
        AreaDelivererEmploymentProxyDto areaDelivererEmploymentDto = id == null ? new AreaDelivererEmploymentProxyDto(this.getTempUUID()) : new AreaDelivererEmploymentProxyDto(id, this.getVersion());
        return areaDelivererEmploymentDto;
    }

    public static enum AreaDelivererEmploymentModelEnum {
        EMPLOYMENT_RADIUS("employmentRadius"),
        FACTORS("factors"),
        RADIUS_AREAS("radiusAreas"),
        REGULAR_AREAS("regularAreas"),
        DELIVERER("deliverer");

        private String propertyName;

        private AreaDelivererEmploymentModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

