/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.offer;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.offer.OfferModel;
import de.datomino.peppergis.client.model.offer.OfferModelImpl;
import de.datomino.peppergis.client.model.offer.OfferTourRelationModel;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.client.model.tour.TourModelImpl;
import de.datomino.peppergis.dto.offer.OfferDto;
import de.datomino.peppergis.dto.offer.OfferTourRelationFullDto;
import de.datomino.peppergis.dto.offer.OfferTourRelationProxyDto;
import de.datomino.peppergis.dto.tour.TourDto;
import de.datomino.peppergis.exception.StaleStateException;
import org.ktde.util.cache.ChangeSet;

public class OfferTourRelationModelImpl
extends AbstractModel<OfferTourRelationFullDto, OfferTourRelationProxyDto>
implements OfferTourRelationModel {
    private OfferModel offer;
    private TourModel tour;

    public OfferTourRelationModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public OfferTourRelationModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public OfferModel getOffer() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.offer;
    }

    @Override
    public void setOffer(OfferModel offer) {
        this.setOffer(offer, true);
    }

    private void setOffer(OfferModel offer, boolean setDirty) {
        OfferModel oldOffer = this.getOffer();
        if (oldOffer == offer) {
            return;
        }
        if (oldOffer != null) {
            oldOffer.removeOfferTourRelation(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, OfferTourRelationModelEnum.OFFER.getPropertyName());
        }
        this.offer = offer;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(OfferTourRelationModelEnum.OFFER, offer, oldOffer);
        if (this.offer != null) {
            this.offer.addOfferTourRelation(this);
        }
    }

    @Override
    public TourModel getTour() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.tour;
    }

    @Override
    public void setTour(TourModel tour) {
        this.setTour(tour, true);
    }

    private void setTour(TourModel tour, boolean setDirty) {
        TourModel oldTour = this.getTour();
        if (oldTour == tour) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, OfferTourRelationModelEnum.TOUR.getPropertyName());
        }
        this.tour = tour;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(OfferTourRelationModelEnum.TOUR, tour, oldTour);
    }

    @Override
    protected void updateByDto(OfferTourRelationFullDto offerTourRelationDto) {
        this.offer = (OfferModel)this.getModelCache().getModel(offerTourRelationDto.getOffer());
        this.tour = (TourModel)this.getModelCache().getModel(offerTourRelationDto.getTour());
    }

    @Override
    protected void updateMasterRelationsByDto(OfferTourRelationFullDto offerTourRelationDto) {
    }

    @Override
    protected void checkStaleByDto(OfferTourRelationFullDto offerTourRelationDto) throws StaleStateException {
        TourModelImpl tourModel;
        TourDto tourDto;
        OfferModelImpl offerModel;
        OfferDto offerDto = offerTourRelationDto.getOffer();
        if (offerDto != null && offerDto.getId() != null && (offerModel = (OfferModelImpl)this.getModelCache().getModel(OfferModel.class, offerDto.getId())) != null) {
            offerModel.checkStaleState(offerDto);
        }
        if ((tourDto = offerTourRelationDto.getTour()) != null && tourDto.getId() != null && (tourModel = (TourModelImpl)this.getModelCache().getModel(TourModel.class, tourDto.getId())) != null) {
            tourModel.checkStaleState(tourDto);
        }
    }

    @Override
    public OfferTourRelationFullDto createDto() {
        TourModelImpl tour;
        Long id = this.getId();
        OfferTourRelationFullDto offerTourRelationDto = id == null ? new OfferTourRelationFullDto(this.getTempUUID()) : new OfferTourRelationFullDto(id, this.getVersion());
        OfferModelImpl offer = (OfferModelImpl)this.getOffer();
        if (offer != null) {
            offerTourRelationDto.setOffer(offer.createProxy());
        }
        if ((tour = (TourModelImpl)this.getTour()) != null) {
            offerTourRelationDto.setTour(tour.createProxy());
        }
        return offerTourRelationDto;
    }

    @Override
    public OfferTourRelationProxyDto createProxy() {
        Long id = this.getId();
        OfferTourRelationProxyDto offerTourRelationDto = id == null ? new OfferTourRelationProxyDto(this.getTempUUID()) : new OfferTourRelationProxyDto(id, this.getVersion());
        return offerTourRelationDto;
    }

    public static enum OfferTourRelationModelEnum {
        OFFER("offer"),
        TOUR("tour");

        private String propertyName;

        private OfferTourRelationModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

