/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.offer;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.area.AreaObjectModelImpl;
import de.datomino.peppergis.client.model.offer.OfferAreaRelationModel;
import de.datomino.peppergis.client.model.offer.OfferModel;
import de.datomino.peppergis.client.model.offer.OfferModelImpl;
import de.datomino.peppergis.dto.area.AreaObjectDto;
import de.datomino.peppergis.dto.offer.OfferAreaRelationFullDto;
import de.datomino.peppergis.dto.offer.OfferAreaRelationProxyDto;
import de.datomino.peppergis.dto.offer.OfferDto;
import de.datomino.peppergis.exception.StaleStateException;
import org.ktde.util.cache.ChangeSet;

public class OfferAreaRelationModelImpl
extends AbstractModel<OfferAreaRelationFullDto, OfferAreaRelationProxyDto>
implements OfferAreaRelationModel {
    private OfferModel offer;
    private AreaObjectModel area;

    public OfferAreaRelationModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public OfferAreaRelationModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public OfferModel getOffer() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.offer;
    }

    @Override
    public void setOffer(OfferModel offer) {
        this.setOffer(offer, true);
    }

    private void setOffer(OfferModel offer, boolean setDirty) {
        OfferModel oldOffer = this.getOffer();
        if (oldOffer == offer) {
            return;
        }
        if (oldOffer != null) {
            oldOffer.removeOfferAreaRelation(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, OfferAreaRelationModelEnum.OFFER.getPropertyName());
        }
        this.offer = offer;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(OfferAreaRelationModelEnum.OFFER, offer, oldOffer);
        if (this.offer != null) {
            this.offer.addOfferAreaRelation(this);
        }
    }

    @Override
    public AreaObjectModel getArea() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.area;
    }

    @Override
    public void setArea(AreaObjectModel area) {
        this.setArea(area, true);
    }

    private void setArea(AreaObjectModel area, boolean setDirty) {
        AreaObjectModel oldArea = this.getArea();
        if (oldArea == area) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, OfferAreaRelationModelEnum.AREA.getPropertyName());
        }
        this.area = area;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(OfferAreaRelationModelEnum.AREA, area, oldArea);
    }

    @Override
    protected void updateByDto(OfferAreaRelationFullDto offerAreaRelationDto) {
        this.offer = (OfferModel)this.getModelCache().getModel(offerAreaRelationDto.getOffer());
        this.area = (AreaObjectModel)this.getModelCache().getModel(offerAreaRelationDto.getArea());
    }

    @Override
    protected void updateMasterRelationsByDto(OfferAreaRelationFullDto offerAreaRelationDto) {
    }

    @Override
    protected void checkStaleByDto(OfferAreaRelationFullDto offerAreaRelationDto) throws StaleStateException {
        AreaObjectModelImpl areaModel;
        AreaObjectDto areaDto;
        OfferModelImpl offerModel;
        OfferDto offerDto = offerAreaRelationDto.getOffer();
        if (offerDto != null && offerDto.getId() != null && (offerModel = (OfferModelImpl)this.getModelCache().getModel(OfferModel.class, offerDto.getId())) != null) {
            offerModel.checkStaleState(offerDto);
        }
        if ((areaDto = offerAreaRelationDto.getArea()) != null && areaDto.getId() != null && (areaModel = (AreaObjectModelImpl)this.getModelCache().getModel(AreaObjectModel.class, areaDto.getId())) != null) {
            areaModel.checkStaleState(areaDto);
        }
    }

    @Override
    public OfferAreaRelationFullDto createDto() {
        AreaObjectModelImpl area;
        Long id = this.getId();
        OfferAreaRelationFullDto offerAreaRelationDto = id == null ? new OfferAreaRelationFullDto(this.getTempUUID()) : new OfferAreaRelationFullDto(id, this.getVersion());
        OfferModelImpl offer = (OfferModelImpl)this.getOffer();
        if (offer != null) {
            offerAreaRelationDto.setOffer(offer.createProxy());
        }
        if ((area = (AreaObjectModelImpl)this.getArea()) != null) {
            offerAreaRelationDto.setArea(area.createProxy());
        }
        return offerAreaRelationDto;
    }

    @Override
    public OfferAreaRelationProxyDto createProxy() {
        Long id = this.getId();
        OfferAreaRelationProxyDto offerAreaRelationDto = id == null ? new OfferAreaRelationProxyDto(this.getTempUUID()) : new OfferAreaRelationProxyDto(id, this.getVersion());
        return offerAreaRelationDto;
    }

    public static enum OfferAreaRelationModelEnum {
        OFFER("offer"),
        AREA("area");

        private String propertyName;

        private OfferAreaRelationModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

