/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.offer;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.offer.AgentModel;
import de.datomino.peppergis.dto.offer.AgentFullDto;
import de.datomino.peppergis.dto.offer.AgentProxyDto;
import de.datomino.peppergis.exception.StaleStateException;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;

public class AgentModelImpl
extends AbstractModel<AgentFullDto, AgentProxyDto>
implements AgentModel {
    private String agentNumber;
    private String firstName;
    private String lastName;
    private String function;
    private String company;
    private String street;
    private String housenumber;
    private String housenumberExtension;
    private String postcode;
    private String city;
    private String phone;
    private String fax;
    private String email;
    private String www;

    public AgentModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public AgentModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public String getAgentNumber() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.agentNumber;
    }

    @Override
    public void setAgentNumber(String agentNumber) {
        this.setAgentNumber(agentNumber, true);
    }

    private void setAgentNumber(String agentNumber, boolean setDirty) {
        String oldAgentNumber = this.getAgentNumber();
        if (new EqualsBuilder().append(oldAgentNumber, agentNumber).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AgentModelEnum.AGENT_NUMBER.getPropertyName());
        }
        this.agentNumber = agentNumber;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AgentModelEnum.AGENT_NUMBER, agentNumber, oldAgentNumber);
    }

    @Override
    public String getFirstName() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.firstName;
    }

    @Override
    public void setFirstName(String firstName) {
        this.setFirstName(firstName, true);
    }

    private void setFirstName(String firstName, boolean setDirty) {
        String oldFirstName = this.getFirstName();
        if (new EqualsBuilder().append(oldFirstName, firstName).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AgentModelEnum.FIRST_NAME.getPropertyName());
        }
        this.firstName = firstName;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AgentModelEnum.FIRST_NAME, firstName, oldFirstName);
    }

    @Override
    public String getLastName() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.lastName;
    }

    @Override
    public void setLastName(String lastName) {
        this.setLastName(lastName, true);
    }

    private void setLastName(String lastName, boolean setDirty) {
        String oldLastName = this.getLastName();
        if (new EqualsBuilder().append(oldLastName, lastName).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AgentModelEnum.LAST_NAME.getPropertyName());
        }
        this.lastName = lastName;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AgentModelEnum.LAST_NAME, lastName, oldLastName);
    }

    @Override
    public String getFunction() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.function;
    }

    @Override
    public void setFunction(String function) {
        this.setFunction(function, true);
    }

    private void setFunction(String function, boolean setDirty) {
        String oldFunction = this.getFunction();
        if (new EqualsBuilder().append(oldFunction, function).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AgentModelEnum.FUNCTION.getPropertyName());
        }
        this.function = function;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AgentModelEnum.FUNCTION, function, oldFunction);
    }

    @Override
    public String getCompany() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.company;
    }

    @Override
    public void setCompany(String company) {
        this.setCompany(company, true);
    }

    private void setCompany(String company, boolean setDirty) {
        String oldCompany = this.getCompany();
        if (new EqualsBuilder().append(oldCompany, company).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AgentModelEnum.COMPANY.getPropertyName());
        }
        this.company = company;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AgentModelEnum.COMPANY, company, oldCompany);
    }

    @Override
    public String getStreet() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.street;
    }

    @Override
    public void setStreet(String street) {
        this.setStreet(street, true);
    }

    private void setStreet(String street, boolean setDirty) {
        String oldStreet = this.getStreet();
        if (new EqualsBuilder().append(oldStreet, street).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AgentModelEnum.STREET.getPropertyName());
        }
        this.street = street;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AgentModelEnum.STREET, street, oldStreet);
    }

    @Override
    public String getHousenumber() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.housenumber;
    }

    @Override
    public void setHousenumber(String housenumber) {
        this.setHousenumber(housenumber, true);
    }

    private void setHousenumber(String housenumber, boolean setDirty) {
        String oldHousenumber = this.getHousenumber();
        if (new EqualsBuilder().append(oldHousenumber, housenumber).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AgentModelEnum.HOUSENUMBER.getPropertyName());
        }
        this.housenumber = housenumber;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AgentModelEnum.HOUSENUMBER, housenumber, oldHousenumber);
    }

    @Override
    public String getHousenumberExtension() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.housenumberExtension;
    }

    @Override
    public void setHousenumberExtension(String housenumberExtension) {
        this.setHousenumberExtension(housenumberExtension, true);
    }

    private void setHousenumberExtension(String housenumberExtension, boolean setDirty) {
        String oldHousenumberExtension = this.getHousenumberExtension();
        if (new EqualsBuilder().append(oldHousenumberExtension, housenumberExtension).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AgentModelEnum.HOUSENUMBER_EXTENSION.getPropertyName());
        }
        this.housenumberExtension = housenumberExtension;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AgentModelEnum.HOUSENUMBER_EXTENSION, housenumberExtension, oldHousenumberExtension);
    }

    @Override
    public String getPostcode() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.postcode;
    }

    @Override
    public void setPostcode(String postcode) {
        this.setPostcode(postcode, true);
    }

    private void setPostcode(String postcode, boolean setDirty) {
        String oldPostcode = this.getPostcode();
        if (new EqualsBuilder().append(oldPostcode, postcode).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AgentModelEnum.POSTCODE.getPropertyName());
        }
        this.postcode = postcode;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AgentModelEnum.POSTCODE, postcode, oldPostcode);
    }

    @Override
    public String getCity() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.city;
    }

    @Override
    public void setCity(String city) {
        this.setCity(city, true);
    }

    private void setCity(String city, boolean setDirty) {
        String oldCity = this.getCity();
        if (new EqualsBuilder().append(oldCity, city).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AgentModelEnum.CITY.getPropertyName());
        }
        this.city = city;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AgentModelEnum.CITY, city, oldCity);
    }

    @Override
    public String getPhone() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.phone;
    }

    @Override
    public void setPhone(String phone) {
        this.setPhone(phone, true);
    }

    private void setPhone(String phone, boolean setDirty) {
        String oldPhone = this.getPhone();
        if (new EqualsBuilder().append(oldPhone, phone).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AgentModelEnum.PHONE.getPropertyName());
        }
        this.phone = phone;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AgentModelEnum.PHONE, phone, oldPhone);
    }

    @Override
    public String getFax() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.fax;
    }

    @Override
    public void setFax(String fax) {
        this.setFax(fax, true);
    }

    private void setFax(String fax, boolean setDirty) {
        String oldFax = this.getFax();
        if (new EqualsBuilder().append(oldFax, fax).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AgentModelEnum.FAX.getPropertyName());
        }
        this.fax = fax;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AgentModelEnum.FAX, fax, oldFax);
    }

    @Override
    public String getEmail() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.email;
    }

    @Override
    public void setEmail(String email) {
        this.setEmail(email, true);
    }

    private void setEmail(String email, boolean setDirty) {
        String oldEmail = this.getEmail();
        if (new EqualsBuilder().append(oldEmail, email).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AgentModelEnum.EMAIL.getPropertyName());
        }
        this.email = email;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AgentModelEnum.EMAIL, email, oldEmail);
    }

    @Override
    public String getWww() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.www;
    }

    @Override
    public void setWww(String www) {
        this.setWww(www, true);
    }

    private void setWww(String www, boolean setDirty) {
        String oldWww = this.getWww();
        if (new EqualsBuilder().append(oldWww, www).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AgentModelEnum.WWW.getPropertyName());
        }
        this.www = www;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AgentModelEnum.WWW, www, oldWww);
    }

    @Override
    protected void updateByDto(AgentFullDto agentDto) {
        this.agentNumber = agentDto.getAgentNumber();
        this.firstName = agentDto.getFirstName();
        this.lastName = agentDto.getLastName();
        this.function = agentDto.getFunction();
        this.company = agentDto.getCompany();
        this.street = agentDto.getStreet();
        this.housenumber = agentDto.getHousenumber();
        this.housenumberExtension = agentDto.getHousenumberExtension();
        this.postcode = agentDto.getPostcode();
        this.city = agentDto.getCity();
        this.phone = agentDto.getPhone();
        this.fax = agentDto.getFax();
        this.email = agentDto.getEmail();
        this.www = agentDto.getWww();
    }

    @Override
    protected void updateMasterRelationsByDto(AgentFullDto agentDto) {
    }

    @Override
    protected void checkStaleByDto(AgentFullDto agentDto) throws StaleStateException {
    }

    @Override
    public AgentFullDto createDto() {
        Long id = this.getId();
        AgentFullDto agentDto = id == null ? new AgentFullDto(this.getTempUUID()) : new AgentFullDto(id, this.getVersion());
        agentDto.setAgentNumber(this.getAgentNumber());
        agentDto.setFirstName(this.getFirstName());
        agentDto.setLastName(this.getLastName());
        agentDto.setFunction(this.getFunction());
        agentDto.setCompany(this.getCompany());
        agentDto.setStreet(this.getStreet());
        agentDto.setHousenumber(this.getHousenumber());
        agentDto.setHousenumberExtension(this.getHousenumberExtension());
        agentDto.setPostcode(this.getPostcode());
        agentDto.setCity(this.getCity());
        agentDto.setPhone(this.getPhone());
        agentDto.setFax(this.getFax());
        agentDto.setEmail(this.getEmail());
        agentDto.setWww(this.getWww());
        return agentDto;
    }

    @Override
    public AgentProxyDto createProxy() {
        Long id = this.getId();
        AgentProxyDto agentDto = id == null ? new AgentProxyDto(this.getTempUUID()) : new AgentProxyDto(id, this.getVersion());
        return agentDto;
    }

    public static enum AgentModelEnum {
        AGENT_NUMBER("agentNumber"),
        FIRST_NAME("firstName"),
        LAST_NAME("lastName"),
        FUNCTION("function"),
        COMPANY("company"),
        STREET("street"),
        HOUSENUMBER("housenumber"),
        HOUSENUMBER_EXTENSION("housenumberExtension"),
        POSTCODE("postcode"),
        CITY("city"),
        PHONE("phone"),
        FAX("fax"),
        EMAIL("email"),
        WWW("www");

        private String propertyName;

        private AgentModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

