/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.mobile;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.mobile.AccountModel;
import de.datomino.peppergis.client.model.mobile.AccountModelImpl;
import de.datomino.peppergis.client.model.mobile.StopSyncStatusModel;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.model.tour.StopModelImpl;
import de.datomino.peppergis.dto.mobile.AccountDto;
import de.datomino.peppergis.dto.mobile.StopSyncStatusFullDto;
import de.datomino.peppergis.dto.mobile.StopSyncStatusProxyDto;
import de.datomino.peppergis.dto.tour.StopDto;
import de.datomino.peppergis.exception.StaleStateException;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;

public class StopSyncStatusModelImpl
extends AbstractModel<StopSyncStatusFullDto, StopSyncStatusProxyDto>
implements StopSyncStatusModel {
    private StopModel stop;
    private Long syncedVersion;
    private AccountModel account;

    public StopSyncStatusModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public StopSyncStatusModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public StopModel getStop() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.stop;
    }

    @Override
    public void setStop(StopModel stop) {
        this.setStop(stop, true);
    }

    private void setStop(StopModel stop, boolean setDirty) {
        StopModel oldStop = this.getStop();
        if (oldStop == stop) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, StopSyncStatusModelEnum.STOP.getPropertyName());
        }
        this.stop = stop;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(StopSyncStatusModelEnum.STOP, stop, oldStop);
    }

    @Override
    public Long getSyncedVersion() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.syncedVersion;
    }

    @Override
    public void setSyncedVersion(Long syncedVersion) {
        this.setSyncedVersion(syncedVersion, true);
    }

    private void setSyncedVersion(Long syncedVersion, boolean setDirty) {
        Long oldSyncedVersion = this.getSyncedVersion();
        if (new EqualsBuilder().append(oldSyncedVersion, syncedVersion).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, StopSyncStatusModelEnum.SYNCED_VERSION.getPropertyName());
        }
        this.syncedVersion = syncedVersion;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(StopSyncStatusModelEnum.SYNCED_VERSION, syncedVersion, oldSyncedVersion);
    }

    @Override
    public AccountModel getAccount() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.account;
    }

    @Override
    public void setAccount(AccountModel account) {
        this.setAccount(account, true);
    }

    private void setAccount(AccountModel account, boolean setDirty) {
        AccountModel oldAccount = this.getAccount();
        if (oldAccount == account) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, StopSyncStatusModelEnum.ACCOUNT.getPropertyName());
        }
        this.account = account;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(StopSyncStatusModelEnum.ACCOUNT, account, oldAccount);
    }

    @Override
    protected void updateByDto(StopSyncStatusFullDto stopSyncStatusDto) {
        this.stop = (StopModel)this.getModelCache().getModel(stopSyncStatusDto.getStop());
        this.syncedVersion = stopSyncStatusDto.getSyncedVersion();
        this.account = (AccountModel)this.getModelCache().getModel(stopSyncStatusDto.getAccount());
    }

    @Override
    protected void updateMasterRelationsByDto(StopSyncStatusFullDto stopSyncStatusDto) {
    }

    @Override
    protected void checkStaleByDto(StopSyncStatusFullDto stopSyncStatusDto) throws StaleStateException {
        AccountModelImpl accountModel;
        AccountDto accountDto;
        StopModelImpl stopModel;
        StopDto stopDto = stopSyncStatusDto.getStop();
        if (stopDto != null && stopDto.getId() != null && (stopModel = (StopModelImpl)this.getModelCache().getModel(StopModel.class, stopDto.getId())) != null) {
            stopModel.checkStaleState(stopDto);
        }
        if ((accountDto = stopSyncStatusDto.getAccount()) != null && accountDto.getId() != null && (accountModel = (AccountModelImpl)this.getModelCache().getModel(AccountModel.class, accountDto.getId())) != null) {
            accountModel.checkStaleState(accountDto);
        }
    }

    @Override
    public StopSyncStatusFullDto createDto() {
        Long id = this.getId();
        StopSyncStatusFullDto stopSyncStatusDto = id == null ? new StopSyncStatusFullDto(this.getTempUUID()) : new StopSyncStatusFullDto(id, this.getVersion());
        StopModelImpl stop = (StopModelImpl)this.getStop();
        if (stop != null) {
            stopSyncStatusDto.setStop(stop.createProxy());
        }
        stopSyncStatusDto.setSyncedVersion(this.getSyncedVersion());
        AccountModelImpl account = (AccountModelImpl)this.getAccount();
        if (account != null) {
            stopSyncStatusDto.setAccount(account.createProxy());
        }
        return stopSyncStatusDto;
    }

    @Override
    public StopSyncStatusProxyDto createProxy() {
        Long id = this.getId();
        StopSyncStatusProxyDto stopSyncStatusDto = id == null ? new StopSyncStatusProxyDto(this.getTempUUID()) : new StopSyncStatusProxyDto(id, this.getVersion());
        return stopSyncStatusDto;
    }

    public static enum StopSyncStatusModelEnum {
        STOP("stop"),
        SYNCED_VERSION("syncedVersion"),
        ACCOUNT("account");

        private String propertyName;

        private StopSyncStatusModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

