/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.mobile;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.mobile.AccountModel;
import de.datomino.peppergis.client.model.mobile.AccountModelImpl;
import de.datomino.peppergis.client.model.mobile.GeoTrackingModel;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.client.model.tour.TourModelImpl;
import de.datomino.peppergis.dto.mobile.AccountDto;
import de.datomino.peppergis.dto.mobile.GeoTrackingFullDto;
import de.datomino.peppergis.dto.mobile.GeoTrackingProxyDto;
import de.datomino.peppergis.dto.tour.TourDto;
import de.datomino.peppergis.exception.StaleStateException;
import de.datomino.peppergis.type.GeoTrackingType;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.dto.ImmutablePointDto;
import java.util.Date;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;

public class GeoTrackingModelImpl
extends AbstractModel<GeoTrackingFullDto, GeoTrackingProxyDto>
implements GeoTrackingModel {
    private Date time;
    private ImmutablePoint geoLocation;
    private AccountModel account;
    private TourModel tour;
    private GeoTrackingType type;

    public GeoTrackingModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public GeoTrackingModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public Date getTime() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.time;
    }

    @Override
    public void setTime(Date time) {
        this.setTime(time, true);
    }

    private void setTime(Date time, boolean setDirty) {
        Date oldTime = this.getTime();
        if (new EqualsBuilder().append(oldTime, time).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, GeoTrackingModelEnum.TIME.getPropertyName());
        }
        this.time = time;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(GeoTrackingModelEnum.TIME, time, oldTime);
    }

    @Override
    public ImmutablePoint getGeoLocation() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.geoLocation;
    }

    @Override
    public void setGeoLocation(ImmutablePoint geoLocation) {
        this.setGeoLocation(geoLocation, true);
    }

    private void setGeoLocation(ImmutablePoint geoLocation, boolean setDirty) {
        ImmutablePoint oldGeoLocation = this.getGeoLocation();
        if (new EqualsBuilder().append(oldGeoLocation, geoLocation).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, GeoTrackingModelEnum.GEO_LOCATION.getPropertyName());
        }
        this.geoLocation = geoLocation;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(GeoTrackingModelEnum.GEO_LOCATION, geoLocation, oldGeoLocation);
    }

    @Override
    public AccountModel getAccount() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.account;
    }

    @Override
    public void setAccount(AccountModel account) {
        this.setAccount(account, true);
    }

    private void setAccount(AccountModel account, boolean setDirty) {
        AccountModel oldAccount = this.getAccount();
        if (oldAccount == account) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, GeoTrackingModelEnum.ACCOUNT.getPropertyName());
        }
        this.account = account;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(GeoTrackingModelEnum.ACCOUNT, account, oldAccount);
    }

    @Override
    public TourModel getTour() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.tour;
    }

    @Override
    public void setTour(TourModel tour) {
        this.setTour(tour, true);
    }

    private void setTour(TourModel tour, boolean setDirty) {
        TourModel oldTour = this.getTour();
        if (oldTour == tour) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, GeoTrackingModelEnum.TOUR.getPropertyName());
        }
        this.tour = tour;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(GeoTrackingModelEnum.TOUR, tour, oldTour);
    }

    @Override
    public GeoTrackingType getType() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.type;
    }

    @Override
    public void setType(GeoTrackingType type) {
        this.setType(type, true);
    }

    private void setType(GeoTrackingType type, boolean setDirty) {
        GeoTrackingType oldType = this.getType();
        if (new EqualsBuilder().append((Object)oldType, (Object)type).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, GeoTrackingModelEnum.TYPE.getPropertyName());
        }
        this.type = type;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(GeoTrackingModelEnum.TYPE, (Object)type, (Object)oldType);
    }

    @Override
    protected void updateByDto(GeoTrackingFullDto geoTrackingDto) {
        this.time = geoTrackingDto.getTime();
        ImmutablePointDto geoLocation = geoTrackingDto.getGeoLocation();
        this.geoLocation = geoLocation == null ? null : (ImmutablePoint)geoLocation.getGeoObject();
        this.account = (AccountModel)this.getModelCache().getModel(geoTrackingDto.getAccount());
        this.tour = (TourModel)this.getModelCache().getModel(geoTrackingDto.getTour());
        this.type = geoTrackingDto.getType();
    }

    @Override
    protected void updateMasterRelationsByDto(GeoTrackingFullDto geoTrackingDto) {
    }

    @Override
    protected void checkStaleByDto(GeoTrackingFullDto geoTrackingDto) throws StaleStateException {
        TourModelImpl tourModel;
        TourDto tourDto;
        AccountModelImpl accountModel;
        AccountDto accountDto = geoTrackingDto.getAccount();
        if (accountDto != null && accountDto.getId() != null && (accountModel = (AccountModelImpl)this.getModelCache().getModel(AccountModel.class, accountDto.getId())) != null) {
            accountModel.checkStaleState(accountDto);
        }
        if ((tourDto = geoTrackingDto.getTour()) != null && tourDto.getId() != null && (tourModel = (TourModelImpl)this.getModelCache().getModel(TourModel.class, tourDto.getId())) != null) {
            tourModel.checkStaleState(tourDto);
        }
    }

    @Override
    public GeoTrackingFullDto createDto() {
        TourModelImpl tour;
        Long id = this.getId();
        GeoTrackingFullDto geoTrackingDto = id == null ? new GeoTrackingFullDto(this.getTempUUID()) : new GeoTrackingFullDto(id, this.getVersion());
        geoTrackingDto.setTime(this.getTime());
        ImmutablePoint geoLocation = this.getGeoLocation();
        geoTrackingDto.setGeoLocation(ImmutablePointDto.create(geoLocation));
        AccountModelImpl account = (AccountModelImpl)this.getAccount();
        if (account != null) {
            geoTrackingDto.setAccount(account.createProxy());
        }
        if ((tour = (TourModelImpl)this.getTour()) != null) {
            geoTrackingDto.setTour(tour.createProxy());
        }
        geoTrackingDto.setType(this.getType());
        return geoTrackingDto;
    }

    @Override
    public GeoTrackingProxyDto createProxy() {
        Long id = this.getId();
        GeoTrackingProxyDto geoTrackingDto = id == null ? new GeoTrackingProxyDto(this.getTempUUID()) : new GeoTrackingProxyDto(id, this.getVersion());
        return geoTrackingDto;
    }

    public static enum GeoTrackingModelEnum {
        TIME("time"),
        GEO_LOCATION("geoLocation"),
        ACCOUNT("account"),
        TOUR("tour"),
        TYPE("type");

        private String propertyName;

        private GeoTrackingModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

