/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.mobile;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.mobile.AccountHitModel;
import de.datomino.peppergis.client.model.mobile.AccountHitModelImpl;
import de.datomino.peppergis.client.model.mobile.AccountModel;
import de.datomino.peppergis.client.model.tour.DelivererModel;
import de.datomino.peppergis.client.model.tour.DelivererModelImpl;
import de.datomino.peppergis.dto.mobile.AccountFullDto;
import de.datomino.peppergis.dto.mobile.AccountHitDto;
import de.datomino.peppergis.dto.mobile.AccountProxyDto;
import de.datomino.peppergis.dto.tour.DelivererDto;
import de.datomino.peppergis.exception.StaleStateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;
import org.ktde.util.conversions.ImmutableIterator;
import org.ktde.util.conversions.IteratorIterable;

public class AccountModelImpl
extends AbstractModel<AccountFullDto, AccountProxyDto>
implements AccountModel {
    private String login;
    private String md5Password;
    private DelivererModel deliverer;
    private Set<AccountHitModel> accountHits = null;

    public AccountModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public AccountModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public String getLogin() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.login;
    }

    @Override
    public void setLogin(String login) {
        this.setLogin(login, true);
    }

    private void setLogin(String login, boolean setDirty) {
        String oldLogin = this.getLogin();
        if (new EqualsBuilder().append(oldLogin, login).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AccountModelEnum.LOGIN.getPropertyName());
        }
        this.login = login;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AccountModelEnum.LOGIN, login, oldLogin);
    }

    @Override
    public String getMd5Password() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.md5Password;
    }

    @Override
    public void setMd5Password(String md5Password) {
        this.setMd5Password(md5Password, true);
    }

    private void setMd5Password(String md5Password, boolean setDirty) {
        String oldMd5Password = this.getMd5Password();
        if (new EqualsBuilder().append(oldMd5Password, md5Password).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AccountModelEnum.MD5_PASSWORD.getPropertyName());
        }
        this.md5Password = md5Password;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AccountModelEnum.MD5_PASSWORD, md5Password, oldMd5Password);
    }

    @Override
    public DelivererModel getDeliverer() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.deliverer;
    }

    @Override
    public void setDeliverer(DelivererModel deliverer) {
        this.setDeliverer(deliverer, true);
    }

    private void setDeliverer(DelivererModel deliverer, boolean setDirty) {
        DelivererModel oldDeliverer = this.getDeliverer();
        if (oldDeliverer == deliverer) {
            return;
        }
        if (oldDeliverer != null) {
            oldDeliverer.removeMobileAccount(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AccountModelEnum.DELIVERER.getPropertyName());
        }
        this.deliverer = deliverer;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AccountModelEnum.DELIVERER, deliverer, oldDeliverer);
        if (this.deliverer != null) {
            this.deliverer.addMobileAccount(this);
        }
    }

    @Override
    public int countAccountHits() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.accountHits == null) {
            this.accountHits = new LinkedHashSet<AccountHitModel>();
            if (this.getId() != null) {
                Collection accountHitsCollection = this.commonCaller.fetchChildren(this, AccountModelEnum.ACCOUNT_HITS.getPropertyName());
                this.accountHits.addAll(accountHitsCollection);
            }
        }
        return this.accountHits.size();
    }

    @Override
    public Iterator<AccountHitModel> iterateAccountHits() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.accountHits == null) {
            this.accountHits = new LinkedHashSet<AccountHitModel>();
            if (this.getId() != null) {
                Collection accountHitsCollection = this.commonCaller.fetchChildren(this, AccountModelEnum.ACCOUNT_HITS.getPropertyName());
                this.accountHits.addAll(accountHitsCollection);
            }
        }
        return new ImmutableIterator<AccountHitModel>(this.accountHits);
    }

    @Override
    public Iterable<AccountHitModel> iterableAccountHits() {
        return new IteratorIterable<AccountHitModel>(this.iterateAccountHits());
    }

    @Override
    public void addAccountHit(AccountHitModel accountHit) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.accountHits == null) {
            this.accountHits = new LinkedHashSet<AccountHitModel>();
            if (this.getId() != null) {
                Collection accountHitsCollection = this.commonCaller.fetchChildren(this, AccountModelEnum.ACCOUNT_HITS.getPropertyName());
                this.accountHits.addAll(accountHitsCollection);
            }
        }
        if (this.accountHits.contains(accountHit)) {
            return;
        }
        this.accountHits.add(accountHit);
        this.fireValueChanged(AccountModelEnum.ACCOUNT_HITS, accountHit, null);
        if (accountHit != null) {
            accountHit.setAccount(this);
        }
    }

    @Override
    public void removeAccountHit(AccountHitModel accountHit) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.accountHits == null) {
            this.accountHits = new LinkedHashSet<AccountHitModel>();
            if (this.getId() != null) {
                Collection accountHitsCollection = this.commonCaller.fetchChildren(this, AccountModelEnum.ACCOUNT_HITS.getPropertyName());
                this.accountHits.addAll(accountHitsCollection);
            }
        }
        if (!this.accountHits.contains(accountHit)) {
            return;
        }
        this.accountHits.remove(accountHit);
        this.fireValueChanged(AccountModelEnum.ACCOUNT_HITS, accountHit, null);
        if (accountHit != null) {
            accountHit.setAccount(null);
        }
    }

    @Override
    public void clearAccountHits() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.accountHits == null) {
            this.accountHits = new LinkedHashSet<AccountHitModel>();
            if (this.getId() != null) {
                Collection accountHitsCollection = this.commonCaller.fetchChildren(this, AccountModelEnum.ACCOUNT_HITS.getPropertyName());
                this.accountHits.addAll(accountHitsCollection);
            }
        }
        ArrayList<AccountHitModel> oldAccountHits = new ArrayList<AccountHitModel>(this.accountHits);
        this.accountHits.clear();
        this.fireValueChanged(AccountModelEnum.ACCOUNT_HITS, null, null);
        for (AccountHitModel oldAccountHit : oldAccountHits) {
            if (oldAccountHit == null) continue;
            oldAccountHit.setAccount(null);
        }
    }

    @Override
    public boolean isAccountHitsEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.accountHits == null) {
            this.accountHits = new LinkedHashSet<AccountHitModel>();
            if (this.getId() != null) {
                Collection accountHitsCollection = this.commonCaller.fetchChildren(this, AccountModelEnum.ACCOUNT_HITS.getPropertyName());
                this.accountHits.addAll(accountHitsCollection);
            }
        }
        return this.accountHits.isEmpty();
    }

    @Override
    public boolean containsAccountHit(AccountHitModel accountHit) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.accountHits == null) {
            this.accountHits = new LinkedHashSet<AccountHitModel>();
            if (this.getId() != null) {
                Collection accountHitsCollection = this.commonCaller.fetchChildren(this, AccountModelEnum.ACCOUNT_HITS.getPropertyName());
                this.accountHits.addAll(accountHitsCollection);
            }
        }
        return this.accountHits.contains(accountHit);
    }

    @Override
    public boolean isAccountHitsInitialized() {
        return this.accountHits != null;
    }

    @Override
    public void setProxy(boolean proxy) {
        super.setProxy(proxy);
        if (proxy) {
            this.accountHits = null;
        }
    }

    @Override
    protected void updateByDto(AccountFullDto accountDto) {
        this.login = accountDto.getLogin();
        this.md5Password = accountDto.getMd5Password();
        this.deliverer = (DelivererModel)this.getModelCache().getModel(accountDto.getDeliverer());
        AccountHitDto[] accountHits = accountDto.getAccountHits();
        if (accountHits != null) {
            if (this.accountHits == null) {
                this.accountHits = new LinkedHashSet<AccountHitModel>();
            } else {
                this.accountHits.clear();
            }
        }
    }

    @Override
    protected void updateMasterRelationsByDto(AccountFullDto accountDto) {
        AccountHitDto[] accountHits = accountDto.getAccountHits();
        if (accountHits != null) {
            if (this.accountHits == null) {
                this.accountHits = new LinkedHashSet<AccountHitModel>();
            } else {
                this.accountHits.clear();
            }
            for (AccountHitDto accountHitDto : accountHits) {
                AccountHitModel accountHitModel = (AccountHitModel)this.getModelCache().getModel(accountHitDto);
                this.accountHits.add(accountHitModel);
            }
        } else {
            this.accountHits = null;
        }
    }

    @Override
    protected void checkStaleByDto(AccountFullDto accountDto) throws StaleStateException {
        AccountHitDto[] accountHitDtos;
        DelivererModelImpl delivererModel;
        DelivererDto delivererDto = accountDto.getDeliverer();
        if (delivererDto != null && delivererDto.getId() != null && (delivererModel = (DelivererModelImpl)this.getModelCache().getModel(DelivererModel.class, delivererDto.getId())) != null) {
            delivererModel.checkStaleState(delivererDto);
        }
        if ((accountHitDtos = accountDto.getAccountHits()) != null) {
            for (AccountHitDto accountHitDto : accountHitDtos) {
                AccountHitModelImpl accountHitModel = (AccountHitModelImpl)this.getModelCache().getModel(AccountHitModel.class, accountHitDto.getId());
                if (accountHitModel == null) continue;
                accountHitModel.checkStaleState(accountHitDto);
            }
        }
    }

    @Override
    public AccountFullDto createDto() {
        Long id = this.getId();
        AccountFullDto accountDto = id == null ? new AccountFullDto(this.getTempUUID()) : new AccountFullDto(id, this.getVersion());
        accountDto.setLogin(this.getLogin());
        accountDto.setMd5Password(this.getMd5Password());
        DelivererModelImpl deliverer = (DelivererModelImpl)this.getDeliverer();
        if (deliverer != null) {
            accountDto.setDeliverer(deliverer.createProxy());
        }
        return accountDto;
    }

    @Override
    public AccountProxyDto createProxy() {
        Long id = this.getId();
        AccountProxyDto accountDto = id == null ? new AccountProxyDto(this.getTempUUID()) : new AccountProxyDto(id, this.getVersion());
        return accountDto;
    }

    public static enum AccountModelEnum {
        LOGIN("login"),
        MD5_PASSWORD("md5Password"),
        DELIVERER("deliverer"),
        ACCOUNT_HITS("accountHits");

        private String propertyName;

        private AccountModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

