/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.mobile;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.mobile.AccountHitModel;
import de.datomino.peppergis.client.model.mobile.AccountModel;
import de.datomino.peppergis.client.model.mobile.AccountModelImpl;
import de.datomino.peppergis.dto.mobile.AccountDto;
import de.datomino.peppergis.dto.mobile.AccountHitFullDto;
import de.datomino.peppergis.dto.mobile.AccountHitProxyDto;
import de.datomino.peppergis.exception.StaleStateException;
import java.util.Date;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;

public class AccountHitModelImpl
extends AbstractModel<AccountHitFullDto, AccountHitProxyDto>
implements AccountHitModel {
    private AccountModel account;
    private Date date;

    public AccountHitModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public AccountHitModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public AccountModel getAccount() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.account;
    }

    @Override
    public void setAccount(AccountModel account) {
        this.setAccount(account, true);
    }

    private void setAccount(AccountModel account, boolean setDirty) {
        AccountModel oldAccount = this.getAccount();
        if (oldAccount == account) {
            return;
        }
        if (oldAccount != null) {
            oldAccount.removeAccountHit(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AccountHitModelEnum.ACCOUNT.getPropertyName());
        }
        this.account = account;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AccountHitModelEnum.ACCOUNT, account, oldAccount);
        if (this.account != null) {
            this.account.addAccountHit(this);
        }
    }

    @Override
    public Date getDate() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.date;
    }

    @Override
    public void setDate(Date date) {
        this.setDate(date, true);
    }

    private void setDate(Date date, boolean setDirty) {
        Date oldDate = this.getDate();
        if (new EqualsBuilder().append(oldDate, date).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AccountHitModelEnum.DATE.getPropertyName());
        }
        this.date = date;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AccountHitModelEnum.DATE, date, oldDate);
    }

    @Override
    protected void updateByDto(AccountHitFullDto accountHitDto) {
        this.account = (AccountModel)this.getModelCache().getModel(accountHitDto.getAccount());
        this.date = accountHitDto.getDate();
    }

    @Override
    protected void updateMasterRelationsByDto(AccountHitFullDto accountHitDto) {
    }

    @Override
    protected void checkStaleByDto(AccountHitFullDto accountHitDto) throws StaleStateException {
        AccountModelImpl accountModel;
        AccountDto accountDto = accountHitDto.getAccount();
        if (accountDto != null && accountDto.getId() != null && (accountModel = (AccountModelImpl)this.getModelCache().getModel(AccountModel.class, accountDto.getId())) != null) {
            accountModel.checkStaleState(accountDto);
        }
    }

    @Override
    public AccountHitFullDto createDto() {
        Long id = this.getId();
        AccountHitFullDto accountHitDto = id == null ? new AccountHitFullDto(this.getTempUUID()) : new AccountHitFullDto(id, this.getVersion());
        AccountModelImpl account = (AccountModelImpl)this.getAccount();
        if (account != null) {
            accountHitDto.setAccount(account.createProxy());
        }
        accountHitDto.setDate(this.getDate());
        return accountHitDto;
    }

    @Override
    public AccountHitProxyDto createProxy() {
        Long id = this.getId();
        AccountHitProxyDto accountHitDto = id == null ? new AccountHitProxyDto(this.getTempUUID()) : new AccountHitProxyDto(id, this.getVersion());
        return accountHitDto;
    }

    public static enum AccountHitModelEnum {
        ACCOUNT("account"),
        DATE("date");

        private String propertyName;

        private AccountHitModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

