/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.map;

import de.datomino.logistic.type.PlaceType;
import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.map.PlaceModel;
import de.datomino.peppergis.dto.map.PlaceFullDto;
import de.datomino.peppergis.dto.map.PlaceProxyDto;
import de.datomino.peppergis.exception.StaleStateException;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.ImmutablePolygonKind;
import de.datomino.util.geo.dto.ImmutablePointDto;
import de.datomino.util.geo.dto.ImmutablePolygonKindDto;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;

public class PlaceModelImpl
extends AbstractModel<PlaceFullDto, PlaceProxyDto>
implements PlaceModel {
    private String name;
    private ImmutablePoint point;
    private ImmutablePolygonKind polygon;
    private Integer population;
    private Long idImportRef;
    private PlaceType placeType;

    public PlaceModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public PlaceModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public String getName() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.setName(name, true);
    }

    private void setName(String name, boolean setDirty) {
        String oldName = this.getName();
        if (new EqualsBuilder().append(oldName, name).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, PlaceModelEnum.NAME.getPropertyName());
        }
        this.name = name;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(PlaceModelEnum.NAME, name, oldName);
    }

    @Override
    public ImmutablePoint getPoint() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.point;
    }

    @Override
    public void setPoint(ImmutablePoint point) {
        this.setPoint(point, true);
    }

    private void setPoint(ImmutablePoint point, boolean setDirty) {
        ImmutablePoint oldPoint = this.getPoint();
        if (new EqualsBuilder().append(oldPoint, point).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, PlaceModelEnum.POINT.getPropertyName());
        }
        this.point = point;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(PlaceModelEnum.POINT, point, oldPoint);
    }

    @Override
    public ImmutablePolygonKind getPolygon() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.polygon;
    }

    @Override
    public void setPolygon(ImmutablePolygonKind polygon) {
        this.setPolygon(polygon, true);
    }

    private void setPolygon(ImmutablePolygonKind polygon, boolean setDirty) {
        ImmutablePolygonKind oldPolygon = this.getPolygon();
        if (new EqualsBuilder().append(oldPolygon, polygon).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, PlaceModelEnum.POLYGON.getPropertyName());
        }
        this.polygon = polygon;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(PlaceModelEnum.POLYGON, polygon, oldPolygon);
    }

    @Override
    public Integer getPopulation() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.population;
    }

    @Override
    public void setPopulation(Integer population) {
        this.setPopulation(population, true);
    }

    private void setPopulation(Integer population, boolean setDirty) {
        Integer oldPopulation = this.getPopulation();
        if (new EqualsBuilder().append(oldPopulation, population).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, PlaceModelEnum.POPULATION.getPropertyName());
        }
        this.population = population;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(PlaceModelEnum.POPULATION, population, oldPopulation);
    }

    @Override
    public Long getIdImportRef() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.idImportRef;
    }

    @Override
    public void setIdImportRef(Long idImportRef) {
        this.setIdImportRef(idImportRef, true);
    }

    private void setIdImportRef(Long idImportRef, boolean setDirty) {
        Long oldIdImportRef = this.getIdImportRef();
        if (new EqualsBuilder().append(oldIdImportRef, idImportRef).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, PlaceModelEnum.ID_IMPORT_REF.getPropertyName());
        }
        this.idImportRef = idImportRef;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(PlaceModelEnum.ID_IMPORT_REF, idImportRef, oldIdImportRef);
    }

    @Override
    public PlaceType getPlaceType() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.placeType;
    }

    @Override
    public void setPlaceType(PlaceType placeType) {
        this.setPlaceType(placeType, true);
    }

    private void setPlaceType(PlaceType placeType, boolean setDirty) {
        PlaceType oldPlaceType = this.getPlaceType();
        if (new EqualsBuilder().append((Object)oldPlaceType, (Object)placeType).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, PlaceModelEnum.PLACE_TYPE.getPropertyName());
        }
        this.placeType = placeType;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(PlaceModelEnum.PLACE_TYPE, (Object)placeType, (Object)oldPlaceType);
    }

    @Override
    protected void updateByDto(PlaceFullDto placeDto) {
        this.name = placeDto.getName();
        ImmutablePointDto point = placeDto.getPoint();
        this.point = point == null ? null : (ImmutablePoint)point.getGeoObject();
        ImmutablePolygonKindDto polygon = placeDto.getPolygon();
        this.polygon = polygon == null ? null : (ImmutablePolygonKind)polygon.getGeoObject();
        this.population = placeDto.getPopulation();
        this.idImportRef = placeDto.getIdImportRef();
        this.placeType = placeDto.getPlaceType();
    }

    @Override
    protected void updateMasterRelationsByDto(PlaceFullDto placeDto) {
    }

    @Override
    protected void checkStaleByDto(PlaceFullDto placeDto) throws StaleStateException {
    }

    @Override
    public PlaceFullDto createDto() {
        Long id = this.getId();
        PlaceFullDto placeDto = id == null ? new PlaceFullDto(this.getTempUUID()) : new PlaceFullDto(id, this.getVersion());
        placeDto.setName(this.getName());
        ImmutablePoint point = this.getPoint();
        placeDto.setPoint(ImmutablePointDto.create(point));
        ImmutablePolygonKind polygon = this.getPolygon();
        placeDto.setPolygon(ImmutablePolygonKindDto.create(polygon));
        placeDto.setPopulation(this.getPopulation());
        placeDto.setIdImportRef(this.getIdImportRef());
        placeDto.setPlaceType(this.getPlaceType());
        return placeDto;
    }

    @Override
    public PlaceProxyDto createProxy() {
        Long id = this.getId();
        PlaceProxyDto placeDto = id == null ? new PlaceProxyDto(this.getTempUUID()) : new PlaceProxyDto(id, this.getVersion());
        return placeDto;
    }

    public static enum PlaceModelEnum {
        NAME("name"),
        POINT("point"),
        POLYGON("polygon"),
        POPULATION("population"),
        ID_IMPORT_REF("idImportRef"),
        PLACE_TYPE("placeType");

        private String propertyName;

        private PlaceModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

