/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.map;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.map.ParcelFilterPatternParameterModel;
import de.datomino.peppergis.client.model.map.ParcelFilterPatternParameterModelImpl;
import de.datomino.peppergis.client.model.map.ParcelFilterPatternRelationModel;
import de.datomino.peppergis.client.model.map.ParcelFilterPatternSetupModel;
import de.datomino.peppergis.client.model.map.ParcelFilterPatternSetupModelImpl;
import de.datomino.peppergis.dto.map.ParcelFilterPatternParameterDto;
import de.datomino.peppergis.dto.map.ParcelFilterPatternRelationFullDto;
import de.datomino.peppergis.dto.map.ParcelFilterPatternRelationProxyDto;
import de.datomino.peppergis.dto.map.ParcelFilterPatternSetupDto;
import de.datomino.peppergis.exception.StaleStateException;
import de.datomino.peppergis.type.RendererType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;
import org.ktde.util.conversions.ImmutableIterator;
import org.ktde.util.conversions.IteratorIterable;

public class ParcelFilterPatternRelationModelImpl
extends AbstractModel<ParcelFilterPatternRelationFullDto, ParcelFilterPatternRelationProxyDto>
implements ParcelFilterPatternRelationModel {
    private ParcelFilterPatternSetupModel patternSetup;
    private RendererType rendererType;
    private Integer sortOrder;
    private List<ParcelFilterPatternParameterModel> parameters = null;

    public ParcelFilterPatternRelationModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public ParcelFilterPatternRelationModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public ParcelFilterPatternSetupModel getPatternSetup() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.patternSetup;
    }

    @Override
    public void setPatternSetup(ParcelFilterPatternSetupModel patternSetup) {
        this.setPatternSetup(patternSetup, true);
    }

    private void setPatternSetup(ParcelFilterPatternSetupModel patternSetup, boolean setDirty) {
        ParcelFilterPatternSetupModel oldPatternSetup = this.getPatternSetup();
        if (oldPatternSetup == patternSetup) {
            return;
        }
        if (oldPatternSetup != null) {
            oldPatternSetup.removeRelation(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ParcelFilterPatternRelationModelEnum.PATTERN_SETUP.getPropertyName());
        }
        this.patternSetup = patternSetup;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ParcelFilterPatternRelationModelEnum.PATTERN_SETUP, patternSetup, oldPatternSetup);
        if (this.patternSetup != null) {
            this.patternSetup.addRelation(this);
        }
    }

    @Override
    public RendererType getRendererType() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.rendererType;
    }

    @Override
    public void setRendererType(RendererType rendererType) {
        this.setRendererType(rendererType, true);
    }

    private void setRendererType(RendererType rendererType, boolean setDirty) {
        RendererType oldRendererType = this.getRendererType();
        if (new EqualsBuilder().append((Object)oldRendererType, (Object)rendererType).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ParcelFilterPatternRelationModelEnum.RENDERER_TYPE.getPropertyName());
        }
        this.rendererType = rendererType;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ParcelFilterPatternRelationModelEnum.RENDERER_TYPE, (Object)rendererType, (Object)oldRendererType);
    }

    @Override
    public Integer getSortOrder() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.sortOrder;
    }

    @Override
    public void setSortOrder(Integer sortOrder) {
        this.setSortOrder(sortOrder, true);
    }

    private void setSortOrder(Integer sortOrder, boolean setDirty) {
        Integer oldSortOrder = this.getSortOrder();
        if (new EqualsBuilder().append(oldSortOrder, sortOrder).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ParcelFilterPatternRelationModelEnum.SORT_ORDER.getPropertyName());
        }
        this.sortOrder = sortOrder;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ParcelFilterPatternRelationModelEnum.SORT_ORDER, sortOrder, oldSortOrder);
    }

    @Override
    public int countParameters() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.parameters == null) {
            this.parameters = new ArrayList<ParcelFilterPatternParameterModel>();
            if (this.getId() != null) {
                Collection parametersCollection = this.commonCaller.fetchChildren(this, ParcelFilterPatternRelationModelEnum.PARAMETERS.getPropertyName());
                this.parameters.addAll(parametersCollection);
            }
        }
        return this.parameters.size();
    }

    @Override
    public Iterator<ParcelFilterPatternParameterModel> iterateParameters() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.parameters == null) {
            this.parameters = new ArrayList<ParcelFilterPatternParameterModel>();
            if (this.getId() != null) {
                Collection parametersCollection = this.commonCaller.fetchChildren(this, ParcelFilterPatternRelationModelEnum.PARAMETERS.getPropertyName());
                this.parameters.addAll(parametersCollection);
            }
        }
        return new ImmutableIterator<ParcelFilterPatternParameterModel>(this.parameters);
    }

    @Override
    public Iterable<ParcelFilterPatternParameterModel> iterableParameters() {
        return new IteratorIterable<ParcelFilterPatternParameterModel>(this.iterateParameters());
    }

    @Override
    public void addParameter(ParcelFilterPatternParameterModel parameter) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.parameters == null) {
            this.parameters = new ArrayList<ParcelFilterPatternParameterModel>();
            if (this.getId() != null) {
                Collection parametersCollection = this.commonCaller.fetchChildren(this, ParcelFilterPatternRelationModelEnum.PARAMETERS.getPropertyName());
                this.parameters.addAll(parametersCollection);
            }
        }
        if (this.parameters.contains(parameter)) {
            return;
        }
        this.parameters.add(parameter);
        this.fireValueChanged(ParcelFilterPatternRelationModelEnum.PARAMETERS, parameter, null);
        if (parameter != null) {
            parameter.setRelation(this);
            parameter.setSortOrder(this.parameters.size() - 1);
        }
    }

    @Override
    public void removeParameter(ParcelFilterPatternParameterModel parameter) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.parameters == null) {
            this.parameters = new ArrayList<ParcelFilterPatternParameterModel>();
            if (this.getId() != null) {
                Collection parametersCollection = this.commonCaller.fetchChildren(this, ParcelFilterPatternRelationModelEnum.PARAMETERS.getPropertyName());
                this.parameters.addAll(parametersCollection);
            }
        }
        if (!this.parameters.contains(parameter)) {
            return;
        }
        this.parameters.remove(parameter);
        this.fireValueChanged(ParcelFilterPatternRelationModelEnum.PARAMETERS, parameter, null);
        if (parameter != null) {
            parameter.setRelation(null);
            parameter.setSortOrder(null);
        }
        this.reorderParameters(0);
    }

    @Override
    public ParcelFilterPatternParameterModel getParameterAt(int index) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.parameters == null) {
            this.parameters = new ArrayList<ParcelFilterPatternParameterModel>();
            if (this.getId() != null) {
                Collection parametersCollection = this.commonCaller.fetchChildren(this, ParcelFilterPatternRelationModelEnum.PARAMETERS.getPropertyName());
                this.parameters.addAll(parametersCollection);
            }
        }
        return this.parameters.get(index);
    }

    @Override
    public void insertParameter(ParcelFilterPatternParameterModel parameter, int index) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.parameters == null) {
            this.parameters = new ArrayList<ParcelFilterPatternParameterModel>();
            if (this.getId() != null) {
                Collection parametersCollection = this.commonCaller.fetchChildren(this, ParcelFilterPatternRelationModelEnum.PARAMETERS.getPropertyName());
                this.parameters.addAll(parametersCollection);
            }
        }
        if (this.parameters.contains(parameter)) {
            this.removeParameter(parameter);
        }
        this.parameters.add(index, parameter);
        this.fireValueChanged(ParcelFilterPatternRelationModelEnum.PARAMETERS, parameter, null);
        if (parameter != null) {
            parameter.setRelation(this);
        }
        this.reorderParameters(index);
    }

    @Override
    public void removeParameterAt(int index) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.parameters == null) {
            this.parameters = new ArrayList<ParcelFilterPatternParameterModel>();
            if (this.getId() != null) {
                Collection parametersCollection = this.commonCaller.fetchChildren(this, ParcelFilterPatternRelationModelEnum.PARAMETERS.getPropertyName());
                this.parameters.addAll(parametersCollection);
            }
        }
        ParcelFilterPatternParameterModel oldParameter = this.parameters.get(index);
        this.parameters.remove(index);
        this.fireValueChanged(ParcelFilterPatternRelationModelEnum.PARAMETERS, oldParameter, null);
        if (oldParameter != null) {
            oldParameter.setRelation(null);
            oldParameter.setSortOrder(null);
        }
        this.reorderParameters(index);
    }

    @Override
    public void setParameterAt(ParcelFilterPatternParameterModel parameter, int index) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.parameters == null) {
            this.parameters = new ArrayList<ParcelFilterPatternParameterModel>();
            if (this.getId() != null) {
                Collection parametersCollection = this.commonCaller.fetchChildren(this, ParcelFilterPatternRelationModelEnum.PARAMETERS.getPropertyName());
                this.parameters.addAll(parametersCollection);
            }
        }
        ParcelFilterPatternParameterModel oldParameter = this.parameters.get(index);
        this.parameters.set(index, parameter);
        this.fireValueChanged(ParcelFilterPatternRelationModelEnum.PARAMETERS, parameter, oldParameter);
        if (oldParameter != null) {
            oldParameter.setRelation(null);
            oldParameter.setSortOrder(null);
        }
        if (parameter != null) {
            parameter.setRelation(this);
            parameter.setSortOrder(index);
        }
    }

    @Override
    public void clearParameters() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.parameters == null) {
            this.parameters = new ArrayList<ParcelFilterPatternParameterModel>();
            if (this.getId() != null) {
                Collection parametersCollection = this.commonCaller.fetchChildren(this, ParcelFilterPatternRelationModelEnum.PARAMETERS.getPropertyName());
                this.parameters.addAll(parametersCollection);
            }
        }
        ArrayList<ParcelFilterPatternParameterModel> oldParameters = new ArrayList<ParcelFilterPatternParameterModel>(this.parameters);
        this.parameters.clear();
        this.fireValueChanged(ParcelFilterPatternRelationModelEnum.PARAMETERS, null, null);
        for (ParcelFilterPatternParameterModel oldParameter : oldParameters) {
            if (oldParameter == null) continue;
            oldParameter.setRelation(null);
            oldParameter.setSortOrder(null);
        }
    }

    @Override
    public boolean isParametersEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.parameters == null) {
            this.parameters = new ArrayList<ParcelFilterPatternParameterModel>();
            if (this.getId() != null) {
                Collection parametersCollection = this.commonCaller.fetchChildren(this, ParcelFilterPatternRelationModelEnum.PARAMETERS.getPropertyName());
                this.parameters.addAll(parametersCollection);
            }
        }
        return this.parameters.isEmpty();
    }

    @Override
    public boolean containsParameter(ParcelFilterPatternParameterModel parameter) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.parameters == null) {
            this.parameters = new ArrayList<ParcelFilterPatternParameterModel>();
            if (this.getId() != null) {
                Collection parametersCollection = this.commonCaller.fetchChildren(this, ParcelFilterPatternRelationModelEnum.PARAMETERS.getPropertyName());
                this.parameters.addAll(parametersCollection);
            }
        }
        return this.parameters.contains(parameter);
    }

    @Override
    public int indexOfParameter(ParcelFilterPatternParameterModel parameter) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.parameters == null) {
            this.parameters = new ArrayList<ParcelFilterPatternParameterModel>();
            if (this.getId() != null) {
                Collection parametersCollection = this.commonCaller.fetchChildren(this, ParcelFilterPatternRelationModelEnum.PARAMETERS.getPropertyName());
                this.parameters.addAll(parametersCollection);
            }
        }
        return this.parameters.indexOf(parameter);
    }

    @Override
    public boolean isParametersInitialized() {
        return this.parameters != null;
    }

    private void reorderParameters(int startIndex) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.parameters == null) {
            this.parameters = new ArrayList<ParcelFilterPatternParameterModel>();
            if (this.getId() != null) {
                Collection parametersCollection = this.commonCaller.fetchChildren(this, ParcelFilterPatternRelationModelEnum.PARAMETERS.getPropertyName());
                this.parameters.addAll(parametersCollection);
            }
        }
        ListIterator<ParcelFilterPatternParameterModel> listIterator = this.parameters.listIterator(startIndex);
        int index = startIndex;
        while (listIterator.hasNext()) {
            ParcelFilterPatternParameterModel parameter = listIterator.next();
            parameter.setSortOrder(index++);
        }
    }

    @Override
    public void setProxy(boolean proxy) {
        super.setProxy(proxy);
        if (proxy) {
            this.parameters = null;
        }
    }

    @Override
    protected void updateByDto(ParcelFilterPatternRelationFullDto parcelFilterPatternRelationDto) {
        this.patternSetup = (ParcelFilterPatternSetupModel)this.getModelCache().getModel(parcelFilterPatternRelationDto.getPatternSetup());
        this.rendererType = parcelFilterPatternRelationDto.getRendererType();
        this.sortOrder = parcelFilterPatternRelationDto.getSortOrder();
        ParcelFilterPatternParameterDto[] parameters = parcelFilterPatternRelationDto.getParameters();
        if (parameters != null) {
            if (this.parameters == null) {
                this.parameters = new ArrayList<ParcelFilterPatternParameterModel>();
            } else {
                this.parameters.clear();
            }
        }
    }

    @Override
    protected void updateMasterRelationsByDto(ParcelFilterPatternRelationFullDto parcelFilterPatternRelationDto) {
        ParcelFilterPatternParameterDto[] parameters = parcelFilterPatternRelationDto.getParameters();
        if (parameters != null) {
            if (this.parameters == null) {
                this.parameters = new ArrayList<ParcelFilterPatternParameterModel>();
            } else {
                this.parameters.clear();
            }
            for (ParcelFilterPatternParameterDto parameterDto : parameters) {
                ParcelFilterPatternParameterModel parameterModel = (ParcelFilterPatternParameterModel)this.getModelCache().getModel(parameterDto);
                this.parameters.add(parameterModel);
            }
        } else {
            this.parameters = null;
        }
    }

    @Override
    protected void checkStaleByDto(ParcelFilterPatternRelationFullDto parcelFilterPatternRelationDto) throws StaleStateException {
        ParcelFilterPatternParameterDto[] parameterDtos;
        ParcelFilterPatternSetupModelImpl patternSetupModel;
        ParcelFilterPatternSetupDto patternSetupDto = parcelFilterPatternRelationDto.getPatternSetup();
        if (patternSetupDto != null && patternSetupDto.getId() != null && (patternSetupModel = (ParcelFilterPatternSetupModelImpl)this.getModelCache().getModel(ParcelFilterPatternSetupModel.class, patternSetupDto.getId())) != null) {
            patternSetupModel.checkStaleState(patternSetupDto);
        }
        if ((parameterDtos = parcelFilterPatternRelationDto.getParameters()) != null) {
            for (ParcelFilterPatternParameterDto parameterDto : parameterDtos) {
                ParcelFilterPatternParameterModelImpl parameterModel = (ParcelFilterPatternParameterModelImpl)this.getModelCache().getModel(ParcelFilterPatternParameterModel.class, parameterDto.getId());
                if (parameterModel == null) continue;
                parameterModel.checkStaleState(parameterDto);
            }
        }
    }

    @Override
    public ParcelFilterPatternRelationFullDto createDto() {
        Long id = this.getId();
        ParcelFilterPatternRelationFullDto parcelFilterPatternRelationDto = id == null ? new ParcelFilterPatternRelationFullDto(this.getTempUUID()) : new ParcelFilterPatternRelationFullDto(id, this.getVersion());
        ParcelFilterPatternSetupModelImpl patternSetup = (ParcelFilterPatternSetupModelImpl)this.getPatternSetup();
        if (patternSetup != null) {
            parcelFilterPatternRelationDto.setPatternSetup(patternSetup.createProxy());
        }
        parcelFilterPatternRelationDto.setRendererType(this.getRendererType());
        parcelFilterPatternRelationDto.setSortOrder(this.getSortOrder());
        return parcelFilterPatternRelationDto;
    }

    @Override
    public ParcelFilterPatternRelationProxyDto createProxy() {
        Long id = this.getId();
        ParcelFilterPatternRelationProxyDto parcelFilterPatternRelationDto = id == null ? new ParcelFilterPatternRelationProxyDto(this.getTempUUID()) : new ParcelFilterPatternRelationProxyDto(id, this.getVersion());
        return parcelFilterPatternRelationDto;
    }

    public static enum ParcelFilterPatternRelationModelEnum {
        PATTERN_SETUP("patternSetup"),
        RENDERER_TYPE("rendererType"),
        SORT_ORDER("sortOrder"),
        PARAMETERS("parameters");

        private String propertyName;

        private ParcelFilterPatternRelationModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

