/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.map;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.map.CityModel;
import de.datomino.peppergis.client.model.map.CityModelImpl;
import de.datomino.peppergis.client.model.map.DistrictAliasModel;
import de.datomino.peppergis.client.model.map.DistrictAliasModelImpl;
import de.datomino.peppergis.client.model.map.DistrictModel;
import de.datomino.peppergis.client.model.map.PostcodeDistrictRelationModel;
import de.datomino.peppergis.client.model.map.PostcodeDistrictRelationModelImpl;
import de.datomino.peppergis.dto.map.CityDto;
import de.datomino.peppergis.dto.map.DistrictAliasDto;
import de.datomino.peppergis.dto.map.DistrictFullDto;
import de.datomino.peppergis.dto.map.DistrictProxyDto;
import de.datomino.peppergis.dto.map.PostcodeDistrictRelationDto;
import de.datomino.peppergis.exception.StaleStateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;
import org.ktde.util.conversions.ImmutableIterator;
import org.ktde.util.conversions.IteratorIterable;

public class DistrictModelImpl
extends AbstractModel<DistrictFullDto, DistrictProxyDto>
implements DistrictModel {
    private String name;
    private CityModel city;
    private Set<PostcodeDistrictRelationModel> postcodes = null;
    private Set<DistrictAliasModel> alias = null;

    public DistrictModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public DistrictModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public String getName() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.setName(name, true);
    }

    private void setName(String name, boolean setDirty) {
        String oldName = this.getName();
        if (new EqualsBuilder().append(oldName, name).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, DistrictModelEnum.NAME.getPropertyName());
        }
        this.name = name;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(DistrictModelEnum.NAME, name, oldName);
    }

    @Override
    public CityModel getCity() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.city;
    }

    @Override
    public void setCity(CityModel city) {
        this.setCity(city, true);
    }

    private void setCity(CityModel city, boolean setDirty) {
        CityModel oldCity = this.getCity();
        if (oldCity == city) {
            return;
        }
        if (oldCity != null) {
            oldCity.removeADistrict(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, DistrictModelEnum.CITY.getPropertyName());
        }
        this.city = city;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(DistrictModelEnum.CITY, city, oldCity);
        if (this.city != null) {
            this.city.addADistrict(this);
        }
    }

    @Override
    public int countPostcodes() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.postcodes == null) {
            this.postcodes = new LinkedHashSet<PostcodeDistrictRelationModel>();
            if (this.getId() != null) {
                Collection postcodesCollection = this.commonCaller.fetchChildren(this, DistrictModelEnum.POSTCODES.getPropertyName());
                this.postcodes.addAll(postcodesCollection);
            }
        }
        return this.postcodes.size();
    }

    @Override
    public Iterator<PostcodeDistrictRelationModel> iteratePostcodes() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.postcodes == null) {
            this.postcodes = new LinkedHashSet<PostcodeDistrictRelationModel>();
            if (this.getId() != null) {
                Collection postcodesCollection = this.commonCaller.fetchChildren(this, DistrictModelEnum.POSTCODES.getPropertyName());
                this.postcodes.addAll(postcodesCollection);
            }
        }
        return new ImmutableIterator<PostcodeDistrictRelationModel>(this.postcodes);
    }

    @Override
    public Iterable<PostcodeDistrictRelationModel> iterablePostcodes() {
        return new IteratorIterable<PostcodeDistrictRelationModel>(this.iteratePostcodes());
    }

    @Override
    public void addPostcode(PostcodeDistrictRelationModel postcode) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.postcodes == null) {
            this.postcodes = new LinkedHashSet<PostcodeDistrictRelationModel>();
            if (this.getId() != null) {
                Collection postcodesCollection = this.commonCaller.fetchChildren(this, DistrictModelEnum.POSTCODES.getPropertyName());
                this.postcodes.addAll(postcodesCollection);
            }
        }
        if (this.postcodes.contains(postcode)) {
            return;
        }
        this.postcodes.add(postcode);
        this.fireValueChanged(DistrictModelEnum.POSTCODES, postcode, null);
        if (postcode != null) {
            postcode.setDistrict(this);
        }
    }

    @Override
    public void removePostcode(PostcodeDistrictRelationModel postcode) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.postcodes == null) {
            this.postcodes = new LinkedHashSet<PostcodeDistrictRelationModel>();
            if (this.getId() != null) {
                Collection postcodesCollection = this.commonCaller.fetchChildren(this, DistrictModelEnum.POSTCODES.getPropertyName());
                this.postcodes.addAll(postcodesCollection);
            }
        }
        if (!this.postcodes.contains(postcode)) {
            return;
        }
        this.postcodes.remove(postcode);
        this.fireValueChanged(DistrictModelEnum.POSTCODES, postcode, null);
        if (postcode != null) {
            postcode.setDistrict(null);
        }
    }

    @Override
    public void clearPostcodes() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.postcodes == null) {
            this.postcodes = new LinkedHashSet<PostcodeDistrictRelationModel>();
            if (this.getId() != null) {
                Collection postcodesCollection = this.commonCaller.fetchChildren(this, DistrictModelEnum.POSTCODES.getPropertyName());
                this.postcodes.addAll(postcodesCollection);
            }
        }
        ArrayList<PostcodeDistrictRelationModel> oldPostcodes = new ArrayList<PostcodeDistrictRelationModel>(this.postcodes);
        this.postcodes.clear();
        this.fireValueChanged(DistrictModelEnum.POSTCODES, null, null);
        for (PostcodeDistrictRelationModel oldPostcode : oldPostcodes) {
            if (oldPostcode == null) continue;
            oldPostcode.setDistrict(null);
        }
    }

    @Override
    public boolean isPostcodesEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.postcodes == null) {
            this.postcodes = new LinkedHashSet<PostcodeDistrictRelationModel>();
            if (this.getId() != null) {
                Collection postcodesCollection = this.commonCaller.fetchChildren(this, DistrictModelEnum.POSTCODES.getPropertyName());
                this.postcodes.addAll(postcodesCollection);
            }
        }
        return this.postcodes.isEmpty();
    }

    @Override
    public boolean containsPostcode(PostcodeDistrictRelationModel postcode) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.postcodes == null) {
            this.postcodes = new LinkedHashSet<PostcodeDistrictRelationModel>();
            if (this.getId() != null) {
                Collection postcodesCollection = this.commonCaller.fetchChildren(this, DistrictModelEnum.POSTCODES.getPropertyName());
                this.postcodes.addAll(postcodesCollection);
            }
        }
        return this.postcodes.contains(postcode);
    }

    @Override
    public boolean isPostcodesInitialized() {
        return this.postcodes != null;
    }

    @Override
    public int countAlias() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.alias == null) {
            this.alias = new LinkedHashSet<DistrictAliasModel>();
            if (this.getId() != null) {
                Collection aliasCollection = this.commonCaller.fetchChildren(this, DistrictModelEnum.ALIAS.getPropertyName());
                this.alias.addAll(aliasCollection);
            }
        }
        return this.alias.size();
    }

    @Override
    public Iterator<DistrictAliasModel> iterateAlias() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.alias == null) {
            this.alias = new LinkedHashSet<DistrictAliasModel>();
            if (this.getId() != null) {
                Collection aliasCollection = this.commonCaller.fetchChildren(this, DistrictModelEnum.ALIAS.getPropertyName());
                this.alias.addAll(aliasCollection);
            }
        }
        return new ImmutableIterator<DistrictAliasModel>(this.alias);
    }

    @Override
    public Iterable<DistrictAliasModel> iterableAlias() {
        return new IteratorIterable<DistrictAliasModel>(this.iterateAlias());
    }

    @Override
    public void addAlia(DistrictAliasModel alia) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.alias == null) {
            this.alias = new LinkedHashSet<DistrictAliasModel>();
            if (this.getId() != null) {
                Collection aliasCollection = this.commonCaller.fetchChildren(this, DistrictModelEnum.ALIAS.getPropertyName());
                this.alias.addAll(aliasCollection);
            }
        }
        if (this.alias.contains(alia)) {
            return;
        }
        this.alias.add(alia);
        this.fireValueChanged(DistrictModelEnum.ALIAS, alia, null);
        if (alia != null) {
            alia.setDistrict(this);
        }
    }

    @Override
    public void removeAlia(DistrictAliasModel alia) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.alias == null) {
            this.alias = new LinkedHashSet<DistrictAliasModel>();
            if (this.getId() != null) {
                Collection aliasCollection = this.commonCaller.fetchChildren(this, DistrictModelEnum.ALIAS.getPropertyName());
                this.alias.addAll(aliasCollection);
            }
        }
        if (!this.alias.contains(alia)) {
            return;
        }
        this.alias.remove(alia);
        this.fireValueChanged(DistrictModelEnum.ALIAS, alia, null);
        if (alia != null) {
            alia.setDistrict(null);
        }
    }

    @Override
    public void clearAlias() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.alias == null) {
            this.alias = new LinkedHashSet<DistrictAliasModel>();
            if (this.getId() != null) {
                Collection aliasCollection = this.commonCaller.fetchChildren(this, DistrictModelEnum.ALIAS.getPropertyName());
                this.alias.addAll(aliasCollection);
            }
        }
        ArrayList<DistrictAliasModel> oldAlias = new ArrayList<DistrictAliasModel>(this.alias);
        this.alias.clear();
        this.fireValueChanged(DistrictModelEnum.ALIAS, null, null);
        for (DistrictAliasModel oldAlia : oldAlias) {
            if (oldAlia == null) continue;
            oldAlia.setDistrict(null);
        }
    }

    @Override
    public boolean isAliasEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.alias == null) {
            this.alias = new LinkedHashSet<DistrictAliasModel>();
            if (this.getId() != null) {
                Collection aliasCollection = this.commonCaller.fetchChildren(this, DistrictModelEnum.ALIAS.getPropertyName());
                this.alias.addAll(aliasCollection);
            }
        }
        return this.alias.isEmpty();
    }

    @Override
    public boolean containsAlia(DistrictAliasModel alia) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.alias == null) {
            this.alias = new LinkedHashSet<DistrictAliasModel>();
            if (this.getId() != null) {
                Collection aliasCollection = this.commonCaller.fetchChildren(this, DistrictModelEnum.ALIAS.getPropertyName());
                this.alias.addAll(aliasCollection);
            }
        }
        return this.alias.contains(alia);
    }

    @Override
    public boolean isAliasInitialized() {
        return this.alias != null;
    }

    @Override
    public void setProxy(boolean proxy) {
        super.setProxy(proxy);
        if (proxy) {
            this.postcodes = null;
            this.alias = null;
        }
    }

    @Override
    protected void updateByDto(DistrictFullDto districtDto) {
        DistrictAliasDto[] alias;
        this.name = districtDto.getName();
        this.city = (CityModel)this.getModelCache().getModel(districtDto.getCity());
        PostcodeDistrictRelationDto[] postcodes = districtDto.getPostcodes();
        if (postcodes != null) {
            if (this.postcodes == null) {
                this.postcodes = new LinkedHashSet<PostcodeDistrictRelationModel>();
            } else {
                this.postcodes.clear();
            }
        }
        if ((alias = districtDto.getAlias()) != null) {
            if (this.alias == null) {
                this.alias = new LinkedHashSet<DistrictAliasModel>();
            } else {
                this.alias.clear();
            }
        }
    }

    @Override
    protected void updateMasterRelationsByDto(DistrictFullDto districtDto) {
        DistrictAliasDto[] alias;
        PostcodeDistrictRelationDto[] postcodes = districtDto.getPostcodes();
        if (postcodes != null) {
            if (this.postcodes == null) {
                this.postcodes = new LinkedHashSet<PostcodeDistrictRelationModel>();
            } else {
                this.postcodes.clear();
            }
            for (PostcodeDistrictRelationDto postcodeDto : postcodes) {
                PostcodeDistrictRelationModel postcodeModel = (PostcodeDistrictRelationModel)this.getModelCache().getModel(postcodeDto);
                this.postcodes.add(postcodeModel);
            }
        } else {
            this.postcodes = null;
        }
        if ((alias = districtDto.getAlias()) != null) {
            if (this.alias == null) {
                this.alias = new LinkedHashSet<DistrictAliasModel>();
            } else {
                this.alias.clear();
            }
            for (DistrictAliasDto aliaDto : alias) {
                DistrictAliasModel aliaModel = (DistrictAliasModel)this.getModelCache().getModel(aliaDto);
                this.alias.add(aliaModel);
            }
        } else {
            this.alias = null;
        }
    }

    @Override
    protected void checkStaleByDto(DistrictFullDto districtDto) throws StaleStateException {
        DistrictAliasDto[] aliaDtos;
        PostcodeDistrictRelationDto[] postcodeDtos;
        CityModelImpl cityModel;
        CityDto cityDto = districtDto.getCity();
        if (cityDto != null && cityDto.getId() != null && (cityModel = (CityModelImpl)this.getModelCache().getModel(CityModel.class, cityDto.getId())) != null) {
            cityModel.checkStaleState(cityDto);
        }
        if ((postcodeDtos = districtDto.getPostcodes()) != null) {
            for (PostcodeDistrictRelationDto postcodeDto : postcodeDtos) {
                PostcodeDistrictRelationModelImpl postcodeModel = (PostcodeDistrictRelationModelImpl)this.getModelCache().getModel(PostcodeDistrictRelationModel.class, postcodeDto.getId());
                if (postcodeModel == null) continue;
                postcodeModel.checkStaleState(postcodeDto);
            }
        }
        if ((aliaDtos = districtDto.getAlias()) != null) {
            for (DistrictAliasDto aliaDto : aliaDtos) {
                DistrictAliasModelImpl aliaModel = (DistrictAliasModelImpl)this.getModelCache().getModel(DistrictAliasModel.class, aliaDto.getId());
                if (aliaModel == null) continue;
                aliaModel.checkStaleState(aliaDto);
            }
        }
    }

    @Override
    public DistrictFullDto createDto() {
        Long id = this.getId();
        DistrictFullDto districtDto = id == null ? new DistrictFullDto(this.getTempUUID()) : new DistrictFullDto(id, this.getVersion());
        districtDto.setName(this.getName());
        CityModelImpl city = (CityModelImpl)this.getCity();
        if (city != null) {
            districtDto.setCity(city.createProxy());
        }
        return districtDto;
    }

    @Override
    public DistrictProxyDto createProxy() {
        Long id = this.getId();
        DistrictProxyDto districtDto = id == null ? new DistrictProxyDto(this.getTempUUID()) : new DistrictProxyDto(id, this.getVersion());
        return districtDto;
    }

    public static enum DistrictModelEnum {
        NAME("name"),
        CITY("city"),
        POSTCODES("postcodes"),
        ALIAS("alias");

        private String propertyName;

        private DistrictModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

