/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.filter;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.area.AreaObjectModelImpl;
import de.datomino.peppergis.client.model.filter.SubscriptionFilterAreaRelationModel;
import de.datomino.peppergis.client.model.filter.SubscriptionFilterModel;
import de.datomino.peppergis.client.model.filter.SubscriptionFilterModelImpl;
import de.datomino.peppergis.dto.area.AreaObjectDto;
import de.datomino.peppergis.dto.filter.SubscriptionFilterAreaRelationFullDto;
import de.datomino.peppergis.dto.filter.SubscriptionFilterAreaRelationProxyDto;
import de.datomino.peppergis.dto.filter.SubscriptionFilterDto;
import de.datomino.peppergis.exception.StaleStateException;
import org.ktde.util.cache.ChangeSet;

public class SubscriptionFilterAreaRelationModelImpl
extends AbstractModel<SubscriptionFilterAreaRelationFullDto, SubscriptionFilterAreaRelationProxyDto>
implements SubscriptionFilterAreaRelationModel {
    private AreaObjectModel areaObject;
    private SubscriptionFilterModel subscriptionFilter;

    public SubscriptionFilterAreaRelationModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public SubscriptionFilterAreaRelationModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public AreaObjectModel getAreaObject() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.areaObject;
    }

    @Override
    public void setAreaObject(AreaObjectModel areaObject) {
        this.setAreaObject(areaObject, true);
    }

    private void setAreaObject(AreaObjectModel areaObject, boolean setDirty) {
        AreaObjectModel oldAreaObject = this.getAreaObject();
        if (oldAreaObject == areaObject) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, SubscriptionFilterAreaRelationModelEnum.AREA_OBJECT.getPropertyName());
        }
        this.areaObject = areaObject;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(SubscriptionFilterAreaRelationModelEnum.AREA_OBJECT, areaObject, oldAreaObject);
    }

    @Override
    public SubscriptionFilterModel getSubscriptionFilter() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.subscriptionFilter;
    }

    @Override
    public void setSubscriptionFilter(SubscriptionFilterModel subscriptionFilter) {
        this.setSubscriptionFilter(subscriptionFilter, true);
    }

    private void setSubscriptionFilter(SubscriptionFilterModel subscriptionFilter, boolean setDirty) {
        SubscriptionFilterModel oldSubscriptionFilter = this.getSubscriptionFilter();
        if (oldSubscriptionFilter == subscriptionFilter) {
            return;
        }
        if (oldSubscriptionFilter != null) {
            oldSubscriptionFilter.removeASubscriptionFilterAreaRelation(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, SubscriptionFilterAreaRelationModelEnum.SUBSCRIPTION_FILTER.getPropertyName());
        }
        this.subscriptionFilter = subscriptionFilter;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(SubscriptionFilterAreaRelationModelEnum.SUBSCRIPTION_FILTER, subscriptionFilter, oldSubscriptionFilter);
        if (this.subscriptionFilter != null) {
            this.subscriptionFilter.addASubscriptionFilterAreaRelation(this);
        }
    }

    @Override
    protected void updateByDto(SubscriptionFilterAreaRelationFullDto subscriptionFilterAreaRelationDto) {
        this.areaObject = (AreaObjectModel)this.getModelCache().getModel(subscriptionFilterAreaRelationDto.getAreaObject());
        this.subscriptionFilter = (SubscriptionFilterModel)this.getModelCache().getModel(subscriptionFilterAreaRelationDto.getSubscriptionFilter());
    }

    @Override
    protected void updateMasterRelationsByDto(SubscriptionFilterAreaRelationFullDto subscriptionFilterAreaRelationDto) {
    }

    @Override
    protected void checkStaleByDto(SubscriptionFilterAreaRelationFullDto subscriptionFilterAreaRelationDto) throws StaleStateException {
        SubscriptionFilterModelImpl subscriptionFilterModel;
        SubscriptionFilterDto subscriptionFilterDto;
        AreaObjectModelImpl areaObjectModel;
        AreaObjectDto areaObjectDto = subscriptionFilterAreaRelationDto.getAreaObject();
        if (areaObjectDto != null && areaObjectDto.getId() != null && (areaObjectModel = (AreaObjectModelImpl)this.getModelCache().getModel(AreaObjectModel.class, areaObjectDto.getId())) != null) {
            areaObjectModel.checkStaleState(areaObjectDto);
        }
        if ((subscriptionFilterDto = subscriptionFilterAreaRelationDto.getSubscriptionFilter()) != null && subscriptionFilterDto.getId() != null && (subscriptionFilterModel = (SubscriptionFilterModelImpl)this.getModelCache().getModel(SubscriptionFilterModel.class, subscriptionFilterDto.getId())) != null) {
            subscriptionFilterModel.checkStaleState(subscriptionFilterDto);
        }
    }

    @Override
    public SubscriptionFilterAreaRelationFullDto createDto() {
        SubscriptionFilterModelImpl subscriptionFilter;
        Long id = this.getId();
        SubscriptionFilterAreaRelationFullDto subscriptionFilterAreaRelationDto = id == null ? new SubscriptionFilterAreaRelationFullDto(this.getTempUUID()) : new SubscriptionFilterAreaRelationFullDto(id, this.getVersion());
        AreaObjectModelImpl areaObject = (AreaObjectModelImpl)this.getAreaObject();
        if (areaObject != null) {
            subscriptionFilterAreaRelationDto.setAreaObject(areaObject.createProxy());
        }
        if ((subscriptionFilter = (SubscriptionFilterModelImpl)this.getSubscriptionFilter()) != null) {
            subscriptionFilterAreaRelationDto.setSubscriptionFilter(subscriptionFilter.createProxy());
        }
        return subscriptionFilterAreaRelationDto;
    }

    @Override
    public SubscriptionFilterAreaRelationProxyDto createProxy() {
        Long id = this.getId();
        SubscriptionFilterAreaRelationProxyDto subscriptionFilterAreaRelationDto = id == null ? new SubscriptionFilterAreaRelationProxyDto(this.getTempUUID()) : new SubscriptionFilterAreaRelationProxyDto(id, this.getVersion());
        return subscriptionFilterAreaRelationDto;
    }

    public static enum SubscriptionFilterAreaRelationModelEnum {
        AREA_OBJECT("areaObject"),
        SUBSCRIPTION_FILTER("subscriptionFilter");

        private String propertyName;

        private SubscriptionFilterAreaRelationModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

