/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.filter;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.filter.AttributeValueFilterModel;
import de.datomino.peppergis.client.model.filter.AttributeValueFilterModelImpl;
import de.datomino.peppergis.client.model.filter.ParcelFilterModel;
import de.datomino.peppergis.dto.filter.AttributeValueFilterDto;
import de.datomino.peppergis.dto.filter.ParcelFilterFullDto;
import de.datomino.peppergis.dto.filter.ParcelFilterProxyDto;
import de.datomino.peppergis.exception.StaleStateException;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;

public class ParcelFilterModelImpl
extends AbstractModel<ParcelFilterFullDto, ParcelFilterProxyDto>
implements ParcelFilterModel {
    private String name;
    private AttributeValueFilterModel attributeValueFilter;
    private Boolean modifiable;

    public ParcelFilterModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public ParcelFilterModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public String getName() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.setName(name, true);
    }

    private void setName(String name, boolean setDirty) {
        String oldName = this.getName();
        if (new EqualsBuilder().append(oldName, name).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ParcelFilterModelEnum.NAME.getPropertyName());
        }
        this.name = name;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ParcelFilterModelEnum.NAME, name, oldName);
    }

    @Override
    public AttributeValueFilterModel getAttributeValueFilter() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.attributeValueFilter;
    }

    @Override
    public void setAttributeValueFilter(AttributeValueFilterModel attributeValueFilter) {
        this.setAttributeValueFilter(attributeValueFilter, true);
    }

    private void setAttributeValueFilter(AttributeValueFilterModel attributeValueFilter, boolean setDirty) {
        AttributeValueFilterModel oldAttributeValueFilter = this.getAttributeValueFilter();
        if (oldAttributeValueFilter == attributeValueFilter) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ParcelFilterModelEnum.ATTRIBUTE_VALUE_FILTER.getPropertyName());
        }
        this.attributeValueFilter = attributeValueFilter;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ParcelFilterModelEnum.ATTRIBUTE_VALUE_FILTER, attributeValueFilter, oldAttributeValueFilter);
    }

    @Override
    public Boolean getModifiable() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.modifiable;
    }

    @Override
    public void setModifiable(Boolean modifiable) {
        this.setModifiable(modifiable, true);
    }

    private void setModifiable(Boolean modifiable, boolean setDirty) {
        Boolean oldModifiable = this.getModifiable();
        if (new EqualsBuilder().append(oldModifiable, modifiable).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ParcelFilterModelEnum.MODIFIABLE.getPropertyName());
        }
        this.modifiable = modifiable;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ParcelFilterModelEnum.MODIFIABLE, modifiable, oldModifiable);
    }

    @Override
    protected void updateByDto(ParcelFilterFullDto parcelFilterDto) {
        this.name = parcelFilterDto.getName();
        this.attributeValueFilter = (AttributeValueFilterModel)this.getModelCache().getModel(parcelFilterDto.getAttributeValueFilter());
        this.modifiable = parcelFilterDto.getModifiable();
    }

    @Override
    protected void updateMasterRelationsByDto(ParcelFilterFullDto parcelFilterDto) {
    }

    @Override
    protected void checkStaleByDto(ParcelFilterFullDto parcelFilterDto) throws StaleStateException {
        AttributeValueFilterModelImpl attributeValueFilterModel;
        AttributeValueFilterDto attributeValueFilterDto = parcelFilterDto.getAttributeValueFilter();
        if (attributeValueFilterDto != null && attributeValueFilterDto.getId() != null && (attributeValueFilterModel = (AttributeValueFilterModelImpl)this.getModelCache().getModel(AttributeValueFilterModel.class, attributeValueFilterDto.getId())) != null) {
            attributeValueFilterModel.checkStaleState(attributeValueFilterDto);
        }
    }

    @Override
    public ParcelFilterFullDto createDto() {
        Long id = this.getId();
        ParcelFilterFullDto parcelFilterDto = id == null ? new ParcelFilterFullDto(this.getTempUUID()) : new ParcelFilterFullDto(id, this.getVersion());
        parcelFilterDto.setName(this.getName());
        AttributeValueFilterModelImpl attributeValueFilter = (AttributeValueFilterModelImpl)this.getAttributeValueFilter();
        if (attributeValueFilter != null) {
            parcelFilterDto.setAttributeValueFilter(attributeValueFilter.createProxy());
        }
        parcelFilterDto.setModifiable(this.getModifiable());
        return parcelFilterDto;
    }

    @Override
    public ParcelFilterProxyDto createProxy() {
        Long id = this.getId();
        ParcelFilterProxyDto parcelFilterDto = id == null ? new ParcelFilterProxyDto(this.getTempUUID()) : new ParcelFilterProxyDto(id, this.getVersion());
        return parcelFilterDto;
    }

    public static enum ParcelFilterModelEnum {
        NAME("name"),
        ATTRIBUTE_VALUE_FILTER("attributeValueFilter"),
        MODIFIABLE("modifiable");

        private String propertyName;

        private ParcelFilterModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

