/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.filter;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.filter.AreaFilterModel;
import de.datomino.peppergis.client.model.filter.AttributeValueFilterModel;
import de.datomino.peppergis.client.model.filter.AttributeValueFilterModelImpl;
import de.datomino.peppergis.dto.filter.AreaFilterFullDto;
import de.datomino.peppergis.dto.filter.AreaFilterProxyDto;
import de.datomino.peppergis.dto.filter.AttributeValueFilterDto;
import de.datomino.peppergis.exception.StaleStateException;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;

public class AreaFilterModelImpl
extends AbstractModel<AreaFilterFullDto, AreaFilterProxyDto>
implements AreaFilterModel {
    private String name;
    private String shortCut;
    private AttributeValueFilterModel attributeValueFilter;
    private Boolean modifiable;

    public AreaFilterModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public AreaFilterModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public String getName() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.setName(name, true);
    }

    private void setName(String name, boolean setDirty) {
        String oldName = this.getName();
        if (new EqualsBuilder().append(oldName, name).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaFilterModelEnum.NAME.getPropertyName());
        }
        this.name = name;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaFilterModelEnum.NAME, name, oldName);
    }

    @Override
    public String getShortCut() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.shortCut;
    }

    @Override
    public void setShortCut(String shortCut) {
        this.setShortCut(shortCut, true);
    }

    private void setShortCut(String shortCut, boolean setDirty) {
        String oldShortCut = this.getShortCut();
        if (new EqualsBuilder().append(oldShortCut, shortCut).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaFilterModelEnum.SHORT_CUT.getPropertyName());
        }
        this.shortCut = shortCut;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaFilterModelEnum.SHORT_CUT, shortCut, oldShortCut);
    }

    @Override
    public AttributeValueFilterModel getAttributeValueFilter() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.attributeValueFilter;
    }

    @Override
    public void setAttributeValueFilter(AttributeValueFilterModel attributeValueFilter) {
        this.setAttributeValueFilter(attributeValueFilter, true);
    }

    private void setAttributeValueFilter(AttributeValueFilterModel attributeValueFilter, boolean setDirty) {
        AttributeValueFilterModel oldAttributeValueFilter = this.getAttributeValueFilter();
        if (oldAttributeValueFilter == attributeValueFilter) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaFilterModelEnum.ATTRIBUTE_VALUE_FILTER.getPropertyName());
        }
        this.attributeValueFilter = attributeValueFilter;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaFilterModelEnum.ATTRIBUTE_VALUE_FILTER, attributeValueFilter, oldAttributeValueFilter);
    }

    @Override
    public Boolean getModifiable() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.modifiable;
    }

    @Override
    public void setModifiable(Boolean modifiable) {
        this.setModifiable(modifiable, true);
    }

    private void setModifiable(Boolean modifiable, boolean setDirty) {
        Boolean oldModifiable = this.getModifiable();
        if (new EqualsBuilder().append(oldModifiable, modifiable).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AreaFilterModelEnum.MODIFIABLE.getPropertyName());
        }
        this.modifiable = modifiable;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AreaFilterModelEnum.MODIFIABLE, modifiable, oldModifiable);
    }

    @Override
    protected void updateByDto(AreaFilterFullDto areaFilterDto) {
        this.name = areaFilterDto.getName();
        this.shortCut = areaFilterDto.getShortCut();
        this.attributeValueFilter = (AttributeValueFilterModel)this.getModelCache().getModel(areaFilterDto.getAttributeValueFilter());
        this.modifiable = areaFilterDto.getModifiable();
    }

    @Override
    protected void updateMasterRelationsByDto(AreaFilterFullDto areaFilterDto) {
    }

    @Override
    protected void checkStaleByDto(AreaFilterFullDto areaFilterDto) throws StaleStateException {
        AttributeValueFilterModelImpl attributeValueFilterModel;
        AttributeValueFilterDto attributeValueFilterDto = areaFilterDto.getAttributeValueFilter();
        if (attributeValueFilterDto != null && attributeValueFilterDto.getId() != null && (attributeValueFilterModel = (AttributeValueFilterModelImpl)this.getModelCache().getModel(AttributeValueFilterModel.class, attributeValueFilterDto.getId())) != null) {
            attributeValueFilterModel.checkStaleState(attributeValueFilterDto);
        }
    }

    @Override
    public AreaFilterFullDto createDto() {
        Long id = this.getId();
        AreaFilterFullDto areaFilterDto = id == null ? new AreaFilterFullDto(this.getTempUUID()) : new AreaFilterFullDto(id, this.getVersion());
        areaFilterDto.setName(this.getName());
        areaFilterDto.setShortCut(this.getShortCut());
        AttributeValueFilterModelImpl attributeValueFilter = (AttributeValueFilterModelImpl)this.getAttributeValueFilter();
        if (attributeValueFilter != null) {
            areaFilterDto.setAttributeValueFilter(attributeValueFilter.createProxy());
        }
        areaFilterDto.setModifiable(this.getModifiable());
        return areaFilterDto;
    }

    @Override
    public AreaFilterProxyDto createProxy() {
        Long id = this.getId();
        AreaFilterProxyDto areaFilterDto = id == null ? new AreaFilterProxyDto(this.getTempUUID()) : new AreaFilterProxyDto(id, this.getVersion());
        return areaFilterDto;
    }

    public static enum AreaFilterModelEnum {
        NAME("name"),
        SHORT_CUT("shortCut"),
        ATTRIBUTE_VALUE_FILTER("attributeValueFilter"),
        MODIFIABLE("modifiable");

        private String propertyName;

        private AreaFilterModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

