/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.distance;

import de.datomino.logistic.type.RouteType;
import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.distance.GeoDistanceMatrix83Model;
import de.datomino.peppergis.dto.distance.GeoDistanceMatrix83FullDto;
import de.datomino.peppergis.dto.distance.GeoDistanceMatrix83ProxyDto;
import de.datomino.peppergis.exception.StaleStateException;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.dto.ImmutableLineStringDto;
import de.datomino.util.geo.dto.ImmutablePointDto;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;

public class GeoDistanceMatrix83ModelImpl
extends AbstractModel<GeoDistanceMatrix83FullDto, GeoDistanceMatrix83ProxyDto>
implements GeoDistanceMatrix83Model {
    private ImmutablePoint start;
    private ImmutablePoint target;
    private Integer distance;
    private Integer duration;
    private ImmutableLineString lineString;
    private RouteType routeType;
    private RouteVehicleType vehicleType;

    public GeoDistanceMatrix83ModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public GeoDistanceMatrix83ModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public ImmutablePoint getStart() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.start;
    }

    @Override
    public void setStart(ImmutablePoint start) {
        this.setStart(start, true);
    }

    private void setStart(ImmutablePoint start, boolean setDirty) {
        ImmutablePoint oldStart = this.getStart();
        if (new EqualsBuilder().append(oldStart, start).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, GeoDistanceMatrix83ModelEnum.START.getPropertyName());
        }
        this.start = start;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(GeoDistanceMatrix83ModelEnum.START, start, oldStart);
    }

    @Override
    public ImmutablePoint getTarget() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.target;
    }

    @Override
    public void setTarget(ImmutablePoint target) {
        this.setTarget(target, true);
    }

    private void setTarget(ImmutablePoint target, boolean setDirty) {
        ImmutablePoint oldTarget = this.getTarget();
        if (new EqualsBuilder().append(oldTarget, target).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, GeoDistanceMatrix83ModelEnum.TARGET.getPropertyName());
        }
        this.target = target;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(GeoDistanceMatrix83ModelEnum.TARGET, target, oldTarget);
    }

    @Override
    public Integer getDistance() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.distance;
    }

    @Override
    public void setDistance(Integer distance) {
        this.setDistance(distance, true);
    }

    private void setDistance(Integer distance, boolean setDirty) {
        Integer oldDistance = this.getDistance();
        if (new EqualsBuilder().append(oldDistance, distance).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, GeoDistanceMatrix83ModelEnum.DISTANCE.getPropertyName());
        }
        this.distance = distance;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(GeoDistanceMatrix83ModelEnum.DISTANCE, distance, oldDistance);
    }

    @Override
    public Integer getDuration() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.duration;
    }

    @Override
    public void setDuration(Integer duration) {
        this.setDuration(duration, true);
    }

    private void setDuration(Integer duration, boolean setDirty) {
        Integer oldDuration = this.getDuration();
        if (new EqualsBuilder().append(oldDuration, duration).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, GeoDistanceMatrix83ModelEnum.DURATION.getPropertyName());
        }
        this.duration = duration;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(GeoDistanceMatrix83ModelEnum.DURATION, duration, oldDuration);
    }

    @Override
    public ImmutableLineString getLineString() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.lineString;
    }

    @Override
    public void setLineString(ImmutableLineString lineString) {
        this.setLineString(lineString, true);
    }

    private void setLineString(ImmutableLineString lineString, boolean setDirty) {
        ImmutableLineString oldLineString = this.getLineString();
        if (new EqualsBuilder().append(oldLineString, lineString).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, GeoDistanceMatrix83ModelEnum.LINE_STRING.getPropertyName());
        }
        this.lineString = lineString;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(GeoDistanceMatrix83ModelEnum.LINE_STRING, lineString, oldLineString);
    }

    @Override
    public RouteType getRouteType() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.routeType;
    }

    @Override
    public void setRouteType(RouteType routeType) {
        this.setRouteType(routeType, true);
    }

    private void setRouteType(RouteType routeType, boolean setDirty) {
        RouteType oldRouteType = this.getRouteType();
        if (new EqualsBuilder().append((Object)oldRouteType, (Object)routeType).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, GeoDistanceMatrix83ModelEnum.ROUTE_TYPE.getPropertyName());
        }
        this.routeType = routeType;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(GeoDistanceMatrix83ModelEnum.ROUTE_TYPE, (Object)routeType, (Object)oldRouteType);
    }

    @Override
    public RouteVehicleType getVehicleType() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.vehicleType;
    }

    @Override
    public void setVehicleType(RouteVehicleType vehicleType) {
        this.setVehicleType(vehicleType, true);
    }

    private void setVehicleType(RouteVehicleType vehicleType, boolean setDirty) {
        RouteVehicleType oldVehicleType = this.getVehicleType();
        if (new EqualsBuilder().append((Object)oldVehicleType, (Object)vehicleType).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, GeoDistanceMatrix83ModelEnum.VEHICLE_TYPE.getPropertyName());
        }
        this.vehicleType = vehicleType;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(GeoDistanceMatrix83ModelEnum.VEHICLE_TYPE, (Object)vehicleType, (Object)oldVehicleType);
    }

    @Override
    protected void updateByDto(GeoDistanceMatrix83FullDto geoDistanceMatrix83Dto) {
        ImmutablePointDto start = geoDistanceMatrix83Dto.getStart();
        this.start = start == null ? null : (ImmutablePoint)start.getGeoObject();
        ImmutablePointDto target = geoDistanceMatrix83Dto.getTarget();
        this.target = target == null ? null : (ImmutablePoint)target.getGeoObject();
        this.distance = geoDistanceMatrix83Dto.getDistance();
        this.duration = geoDistanceMatrix83Dto.getDuration();
        ImmutableLineStringDto lineString = geoDistanceMatrix83Dto.getLineString();
        this.lineString = lineString == null ? null : (ImmutableLineString)lineString.getGeoObject();
        this.routeType = geoDistanceMatrix83Dto.getRouteType();
        this.vehicleType = geoDistanceMatrix83Dto.getVehicleType();
    }

    @Override
    protected void updateMasterRelationsByDto(GeoDistanceMatrix83FullDto geoDistanceMatrix83Dto) {
    }

    @Override
    protected void checkStaleByDto(GeoDistanceMatrix83FullDto geoDistanceMatrix83Dto) throws StaleStateException {
    }

    @Override
    public GeoDistanceMatrix83FullDto createDto() {
        Long id = this.getId();
        GeoDistanceMatrix83FullDto geoDistanceMatrix83Dto = id == null ? new GeoDistanceMatrix83FullDto(this.getTempUUID()) : new GeoDistanceMatrix83FullDto(id, this.getVersion());
        ImmutablePoint start = this.getStart();
        geoDistanceMatrix83Dto.setStart(ImmutablePointDto.create(start));
        ImmutablePoint target = this.getTarget();
        geoDistanceMatrix83Dto.setTarget(ImmutablePointDto.create(target));
        geoDistanceMatrix83Dto.setDistance(this.getDistance());
        geoDistanceMatrix83Dto.setDuration(this.getDuration());
        ImmutableLineString lineString = this.getLineString();
        geoDistanceMatrix83Dto.setLineString(ImmutableLineStringDto.create(lineString));
        geoDistanceMatrix83Dto.setRouteType(this.getRouteType());
        geoDistanceMatrix83Dto.setVehicleType(this.getVehicleType());
        return geoDistanceMatrix83Dto;
    }

    @Override
    public GeoDistanceMatrix83ProxyDto createProxy() {
        Long id = this.getId();
        GeoDistanceMatrix83ProxyDto geoDistanceMatrix83Dto = id == null ? new GeoDistanceMatrix83ProxyDto(this.getTempUUID()) : new GeoDistanceMatrix83ProxyDto(id, this.getVersion());
        return geoDistanceMatrix83Dto;
    }

    public static enum GeoDistanceMatrix83ModelEnum {
        START("start"),
        TARGET("target"),
        DISTANCE("distance"),
        DURATION("duration"),
        LINE_STRING("lineString"),
        ROUTE_TYPE("routeType"),
        VEHICLE_TYPE("vehicleType");

        private String propertyName;

        private GeoDistanceMatrix83ModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

