/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.distance;

import de.datomino.logistic.type.RouteType;
import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.distance.GeoDistanceMatrix62Model;
import de.datomino.peppergis.dto.distance.GeoDistanceMatrix62FullDto;
import de.datomino.peppergis.dto.distance.GeoDistanceMatrix62ProxyDto;
import de.datomino.peppergis.exception.StaleStateException;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.dto.ImmutableLineStringDto;
import de.datomino.util.geo.dto.ImmutablePointDto;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;

public class GeoDistanceMatrix62ModelImpl
extends AbstractModel<GeoDistanceMatrix62FullDto, GeoDistanceMatrix62ProxyDto>
implements GeoDistanceMatrix62Model {
    private ImmutablePoint start;
    private ImmutablePoint target;
    private Integer distance;
    private Integer duration;
    private ImmutableLineString lineString;
    private RouteType routeType;
    private RouteVehicleType vehicleType;

    public GeoDistanceMatrix62ModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public GeoDistanceMatrix62ModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public ImmutablePoint getStart() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.start;
    }

    @Override
    public void setStart(ImmutablePoint start) {
        this.setStart(start, true);
    }

    private void setStart(ImmutablePoint start, boolean setDirty) {
        ImmutablePoint oldStart = this.getStart();
        if (new EqualsBuilder().append(oldStart, start).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, GeoDistanceMatrix62ModelEnum.START.getPropertyName());
        }
        this.start = start;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(GeoDistanceMatrix62ModelEnum.START, start, oldStart);
    }

    @Override
    public ImmutablePoint getTarget() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.target;
    }

    @Override
    public void setTarget(ImmutablePoint target) {
        this.setTarget(target, true);
    }

    private void setTarget(ImmutablePoint target, boolean setDirty) {
        ImmutablePoint oldTarget = this.getTarget();
        if (new EqualsBuilder().append(oldTarget, target).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, GeoDistanceMatrix62ModelEnum.TARGET.getPropertyName());
        }
        this.target = target;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(GeoDistanceMatrix62ModelEnum.TARGET, target, oldTarget);
    }

    @Override
    public Integer getDistance() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.distance;
    }

    @Override
    public void setDistance(Integer distance) {
        this.setDistance(distance, true);
    }

    private void setDistance(Integer distance, boolean setDirty) {
        Integer oldDistance = this.getDistance();
        if (new EqualsBuilder().append(oldDistance, distance).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, GeoDistanceMatrix62ModelEnum.DISTANCE.getPropertyName());
        }
        this.distance = distance;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(GeoDistanceMatrix62ModelEnum.DISTANCE, distance, oldDistance);
    }

    @Override
    public Integer getDuration() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.duration;
    }

    @Override
    public void setDuration(Integer duration) {
        this.setDuration(duration, true);
    }

    private void setDuration(Integer duration, boolean setDirty) {
        Integer oldDuration = this.getDuration();
        if (new EqualsBuilder().append(oldDuration, duration).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, GeoDistanceMatrix62ModelEnum.DURATION.getPropertyName());
        }
        this.duration = duration;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(GeoDistanceMatrix62ModelEnum.DURATION, duration, oldDuration);
    }

    @Override
    public ImmutableLineString getLineString() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.lineString;
    }

    @Override
    public void setLineString(ImmutableLineString lineString) {
        this.setLineString(lineString, true);
    }

    private void setLineString(ImmutableLineString lineString, boolean setDirty) {
        ImmutableLineString oldLineString = this.getLineString();
        if (new EqualsBuilder().append(oldLineString, lineString).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, GeoDistanceMatrix62ModelEnum.LINE_STRING.getPropertyName());
        }
        this.lineString = lineString;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(GeoDistanceMatrix62ModelEnum.LINE_STRING, lineString, oldLineString);
    }

    @Override
    public RouteType getRouteType() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.routeType;
    }

    @Override
    public void setRouteType(RouteType routeType) {
        this.setRouteType(routeType, true);
    }

    private void setRouteType(RouteType routeType, boolean setDirty) {
        RouteType oldRouteType = this.getRouteType();
        if (new EqualsBuilder().append((Object)oldRouteType, (Object)routeType).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, GeoDistanceMatrix62ModelEnum.ROUTE_TYPE.getPropertyName());
        }
        this.routeType = routeType;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(GeoDistanceMatrix62ModelEnum.ROUTE_TYPE, (Object)routeType, (Object)oldRouteType);
    }

    @Override
    public RouteVehicleType getVehicleType() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.vehicleType;
    }

    @Override
    public void setVehicleType(RouteVehicleType vehicleType) {
        this.setVehicleType(vehicleType, true);
    }

    private void setVehicleType(RouteVehicleType vehicleType, boolean setDirty) {
        RouteVehicleType oldVehicleType = this.getVehicleType();
        if (new EqualsBuilder().append((Object)oldVehicleType, (Object)vehicleType).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, GeoDistanceMatrix62ModelEnum.VEHICLE_TYPE.getPropertyName());
        }
        this.vehicleType = vehicleType;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(GeoDistanceMatrix62ModelEnum.VEHICLE_TYPE, (Object)vehicleType, (Object)oldVehicleType);
    }

    @Override
    protected void updateByDto(GeoDistanceMatrix62FullDto geoDistanceMatrix62Dto) {
        ImmutablePointDto start = geoDistanceMatrix62Dto.getStart();
        this.start = start == null ? null : (ImmutablePoint)start.getGeoObject();
        ImmutablePointDto target = geoDistanceMatrix62Dto.getTarget();
        this.target = target == null ? null : (ImmutablePoint)target.getGeoObject();
        this.distance = geoDistanceMatrix62Dto.getDistance();
        this.duration = geoDistanceMatrix62Dto.getDuration();
        ImmutableLineStringDto lineString = geoDistanceMatrix62Dto.getLineString();
        this.lineString = lineString == null ? null : (ImmutableLineString)lineString.getGeoObject();
        this.routeType = geoDistanceMatrix62Dto.getRouteType();
        this.vehicleType = geoDistanceMatrix62Dto.getVehicleType();
    }

    @Override
    protected void updateMasterRelationsByDto(GeoDistanceMatrix62FullDto geoDistanceMatrix62Dto) {
    }

    @Override
    protected void checkStaleByDto(GeoDistanceMatrix62FullDto geoDistanceMatrix62Dto) throws StaleStateException {
    }

    @Override
    public GeoDistanceMatrix62FullDto createDto() {
        Long id = this.getId();
        GeoDistanceMatrix62FullDto geoDistanceMatrix62Dto = id == null ? new GeoDistanceMatrix62FullDto(this.getTempUUID()) : new GeoDistanceMatrix62FullDto(id, this.getVersion());
        ImmutablePoint start = this.getStart();
        geoDistanceMatrix62Dto.setStart(ImmutablePointDto.create(start));
        ImmutablePoint target = this.getTarget();
        geoDistanceMatrix62Dto.setTarget(ImmutablePointDto.create(target));
        geoDistanceMatrix62Dto.setDistance(this.getDistance());
        geoDistanceMatrix62Dto.setDuration(this.getDuration());
        ImmutableLineString lineString = this.getLineString();
        geoDistanceMatrix62Dto.setLineString(ImmutableLineStringDto.create(lineString));
        geoDistanceMatrix62Dto.setRouteType(this.getRouteType());
        geoDistanceMatrix62Dto.setVehicleType(this.getVehicleType());
        return geoDistanceMatrix62Dto;
    }

    @Override
    public GeoDistanceMatrix62ProxyDto createProxy() {
        Long id = this.getId();
        GeoDistanceMatrix62ProxyDto geoDistanceMatrix62Dto = id == null ? new GeoDistanceMatrix62ProxyDto(this.getTempUUID()) : new GeoDistanceMatrix62ProxyDto(id, this.getVersion());
        return geoDistanceMatrix62Dto;
    }

    public static enum GeoDistanceMatrix62ModelEnum {
        START("start"),
        TARGET("target"),
        DISTANCE("distance"),
        DURATION("duration"),
        LINE_STRING("lineString"),
        ROUTE_TYPE("routeType"),
        VEHICLE_TYPE("vehicleType");

        private String propertyName;

        private GeoDistanceMatrix62ModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

