/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.distance;

import de.datomino.logistic.type.RouteType;
import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.distance.GeoDistanceMatrix42Model;
import de.datomino.peppergis.dto.distance.GeoDistanceMatrix42FullDto;
import de.datomino.peppergis.dto.distance.GeoDistanceMatrix42ProxyDto;
import de.datomino.peppergis.exception.StaleStateException;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.dto.ImmutableLineStringDto;
import de.datomino.util.geo.dto.ImmutablePointDto;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;

public class GeoDistanceMatrix42ModelImpl
extends AbstractModel<GeoDistanceMatrix42FullDto, GeoDistanceMatrix42ProxyDto>
implements GeoDistanceMatrix42Model {
    private ImmutablePoint start;
    private ImmutablePoint target;
    private Integer distance;
    private Integer duration;
    private ImmutableLineString lineString;
    private RouteType routeType;
    private RouteVehicleType vehicleType;

    public GeoDistanceMatrix42ModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public GeoDistanceMatrix42ModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public ImmutablePoint getStart() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.start;
    }

    @Override
    public void setStart(ImmutablePoint start) {
        this.setStart(start, true);
    }

    private void setStart(ImmutablePoint start, boolean setDirty) {
        ImmutablePoint oldStart = this.getStart();
        if (new EqualsBuilder().append(oldStart, start).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, GeoDistanceMatrix42ModelEnum.START.getPropertyName());
        }
        this.start = start;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(GeoDistanceMatrix42ModelEnum.START, start, oldStart);
    }

    @Override
    public ImmutablePoint getTarget() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.target;
    }

    @Override
    public void setTarget(ImmutablePoint target) {
        this.setTarget(target, true);
    }

    private void setTarget(ImmutablePoint target, boolean setDirty) {
        ImmutablePoint oldTarget = this.getTarget();
        if (new EqualsBuilder().append(oldTarget, target).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, GeoDistanceMatrix42ModelEnum.TARGET.getPropertyName());
        }
        this.target = target;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(GeoDistanceMatrix42ModelEnum.TARGET, target, oldTarget);
    }

    @Override
    public Integer getDistance() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.distance;
    }

    @Override
    public void setDistance(Integer distance) {
        this.setDistance(distance, true);
    }

    private void setDistance(Integer distance, boolean setDirty) {
        Integer oldDistance = this.getDistance();
        if (new EqualsBuilder().append(oldDistance, distance).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, GeoDistanceMatrix42ModelEnum.DISTANCE.getPropertyName());
        }
        this.distance = distance;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(GeoDistanceMatrix42ModelEnum.DISTANCE, distance, oldDistance);
    }

    @Override
    public Integer getDuration() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.duration;
    }

    @Override
    public void setDuration(Integer duration) {
        this.setDuration(duration, true);
    }

    private void setDuration(Integer duration, boolean setDirty) {
        Integer oldDuration = this.getDuration();
        if (new EqualsBuilder().append(oldDuration, duration).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, GeoDistanceMatrix42ModelEnum.DURATION.getPropertyName());
        }
        this.duration = duration;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(GeoDistanceMatrix42ModelEnum.DURATION, duration, oldDuration);
    }

    @Override
    public ImmutableLineString getLineString() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.lineString;
    }

    @Override
    public void setLineString(ImmutableLineString lineString) {
        this.setLineString(lineString, true);
    }

    private void setLineString(ImmutableLineString lineString, boolean setDirty) {
        ImmutableLineString oldLineString = this.getLineString();
        if (new EqualsBuilder().append(oldLineString, lineString).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, GeoDistanceMatrix42ModelEnum.LINE_STRING.getPropertyName());
        }
        this.lineString = lineString;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(GeoDistanceMatrix42ModelEnum.LINE_STRING, lineString, oldLineString);
    }

    @Override
    public RouteType getRouteType() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.routeType;
    }

    @Override
    public void setRouteType(RouteType routeType) {
        this.setRouteType(routeType, true);
    }

    private void setRouteType(RouteType routeType, boolean setDirty) {
        RouteType oldRouteType = this.getRouteType();
        if (new EqualsBuilder().append((Object)oldRouteType, (Object)routeType).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, GeoDistanceMatrix42ModelEnum.ROUTE_TYPE.getPropertyName());
        }
        this.routeType = routeType;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(GeoDistanceMatrix42ModelEnum.ROUTE_TYPE, (Object)routeType, (Object)oldRouteType);
    }

    @Override
    public RouteVehicleType getVehicleType() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.vehicleType;
    }

    @Override
    public void setVehicleType(RouteVehicleType vehicleType) {
        this.setVehicleType(vehicleType, true);
    }

    private void setVehicleType(RouteVehicleType vehicleType, boolean setDirty) {
        RouteVehicleType oldVehicleType = this.getVehicleType();
        if (new EqualsBuilder().append((Object)oldVehicleType, (Object)vehicleType).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, GeoDistanceMatrix42ModelEnum.VEHICLE_TYPE.getPropertyName());
        }
        this.vehicleType = vehicleType;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(GeoDistanceMatrix42ModelEnum.VEHICLE_TYPE, (Object)vehicleType, (Object)oldVehicleType);
    }

    @Override
    protected void updateByDto(GeoDistanceMatrix42FullDto geoDistanceMatrix42Dto) {
        ImmutablePointDto start = geoDistanceMatrix42Dto.getStart();
        this.start = start == null ? null : (ImmutablePoint)start.getGeoObject();
        ImmutablePointDto target = geoDistanceMatrix42Dto.getTarget();
        this.target = target == null ? null : (ImmutablePoint)target.getGeoObject();
        this.distance = geoDistanceMatrix42Dto.getDistance();
        this.duration = geoDistanceMatrix42Dto.getDuration();
        ImmutableLineStringDto lineString = geoDistanceMatrix42Dto.getLineString();
        this.lineString = lineString == null ? null : (ImmutableLineString)lineString.getGeoObject();
        this.routeType = geoDistanceMatrix42Dto.getRouteType();
        this.vehicleType = geoDistanceMatrix42Dto.getVehicleType();
    }

    @Override
    protected void updateMasterRelationsByDto(GeoDistanceMatrix42FullDto geoDistanceMatrix42Dto) {
    }

    @Override
    protected void checkStaleByDto(GeoDistanceMatrix42FullDto geoDistanceMatrix42Dto) throws StaleStateException {
    }

    @Override
    public GeoDistanceMatrix42FullDto createDto() {
        Long id = this.getId();
        GeoDistanceMatrix42FullDto geoDistanceMatrix42Dto = id == null ? new GeoDistanceMatrix42FullDto(this.getTempUUID()) : new GeoDistanceMatrix42FullDto(id, this.getVersion());
        ImmutablePoint start = this.getStart();
        geoDistanceMatrix42Dto.setStart(ImmutablePointDto.create(start));
        ImmutablePoint target = this.getTarget();
        geoDistanceMatrix42Dto.setTarget(ImmutablePointDto.create(target));
        geoDistanceMatrix42Dto.setDistance(this.getDistance());
        geoDistanceMatrix42Dto.setDuration(this.getDuration());
        ImmutableLineString lineString = this.getLineString();
        geoDistanceMatrix42Dto.setLineString(ImmutableLineStringDto.create(lineString));
        geoDistanceMatrix42Dto.setRouteType(this.getRouteType());
        geoDistanceMatrix42Dto.setVehicleType(this.getVehicleType());
        return geoDistanceMatrix42Dto;
    }

    @Override
    public GeoDistanceMatrix42ProxyDto createProxy() {
        Long id = this.getId();
        GeoDistanceMatrix42ProxyDto geoDistanceMatrix42Dto = id == null ? new GeoDistanceMatrix42ProxyDto(this.getTempUUID()) : new GeoDistanceMatrix42ProxyDto(id, this.getVersion());
        return geoDistanceMatrix42Dto;
    }

    public static enum GeoDistanceMatrix42ModelEnum {
        START("start"),
        TARGET("target"),
        DISTANCE("distance"),
        DURATION("duration"),
        LINE_STRING("lineString"),
        ROUTE_TYPE("routeType"),
        VEHICLE_TYPE("vehicleType");

        private String propertyName;

        private GeoDistanceMatrix42ModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

