/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.base;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaLayerModelImpl;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.area.AreaObjectModelImpl;
import de.datomino.peppergis.client.model.base.CustomerModel;
import de.datomino.peppergis.client.model.base.CustomerModelImpl;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.model.base.LocationModelImpl;
import de.datomino.peppergis.client.model.base.SubscriptionAttributeValueModel;
import de.datomino.peppergis.client.model.base.SubscriptionAttributeValueModelImpl;
import de.datomino.peppergis.client.model.base.SubscriptionBreakTimeModel;
import de.datomino.peppergis.client.model.base.SubscriptionBreakTimeModelImpl;
import de.datomino.peppergis.client.model.base.SubscriptionModel;
import de.datomino.peppergis.client.model.base.SubscriptionSortOrderModel;
import de.datomino.peppergis.client.model.base.SubscriptionSortOrderModelImpl;
import de.datomino.peppergis.dto.area.AreaLayerDto;
import de.datomino.peppergis.dto.area.AreaObjectDto;
import de.datomino.peppergis.dto.base.CustomerDto;
import de.datomino.peppergis.dto.base.LocationDto;
import de.datomino.peppergis.dto.base.SubscriptionAttributeValueDto;
import de.datomino.peppergis.dto.base.SubscriptionBreakTimeDto;
import de.datomino.peppergis.dto.base.SubscriptionFullDto;
import de.datomino.peppergis.dto.base.SubscriptionProxyDto;
import de.datomino.peppergis.dto.base.SubscriptionSortOrderDto;
import de.datomino.peppergis.exception.StaleStateException;
import de.datomino.peppergis.type.SubscriptionDeliveryType;
import de.datomino.peppergis.type.SubscriptionImportStatus;
import de.datomino.peppergis.type.SubscriptionStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;
import org.ktde.util.conversions.ImmutableIterator;
import org.ktde.util.conversions.IteratorIterable;

public class SubscriptionModelImpl
extends AbstractModel<SubscriptionFullDto, SubscriptionProxyDto>
implements SubscriptionModel {
    private String subscriptionNumber;
    private String information;
    private CustomerModel customer;
    private SubscriptionStatus status;
    private SubscriptionImportStatus importStatus;
    private AreaObjectModel areaObject;
    private Set<SubscriptionAttributeValueModel> subscriptionAttributeValues = null;
    private AreaLayerModel areaLayer;
    private Boolean monday;
    private Boolean tuesday;
    private Boolean wednesday;
    private Boolean thursday;
    private Boolean friday;
    private Boolean saturday;
    private Boolean sunday;
    private SubscriptionDeliveryType deliveryType;
    private Date startDate;
    private Date endDate;
    private Set<SubscriptionBreakTimeModel> breakTimes = null;
    private Set<SubscriptionSortOrderModel> sortOrders = null;
    private LocationModel location;

    public SubscriptionModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public SubscriptionModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public String getSubscriptionNumber() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.subscriptionNumber;
    }

    @Override
    public void setSubscriptionNumber(String subscriptionNumber) {
        this.setSubscriptionNumber(subscriptionNumber, true);
    }

    private void setSubscriptionNumber(String subscriptionNumber, boolean setDirty) {
        String oldSubscriptionNumber = this.getSubscriptionNumber();
        if (new EqualsBuilder().append(oldSubscriptionNumber, subscriptionNumber).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, SubscriptionModelEnum.SUBSCRIPTION_NUMBER.getPropertyName());
        }
        this.subscriptionNumber = subscriptionNumber;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(SubscriptionModelEnum.SUBSCRIPTION_NUMBER, subscriptionNumber, oldSubscriptionNumber);
    }

    @Override
    public String getInformation() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.information;
    }

    @Override
    public void setInformation(String information) {
        this.setInformation(information, true);
    }

    private void setInformation(String information, boolean setDirty) {
        String oldInformation = this.getInformation();
        if (new EqualsBuilder().append(oldInformation, information).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, SubscriptionModelEnum.INFORMATION.getPropertyName());
        }
        this.information = information;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(SubscriptionModelEnum.INFORMATION, information, oldInformation);
    }

    @Override
    public CustomerModel getCustomer() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.customer;
    }

    @Override
    public void setCustomer(CustomerModel customer) {
        this.setCustomer(customer, true);
    }

    private void setCustomer(CustomerModel customer, boolean setDirty) {
        CustomerModel oldCustomer = this.getCustomer();
        if (oldCustomer == customer) {
            return;
        }
        if (oldCustomer != null) {
            oldCustomer.removeSubscription(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, SubscriptionModelEnum.CUSTOMER.getPropertyName());
        }
        this.customer = customer;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(SubscriptionModelEnum.CUSTOMER, customer, oldCustomer);
        if (this.customer != null) {
            this.customer.addSubscription(this);
        }
    }

    @Override
    public SubscriptionStatus getStatus() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.status;
    }

    @Override
    public void setStatus(SubscriptionStatus status) {
        this.setStatus(status, true);
    }

    private void setStatus(SubscriptionStatus status, boolean setDirty) {
        SubscriptionStatus oldStatus = this.getStatus();
        if (new EqualsBuilder().append((Object)oldStatus, (Object)status).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, SubscriptionModelEnum.STATUS.getPropertyName());
        }
        this.status = status;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(SubscriptionModelEnum.STATUS, (Object)status, (Object)oldStatus);
    }

    @Override
    public SubscriptionImportStatus getImportStatus() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.importStatus;
    }

    @Override
    public void setImportStatus(SubscriptionImportStatus importStatus) {
        this.setImportStatus(importStatus, true);
    }

    private void setImportStatus(SubscriptionImportStatus importStatus, boolean setDirty) {
        SubscriptionImportStatus oldImportStatus = this.getImportStatus();
        if (new EqualsBuilder().append((Object)oldImportStatus, (Object)importStatus).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, SubscriptionModelEnum.IMPORT_STATUS.getPropertyName());
        }
        this.importStatus = importStatus;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(SubscriptionModelEnum.IMPORT_STATUS, (Object)importStatus, (Object)oldImportStatus);
    }

    @Override
    public AreaObjectModel getAreaObject() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.areaObject;
    }

    @Override
    public void setAreaObject(AreaObjectModel areaObject) {
        this.setAreaObject(areaObject, true);
    }

    private void setAreaObject(AreaObjectModel areaObject, boolean setDirty) {
        AreaObjectModel oldAreaObject = this.getAreaObject();
        if (oldAreaObject == areaObject) {
            return;
        }
        if (oldAreaObject != null) {
            oldAreaObject.removeSubscription(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, SubscriptionModelEnum.AREA_OBJECT.getPropertyName());
        }
        this.areaObject = areaObject;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(SubscriptionModelEnum.AREA_OBJECT, areaObject, oldAreaObject);
        if (this.areaObject != null) {
            this.areaObject.addSubscription(this);
        }
    }

    @Override
    public int countSubscriptionAttributeValues() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.subscriptionAttributeValues == null) {
            this.subscriptionAttributeValues = new LinkedHashSet<SubscriptionAttributeValueModel>();
            if (this.getId() != null) {
                Collection subscriptionAttributeValuesCollection = this.commonCaller.fetchChildren(this, SubscriptionModelEnum.SUBSCRIPTION_ATTRIBUTE_VALUES.getPropertyName());
                this.subscriptionAttributeValues.addAll(subscriptionAttributeValuesCollection);
            }
        }
        return this.subscriptionAttributeValues.size();
    }

    @Override
    public Iterator<SubscriptionAttributeValueModel> iterateSubscriptionAttributeValues() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.subscriptionAttributeValues == null) {
            this.subscriptionAttributeValues = new LinkedHashSet<SubscriptionAttributeValueModel>();
            if (this.getId() != null) {
                Collection subscriptionAttributeValuesCollection = this.commonCaller.fetchChildren(this, SubscriptionModelEnum.SUBSCRIPTION_ATTRIBUTE_VALUES.getPropertyName());
                this.subscriptionAttributeValues.addAll(subscriptionAttributeValuesCollection);
            }
        }
        return new ImmutableIterator<SubscriptionAttributeValueModel>(this.subscriptionAttributeValues);
    }

    @Override
    public Iterable<SubscriptionAttributeValueModel> iterableSubscriptionAttributeValues() {
        return new IteratorIterable<SubscriptionAttributeValueModel>(this.iterateSubscriptionAttributeValues());
    }

    @Override
    public void addSubscriptionAttributeValue(SubscriptionAttributeValueModel subscriptionAttributeValue) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.subscriptionAttributeValues == null) {
            this.subscriptionAttributeValues = new LinkedHashSet<SubscriptionAttributeValueModel>();
            if (this.getId() != null) {
                Collection subscriptionAttributeValuesCollection = this.commonCaller.fetchChildren(this, SubscriptionModelEnum.SUBSCRIPTION_ATTRIBUTE_VALUES.getPropertyName());
                this.subscriptionAttributeValues.addAll(subscriptionAttributeValuesCollection);
            }
        }
        if (this.subscriptionAttributeValues.contains(subscriptionAttributeValue)) {
            return;
        }
        this.subscriptionAttributeValues.add(subscriptionAttributeValue);
        this.fireValueChanged(SubscriptionModelEnum.SUBSCRIPTION_ATTRIBUTE_VALUES, subscriptionAttributeValue, null);
        if (subscriptionAttributeValue != null) {
            subscriptionAttributeValue.setSubscription(this);
        }
    }

    @Override
    public void removeSubscriptionAttributeValue(SubscriptionAttributeValueModel subscriptionAttributeValue) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.subscriptionAttributeValues == null) {
            this.subscriptionAttributeValues = new LinkedHashSet<SubscriptionAttributeValueModel>();
            if (this.getId() != null) {
                Collection subscriptionAttributeValuesCollection = this.commonCaller.fetchChildren(this, SubscriptionModelEnum.SUBSCRIPTION_ATTRIBUTE_VALUES.getPropertyName());
                this.subscriptionAttributeValues.addAll(subscriptionAttributeValuesCollection);
            }
        }
        if (!this.subscriptionAttributeValues.contains(subscriptionAttributeValue)) {
            return;
        }
        this.subscriptionAttributeValues.remove(subscriptionAttributeValue);
        this.fireValueChanged(SubscriptionModelEnum.SUBSCRIPTION_ATTRIBUTE_VALUES, subscriptionAttributeValue, null);
        if (subscriptionAttributeValue != null) {
            subscriptionAttributeValue.setSubscription(null);
        }
    }

    @Override
    public void clearSubscriptionAttributeValues() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.subscriptionAttributeValues == null) {
            this.subscriptionAttributeValues = new LinkedHashSet<SubscriptionAttributeValueModel>();
            if (this.getId() != null) {
                Collection subscriptionAttributeValuesCollection = this.commonCaller.fetchChildren(this, SubscriptionModelEnum.SUBSCRIPTION_ATTRIBUTE_VALUES.getPropertyName());
                this.subscriptionAttributeValues.addAll(subscriptionAttributeValuesCollection);
            }
        }
        ArrayList<SubscriptionAttributeValueModel> oldSubscriptionAttributeValues = new ArrayList<SubscriptionAttributeValueModel>(this.subscriptionAttributeValues);
        this.subscriptionAttributeValues.clear();
        this.fireValueChanged(SubscriptionModelEnum.SUBSCRIPTION_ATTRIBUTE_VALUES, null, null);
        for (SubscriptionAttributeValueModel oldSubscriptionAttributeValue : oldSubscriptionAttributeValues) {
            if (oldSubscriptionAttributeValue == null) continue;
            oldSubscriptionAttributeValue.setSubscription(null);
        }
    }

    @Override
    public boolean isSubscriptionAttributeValuesEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.subscriptionAttributeValues == null) {
            this.subscriptionAttributeValues = new LinkedHashSet<SubscriptionAttributeValueModel>();
            if (this.getId() != null) {
                Collection subscriptionAttributeValuesCollection = this.commonCaller.fetchChildren(this, SubscriptionModelEnum.SUBSCRIPTION_ATTRIBUTE_VALUES.getPropertyName());
                this.subscriptionAttributeValues.addAll(subscriptionAttributeValuesCollection);
            }
        }
        return this.subscriptionAttributeValues.isEmpty();
    }

    @Override
    public boolean containsSubscriptionAttributeValue(SubscriptionAttributeValueModel subscriptionAttributeValue) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.subscriptionAttributeValues == null) {
            this.subscriptionAttributeValues = new LinkedHashSet<SubscriptionAttributeValueModel>();
            if (this.getId() != null) {
                Collection subscriptionAttributeValuesCollection = this.commonCaller.fetchChildren(this, SubscriptionModelEnum.SUBSCRIPTION_ATTRIBUTE_VALUES.getPropertyName());
                this.subscriptionAttributeValues.addAll(subscriptionAttributeValuesCollection);
            }
        }
        return this.subscriptionAttributeValues.contains(subscriptionAttributeValue);
    }

    @Override
    public boolean isSubscriptionAttributeValuesInitialized() {
        return this.subscriptionAttributeValues != null;
    }

    @Override
    public AreaLayerModel getAreaLayer() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.areaLayer;
    }

    @Override
    public void setAreaLayer(AreaLayerModel areaLayer) {
        this.setAreaLayer(areaLayer, true);
    }

    private void setAreaLayer(AreaLayerModel areaLayer, boolean setDirty) {
        AreaLayerModel oldAreaLayer = this.getAreaLayer();
        if (oldAreaLayer == areaLayer) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, SubscriptionModelEnum.AREA_LAYER.getPropertyName());
        }
        this.areaLayer = areaLayer;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(SubscriptionModelEnum.AREA_LAYER, areaLayer, oldAreaLayer);
    }

    @Override
    public Boolean getMonday() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.monday;
    }

    @Override
    public void setMonday(Boolean monday) {
        this.setMonday(monday, true);
    }

    private void setMonday(Boolean monday, boolean setDirty) {
        Boolean oldMonday = this.getMonday();
        if (new EqualsBuilder().append(oldMonday, monday).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, SubscriptionModelEnum.MONDAY.getPropertyName());
        }
        this.monday = monday;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(SubscriptionModelEnum.MONDAY, monday, oldMonday);
    }

    @Override
    public Boolean getTuesday() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.tuesday;
    }

    @Override
    public void setTuesday(Boolean tuesday) {
        this.setTuesday(tuesday, true);
    }

    private void setTuesday(Boolean tuesday, boolean setDirty) {
        Boolean oldTuesday = this.getTuesday();
        if (new EqualsBuilder().append(oldTuesday, tuesday).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, SubscriptionModelEnum.TUESDAY.getPropertyName());
        }
        this.tuesday = tuesday;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(SubscriptionModelEnum.TUESDAY, tuesday, oldTuesday);
    }

    @Override
    public Boolean getWednesday() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.wednesday;
    }

    @Override
    public void setWednesday(Boolean wednesday) {
        this.setWednesday(wednesday, true);
    }

    private void setWednesday(Boolean wednesday, boolean setDirty) {
        Boolean oldWednesday = this.getWednesday();
        if (new EqualsBuilder().append(oldWednesday, wednesday).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, SubscriptionModelEnum.WEDNESDAY.getPropertyName());
        }
        this.wednesday = wednesday;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(SubscriptionModelEnum.WEDNESDAY, wednesday, oldWednesday);
    }

    @Override
    public Boolean getThursday() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.thursday;
    }

    @Override
    public void setThursday(Boolean thursday) {
        this.setThursday(thursday, true);
    }

    private void setThursday(Boolean thursday, boolean setDirty) {
        Boolean oldThursday = this.getThursday();
        if (new EqualsBuilder().append(oldThursday, thursday).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, SubscriptionModelEnum.THURSDAY.getPropertyName());
        }
        this.thursday = thursday;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(SubscriptionModelEnum.THURSDAY, thursday, oldThursday);
    }

    @Override
    public Boolean getFriday() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.friday;
    }

    @Override
    public void setFriday(Boolean friday) {
        this.setFriday(friday, true);
    }

    private void setFriday(Boolean friday, boolean setDirty) {
        Boolean oldFriday = this.getFriday();
        if (new EqualsBuilder().append(oldFriday, friday).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, SubscriptionModelEnum.FRIDAY.getPropertyName());
        }
        this.friday = friday;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(SubscriptionModelEnum.FRIDAY, friday, oldFriday);
    }

    @Override
    public Boolean getSaturday() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.saturday;
    }

    @Override
    public void setSaturday(Boolean saturday) {
        this.setSaturday(saturday, true);
    }

    private void setSaturday(Boolean saturday, boolean setDirty) {
        Boolean oldSaturday = this.getSaturday();
        if (new EqualsBuilder().append(oldSaturday, saturday).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, SubscriptionModelEnum.SATURDAY.getPropertyName());
        }
        this.saturday = saturday;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(SubscriptionModelEnum.SATURDAY, saturday, oldSaturday);
    }

    @Override
    public Boolean getSunday() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.sunday;
    }

    @Override
    public void setSunday(Boolean sunday) {
        this.setSunday(sunday, true);
    }

    private void setSunday(Boolean sunday, boolean setDirty) {
        Boolean oldSunday = this.getSunday();
        if (new EqualsBuilder().append(oldSunday, sunday).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, SubscriptionModelEnum.SUNDAY.getPropertyName());
        }
        this.sunday = sunday;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(SubscriptionModelEnum.SUNDAY, sunday, oldSunday);
    }

    @Override
    public SubscriptionDeliveryType getDeliveryType() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.deliveryType;
    }

    @Override
    public void setDeliveryType(SubscriptionDeliveryType deliveryType) {
        this.setDeliveryType(deliveryType, true);
    }

    private void setDeliveryType(SubscriptionDeliveryType deliveryType, boolean setDirty) {
        SubscriptionDeliveryType oldDeliveryType = this.getDeliveryType();
        if (new EqualsBuilder().append((Object)oldDeliveryType, (Object)deliveryType).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, SubscriptionModelEnum.DELIVERY_TYPE.getPropertyName());
        }
        this.deliveryType = deliveryType;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(SubscriptionModelEnum.DELIVERY_TYPE, (Object)deliveryType, (Object)oldDeliveryType);
    }

    @Override
    public Date getStartDate() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.startDate;
    }

    @Override
    public void setStartDate(Date startDate) {
        this.setStartDate(startDate, true);
    }

    private void setStartDate(Date startDate, boolean setDirty) {
        Date oldStartDate = this.getStartDate();
        if (new EqualsBuilder().append(oldStartDate, startDate).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, SubscriptionModelEnum.START_DATE.getPropertyName());
        }
        this.startDate = startDate;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(SubscriptionModelEnum.START_DATE, startDate, oldStartDate);
    }

    @Override
    public Date getEndDate() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.endDate;
    }

    @Override
    public void setEndDate(Date endDate) {
        this.setEndDate(endDate, true);
    }

    private void setEndDate(Date endDate, boolean setDirty) {
        Date oldEndDate = this.getEndDate();
        if (new EqualsBuilder().append(oldEndDate, endDate).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, SubscriptionModelEnum.END_DATE.getPropertyName());
        }
        this.endDate = endDate;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(SubscriptionModelEnum.END_DATE, endDate, oldEndDate);
    }

    @Override
    public int countBreakTimes() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.breakTimes == null) {
            this.breakTimes = new LinkedHashSet<SubscriptionBreakTimeModel>();
            if (this.getId() != null) {
                Collection breakTimesCollection = this.commonCaller.fetchChildren(this, SubscriptionModelEnum.BREAK_TIMES.getPropertyName());
                this.breakTimes.addAll(breakTimesCollection);
            }
        }
        return this.breakTimes.size();
    }

    @Override
    public Iterator<SubscriptionBreakTimeModel> iterateBreakTimes() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.breakTimes == null) {
            this.breakTimes = new LinkedHashSet<SubscriptionBreakTimeModel>();
            if (this.getId() != null) {
                Collection breakTimesCollection = this.commonCaller.fetchChildren(this, SubscriptionModelEnum.BREAK_TIMES.getPropertyName());
                this.breakTimes.addAll(breakTimesCollection);
            }
        }
        return new ImmutableIterator<SubscriptionBreakTimeModel>(this.breakTimes);
    }

    @Override
    public Iterable<SubscriptionBreakTimeModel> iterableBreakTimes() {
        return new IteratorIterable<SubscriptionBreakTimeModel>(this.iterateBreakTimes());
    }

    @Override
    public void addBreakTime(SubscriptionBreakTimeModel breakTime) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.breakTimes == null) {
            this.breakTimes = new LinkedHashSet<SubscriptionBreakTimeModel>();
            if (this.getId() != null) {
                Collection breakTimesCollection = this.commonCaller.fetchChildren(this, SubscriptionModelEnum.BREAK_TIMES.getPropertyName());
                this.breakTimes.addAll(breakTimesCollection);
            }
        }
        if (this.breakTimes.contains(breakTime)) {
            return;
        }
        this.breakTimes.add(breakTime);
        this.fireValueChanged(SubscriptionModelEnum.BREAK_TIMES, breakTime, null);
        if (breakTime != null) {
            breakTime.setSubscription(this);
        }
    }

    @Override
    public void removeBreakTime(SubscriptionBreakTimeModel breakTime) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.breakTimes == null) {
            this.breakTimes = new LinkedHashSet<SubscriptionBreakTimeModel>();
            if (this.getId() != null) {
                Collection breakTimesCollection = this.commonCaller.fetchChildren(this, SubscriptionModelEnum.BREAK_TIMES.getPropertyName());
                this.breakTimes.addAll(breakTimesCollection);
            }
        }
        if (!this.breakTimes.contains(breakTime)) {
            return;
        }
        this.breakTimes.remove(breakTime);
        this.fireValueChanged(SubscriptionModelEnum.BREAK_TIMES, breakTime, null);
        if (breakTime != null) {
            breakTime.setSubscription(null);
        }
    }

    @Override
    public void clearBreakTimes() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.breakTimes == null) {
            this.breakTimes = new LinkedHashSet<SubscriptionBreakTimeModel>();
            if (this.getId() != null) {
                Collection breakTimesCollection = this.commonCaller.fetchChildren(this, SubscriptionModelEnum.BREAK_TIMES.getPropertyName());
                this.breakTimes.addAll(breakTimesCollection);
            }
        }
        ArrayList<SubscriptionBreakTimeModel> oldBreakTimes = new ArrayList<SubscriptionBreakTimeModel>(this.breakTimes);
        this.breakTimes.clear();
        this.fireValueChanged(SubscriptionModelEnum.BREAK_TIMES, null, null);
        for (SubscriptionBreakTimeModel oldBreakTime : oldBreakTimes) {
            if (oldBreakTime == null) continue;
            oldBreakTime.setSubscription(null);
        }
    }

    @Override
    public boolean isBreakTimesEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.breakTimes == null) {
            this.breakTimes = new LinkedHashSet<SubscriptionBreakTimeModel>();
            if (this.getId() != null) {
                Collection breakTimesCollection = this.commonCaller.fetchChildren(this, SubscriptionModelEnum.BREAK_TIMES.getPropertyName());
                this.breakTimes.addAll(breakTimesCollection);
            }
        }
        return this.breakTimes.isEmpty();
    }

    @Override
    public boolean containsBreakTime(SubscriptionBreakTimeModel breakTime) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.breakTimes == null) {
            this.breakTimes = new LinkedHashSet<SubscriptionBreakTimeModel>();
            if (this.getId() != null) {
                Collection breakTimesCollection = this.commonCaller.fetchChildren(this, SubscriptionModelEnum.BREAK_TIMES.getPropertyName());
                this.breakTimes.addAll(breakTimesCollection);
            }
        }
        return this.breakTimes.contains(breakTime);
    }

    @Override
    public boolean isBreakTimesInitialized() {
        return this.breakTimes != null;
    }

    @Override
    public int countSortOrders() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.sortOrders == null) {
            this.sortOrders = new LinkedHashSet<SubscriptionSortOrderModel>();
            if (this.getId() != null) {
                Collection sortOrdersCollection = this.commonCaller.fetchChildren(this, SubscriptionModelEnum.SORT_ORDERS.getPropertyName());
                this.sortOrders.addAll(sortOrdersCollection);
            }
        }
        return this.sortOrders.size();
    }

    @Override
    public Iterator<SubscriptionSortOrderModel> iterateSortOrders() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.sortOrders == null) {
            this.sortOrders = new LinkedHashSet<SubscriptionSortOrderModel>();
            if (this.getId() != null) {
                Collection sortOrdersCollection = this.commonCaller.fetchChildren(this, SubscriptionModelEnum.SORT_ORDERS.getPropertyName());
                this.sortOrders.addAll(sortOrdersCollection);
            }
        }
        return new ImmutableIterator<SubscriptionSortOrderModel>(this.sortOrders);
    }

    @Override
    public Iterable<SubscriptionSortOrderModel> iterableSortOrders() {
        return new IteratorIterable<SubscriptionSortOrderModel>(this.iterateSortOrders());
    }

    @Override
    public void addSortOrder(SubscriptionSortOrderModel sortOrder) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.sortOrders == null) {
            this.sortOrders = new LinkedHashSet<SubscriptionSortOrderModel>();
            if (this.getId() != null) {
                Collection sortOrdersCollection = this.commonCaller.fetchChildren(this, SubscriptionModelEnum.SORT_ORDERS.getPropertyName());
                this.sortOrders.addAll(sortOrdersCollection);
            }
        }
        if (this.sortOrders.contains(sortOrder)) {
            return;
        }
        this.sortOrders.add(sortOrder);
        this.fireValueChanged(SubscriptionModelEnum.SORT_ORDERS, sortOrder, null);
        if (sortOrder != null) {
            sortOrder.setSubscription(this);
        }
    }

    @Override
    public void removeSortOrder(SubscriptionSortOrderModel sortOrder) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.sortOrders == null) {
            this.sortOrders = new LinkedHashSet<SubscriptionSortOrderModel>();
            if (this.getId() != null) {
                Collection sortOrdersCollection = this.commonCaller.fetchChildren(this, SubscriptionModelEnum.SORT_ORDERS.getPropertyName());
                this.sortOrders.addAll(sortOrdersCollection);
            }
        }
        if (!this.sortOrders.contains(sortOrder)) {
            return;
        }
        this.sortOrders.remove(sortOrder);
        this.fireValueChanged(SubscriptionModelEnum.SORT_ORDERS, sortOrder, null);
        if (sortOrder != null) {
            sortOrder.setSubscription(null);
        }
    }

    @Override
    public void clearSortOrders() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.sortOrders == null) {
            this.sortOrders = new LinkedHashSet<SubscriptionSortOrderModel>();
            if (this.getId() != null) {
                Collection sortOrdersCollection = this.commonCaller.fetchChildren(this, SubscriptionModelEnum.SORT_ORDERS.getPropertyName());
                this.sortOrders.addAll(sortOrdersCollection);
            }
        }
        ArrayList<SubscriptionSortOrderModel> oldSortOrders = new ArrayList<SubscriptionSortOrderModel>(this.sortOrders);
        this.sortOrders.clear();
        this.fireValueChanged(SubscriptionModelEnum.SORT_ORDERS, null, null);
        for (SubscriptionSortOrderModel oldSortOrder : oldSortOrders) {
            if (oldSortOrder == null) continue;
            oldSortOrder.setSubscription(null);
        }
    }

    @Override
    public boolean isSortOrdersEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.sortOrders == null) {
            this.sortOrders = new LinkedHashSet<SubscriptionSortOrderModel>();
            if (this.getId() != null) {
                Collection sortOrdersCollection = this.commonCaller.fetchChildren(this, SubscriptionModelEnum.SORT_ORDERS.getPropertyName());
                this.sortOrders.addAll(sortOrdersCollection);
            }
        }
        return this.sortOrders.isEmpty();
    }

    @Override
    public boolean containsSortOrder(SubscriptionSortOrderModel sortOrder) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.sortOrders == null) {
            this.sortOrders = new LinkedHashSet<SubscriptionSortOrderModel>();
            if (this.getId() != null) {
                Collection sortOrdersCollection = this.commonCaller.fetchChildren(this, SubscriptionModelEnum.SORT_ORDERS.getPropertyName());
                this.sortOrders.addAll(sortOrdersCollection);
            }
        }
        return this.sortOrders.contains(sortOrder);
    }

    @Override
    public boolean isSortOrdersInitialized() {
        return this.sortOrders != null;
    }

    @Override
    public LocationModel getLocation() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.location;
    }

    @Override
    public void setLocation(LocationModel location) {
        this.setLocation(location, true);
    }

    private void setLocation(LocationModel location, boolean setDirty) {
        LocationModel oldLocation = this.getLocation();
        if (oldLocation == location) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, SubscriptionModelEnum.LOCATION.getPropertyName());
        }
        this.location = location;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(SubscriptionModelEnum.LOCATION, location, oldLocation);
    }

    @Override
    public void setProxy(boolean proxy) {
        super.setProxy(proxy);
        if (proxy) {
            this.subscriptionAttributeValues = null;
            this.breakTimes = null;
            this.sortOrders = null;
        }
    }

    @Override
    protected void updateByDto(SubscriptionFullDto subscriptionDto) {
        SubscriptionSortOrderDto[] sortOrders;
        this.subscriptionNumber = subscriptionDto.getSubscriptionNumber();
        this.information = subscriptionDto.getInformation();
        this.customer = (CustomerModel)this.getModelCache().getModel(subscriptionDto.getCustomer());
        this.status = subscriptionDto.getStatus();
        this.importStatus = subscriptionDto.getImportStatus();
        this.areaObject = (AreaObjectModel)this.getModelCache().getModel(subscriptionDto.getAreaObject());
        SubscriptionAttributeValueDto[] subscriptionAttributeValues = subscriptionDto.getSubscriptionAttributeValues();
        if (subscriptionAttributeValues != null) {
            if (this.subscriptionAttributeValues == null) {
                this.subscriptionAttributeValues = new LinkedHashSet<SubscriptionAttributeValueModel>();
            } else {
                this.subscriptionAttributeValues.clear();
            }
        }
        this.areaLayer = (AreaLayerModel)this.getModelCache().getModel(subscriptionDto.getAreaLayer());
        this.monday = subscriptionDto.getMonday();
        this.tuesday = subscriptionDto.getTuesday();
        this.wednesday = subscriptionDto.getWednesday();
        this.thursday = subscriptionDto.getThursday();
        this.friday = subscriptionDto.getFriday();
        this.saturday = subscriptionDto.getSaturday();
        this.sunday = subscriptionDto.getSunday();
        this.deliveryType = subscriptionDto.getDeliveryType();
        this.startDate = subscriptionDto.getStartDate();
        this.endDate = subscriptionDto.getEndDate();
        SubscriptionBreakTimeDto[] breakTimes = subscriptionDto.getBreakTimes();
        if (breakTimes != null) {
            if (this.breakTimes == null) {
                this.breakTimes = new LinkedHashSet<SubscriptionBreakTimeModel>();
            } else {
                this.breakTimes.clear();
            }
        }
        if ((sortOrders = subscriptionDto.getSortOrders()) != null) {
            if (this.sortOrders == null) {
                this.sortOrders = new LinkedHashSet<SubscriptionSortOrderModel>();
            } else {
                this.sortOrders.clear();
            }
        }
        this.location = (LocationModel)this.getModelCache().getModel(subscriptionDto.getLocation());
    }

    @Override
    protected void updateMasterRelationsByDto(SubscriptionFullDto subscriptionDto) {
        SubscriptionSortOrderDto[] sortOrders;
        SubscriptionBreakTimeDto[] breakTimes;
        SubscriptionAttributeValueDto[] subscriptionAttributeValues = subscriptionDto.getSubscriptionAttributeValues();
        if (subscriptionAttributeValues != null) {
            if (this.subscriptionAttributeValues == null) {
                this.subscriptionAttributeValues = new LinkedHashSet<SubscriptionAttributeValueModel>();
            } else {
                this.subscriptionAttributeValues.clear();
            }
            for (SubscriptionAttributeValueDto subscriptionAttributeValueDto : subscriptionAttributeValues) {
                SubscriptionAttributeValueModel subscriptionAttributeValueModel = (SubscriptionAttributeValueModel)this.getModelCache().getModel(subscriptionAttributeValueDto);
                this.subscriptionAttributeValues.add(subscriptionAttributeValueModel);
            }
        } else {
            this.subscriptionAttributeValues = null;
        }
        if ((breakTimes = subscriptionDto.getBreakTimes()) != null) {
            if (this.breakTimes == null) {
                this.breakTimes = new LinkedHashSet<SubscriptionBreakTimeModel>();
            } else {
                this.breakTimes.clear();
            }
            for (SubscriptionBreakTimeDto breakTimeDto : breakTimes) {
                SubscriptionBreakTimeModel breakTimeModel = (SubscriptionBreakTimeModel)this.getModelCache().getModel(breakTimeDto);
                this.breakTimes.add(breakTimeModel);
            }
        } else {
            this.breakTimes = null;
        }
        if ((sortOrders = subscriptionDto.getSortOrders()) != null) {
            if (this.sortOrders == null) {
                this.sortOrders = new LinkedHashSet<SubscriptionSortOrderModel>();
            } else {
                this.sortOrders.clear();
            }
            for (SubscriptionSortOrderDto sortOrderDto : sortOrders) {
                SubscriptionSortOrderModel sortOrderModel = (SubscriptionSortOrderModel)this.getModelCache().getModel(sortOrderDto);
                this.sortOrders.add(sortOrderModel);
            }
        } else {
            this.sortOrders = null;
        }
    }

    @Override
    protected void checkStaleByDto(SubscriptionFullDto subscriptionDto) throws StaleStateException {
        LocationModelImpl locationModel;
        LocationDto locationDto;
        SubscriptionSortOrderDto[] sortOrderDtos;
        SubscriptionBreakTimeDto[] breakTimeDtos;
        AreaLayerModelImpl areaLayerModel;
        AreaLayerDto areaLayerDto;
        SubscriptionAttributeValueDto[] subscriptionAttributeValueDtos;
        AreaObjectModelImpl areaObjectModel;
        AreaObjectDto areaObjectDto;
        CustomerModelImpl customerModel;
        CustomerDto customerDto = subscriptionDto.getCustomer();
        if (customerDto != null && customerDto.getId() != null && (customerModel = (CustomerModelImpl)this.getModelCache().getModel(CustomerModel.class, customerDto.getId())) != null) {
            customerModel.checkStaleState(customerDto);
        }
        if ((areaObjectDto = subscriptionDto.getAreaObject()) != null && areaObjectDto.getId() != null && (areaObjectModel = (AreaObjectModelImpl)this.getModelCache().getModel(AreaObjectModel.class, areaObjectDto.getId())) != null) {
            areaObjectModel.checkStaleState(areaObjectDto);
        }
        if ((subscriptionAttributeValueDtos = subscriptionDto.getSubscriptionAttributeValues()) != null) {
            for (SubscriptionAttributeValueDto subscriptionAttributeValueDto : subscriptionAttributeValueDtos) {
                SubscriptionAttributeValueModelImpl subscriptionAttributeValueModel = (SubscriptionAttributeValueModelImpl)this.getModelCache().getModel(SubscriptionAttributeValueModel.class, subscriptionAttributeValueDto.getId());
                if (subscriptionAttributeValueModel == null) continue;
                subscriptionAttributeValueModel.checkStaleState(subscriptionAttributeValueDto);
            }
        }
        if ((areaLayerDto = subscriptionDto.getAreaLayer()) != null && areaLayerDto.getId() != null && (areaLayerModel = (AreaLayerModelImpl)this.getModelCache().getModel(AreaLayerModel.class, areaLayerDto.getId())) != null) {
            areaLayerModel.checkStaleState(areaLayerDto);
        }
        if ((breakTimeDtos = subscriptionDto.getBreakTimes()) != null) {
            for (SubscriptionBreakTimeDto breakTimeDto : breakTimeDtos) {
                SubscriptionBreakTimeModelImpl breakTimeModel = (SubscriptionBreakTimeModelImpl)this.getModelCache().getModel(SubscriptionBreakTimeModel.class, breakTimeDto.getId());
                if (breakTimeModel == null) continue;
                breakTimeModel.checkStaleState(breakTimeDto);
            }
        }
        if ((sortOrderDtos = subscriptionDto.getSortOrders()) != null) {
            for (SubscriptionSortOrderDto sortOrderDto : sortOrderDtos) {
                SubscriptionSortOrderModelImpl sortOrderModel = (SubscriptionSortOrderModelImpl)this.getModelCache().getModel(SubscriptionSortOrderModel.class, sortOrderDto.getId());
                if (sortOrderModel == null) continue;
                sortOrderModel.checkStaleState(sortOrderDto);
            }
        }
        if ((locationDto = subscriptionDto.getLocation()) != null && locationDto.getId() != null && (locationModel = (LocationModelImpl)this.getModelCache().getModel(LocationModel.class, locationDto.getId())) != null) {
            locationModel.checkStaleState(locationDto);
        }
    }

    @Override
    public SubscriptionFullDto createDto() {
        AreaLayerModelImpl areaLayer;
        Long id = this.getId();
        SubscriptionFullDto subscriptionDto = id == null ? new SubscriptionFullDto(this.getTempUUID()) : new SubscriptionFullDto(id, this.getVersion());
        subscriptionDto.setSubscriptionNumber(this.getSubscriptionNumber());
        subscriptionDto.setInformation(this.getInformation());
        CustomerModelImpl customer = (CustomerModelImpl)this.getCustomer();
        if (customer != null) {
            subscriptionDto.setCustomer(customer.createProxy());
        }
        subscriptionDto.setStatus(this.getStatus());
        subscriptionDto.setImportStatus(this.getImportStatus());
        AreaObjectModelImpl areaObject = (AreaObjectModelImpl)this.getAreaObject();
        if (areaObject != null) {
            subscriptionDto.setAreaObject(areaObject.createProxy());
        }
        if ((areaLayer = (AreaLayerModelImpl)this.getAreaLayer()) != null) {
            subscriptionDto.setAreaLayer(areaLayer.createProxy());
        }
        subscriptionDto.setMonday(this.getMonday());
        subscriptionDto.setTuesday(this.getTuesday());
        subscriptionDto.setWednesday(this.getWednesday());
        subscriptionDto.setThursday(this.getThursday());
        subscriptionDto.setFriday(this.getFriday());
        subscriptionDto.setSaturday(this.getSaturday());
        subscriptionDto.setSunday(this.getSunday());
        subscriptionDto.setDeliveryType(this.getDeliveryType());
        subscriptionDto.setStartDate(this.getStartDate());
        subscriptionDto.setEndDate(this.getEndDate());
        LocationModelImpl location = (LocationModelImpl)this.getLocation();
        if (location != null) {
            subscriptionDto.setLocation(location.createProxy());
        }
        return subscriptionDto;
    }

    @Override
    public SubscriptionProxyDto createProxy() {
        Long id = this.getId();
        SubscriptionProxyDto subscriptionDto = id == null ? new SubscriptionProxyDto(this.getTempUUID()) : new SubscriptionProxyDto(id, this.getVersion());
        return subscriptionDto;
    }

    public static enum SubscriptionModelEnum {
        SUBSCRIPTION_NUMBER("subscriptionNumber"),
        INFORMATION("information"),
        CUSTOMER("customer"),
        STATUS("status"),
        IMPORT_STATUS("importStatus"),
        AREA_OBJECT("areaObject"),
        SUBSCRIPTION_ATTRIBUTE_VALUES("subscriptionAttributeValues"),
        AREA_LAYER("areaLayer"),
        MONDAY("monday"),
        TUESDAY("tuesday"),
        WEDNESDAY("wednesday"),
        THURSDAY("thursday"),
        FRIDAY("friday"),
        SATURDAY("saturday"),
        SUNDAY("sunday"),
        DELIVERY_TYPE("deliveryType"),
        START_DATE("startDate"),
        END_DATE("endDate"),
        BREAK_TIMES("breakTimes"),
        SORT_ORDERS("sortOrders"),
        LOCATION("location");

        private String propertyName;

        private SubscriptionModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

