/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.base;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.base.ServiceValueDescriptorModel;
import de.datomino.peppergis.client.model.base.ServiceValueDescriptorModelImpl;
import de.datomino.peppergis.client.model.base.StaticChoiceValueModel;
import de.datomino.peppergis.dto.base.ServiceValueDescriptorDto;
import de.datomino.peppergis.dto.base.StaticChoiceValueFullDto;
import de.datomino.peppergis.dto.base.StaticChoiceValueProxyDto;
import de.datomino.peppergis.exception.StaleStateException;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;

public class StaticChoiceValueModelImpl
extends AbstractModel<StaticChoiceValueFullDto, StaticChoiceValueProxyDto>
implements StaticChoiceValueModel {
    private String name;
    private String description;
    private String value;
    private Integer sortOrder;
    private ServiceValueDescriptorModel serviceValueDescriptor;

    public StaticChoiceValueModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public StaticChoiceValueModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public String getName() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.setName(name, true);
    }

    private void setName(String name, boolean setDirty) {
        String oldName = this.getName();
        if (new EqualsBuilder().append(oldName, name).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, StaticChoiceValueModelEnum.NAME.getPropertyName());
        }
        this.name = name;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(StaticChoiceValueModelEnum.NAME, name, oldName);
    }

    @Override
    public String getDescription() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.setDescription(description, true);
    }

    private void setDescription(String description, boolean setDirty) {
        String oldDescription = this.getDescription();
        if (new EqualsBuilder().append(oldDescription, description).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, StaticChoiceValueModelEnum.DESCRIPTION.getPropertyName());
        }
        this.description = description;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(StaticChoiceValueModelEnum.DESCRIPTION, description, oldDescription);
    }

    @Override
    public String getValue() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.value;
    }

    @Override
    public void setValue(String value) {
        this.setValue(value, true);
    }

    private void setValue(String value, boolean setDirty) {
        String oldValue = this.getValue();
        if (new EqualsBuilder().append(oldValue, value).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, StaticChoiceValueModelEnum.VALUE.getPropertyName());
        }
        this.value = value;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(StaticChoiceValueModelEnum.VALUE, value, oldValue);
    }

    @Override
    public Integer getSortOrder() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.sortOrder;
    }

    @Override
    public void setSortOrder(Integer sortOrder) {
        this.setSortOrder(sortOrder, true);
    }

    private void setSortOrder(Integer sortOrder, boolean setDirty) {
        Integer oldSortOrder = this.getSortOrder();
        if (new EqualsBuilder().append(oldSortOrder, sortOrder).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, StaticChoiceValueModelEnum.SORT_ORDER.getPropertyName());
        }
        this.sortOrder = sortOrder;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(StaticChoiceValueModelEnum.SORT_ORDER, sortOrder, oldSortOrder);
    }

    @Override
    public ServiceValueDescriptorModel getServiceValueDescriptor() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.serviceValueDescriptor;
    }

    @Override
    public void setServiceValueDescriptor(ServiceValueDescriptorModel serviceValueDescriptor) {
        this.setServiceValueDescriptor(serviceValueDescriptor, true);
    }

    private void setServiceValueDescriptor(ServiceValueDescriptorModel serviceValueDescriptor, boolean setDirty) {
        ServiceValueDescriptorModel oldServiceValueDescriptor = this.getServiceValueDescriptor();
        if (oldServiceValueDescriptor == serviceValueDescriptor) {
            return;
        }
        if (oldServiceValueDescriptor != null) {
            oldServiceValueDescriptor.removeStaticChoiceValue(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, StaticChoiceValueModelEnum.SERVICE_VALUE_DESCRIPTOR.getPropertyName());
        }
        this.serviceValueDescriptor = serviceValueDescriptor;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(StaticChoiceValueModelEnum.SERVICE_VALUE_DESCRIPTOR, serviceValueDescriptor, oldServiceValueDescriptor);
        if (this.serviceValueDescriptor != null) {
            this.serviceValueDescriptor.addStaticChoiceValue(this);
        }
    }

    @Override
    protected void updateByDto(StaticChoiceValueFullDto staticChoiceValueDto) {
        this.name = staticChoiceValueDto.getName();
        this.description = staticChoiceValueDto.getDescription();
        this.value = staticChoiceValueDto.getValue();
        this.sortOrder = staticChoiceValueDto.getSortOrder();
        this.serviceValueDescriptor = (ServiceValueDescriptorModel)this.getModelCache().getModel(staticChoiceValueDto.getServiceValueDescriptor());
    }

    @Override
    protected void updateMasterRelationsByDto(StaticChoiceValueFullDto staticChoiceValueDto) {
    }

    @Override
    protected void checkStaleByDto(StaticChoiceValueFullDto staticChoiceValueDto) throws StaleStateException {
        ServiceValueDescriptorModelImpl serviceValueDescriptorModel;
        ServiceValueDescriptorDto serviceValueDescriptorDto = staticChoiceValueDto.getServiceValueDescriptor();
        if (serviceValueDescriptorDto != null && serviceValueDescriptorDto.getId() != null && (serviceValueDescriptorModel = (ServiceValueDescriptorModelImpl)this.getModelCache().getModel(ServiceValueDescriptorModel.class, serviceValueDescriptorDto.getId())) != null) {
            serviceValueDescriptorModel.checkStaleState(serviceValueDescriptorDto);
        }
    }

    @Override
    public StaticChoiceValueFullDto createDto() {
        Long id = this.getId();
        StaticChoiceValueFullDto staticChoiceValueDto = id == null ? new StaticChoiceValueFullDto(this.getTempUUID()) : new StaticChoiceValueFullDto(id, this.getVersion());
        staticChoiceValueDto.setName(this.getName());
        staticChoiceValueDto.setDescription(this.getDescription());
        staticChoiceValueDto.setValue(this.getValue());
        staticChoiceValueDto.setSortOrder(this.getSortOrder());
        ServiceValueDescriptorModelImpl serviceValueDescriptor = (ServiceValueDescriptorModelImpl)this.getServiceValueDescriptor();
        if (serviceValueDescriptor != null) {
            staticChoiceValueDto.setServiceValueDescriptor(serviceValueDescriptor.createProxy());
        }
        return staticChoiceValueDto;
    }

    @Override
    public StaticChoiceValueProxyDto createProxy() {
        Long id = this.getId();
        StaticChoiceValueProxyDto staticChoiceValueDto = id == null ? new StaticChoiceValueProxyDto(this.getTempUUID()) : new StaticChoiceValueProxyDto(id, this.getVersion());
        return staticChoiceValueDto;
    }

    public static enum StaticChoiceValueModelEnum {
        NAME("name"),
        DESCRIPTION("description"),
        VALUE("value"),
        SORT_ORDER("sortOrder"),
        SERVICE_VALUE_DESCRIPTOR("serviceValueDescriptor");

        private String propertyName;

        private StaticChoiceValueModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

