/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.base;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.base.AttributeGroupModel;
import de.datomino.peppergis.client.model.base.AttributeGroupModelImpl;
import de.datomino.peppergis.client.model.base.ServiceModel;
import de.datomino.peppergis.client.model.base.ServiceModelImpl;
import de.datomino.peppergis.client.model.base.ServiceValueDescriptorModel;
import de.datomino.peppergis.client.model.base.StaticChoiceValueModel;
import de.datomino.peppergis.client.model.base.StaticChoiceValueModelImpl;
import de.datomino.peppergis.dto.base.AttributeGroupDto;
import de.datomino.peppergis.dto.base.ServiceDto;
import de.datomino.peppergis.dto.base.ServiceValueDescriptorFullDto;
import de.datomino.peppergis.dto.base.ServiceValueDescriptorProxyDto;
import de.datomino.peppergis.dto.base.StaticChoiceValueDto;
import de.datomino.peppergis.exception.StaleStateException;
import de.datomino.peppergis.type.AttributeValueType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;
import org.ktde.util.conversions.ImmutableIterator;
import org.ktde.util.conversions.IteratorIterable;

public class ServiceValueDescriptorModelImpl
extends AbstractModel<ServiceValueDescriptorFullDto, ServiceValueDescriptorProxyDto>
implements ServiceValueDescriptorModel {
    private String name;
    private String description;
    private String key;
    private AttributeValueType serviceValueType;
    private ServiceModel service;
    private Boolean editable;
    private Integer sortOrder;
    private Boolean canPrint;
    private Integer printSortOrder;
    private Integer printLength;
    private List<StaticChoiceValueModel> staticChoiceValues = null;
    private Boolean modifiable;
    private Double lowerLimit;
    private Double upperLimit;
    private AttributeGroupModel group;

    public ServiceValueDescriptorModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public ServiceValueDescriptorModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public String getName() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.setName(name, true);
    }

    private void setName(String name, boolean setDirty) {
        String oldName = this.getName();
        if (new EqualsBuilder().append(oldName, name).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ServiceValueDescriptorModelEnum.NAME.getPropertyName());
        }
        this.name = name;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ServiceValueDescriptorModelEnum.NAME, name, oldName);
    }

    @Override
    public String getDescription() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.setDescription(description, true);
    }

    private void setDescription(String description, boolean setDirty) {
        String oldDescription = this.getDescription();
        if (new EqualsBuilder().append(oldDescription, description).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ServiceValueDescriptorModelEnum.DESCRIPTION.getPropertyName());
        }
        this.description = description;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ServiceValueDescriptorModelEnum.DESCRIPTION, description, oldDescription);
    }

    @Override
    public String getKey() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.key;
    }

    @Override
    public void setKey(String key) {
        this.setKey(key, true);
    }

    private void setKey(String key, boolean setDirty) {
        String oldKey = this.getKey();
        if (new EqualsBuilder().append(oldKey, key).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ServiceValueDescriptorModelEnum.KEY.getPropertyName());
        }
        this.key = key;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ServiceValueDescriptorModelEnum.KEY, key, oldKey);
    }

    @Override
    public AttributeValueType getServiceValueType() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.serviceValueType;
    }

    @Override
    public void setServiceValueType(AttributeValueType serviceValueType) {
        this.setServiceValueType(serviceValueType, true);
    }

    private void setServiceValueType(AttributeValueType serviceValueType, boolean setDirty) {
        AttributeValueType oldServiceValueType = this.getServiceValueType();
        if (new EqualsBuilder().append((Object)oldServiceValueType, (Object)serviceValueType).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ServiceValueDescriptorModelEnum.SERVICE_VALUE_TYPE.getPropertyName());
        }
        this.serviceValueType = serviceValueType;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ServiceValueDescriptorModelEnum.SERVICE_VALUE_TYPE, (Object)serviceValueType, (Object)oldServiceValueType);
    }

    @Override
    public ServiceModel getService() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.service;
    }

    @Override
    public void setService(ServiceModel service) {
        this.setService(service, true);
    }

    private void setService(ServiceModel service, boolean setDirty) {
        ServiceModel oldService = this.getService();
        if (oldService == service) {
            return;
        }
        if (oldService != null) {
            oldService.removeServiceValueDescriptor(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ServiceValueDescriptorModelEnum.SERVICE.getPropertyName());
        }
        this.service = service;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ServiceValueDescriptorModelEnum.SERVICE, service, oldService);
        if (this.service != null) {
            this.service.addServiceValueDescriptor(this);
        }
    }

    @Override
    public Boolean getEditable() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.editable;
    }

    @Override
    public void setEditable(Boolean editable) {
        this.setEditable(editable, true);
    }

    private void setEditable(Boolean editable, boolean setDirty) {
        Boolean oldEditable = this.getEditable();
        if (new EqualsBuilder().append(oldEditable, editable).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ServiceValueDescriptorModelEnum.EDITABLE.getPropertyName());
        }
        this.editable = editable;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ServiceValueDescriptorModelEnum.EDITABLE, editable, oldEditable);
    }

    @Override
    public Integer getSortOrder() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.sortOrder;
    }

    @Override
    public void setSortOrder(Integer sortOrder) {
        this.setSortOrder(sortOrder, true);
    }

    private void setSortOrder(Integer sortOrder, boolean setDirty) {
        Integer oldSortOrder = this.getSortOrder();
        if (new EqualsBuilder().append(oldSortOrder, sortOrder).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ServiceValueDescriptorModelEnum.SORT_ORDER.getPropertyName());
        }
        this.sortOrder = sortOrder;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ServiceValueDescriptorModelEnum.SORT_ORDER, sortOrder, oldSortOrder);
    }

    @Override
    public Boolean getCanPrint() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.canPrint;
    }

    @Override
    public void setCanPrint(Boolean canPrint) {
        this.setCanPrint(canPrint, true);
    }

    private void setCanPrint(Boolean canPrint, boolean setDirty) {
        Boolean oldCanPrint = this.getCanPrint();
        if (new EqualsBuilder().append(oldCanPrint, canPrint).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ServiceValueDescriptorModelEnum.CAN_PRINT.getPropertyName());
        }
        this.canPrint = canPrint;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ServiceValueDescriptorModelEnum.CAN_PRINT, canPrint, oldCanPrint);
    }

    @Override
    public Integer getPrintSortOrder() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.printSortOrder;
    }

    @Override
    public void setPrintSortOrder(Integer printSortOrder) {
        this.setPrintSortOrder(printSortOrder, true);
    }

    private void setPrintSortOrder(Integer printSortOrder, boolean setDirty) {
        Integer oldPrintSortOrder = this.getPrintSortOrder();
        if (new EqualsBuilder().append(oldPrintSortOrder, printSortOrder).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ServiceValueDescriptorModelEnum.PRINT_SORT_ORDER.getPropertyName());
        }
        this.printSortOrder = printSortOrder;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ServiceValueDescriptorModelEnum.PRINT_SORT_ORDER, printSortOrder, oldPrintSortOrder);
    }

    @Override
    public Integer getPrintLength() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.printLength;
    }

    @Override
    public void setPrintLength(Integer printLength) {
        this.setPrintLength(printLength, true);
    }

    private void setPrintLength(Integer printLength, boolean setDirty) {
        Integer oldPrintLength = this.getPrintLength();
        if (new EqualsBuilder().append(oldPrintLength, printLength).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ServiceValueDescriptorModelEnum.PRINT_LENGTH.getPropertyName());
        }
        this.printLength = printLength;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ServiceValueDescriptorModelEnum.PRINT_LENGTH, printLength, oldPrintLength);
    }

    @Override
    public int countStaticChoiceValues() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.staticChoiceValues == null) {
            this.staticChoiceValues = new ArrayList<StaticChoiceValueModel>();
            if (this.getId() != null) {
                Collection staticChoiceValuesCollection = this.commonCaller.fetchChildren(this, ServiceValueDescriptorModelEnum.STATIC_CHOICE_VALUES.getPropertyName());
                this.staticChoiceValues.addAll(staticChoiceValuesCollection);
            }
        }
        return this.staticChoiceValues.size();
    }

    @Override
    public Iterator<StaticChoiceValueModel> iterateStaticChoiceValues() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.staticChoiceValues == null) {
            this.staticChoiceValues = new ArrayList<StaticChoiceValueModel>();
            if (this.getId() != null) {
                Collection staticChoiceValuesCollection = this.commonCaller.fetchChildren(this, ServiceValueDescriptorModelEnum.STATIC_CHOICE_VALUES.getPropertyName());
                this.staticChoiceValues.addAll(staticChoiceValuesCollection);
            }
        }
        return new ImmutableIterator<StaticChoiceValueModel>(this.staticChoiceValues);
    }

    @Override
    public Iterable<StaticChoiceValueModel> iterableStaticChoiceValues() {
        return new IteratorIterable<StaticChoiceValueModel>(this.iterateStaticChoiceValues());
    }

    @Override
    public void addStaticChoiceValue(StaticChoiceValueModel staticChoiceValue) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.staticChoiceValues == null) {
            this.staticChoiceValues = new ArrayList<StaticChoiceValueModel>();
            if (this.getId() != null) {
                Collection staticChoiceValuesCollection = this.commonCaller.fetchChildren(this, ServiceValueDescriptorModelEnum.STATIC_CHOICE_VALUES.getPropertyName());
                this.staticChoiceValues.addAll(staticChoiceValuesCollection);
            }
        }
        if (this.staticChoiceValues.contains(staticChoiceValue)) {
            return;
        }
        this.staticChoiceValues.add(staticChoiceValue);
        this.fireValueChanged(ServiceValueDescriptorModelEnum.STATIC_CHOICE_VALUES, staticChoiceValue, null);
        if (staticChoiceValue != null) {
            staticChoiceValue.setServiceValueDescriptor(this);
            staticChoiceValue.setSortOrder(this.staticChoiceValues.size() - 1);
        }
    }

    @Override
    public void removeStaticChoiceValue(StaticChoiceValueModel staticChoiceValue) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.staticChoiceValues == null) {
            this.staticChoiceValues = new ArrayList<StaticChoiceValueModel>();
            if (this.getId() != null) {
                Collection staticChoiceValuesCollection = this.commonCaller.fetchChildren(this, ServiceValueDescriptorModelEnum.STATIC_CHOICE_VALUES.getPropertyName());
                this.staticChoiceValues.addAll(staticChoiceValuesCollection);
            }
        }
        if (!this.staticChoiceValues.contains(staticChoiceValue)) {
            return;
        }
        this.staticChoiceValues.remove(staticChoiceValue);
        this.fireValueChanged(ServiceValueDescriptorModelEnum.STATIC_CHOICE_VALUES, staticChoiceValue, null);
        if (staticChoiceValue != null) {
            staticChoiceValue.setServiceValueDescriptor(null);
            staticChoiceValue.setSortOrder(null);
        }
        this.reorderStaticChoiceValues(0);
    }

    @Override
    public StaticChoiceValueModel getStaticChoiceValueAt(int index) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.staticChoiceValues == null) {
            this.staticChoiceValues = new ArrayList<StaticChoiceValueModel>();
            if (this.getId() != null) {
                Collection staticChoiceValuesCollection = this.commonCaller.fetchChildren(this, ServiceValueDescriptorModelEnum.STATIC_CHOICE_VALUES.getPropertyName());
                this.staticChoiceValues.addAll(staticChoiceValuesCollection);
            }
        }
        return this.staticChoiceValues.get(index);
    }

    @Override
    public void insertStaticChoiceValue(StaticChoiceValueModel staticChoiceValue, int index) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.staticChoiceValues == null) {
            this.staticChoiceValues = new ArrayList<StaticChoiceValueModel>();
            if (this.getId() != null) {
                Collection staticChoiceValuesCollection = this.commonCaller.fetchChildren(this, ServiceValueDescriptorModelEnum.STATIC_CHOICE_VALUES.getPropertyName());
                this.staticChoiceValues.addAll(staticChoiceValuesCollection);
            }
        }
        if (this.staticChoiceValues.contains(staticChoiceValue)) {
            this.removeStaticChoiceValue(staticChoiceValue);
        }
        this.staticChoiceValues.add(index, staticChoiceValue);
        this.fireValueChanged(ServiceValueDescriptorModelEnum.STATIC_CHOICE_VALUES, staticChoiceValue, null);
        if (staticChoiceValue != null) {
            staticChoiceValue.setServiceValueDescriptor(this);
        }
        this.reorderStaticChoiceValues(index);
    }

    @Override
    public void removeStaticChoiceValueAt(int index) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.staticChoiceValues == null) {
            this.staticChoiceValues = new ArrayList<StaticChoiceValueModel>();
            if (this.getId() != null) {
                Collection staticChoiceValuesCollection = this.commonCaller.fetchChildren(this, ServiceValueDescriptorModelEnum.STATIC_CHOICE_VALUES.getPropertyName());
                this.staticChoiceValues.addAll(staticChoiceValuesCollection);
            }
        }
        StaticChoiceValueModel oldStaticChoiceValue = this.staticChoiceValues.get(index);
        this.staticChoiceValues.remove(index);
        this.fireValueChanged(ServiceValueDescriptorModelEnum.STATIC_CHOICE_VALUES, oldStaticChoiceValue, null);
        if (oldStaticChoiceValue != null) {
            oldStaticChoiceValue.setServiceValueDescriptor(null);
            oldStaticChoiceValue.setSortOrder(null);
        }
        this.reorderStaticChoiceValues(index);
    }

    @Override
    public void setStaticChoiceValueAt(StaticChoiceValueModel staticChoiceValue, int index) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.staticChoiceValues == null) {
            this.staticChoiceValues = new ArrayList<StaticChoiceValueModel>();
            if (this.getId() != null) {
                Collection staticChoiceValuesCollection = this.commonCaller.fetchChildren(this, ServiceValueDescriptorModelEnum.STATIC_CHOICE_VALUES.getPropertyName());
                this.staticChoiceValues.addAll(staticChoiceValuesCollection);
            }
        }
        StaticChoiceValueModel oldStaticChoiceValue = this.staticChoiceValues.get(index);
        this.staticChoiceValues.set(index, staticChoiceValue);
        this.fireValueChanged(ServiceValueDescriptorModelEnum.STATIC_CHOICE_VALUES, staticChoiceValue, oldStaticChoiceValue);
        if (oldStaticChoiceValue != null) {
            oldStaticChoiceValue.setServiceValueDescriptor(null);
            oldStaticChoiceValue.setSortOrder(null);
        }
        if (staticChoiceValue != null) {
            staticChoiceValue.setServiceValueDescriptor(this);
            staticChoiceValue.setSortOrder(index);
        }
    }

    @Override
    public void clearStaticChoiceValues() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.staticChoiceValues == null) {
            this.staticChoiceValues = new ArrayList<StaticChoiceValueModel>();
            if (this.getId() != null) {
                Collection staticChoiceValuesCollection = this.commonCaller.fetchChildren(this, ServiceValueDescriptorModelEnum.STATIC_CHOICE_VALUES.getPropertyName());
                this.staticChoiceValues.addAll(staticChoiceValuesCollection);
            }
        }
        ArrayList<StaticChoiceValueModel> oldStaticChoiceValues = new ArrayList<StaticChoiceValueModel>(this.staticChoiceValues);
        this.staticChoiceValues.clear();
        this.fireValueChanged(ServiceValueDescriptorModelEnum.STATIC_CHOICE_VALUES, null, null);
        for (StaticChoiceValueModel oldStaticChoiceValue : oldStaticChoiceValues) {
            if (oldStaticChoiceValue == null) continue;
            oldStaticChoiceValue.setServiceValueDescriptor(null);
            oldStaticChoiceValue.setSortOrder(null);
        }
    }

    @Override
    public boolean isStaticChoiceValuesEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.staticChoiceValues == null) {
            this.staticChoiceValues = new ArrayList<StaticChoiceValueModel>();
            if (this.getId() != null) {
                Collection staticChoiceValuesCollection = this.commonCaller.fetchChildren(this, ServiceValueDescriptorModelEnum.STATIC_CHOICE_VALUES.getPropertyName());
                this.staticChoiceValues.addAll(staticChoiceValuesCollection);
            }
        }
        return this.staticChoiceValues.isEmpty();
    }

    @Override
    public boolean containsStaticChoiceValue(StaticChoiceValueModel staticChoiceValue) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.staticChoiceValues == null) {
            this.staticChoiceValues = new ArrayList<StaticChoiceValueModel>();
            if (this.getId() != null) {
                Collection staticChoiceValuesCollection = this.commonCaller.fetchChildren(this, ServiceValueDescriptorModelEnum.STATIC_CHOICE_VALUES.getPropertyName());
                this.staticChoiceValues.addAll(staticChoiceValuesCollection);
            }
        }
        return this.staticChoiceValues.contains(staticChoiceValue);
    }

    @Override
    public int indexOfStaticChoiceValue(StaticChoiceValueModel staticChoiceValue) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.staticChoiceValues == null) {
            this.staticChoiceValues = new ArrayList<StaticChoiceValueModel>();
            if (this.getId() != null) {
                Collection staticChoiceValuesCollection = this.commonCaller.fetchChildren(this, ServiceValueDescriptorModelEnum.STATIC_CHOICE_VALUES.getPropertyName());
                this.staticChoiceValues.addAll(staticChoiceValuesCollection);
            }
        }
        return this.staticChoiceValues.indexOf(staticChoiceValue);
    }

    @Override
    public boolean isStaticChoiceValuesInitialized() {
        return this.staticChoiceValues != null;
    }

    private void reorderStaticChoiceValues(int startIndex) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.staticChoiceValues == null) {
            this.staticChoiceValues = new ArrayList<StaticChoiceValueModel>();
            if (this.getId() != null) {
                Collection staticChoiceValuesCollection = this.commonCaller.fetchChildren(this, ServiceValueDescriptorModelEnum.STATIC_CHOICE_VALUES.getPropertyName());
                this.staticChoiceValues.addAll(staticChoiceValuesCollection);
            }
        }
        ListIterator<StaticChoiceValueModel> listIterator = this.staticChoiceValues.listIterator(startIndex);
        int index = startIndex;
        while (listIterator.hasNext()) {
            StaticChoiceValueModel staticChoiceValue = listIterator.next();
            staticChoiceValue.setSortOrder(index++);
        }
    }

    @Override
    public Boolean getModifiable() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.modifiable;
    }

    @Override
    public void setModifiable(Boolean modifiable) {
        this.setModifiable(modifiable, true);
    }

    private void setModifiable(Boolean modifiable, boolean setDirty) {
        Boolean oldModifiable = this.getModifiable();
        if (new EqualsBuilder().append(oldModifiable, modifiable).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ServiceValueDescriptorModelEnum.MODIFIABLE.getPropertyName());
        }
        this.modifiable = modifiable;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ServiceValueDescriptorModelEnum.MODIFIABLE, modifiable, oldModifiable);
    }

    @Override
    public Double getLowerLimit() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.lowerLimit;
    }

    @Override
    public void setLowerLimit(Double lowerLimit) {
        this.setLowerLimit(lowerLimit, true);
    }

    private void setLowerLimit(Double lowerLimit, boolean setDirty) {
        Double oldLowerLimit = this.getLowerLimit();
        if (new EqualsBuilder().append(oldLowerLimit, lowerLimit).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ServiceValueDescriptorModelEnum.LOWER_LIMIT.getPropertyName());
        }
        this.lowerLimit = lowerLimit;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ServiceValueDescriptorModelEnum.LOWER_LIMIT, lowerLimit, oldLowerLimit);
    }

    @Override
    public Double getUpperLimit() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.upperLimit;
    }

    @Override
    public void setUpperLimit(Double upperLimit) {
        this.setUpperLimit(upperLimit, true);
    }

    private void setUpperLimit(Double upperLimit, boolean setDirty) {
        Double oldUpperLimit = this.getUpperLimit();
        if (new EqualsBuilder().append(oldUpperLimit, upperLimit).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ServiceValueDescriptorModelEnum.UPPER_LIMIT.getPropertyName());
        }
        this.upperLimit = upperLimit;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ServiceValueDescriptorModelEnum.UPPER_LIMIT, upperLimit, oldUpperLimit);
    }

    @Override
    public AttributeGroupModel getGroup() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.group;
    }

    @Override
    public void setGroup(AttributeGroupModel group) {
        this.setGroup(group, true);
    }

    private void setGroup(AttributeGroupModel group, boolean setDirty) {
        AttributeGroupModel oldGroup = this.getGroup();
        if (oldGroup == group) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ServiceValueDescriptorModelEnum.GROUP.getPropertyName());
        }
        this.group = group;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ServiceValueDescriptorModelEnum.GROUP, group, oldGroup);
    }

    @Override
    public void setProxy(boolean proxy) {
        super.setProxy(proxy);
        if (proxy) {
            this.staticChoiceValues = null;
        }
    }

    @Override
    protected void updateByDto(ServiceValueDescriptorFullDto serviceValueDescriptorDto) {
        this.name = serviceValueDescriptorDto.getName();
        this.description = serviceValueDescriptorDto.getDescription();
        this.key = serviceValueDescriptorDto.getKey();
        this.serviceValueType = serviceValueDescriptorDto.getServiceValueType();
        this.service = (ServiceModel)this.getModelCache().getModel(serviceValueDescriptorDto.getService());
        this.editable = serviceValueDescriptorDto.getEditable();
        this.sortOrder = serviceValueDescriptorDto.getSortOrder();
        this.canPrint = serviceValueDescriptorDto.getCanPrint();
        this.printSortOrder = serviceValueDescriptorDto.getPrintSortOrder();
        this.printLength = serviceValueDescriptorDto.getPrintLength();
        StaticChoiceValueDto[] staticChoiceValues = serviceValueDescriptorDto.getStaticChoiceValues();
        if (staticChoiceValues != null) {
            if (this.staticChoiceValues == null) {
                this.staticChoiceValues = new ArrayList<StaticChoiceValueModel>();
            } else {
                this.staticChoiceValues.clear();
            }
        }
        this.modifiable = serviceValueDescriptorDto.getModifiable();
        this.lowerLimit = serviceValueDescriptorDto.getLowerLimit();
        this.upperLimit = serviceValueDescriptorDto.getUpperLimit();
        this.group = (AttributeGroupModel)this.getModelCache().getModel(serviceValueDescriptorDto.getGroup());
    }

    @Override
    protected void updateMasterRelationsByDto(ServiceValueDescriptorFullDto serviceValueDescriptorDto) {
        StaticChoiceValueDto[] staticChoiceValues = serviceValueDescriptorDto.getStaticChoiceValues();
        if (staticChoiceValues != null) {
            if (this.staticChoiceValues == null) {
                this.staticChoiceValues = new ArrayList<StaticChoiceValueModel>();
            } else {
                this.staticChoiceValues.clear();
            }
            for (StaticChoiceValueDto staticChoiceValueDto : staticChoiceValues) {
                StaticChoiceValueModel staticChoiceValueModel = (StaticChoiceValueModel)this.getModelCache().getModel(staticChoiceValueDto);
                this.staticChoiceValues.add(staticChoiceValueModel);
            }
        } else {
            this.staticChoiceValues = null;
        }
    }

    @Override
    protected void checkStaleByDto(ServiceValueDescriptorFullDto serviceValueDescriptorDto) throws StaleStateException {
        AttributeGroupModelImpl groupModel;
        AttributeGroupDto groupDto;
        StaticChoiceValueDto[] staticChoiceValueDtos;
        ServiceModelImpl serviceModel;
        ServiceDto serviceDto = serviceValueDescriptorDto.getService();
        if (serviceDto != null && serviceDto.getId() != null && (serviceModel = (ServiceModelImpl)this.getModelCache().getModel(ServiceModel.class, serviceDto.getId())) != null) {
            serviceModel.checkStaleState(serviceDto);
        }
        if ((staticChoiceValueDtos = serviceValueDescriptorDto.getStaticChoiceValues()) != null) {
            for (StaticChoiceValueDto staticChoiceValueDto : staticChoiceValueDtos) {
                StaticChoiceValueModelImpl staticChoiceValueModel = (StaticChoiceValueModelImpl)this.getModelCache().getModel(StaticChoiceValueModel.class, staticChoiceValueDto.getId());
                if (staticChoiceValueModel == null) continue;
                staticChoiceValueModel.checkStaleState(staticChoiceValueDto);
            }
        }
        if ((groupDto = serviceValueDescriptorDto.getGroup()) != null && groupDto.getId() != null && (groupModel = (AttributeGroupModelImpl)this.getModelCache().getModel(AttributeGroupModel.class, groupDto.getId())) != null) {
            groupModel.checkStaleState(groupDto);
        }
    }

    @Override
    public ServiceValueDescriptorFullDto createDto() {
        Long id = this.getId();
        ServiceValueDescriptorFullDto serviceValueDescriptorDto = id == null ? new ServiceValueDescriptorFullDto(this.getTempUUID()) : new ServiceValueDescriptorFullDto(id, this.getVersion());
        serviceValueDescriptorDto.setName(this.getName());
        serviceValueDescriptorDto.setDescription(this.getDescription());
        serviceValueDescriptorDto.setKey(this.getKey());
        serviceValueDescriptorDto.setServiceValueType(this.getServiceValueType());
        ServiceModelImpl service = (ServiceModelImpl)this.getService();
        if (service != null) {
            serviceValueDescriptorDto.setService(service.createProxy());
        }
        serviceValueDescriptorDto.setEditable(this.getEditable());
        serviceValueDescriptorDto.setSortOrder(this.getSortOrder());
        serviceValueDescriptorDto.setCanPrint(this.getCanPrint());
        serviceValueDescriptorDto.setPrintSortOrder(this.getPrintSortOrder());
        serviceValueDescriptorDto.setPrintLength(this.getPrintLength());
        serviceValueDescriptorDto.setModifiable(this.getModifiable());
        serviceValueDescriptorDto.setLowerLimit(this.getLowerLimit());
        serviceValueDescriptorDto.setUpperLimit(this.getUpperLimit());
        AttributeGroupModelImpl group = (AttributeGroupModelImpl)this.getGroup();
        if (group != null) {
            serviceValueDescriptorDto.setGroup(group.createProxy());
        }
        return serviceValueDescriptorDto;
    }

    @Override
    public ServiceValueDescriptorProxyDto createProxy() {
        Long id = this.getId();
        ServiceValueDescriptorProxyDto serviceValueDescriptorDto = id == null ? new ServiceValueDescriptorProxyDto(this.getTempUUID()) : new ServiceValueDescriptorProxyDto(id, this.getVersion());
        return serviceValueDescriptorDto;
    }

    public static enum ServiceValueDescriptorModelEnum {
        NAME("name"),
        DESCRIPTION("description"),
        KEY("key"),
        SERVICE_VALUE_TYPE("serviceValueType"),
        SERVICE("service"),
        EDITABLE("editable"),
        SORT_ORDER("sortOrder"),
        CAN_PRINT("canPrint"),
        PRINT_SORT_ORDER("printSortOrder"),
        PRINT_LENGTH("printLength"),
        STATIC_CHOICE_VALUES("staticChoiceValues"),
        MODIFIABLE("modifiable"),
        LOWER_LIMIT("lowerLimit"),
        UPPER_LIMIT("upperLimit"),
        GROUP("group");

        private String propertyName;

        private ServiceValueDescriptorModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

