/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.base;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.base.ServiceModel;
import de.datomino.peppergis.client.model.base.ServiceModelImpl;
import de.datomino.peppergis.client.model.base.ServiceStatusConfigurationModel;
import de.datomino.peppergis.client.model.base.ServiceStatusValueConfigurationModel;
import de.datomino.peppergis.client.model.base.ServiceStatusValueConfigurationModelImpl;
import de.datomino.peppergis.dto.base.ServiceDto;
import de.datomino.peppergis.dto.base.ServiceStatusConfigurationFullDto;
import de.datomino.peppergis.dto.base.ServiceStatusConfigurationProxyDto;
import de.datomino.peppergis.dto.base.ServiceStatusValueConfigurationDto;
import de.datomino.peppergis.exception.StaleStateException;
import de.datomino.peppergis.type.ServiceStatusType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;
import org.ktde.util.conversions.ImmutableIterator;
import org.ktde.util.conversions.IteratorIterable;

public class ServiceStatusConfigurationModelImpl
extends AbstractModel<ServiceStatusConfigurationFullDto, ServiceStatusConfigurationProxyDto>
implements ServiceStatusConfigurationModel {
    private ServiceModel service;
    private ServiceStatusType type;
    private Set<ServiceStatusValueConfigurationModel> serviceStatusValueConfigurations = null;

    public ServiceStatusConfigurationModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public ServiceStatusConfigurationModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public ServiceModel getService() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.service;
    }

    @Override
    public void setService(ServiceModel service) {
        this.setService(service, true);
    }

    private void setService(ServiceModel service, boolean setDirty) {
        ServiceModel oldService = this.getService();
        if (oldService == service) {
            return;
        }
        if (oldService != null) {
            oldService.removeServiceStatusConfiguration(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ServiceStatusConfigurationModelEnum.SERVICE.getPropertyName());
        }
        this.service = service;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ServiceStatusConfigurationModelEnum.SERVICE, service, oldService);
        if (this.service != null) {
            this.service.addServiceStatusConfiguration(this);
        }
    }

    @Override
    public ServiceStatusType getType() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.type;
    }

    @Override
    public void setType(ServiceStatusType type) {
        this.setType(type, true);
    }

    private void setType(ServiceStatusType type, boolean setDirty) {
        ServiceStatusType oldType = this.getType();
        if (new EqualsBuilder().append((Object)oldType, (Object)type).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ServiceStatusConfigurationModelEnum.TYPE.getPropertyName());
        }
        this.type = type;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ServiceStatusConfigurationModelEnum.TYPE, (Object)type, (Object)oldType);
    }

    @Override
    public int countServiceStatusValueConfigurations() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.serviceStatusValueConfigurations == null) {
            this.serviceStatusValueConfigurations = new LinkedHashSet<ServiceStatusValueConfigurationModel>();
            if (this.getId() != null) {
                Collection serviceStatusValueConfigurationsCollection = this.commonCaller.fetchChildren(this, ServiceStatusConfigurationModelEnum.SERVICE_STATUS_VALUE_CONFIGURATIONS.getPropertyName());
                this.serviceStatusValueConfigurations.addAll(serviceStatusValueConfigurationsCollection);
            }
        }
        return this.serviceStatusValueConfigurations.size();
    }

    @Override
    public Iterator<ServiceStatusValueConfigurationModel> iterateServiceStatusValueConfigurations() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.serviceStatusValueConfigurations == null) {
            this.serviceStatusValueConfigurations = new LinkedHashSet<ServiceStatusValueConfigurationModel>();
            if (this.getId() != null) {
                Collection serviceStatusValueConfigurationsCollection = this.commonCaller.fetchChildren(this, ServiceStatusConfigurationModelEnum.SERVICE_STATUS_VALUE_CONFIGURATIONS.getPropertyName());
                this.serviceStatusValueConfigurations.addAll(serviceStatusValueConfigurationsCollection);
            }
        }
        return new ImmutableIterator<ServiceStatusValueConfigurationModel>(this.serviceStatusValueConfigurations);
    }

    @Override
    public Iterable<ServiceStatusValueConfigurationModel> iterableServiceStatusValueConfigurations() {
        return new IteratorIterable<ServiceStatusValueConfigurationModel>(this.iterateServiceStatusValueConfigurations());
    }

    @Override
    public void addServiceStatusValueConfiguration(ServiceStatusValueConfigurationModel serviceStatusValueConfiguration) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.serviceStatusValueConfigurations == null) {
            this.serviceStatusValueConfigurations = new LinkedHashSet<ServiceStatusValueConfigurationModel>();
            if (this.getId() != null) {
                Collection serviceStatusValueConfigurationsCollection = this.commonCaller.fetchChildren(this, ServiceStatusConfigurationModelEnum.SERVICE_STATUS_VALUE_CONFIGURATIONS.getPropertyName());
                this.serviceStatusValueConfigurations.addAll(serviceStatusValueConfigurationsCollection);
            }
        }
        if (this.serviceStatusValueConfigurations.contains(serviceStatusValueConfiguration)) {
            return;
        }
        this.serviceStatusValueConfigurations.add(serviceStatusValueConfiguration);
        this.fireValueChanged(ServiceStatusConfigurationModelEnum.SERVICE_STATUS_VALUE_CONFIGURATIONS, serviceStatusValueConfiguration, null);
        if (serviceStatusValueConfiguration != null) {
            serviceStatusValueConfiguration.setServiceStatusConfiguration(this);
        }
    }

    @Override
    public void removeServiceStatusValueConfiguration(ServiceStatusValueConfigurationModel serviceStatusValueConfiguration) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.serviceStatusValueConfigurations == null) {
            this.serviceStatusValueConfigurations = new LinkedHashSet<ServiceStatusValueConfigurationModel>();
            if (this.getId() != null) {
                Collection serviceStatusValueConfigurationsCollection = this.commonCaller.fetchChildren(this, ServiceStatusConfigurationModelEnum.SERVICE_STATUS_VALUE_CONFIGURATIONS.getPropertyName());
                this.serviceStatusValueConfigurations.addAll(serviceStatusValueConfigurationsCollection);
            }
        }
        if (!this.serviceStatusValueConfigurations.contains(serviceStatusValueConfiguration)) {
            return;
        }
        this.serviceStatusValueConfigurations.remove(serviceStatusValueConfiguration);
        this.fireValueChanged(ServiceStatusConfigurationModelEnum.SERVICE_STATUS_VALUE_CONFIGURATIONS, serviceStatusValueConfiguration, null);
        if (serviceStatusValueConfiguration != null) {
            serviceStatusValueConfiguration.setServiceStatusConfiguration(null);
        }
    }

    @Override
    public void clearServiceStatusValueConfigurations() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.serviceStatusValueConfigurations == null) {
            this.serviceStatusValueConfigurations = new LinkedHashSet<ServiceStatusValueConfigurationModel>();
            if (this.getId() != null) {
                Collection serviceStatusValueConfigurationsCollection = this.commonCaller.fetchChildren(this, ServiceStatusConfigurationModelEnum.SERVICE_STATUS_VALUE_CONFIGURATIONS.getPropertyName());
                this.serviceStatusValueConfigurations.addAll(serviceStatusValueConfigurationsCollection);
            }
        }
        ArrayList<ServiceStatusValueConfigurationModel> oldServiceStatusValueConfigurations = new ArrayList<ServiceStatusValueConfigurationModel>(this.serviceStatusValueConfigurations);
        this.serviceStatusValueConfigurations.clear();
        this.fireValueChanged(ServiceStatusConfigurationModelEnum.SERVICE_STATUS_VALUE_CONFIGURATIONS, null, null);
        for (ServiceStatusValueConfigurationModel oldServiceStatusValueConfiguration : oldServiceStatusValueConfigurations) {
            if (oldServiceStatusValueConfiguration == null) continue;
            oldServiceStatusValueConfiguration.setServiceStatusConfiguration(null);
        }
    }

    @Override
    public boolean isServiceStatusValueConfigurationsEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.serviceStatusValueConfigurations == null) {
            this.serviceStatusValueConfigurations = new LinkedHashSet<ServiceStatusValueConfigurationModel>();
            if (this.getId() != null) {
                Collection serviceStatusValueConfigurationsCollection = this.commonCaller.fetchChildren(this, ServiceStatusConfigurationModelEnum.SERVICE_STATUS_VALUE_CONFIGURATIONS.getPropertyName());
                this.serviceStatusValueConfigurations.addAll(serviceStatusValueConfigurationsCollection);
            }
        }
        return this.serviceStatusValueConfigurations.isEmpty();
    }

    @Override
    public boolean containsServiceStatusValueConfiguration(ServiceStatusValueConfigurationModel serviceStatusValueConfiguration) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.serviceStatusValueConfigurations == null) {
            this.serviceStatusValueConfigurations = new LinkedHashSet<ServiceStatusValueConfigurationModel>();
            if (this.getId() != null) {
                Collection serviceStatusValueConfigurationsCollection = this.commonCaller.fetchChildren(this, ServiceStatusConfigurationModelEnum.SERVICE_STATUS_VALUE_CONFIGURATIONS.getPropertyName());
                this.serviceStatusValueConfigurations.addAll(serviceStatusValueConfigurationsCollection);
            }
        }
        return this.serviceStatusValueConfigurations.contains(serviceStatusValueConfiguration);
    }

    @Override
    public boolean isServiceStatusValueConfigurationsInitialized() {
        return this.serviceStatusValueConfigurations != null;
    }

    @Override
    public void setProxy(boolean proxy) {
        super.setProxy(proxy);
        if (proxy) {
            this.serviceStatusValueConfigurations = null;
        }
    }

    @Override
    protected void updateByDto(ServiceStatusConfigurationFullDto serviceStatusConfigurationDto) {
        this.service = (ServiceModel)this.getModelCache().getModel(serviceStatusConfigurationDto.getService());
        this.type = serviceStatusConfigurationDto.getType();
        ServiceStatusValueConfigurationDto[] serviceStatusValueConfigurations = serviceStatusConfigurationDto.getServiceStatusValueConfigurations();
        if (serviceStatusValueConfigurations != null) {
            if (this.serviceStatusValueConfigurations == null) {
                this.serviceStatusValueConfigurations = new LinkedHashSet<ServiceStatusValueConfigurationModel>();
            } else {
                this.serviceStatusValueConfigurations.clear();
            }
        }
    }

    @Override
    protected void updateMasterRelationsByDto(ServiceStatusConfigurationFullDto serviceStatusConfigurationDto) {
        ServiceStatusValueConfigurationDto[] serviceStatusValueConfigurations = serviceStatusConfigurationDto.getServiceStatusValueConfigurations();
        if (serviceStatusValueConfigurations != null) {
            if (this.serviceStatusValueConfigurations == null) {
                this.serviceStatusValueConfigurations = new LinkedHashSet<ServiceStatusValueConfigurationModel>();
            } else {
                this.serviceStatusValueConfigurations.clear();
            }
            for (ServiceStatusValueConfigurationDto serviceStatusValueConfigurationDto : serviceStatusValueConfigurations) {
                ServiceStatusValueConfigurationModel serviceStatusValueConfigurationModel = (ServiceStatusValueConfigurationModel)this.getModelCache().getModel(serviceStatusValueConfigurationDto);
                this.serviceStatusValueConfigurations.add(serviceStatusValueConfigurationModel);
            }
        } else {
            this.serviceStatusValueConfigurations = null;
        }
    }

    @Override
    protected void checkStaleByDto(ServiceStatusConfigurationFullDto serviceStatusConfigurationDto) throws StaleStateException {
        ServiceStatusValueConfigurationDto[] serviceStatusValueConfigurationDtos;
        ServiceModelImpl serviceModel;
        ServiceDto serviceDto = serviceStatusConfigurationDto.getService();
        if (serviceDto != null && serviceDto.getId() != null && (serviceModel = (ServiceModelImpl)this.getModelCache().getModel(ServiceModel.class, serviceDto.getId())) != null) {
            serviceModel.checkStaleState(serviceDto);
        }
        if ((serviceStatusValueConfigurationDtos = serviceStatusConfigurationDto.getServiceStatusValueConfigurations()) != null) {
            for (ServiceStatusValueConfigurationDto serviceStatusValueConfigurationDto : serviceStatusValueConfigurationDtos) {
                ServiceStatusValueConfigurationModelImpl serviceStatusValueConfigurationModel = (ServiceStatusValueConfigurationModelImpl)this.getModelCache().getModel(ServiceStatusValueConfigurationModel.class, serviceStatusValueConfigurationDto.getId());
                if (serviceStatusValueConfigurationModel == null) continue;
                serviceStatusValueConfigurationModel.checkStaleState(serviceStatusValueConfigurationDto);
            }
        }
    }

    @Override
    public ServiceStatusConfigurationFullDto createDto() {
        Long id = this.getId();
        ServiceStatusConfigurationFullDto serviceStatusConfigurationDto = id == null ? new ServiceStatusConfigurationFullDto(this.getTempUUID()) : new ServiceStatusConfigurationFullDto(id, this.getVersion());
        ServiceModelImpl service = (ServiceModelImpl)this.getService();
        if (service != null) {
            serviceStatusConfigurationDto.setService(service.createProxy());
        }
        serviceStatusConfigurationDto.setType(this.getType());
        return serviceStatusConfigurationDto;
    }

    @Override
    public ServiceStatusConfigurationProxyDto createProxy() {
        Long id = this.getId();
        ServiceStatusConfigurationProxyDto serviceStatusConfigurationDto = id == null ? new ServiceStatusConfigurationProxyDto(this.getTempUUID()) : new ServiceStatusConfigurationProxyDto(id, this.getVersion());
        return serviceStatusConfigurationDto;
    }

    public static enum ServiceStatusConfigurationModelEnum {
        SERVICE("service"),
        TYPE("type"),
        SERVICE_STATUS_VALUE_CONFIGURATIONS("serviceStatusValueConfigurations");

        private String propertyName;

        private ServiceStatusConfigurationModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

