/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.base;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.base.PrintContentModel;
import de.datomino.peppergis.dto.base.PrintContentFullDto;
import de.datomino.peppergis.dto.base.PrintContentProxyDto;
import de.datomino.peppergis.exception.StaleStateException;
import de.datomino.peppergis.type.PrintContentKey;
import de.datomino.peppergis.type.PrintObject;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;

public class PrintContentModelImpl
extends AbstractModel<PrintContentFullDto, PrintContentProxyDto>
implements PrintContentModel {
    private PrintObject printObject;
    private PrintContentKey key;
    private Boolean canPrint;
    private Integer printSortOrder;
    private Integer printLength;

    public PrintContentModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public PrintContentModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public PrintObject getPrintObject() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.printObject;
    }

    @Override
    public void setPrintObject(PrintObject printObject) {
        this.setPrintObject(printObject, true);
    }

    private void setPrintObject(PrintObject printObject, boolean setDirty) {
        PrintObject oldPrintObject = this.getPrintObject();
        if (new EqualsBuilder().append((Object)oldPrintObject, (Object)printObject).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, PrintContentModelEnum.PRINT_OBJECT.getPropertyName());
        }
        this.printObject = printObject;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(PrintContentModelEnum.PRINT_OBJECT, (Object)printObject, (Object)oldPrintObject);
    }

    @Override
    public PrintContentKey getKey() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.key;
    }

    @Override
    public void setKey(PrintContentKey key) {
        this.setKey(key, true);
    }

    private void setKey(PrintContentKey key, boolean setDirty) {
        PrintContentKey oldKey = this.getKey();
        if (new EqualsBuilder().append(oldKey, key).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, PrintContentModelEnum.KEY.getPropertyName());
        }
        this.key = key;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(PrintContentModelEnum.KEY, key, oldKey);
    }

    @Override
    public Boolean getCanPrint() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.canPrint;
    }

    @Override
    public void setCanPrint(Boolean canPrint) {
        this.setCanPrint(canPrint, true);
    }

    private void setCanPrint(Boolean canPrint, boolean setDirty) {
        Boolean oldCanPrint = this.getCanPrint();
        if (new EqualsBuilder().append(oldCanPrint, canPrint).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, PrintContentModelEnum.CAN_PRINT.getPropertyName());
        }
        this.canPrint = canPrint;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(PrintContentModelEnum.CAN_PRINT, canPrint, oldCanPrint);
    }

    @Override
    public Integer getPrintSortOrder() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.printSortOrder;
    }

    @Override
    public void setPrintSortOrder(Integer printSortOrder) {
        this.setPrintSortOrder(printSortOrder, true);
    }

    private void setPrintSortOrder(Integer printSortOrder, boolean setDirty) {
        Integer oldPrintSortOrder = this.getPrintSortOrder();
        if (new EqualsBuilder().append(oldPrintSortOrder, printSortOrder).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, PrintContentModelEnum.PRINT_SORT_ORDER.getPropertyName());
        }
        this.printSortOrder = printSortOrder;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(PrintContentModelEnum.PRINT_SORT_ORDER, printSortOrder, oldPrintSortOrder);
    }

    @Override
    public Integer getPrintLength() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.printLength;
    }

    @Override
    public void setPrintLength(Integer printLength) {
        this.setPrintLength(printLength, true);
    }

    private void setPrintLength(Integer printLength, boolean setDirty) {
        Integer oldPrintLength = this.getPrintLength();
        if (new EqualsBuilder().append(oldPrintLength, printLength).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, PrintContentModelEnum.PRINT_LENGTH.getPropertyName());
        }
        this.printLength = printLength;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(PrintContentModelEnum.PRINT_LENGTH, printLength, oldPrintLength);
    }

    @Override
    protected void updateByDto(PrintContentFullDto printContentDto) {
        this.printObject = printContentDto.getPrintObject();
        this.key = printContentDto.getKey();
        this.canPrint = printContentDto.getCanPrint();
        this.printSortOrder = printContentDto.getPrintSortOrder();
        this.printLength = printContentDto.getPrintLength();
    }

    @Override
    protected void updateMasterRelationsByDto(PrintContentFullDto printContentDto) {
    }

    @Override
    protected void checkStaleByDto(PrintContentFullDto printContentDto) throws StaleStateException {
    }

    @Override
    public PrintContentFullDto createDto() {
        Long id = this.getId();
        PrintContentFullDto printContentDto = id == null ? new PrintContentFullDto(this.getTempUUID()) : new PrintContentFullDto(id, this.getVersion());
        printContentDto.setPrintObject(this.getPrintObject());
        printContentDto.setKey(this.getKey());
        printContentDto.setCanPrint(this.getCanPrint());
        printContentDto.setPrintSortOrder(this.getPrintSortOrder());
        printContentDto.setPrintLength(this.getPrintLength());
        return printContentDto;
    }

    @Override
    public PrintContentProxyDto createProxy() {
        Long id = this.getId();
        PrintContentProxyDto printContentDto = id == null ? new PrintContentProxyDto(this.getTempUUID()) : new PrintContentProxyDto(id, this.getVersion());
        return printContentDto;
    }

    public static enum PrintContentModelEnum {
        PRINT_OBJECT("printObject"),
        KEY("key"),
        CAN_PRINT("canPrint"),
        PRINT_SORT_ORDER("printSortOrder"),
        PRINT_LENGTH("printLength");

        private String propertyName;

        private PrintContentModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

