/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.base;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.area.AreaObjectModelImpl;
import de.datomino.peppergis.client.model.base.BranchModel;
import de.datomino.peppergis.client.model.base.BranchModelImpl;
import de.datomino.peppergis.client.model.base.ImageModel;
import de.datomino.peppergis.client.model.base.ImageModelImpl;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.model.base.LocationModelImpl;
import de.datomino.peppergis.client.model.base.PoiAttributeValueModel;
import de.datomino.peppergis.client.model.base.PoiAttributeValueModelImpl;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.client.model.tour.AreaDelivererModel;
import de.datomino.peppergis.client.model.tour.AreaDelivererModelImpl;
import de.datomino.peppergis.client.model.tour.DelivererModel;
import de.datomino.peppergis.client.model.tour.DelivererModelImpl;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.model.tour.StopModelImpl;
import de.datomino.peppergis.dto.area.AreaObjectDto;
import de.datomino.peppergis.dto.base.BranchDto;
import de.datomino.peppergis.dto.base.ImageDto;
import de.datomino.peppergis.dto.base.LocationDto;
import de.datomino.peppergis.dto.base.PoiAttributeValueDto;
import de.datomino.peppergis.dto.base.PoiFullDto;
import de.datomino.peppergis.dto.base.PoiProxyDto;
import de.datomino.peppergis.dto.tour.AreaDelivererDto;
import de.datomino.peppergis.dto.tour.DelivererDto;
import de.datomino.peppergis.dto.tour.StopDto;
import de.datomino.peppergis.exception.StaleStateException;
import de.datomino.peppergis.type.PoiType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;
import org.ktde.util.conversions.ImmutableIterator;
import org.ktde.util.conversions.IteratorIterable;

public class PoiModelImpl
extends AbstractModel<PoiFullDto, PoiProxyDto>
implements PoiModel {
    private String poiNumber;
    private String name;
    private String information;
    private LocationModel location;
    private PoiType poiType;
    private Set<PoiAttributeValueModel> poiAttributeValues = null;
    private ImageModel image;
    private Set<AreaObjectModel> areaObjects = null;
    private Set<AreaObjectModel> firstThrowAreaObjects = null;
    private Set<AreaObjectModel> lastThrowAreaObjects = null;
    private Set<DelivererModel> deliverers = null;
    private Set<AreaDelivererModel> areaDeliverers = null;
    private Set<StopModel> stops = null;
    private Set<BranchModel> branches = null;

    public PoiModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public PoiModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public String getPoiNumber() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.poiNumber;
    }

    @Override
    public void setPoiNumber(String poiNumber) {
        this.setPoiNumber(poiNumber, true);
    }

    private void setPoiNumber(String poiNumber, boolean setDirty) {
        String oldPoiNumber = this.getPoiNumber();
        if (new EqualsBuilder().append(oldPoiNumber, poiNumber).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, PoiModelEnum.POI_NUMBER.getPropertyName());
        }
        this.poiNumber = poiNumber;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(PoiModelEnum.POI_NUMBER, poiNumber, oldPoiNumber);
    }

    @Override
    public String getName() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.setName(name, true);
    }

    private void setName(String name, boolean setDirty) {
        String oldName = this.getName();
        if (new EqualsBuilder().append(oldName, name).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, PoiModelEnum.NAME.getPropertyName());
        }
        this.name = name;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(PoiModelEnum.NAME, name, oldName);
    }

    @Override
    public String getInformation() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.information;
    }

    @Override
    public void setInformation(String information) {
        this.setInformation(information, true);
    }

    private void setInformation(String information, boolean setDirty) {
        String oldInformation = this.getInformation();
        if (new EqualsBuilder().append(oldInformation, information).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, PoiModelEnum.INFORMATION.getPropertyName());
        }
        this.information = information;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(PoiModelEnum.INFORMATION, information, oldInformation);
    }

    @Override
    public LocationModel getLocation() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.location;
    }

    @Override
    public void setLocation(LocationModel location) {
        this.setLocation(location, true);
    }

    private void setLocation(LocationModel location, boolean setDirty) {
        LocationModel oldLocation = this.getLocation();
        if (oldLocation == location) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, PoiModelEnum.LOCATION.getPropertyName());
        }
        this.location = location;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(PoiModelEnum.LOCATION, location, oldLocation);
    }

    @Override
    public PoiType getPoiType() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.poiType;
    }

    @Override
    public void setPoiType(PoiType poiType) {
        this.setPoiType(poiType, true);
    }

    private void setPoiType(PoiType poiType, boolean setDirty) {
        PoiType oldPoiType = this.getPoiType();
        if (new EqualsBuilder().append((Object)oldPoiType, (Object)poiType).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, PoiModelEnum.POI_TYPE.getPropertyName());
        }
        this.poiType = poiType;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(PoiModelEnum.POI_TYPE, (Object)poiType, (Object)oldPoiType);
    }

    @Override
    public int countPoiAttributeValues() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.poiAttributeValues == null) {
            this.poiAttributeValues = new LinkedHashSet<PoiAttributeValueModel>();
            if (this.getId() != null) {
                Collection poiAttributeValuesCollection = this.commonCaller.fetchChildren(this, PoiModelEnum.POI_ATTRIBUTE_VALUES.getPropertyName());
                this.poiAttributeValues.addAll(poiAttributeValuesCollection);
            }
        }
        return this.poiAttributeValues.size();
    }

    @Override
    public Iterator<PoiAttributeValueModel> iteratePoiAttributeValues() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.poiAttributeValues == null) {
            this.poiAttributeValues = new LinkedHashSet<PoiAttributeValueModel>();
            if (this.getId() != null) {
                Collection poiAttributeValuesCollection = this.commonCaller.fetchChildren(this, PoiModelEnum.POI_ATTRIBUTE_VALUES.getPropertyName());
                this.poiAttributeValues.addAll(poiAttributeValuesCollection);
            }
        }
        return new ImmutableIterator<PoiAttributeValueModel>(this.poiAttributeValues);
    }

    @Override
    public Iterable<PoiAttributeValueModel> iterablePoiAttributeValues() {
        return new IteratorIterable<PoiAttributeValueModel>(this.iteratePoiAttributeValues());
    }

    @Override
    public void addPoiAttributeValue(PoiAttributeValueModel poiAttributeValue) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.poiAttributeValues == null) {
            this.poiAttributeValues = new LinkedHashSet<PoiAttributeValueModel>();
            if (this.getId() != null) {
                Collection poiAttributeValuesCollection = this.commonCaller.fetchChildren(this, PoiModelEnum.POI_ATTRIBUTE_VALUES.getPropertyName());
                this.poiAttributeValues.addAll(poiAttributeValuesCollection);
            }
        }
        if (this.poiAttributeValues.contains(poiAttributeValue)) {
            return;
        }
        this.poiAttributeValues.add(poiAttributeValue);
        this.fireValueChanged(PoiModelEnum.POI_ATTRIBUTE_VALUES, poiAttributeValue, null);
        if (poiAttributeValue != null) {
            poiAttributeValue.setPoi(this);
        }
    }

    @Override
    public void removePoiAttributeValue(PoiAttributeValueModel poiAttributeValue) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.poiAttributeValues == null) {
            this.poiAttributeValues = new LinkedHashSet<PoiAttributeValueModel>();
            if (this.getId() != null) {
                Collection poiAttributeValuesCollection = this.commonCaller.fetchChildren(this, PoiModelEnum.POI_ATTRIBUTE_VALUES.getPropertyName());
                this.poiAttributeValues.addAll(poiAttributeValuesCollection);
            }
        }
        if (!this.poiAttributeValues.contains(poiAttributeValue)) {
            return;
        }
        this.poiAttributeValues.remove(poiAttributeValue);
        this.fireValueChanged(PoiModelEnum.POI_ATTRIBUTE_VALUES, poiAttributeValue, null);
        if (poiAttributeValue != null) {
            poiAttributeValue.setPoi(null);
        }
    }

    @Override
    public void clearPoiAttributeValues() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.poiAttributeValues == null) {
            this.poiAttributeValues = new LinkedHashSet<PoiAttributeValueModel>();
            if (this.getId() != null) {
                Collection poiAttributeValuesCollection = this.commonCaller.fetchChildren(this, PoiModelEnum.POI_ATTRIBUTE_VALUES.getPropertyName());
                this.poiAttributeValues.addAll(poiAttributeValuesCollection);
            }
        }
        ArrayList<PoiAttributeValueModel> oldPoiAttributeValues = new ArrayList<PoiAttributeValueModel>(this.poiAttributeValues);
        this.poiAttributeValues.clear();
        this.fireValueChanged(PoiModelEnum.POI_ATTRIBUTE_VALUES, null, null);
        for (PoiAttributeValueModel oldPoiAttributeValue : oldPoiAttributeValues) {
            if (oldPoiAttributeValue == null) continue;
            oldPoiAttributeValue.setPoi(null);
        }
    }

    @Override
    public boolean isPoiAttributeValuesEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.poiAttributeValues == null) {
            this.poiAttributeValues = new LinkedHashSet<PoiAttributeValueModel>();
            if (this.getId() != null) {
                Collection poiAttributeValuesCollection = this.commonCaller.fetchChildren(this, PoiModelEnum.POI_ATTRIBUTE_VALUES.getPropertyName());
                this.poiAttributeValues.addAll(poiAttributeValuesCollection);
            }
        }
        return this.poiAttributeValues.isEmpty();
    }

    @Override
    public boolean containsPoiAttributeValue(PoiAttributeValueModel poiAttributeValue) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.poiAttributeValues == null) {
            this.poiAttributeValues = new LinkedHashSet<PoiAttributeValueModel>();
            if (this.getId() != null) {
                Collection poiAttributeValuesCollection = this.commonCaller.fetchChildren(this, PoiModelEnum.POI_ATTRIBUTE_VALUES.getPropertyName());
                this.poiAttributeValues.addAll(poiAttributeValuesCollection);
            }
        }
        return this.poiAttributeValues.contains(poiAttributeValue);
    }

    @Override
    public boolean isPoiAttributeValuesInitialized() {
        return this.poiAttributeValues != null;
    }

    @Override
    public ImageModel getImage() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.image;
    }

    @Override
    public void setImage(ImageModel image) {
        this.setImage(image, true);
    }

    private void setImage(ImageModel image, boolean setDirty) {
        ImageModel oldImage = this.getImage();
        if (oldImage == image) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, PoiModelEnum.IMAGE.getPropertyName());
        }
        this.image = image;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(PoiModelEnum.IMAGE, image, oldImage);
    }

    @Override
    public int countAreaObjects() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaObjects == null) {
            this.areaObjects = new LinkedHashSet<AreaObjectModel>();
            if (this.getId() != null) {
                Collection areaObjectsCollection = this.commonCaller.fetchChildren(this, PoiModelEnum.AREA_OBJECTS.getPropertyName());
                this.areaObjects.addAll(areaObjectsCollection);
            }
        }
        return this.areaObjects.size();
    }

    @Override
    public Iterator<AreaObjectModel> iterateAreaObjects() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaObjects == null) {
            this.areaObjects = new LinkedHashSet<AreaObjectModel>();
            if (this.getId() != null) {
                Collection areaObjectsCollection = this.commonCaller.fetchChildren(this, PoiModelEnum.AREA_OBJECTS.getPropertyName());
                this.areaObjects.addAll(areaObjectsCollection);
            }
        }
        return new ImmutableIterator<AreaObjectModel>(this.areaObjects);
    }

    @Override
    public Iterable<AreaObjectModel> iterableAreaObjects() {
        return new IteratorIterable<AreaObjectModel>(this.iterateAreaObjects());
    }

    @Override
    public void addAreaObject(AreaObjectModel areaObject) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaObjects == null) {
            this.areaObjects = new LinkedHashSet<AreaObjectModel>();
            if (this.getId() != null) {
                Collection areaObjectsCollection = this.commonCaller.fetchChildren(this, PoiModelEnum.AREA_OBJECTS.getPropertyName());
                this.areaObjects.addAll(areaObjectsCollection);
            }
        }
        if (this.areaObjects.contains(areaObject)) {
            return;
        }
        this.areaObjects.add(areaObject);
        this.fireValueChanged(PoiModelEnum.AREA_OBJECTS, areaObject, null);
        if (areaObject != null) {
            areaObject.setPoi(this);
        }
    }

    @Override
    public void removeAreaObject(AreaObjectModel areaObject) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaObjects == null) {
            this.areaObjects = new LinkedHashSet<AreaObjectModel>();
            if (this.getId() != null) {
                Collection areaObjectsCollection = this.commonCaller.fetchChildren(this, PoiModelEnum.AREA_OBJECTS.getPropertyName());
                this.areaObjects.addAll(areaObjectsCollection);
            }
        }
        if (!this.areaObjects.contains(areaObject)) {
            return;
        }
        this.areaObjects.remove(areaObject);
        this.fireValueChanged(PoiModelEnum.AREA_OBJECTS, areaObject, null);
        if (areaObject != null) {
            areaObject.setPoi(null);
        }
    }

    @Override
    public void clearAreaObjects() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaObjects == null) {
            this.areaObjects = new LinkedHashSet<AreaObjectModel>();
            if (this.getId() != null) {
                Collection areaObjectsCollection = this.commonCaller.fetchChildren(this, PoiModelEnum.AREA_OBJECTS.getPropertyName());
                this.areaObjects.addAll(areaObjectsCollection);
            }
        }
        ArrayList<AreaObjectModel> oldAreaObjects = new ArrayList<AreaObjectModel>(this.areaObjects);
        this.areaObjects.clear();
        this.fireValueChanged(PoiModelEnum.AREA_OBJECTS, null, null);
        for (AreaObjectModel oldAreaObject : oldAreaObjects) {
            if (oldAreaObject == null) continue;
            oldAreaObject.setPoi(null);
        }
    }

    @Override
    public boolean isAreaObjectsEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaObjects == null) {
            this.areaObjects = new LinkedHashSet<AreaObjectModel>();
            if (this.getId() != null) {
                Collection areaObjectsCollection = this.commonCaller.fetchChildren(this, PoiModelEnum.AREA_OBJECTS.getPropertyName());
                this.areaObjects.addAll(areaObjectsCollection);
            }
        }
        return this.areaObjects.isEmpty();
    }

    @Override
    public boolean containsAreaObject(AreaObjectModel areaObject) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaObjects == null) {
            this.areaObjects = new LinkedHashSet<AreaObjectModel>();
            if (this.getId() != null) {
                Collection areaObjectsCollection = this.commonCaller.fetchChildren(this, PoiModelEnum.AREA_OBJECTS.getPropertyName());
                this.areaObjects.addAll(areaObjectsCollection);
            }
        }
        return this.areaObjects.contains(areaObject);
    }

    @Override
    public boolean isAreaObjectsInitialized() {
        return this.areaObjects != null;
    }

    @Override
    public int countFirstThrowAreaObjects() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.firstThrowAreaObjects == null) {
            this.firstThrowAreaObjects = new LinkedHashSet<AreaObjectModel>();
            if (this.getId() != null) {
                Collection firstThrowAreaObjectsCollection = this.commonCaller.fetchChildren(this, PoiModelEnum.FIRST_THROW_AREA_OBJECTS.getPropertyName());
                this.firstThrowAreaObjects.addAll(firstThrowAreaObjectsCollection);
            }
        }
        return this.firstThrowAreaObjects.size();
    }

    @Override
    public Iterator<AreaObjectModel> iterateFirstThrowAreaObjects() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.firstThrowAreaObjects == null) {
            this.firstThrowAreaObjects = new LinkedHashSet<AreaObjectModel>();
            if (this.getId() != null) {
                Collection firstThrowAreaObjectsCollection = this.commonCaller.fetchChildren(this, PoiModelEnum.FIRST_THROW_AREA_OBJECTS.getPropertyName());
                this.firstThrowAreaObjects.addAll(firstThrowAreaObjectsCollection);
            }
        }
        return new ImmutableIterator<AreaObjectModel>(this.firstThrowAreaObjects);
    }

    @Override
    public Iterable<AreaObjectModel> iterableFirstThrowAreaObjects() {
        return new IteratorIterable<AreaObjectModel>(this.iterateFirstThrowAreaObjects());
    }

    @Override
    public void addFirstThrowAreaObject(AreaObjectModel firstThrowAreaObject) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.firstThrowAreaObjects == null) {
            this.firstThrowAreaObjects = new LinkedHashSet<AreaObjectModel>();
            if (this.getId() != null) {
                Collection firstThrowAreaObjectsCollection = this.commonCaller.fetchChildren(this, PoiModelEnum.FIRST_THROW_AREA_OBJECTS.getPropertyName());
                this.firstThrowAreaObjects.addAll(firstThrowAreaObjectsCollection);
            }
        }
        if (this.firstThrowAreaObjects.contains(firstThrowAreaObject)) {
            return;
        }
        this.firstThrowAreaObjects.add(firstThrowAreaObject);
        this.fireValueChanged(PoiModelEnum.FIRST_THROW_AREA_OBJECTS, firstThrowAreaObject, null);
        if (firstThrowAreaObject != null) {
            firstThrowAreaObject.setFirstPickPoint(this);
        }
    }

    @Override
    public void removeFirstThrowAreaObject(AreaObjectModel firstThrowAreaObject) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.firstThrowAreaObjects == null) {
            this.firstThrowAreaObjects = new LinkedHashSet<AreaObjectModel>();
            if (this.getId() != null) {
                Collection firstThrowAreaObjectsCollection = this.commonCaller.fetchChildren(this, PoiModelEnum.FIRST_THROW_AREA_OBJECTS.getPropertyName());
                this.firstThrowAreaObjects.addAll(firstThrowAreaObjectsCollection);
            }
        }
        if (!this.firstThrowAreaObjects.contains(firstThrowAreaObject)) {
            return;
        }
        this.firstThrowAreaObjects.remove(firstThrowAreaObject);
        this.fireValueChanged(PoiModelEnum.FIRST_THROW_AREA_OBJECTS, firstThrowAreaObject, null);
        if (firstThrowAreaObject != null) {
            firstThrowAreaObject.setFirstPickPoint(null);
        }
    }

    @Override
    public void clearFirstThrowAreaObjects() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.firstThrowAreaObjects == null) {
            this.firstThrowAreaObjects = new LinkedHashSet<AreaObjectModel>();
            if (this.getId() != null) {
                Collection firstThrowAreaObjectsCollection = this.commonCaller.fetchChildren(this, PoiModelEnum.FIRST_THROW_AREA_OBJECTS.getPropertyName());
                this.firstThrowAreaObjects.addAll(firstThrowAreaObjectsCollection);
            }
        }
        ArrayList<AreaObjectModel> oldFirstThrowAreaObjects = new ArrayList<AreaObjectModel>(this.firstThrowAreaObjects);
        this.firstThrowAreaObjects.clear();
        this.fireValueChanged(PoiModelEnum.FIRST_THROW_AREA_OBJECTS, null, null);
        for (AreaObjectModel oldFirstThrowAreaObject : oldFirstThrowAreaObjects) {
            if (oldFirstThrowAreaObject == null) continue;
            oldFirstThrowAreaObject.setFirstPickPoint(null);
        }
    }

    @Override
    public boolean isFirstThrowAreaObjectsEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.firstThrowAreaObjects == null) {
            this.firstThrowAreaObjects = new LinkedHashSet<AreaObjectModel>();
            if (this.getId() != null) {
                Collection firstThrowAreaObjectsCollection = this.commonCaller.fetchChildren(this, PoiModelEnum.FIRST_THROW_AREA_OBJECTS.getPropertyName());
                this.firstThrowAreaObjects.addAll(firstThrowAreaObjectsCollection);
            }
        }
        return this.firstThrowAreaObjects.isEmpty();
    }

    @Override
    public boolean containsFirstThrowAreaObject(AreaObjectModel firstThrowAreaObject) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.firstThrowAreaObjects == null) {
            this.firstThrowAreaObjects = new LinkedHashSet<AreaObjectModel>();
            if (this.getId() != null) {
                Collection firstThrowAreaObjectsCollection = this.commonCaller.fetchChildren(this, PoiModelEnum.FIRST_THROW_AREA_OBJECTS.getPropertyName());
                this.firstThrowAreaObjects.addAll(firstThrowAreaObjectsCollection);
            }
        }
        return this.firstThrowAreaObjects.contains(firstThrowAreaObject);
    }

    @Override
    public boolean isFirstThrowAreaObjectsInitialized() {
        return this.firstThrowAreaObjects != null;
    }

    @Override
    public int countLastThrowAreaObjects() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.lastThrowAreaObjects == null) {
            this.lastThrowAreaObjects = new LinkedHashSet<AreaObjectModel>();
            if (this.getId() != null) {
                Collection lastThrowAreaObjectsCollection = this.commonCaller.fetchChildren(this, PoiModelEnum.LAST_THROW_AREA_OBJECTS.getPropertyName());
                this.lastThrowAreaObjects.addAll(lastThrowAreaObjectsCollection);
            }
        }
        return this.lastThrowAreaObjects.size();
    }

    @Override
    public Iterator<AreaObjectModel> iterateLastThrowAreaObjects() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.lastThrowAreaObjects == null) {
            this.lastThrowAreaObjects = new LinkedHashSet<AreaObjectModel>();
            if (this.getId() != null) {
                Collection lastThrowAreaObjectsCollection = this.commonCaller.fetchChildren(this, PoiModelEnum.LAST_THROW_AREA_OBJECTS.getPropertyName());
                this.lastThrowAreaObjects.addAll(lastThrowAreaObjectsCollection);
            }
        }
        return new ImmutableIterator<AreaObjectModel>(this.lastThrowAreaObjects);
    }

    @Override
    public Iterable<AreaObjectModel> iterableLastThrowAreaObjects() {
        return new IteratorIterable<AreaObjectModel>(this.iterateLastThrowAreaObjects());
    }

    @Override
    public void addLastThrowAreaObject(AreaObjectModel lastThrowAreaObject) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.lastThrowAreaObjects == null) {
            this.lastThrowAreaObjects = new LinkedHashSet<AreaObjectModel>();
            if (this.getId() != null) {
                Collection lastThrowAreaObjectsCollection = this.commonCaller.fetchChildren(this, PoiModelEnum.LAST_THROW_AREA_OBJECTS.getPropertyName());
                this.lastThrowAreaObjects.addAll(lastThrowAreaObjectsCollection);
            }
        }
        if (this.lastThrowAreaObjects.contains(lastThrowAreaObject)) {
            return;
        }
        this.lastThrowAreaObjects.add(lastThrowAreaObject);
        this.fireValueChanged(PoiModelEnum.LAST_THROW_AREA_OBJECTS, lastThrowAreaObject, null);
        if (lastThrowAreaObject != null) {
            lastThrowAreaObject.setLastPickPoint(this);
        }
    }

    @Override
    public void removeLastThrowAreaObject(AreaObjectModel lastThrowAreaObject) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.lastThrowAreaObjects == null) {
            this.lastThrowAreaObjects = new LinkedHashSet<AreaObjectModel>();
            if (this.getId() != null) {
                Collection lastThrowAreaObjectsCollection = this.commonCaller.fetchChildren(this, PoiModelEnum.LAST_THROW_AREA_OBJECTS.getPropertyName());
                this.lastThrowAreaObjects.addAll(lastThrowAreaObjectsCollection);
            }
        }
        if (!this.lastThrowAreaObjects.contains(lastThrowAreaObject)) {
            return;
        }
        this.lastThrowAreaObjects.remove(lastThrowAreaObject);
        this.fireValueChanged(PoiModelEnum.LAST_THROW_AREA_OBJECTS, lastThrowAreaObject, null);
        if (lastThrowAreaObject != null) {
            lastThrowAreaObject.setLastPickPoint(null);
        }
    }

    @Override
    public void clearLastThrowAreaObjects() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.lastThrowAreaObjects == null) {
            this.lastThrowAreaObjects = new LinkedHashSet<AreaObjectModel>();
            if (this.getId() != null) {
                Collection lastThrowAreaObjectsCollection = this.commonCaller.fetchChildren(this, PoiModelEnum.LAST_THROW_AREA_OBJECTS.getPropertyName());
                this.lastThrowAreaObjects.addAll(lastThrowAreaObjectsCollection);
            }
        }
        ArrayList<AreaObjectModel> oldLastThrowAreaObjects = new ArrayList<AreaObjectModel>(this.lastThrowAreaObjects);
        this.lastThrowAreaObjects.clear();
        this.fireValueChanged(PoiModelEnum.LAST_THROW_AREA_OBJECTS, null, null);
        for (AreaObjectModel oldLastThrowAreaObject : oldLastThrowAreaObjects) {
            if (oldLastThrowAreaObject == null) continue;
            oldLastThrowAreaObject.setLastPickPoint(null);
        }
    }

    @Override
    public boolean isLastThrowAreaObjectsEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.lastThrowAreaObjects == null) {
            this.lastThrowAreaObjects = new LinkedHashSet<AreaObjectModel>();
            if (this.getId() != null) {
                Collection lastThrowAreaObjectsCollection = this.commonCaller.fetchChildren(this, PoiModelEnum.LAST_THROW_AREA_OBJECTS.getPropertyName());
                this.lastThrowAreaObjects.addAll(lastThrowAreaObjectsCollection);
            }
        }
        return this.lastThrowAreaObjects.isEmpty();
    }

    @Override
    public boolean containsLastThrowAreaObject(AreaObjectModel lastThrowAreaObject) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.lastThrowAreaObjects == null) {
            this.lastThrowAreaObjects = new LinkedHashSet<AreaObjectModel>();
            if (this.getId() != null) {
                Collection lastThrowAreaObjectsCollection = this.commonCaller.fetchChildren(this, PoiModelEnum.LAST_THROW_AREA_OBJECTS.getPropertyName());
                this.lastThrowAreaObjects.addAll(lastThrowAreaObjectsCollection);
            }
        }
        return this.lastThrowAreaObjects.contains(lastThrowAreaObject);
    }

    @Override
    public boolean isLastThrowAreaObjectsInitialized() {
        return this.lastThrowAreaObjects != null;
    }

    @Override
    public int countDeliverers() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.deliverers == null) {
            this.deliverers = new LinkedHashSet<DelivererModel>();
            if (this.getId() != null) {
                Collection deliverersCollection = this.commonCaller.fetchChildren(this, PoiModelEnum.DELIVERERS.getPropertyName());
                this.deliverers.addAll(deliverersCollection);
            }
        }
        return this.deliverers.size();
    }

    @Override
    public Iterator<DelivererModel> iterateDeliverers() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.deliverers == null) {
            this.deliverers = new LinkedHashSet<DelivererModel>();
            if (this.getId() != null) {
                Collection deliverersCollection = this.commonCaller.fetchChildren(this, PoiModelEnum.DELIVERERS.getPropertyName());
                this.deliverers.addAll(deliverersCollection);
            }
        }
        return new ImmutableIterator<DelivererModel>(this.deliverers);
    }

    @Override
    public Iterable<DelivererModel> iterableDeliverers() {
        return new IteratorIterable<DelivererModel>(this.iterateDeliverers());
    }

    @Override
    public void addDeliverer(DelivererModel deliverer) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.deliverers == null) {
            this.deliverers = new LinkedHashSet<DelivererModel>();
            if (this.getId() != null) {
                Collection deliverersCollection = this.commonCaller.fetchChildren(this, PoiModelEnum.DELIVERERS.getPropertyName());
                this.deliverers.addAll(deliverersCollection);
            }
        }
        if (this.deliverers.contains(deliverer)) {
            return;
        }
        this.deliverers.add(deliverer);
        this.fireValueChanged(PoiModelEnum.DELIVERERS, deliverer, null);
        if (deliverer != null) {
            deliverer.setPoi(this);
        }
    }

    @Override
    public void removeDeliverer(DelivererModel deliverer) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.deliverers == null) {
            this.deliverers = new LinkedHashSet<DelivererModel>();
            if (this.getId() != null) {
                Collection deliverersCollection = this.commonCaller.fetchChildren(this, PoiModelEnum.DELIVERERS.getPropertyName());
                this.deliverers.addAll(deliverersCollection);
            }
        }
        if (!this.deliverers.contains(deliverer)) {
            return;
        }
        this.deliverers.remove(deliverer);
        this.fireValueChanged(PoiModelEnum.DELIVERERS, deliverer, null);
        if (deliverer != null) {
            deliverer.setPoi(null);
        }
    }

    @Override
    public void clearDeliverers() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.deliverers == null) {
            this.deliverers = new LinkedHashSet<DelivererModel>();
            if (this.getId() != null) {
                Collection deliverersCollection = this.commonCaller.fetchChildren(this, PoiModelEnum.DELIVERERS.getPropertyName());
                this.deliverers.addAll(deliverersCollection);
            }
        }
        ArrayList<DelivererModel> oldDeliverers = new ArrayList<DelivererModel>(this.deliverers);
        this.deliverers.clear();
        this.fireValueChanged(PoiModelEnum.DELIVERERS, null, null);
        for (DelivererModel oldDeliverer : oldDeliverers) {
            if (oldDeliverer == null) continue;
            oldDeliverer.setPoi(null);
        }
    }

    @Override
    public boolean isDeliverersEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.deliverers == null) {
            this.deliverers = new LinkedHashSet<DelivererModel>();
            if (this.getId() != null) {
                Collection deliverersCollection = this.commonCaller.fetchChildren(this, PoiModelEnum.DELIVERERS.getPropertyName());
                this.deliverers.addAll(deliverersCollection);
            }
        }
        return this.deliverers.isEmpty();
    }

    @Override
    public boolean containsDeliverer(DelivererModel deliverer) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.deliverers == null) {
            this.deliverers = new LinkedHashSet<DelivererModel>();
            if (this.getId() != null) {
                Collection deliverersCollection = this.commonCaller.fetchChildren(this, PoiModelEnum.DELIVERERS.getPropertyName());
                this.deliverers.addAll(deliverersCollection);
            }
        }
        return this.deliverers.contains(deliverer);
    }

    @Override
    public boolean isDeliverersInitialized() {
        return this.deliverers != null;
    }

    @Override
    public int countAreaDeliverers() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaDeliverers == null) {
            this.areaDeliverers = new LinkedHashSet<AreaDelivererModel>();
            if (this.getId() != null) {
                Collection areaDeliverersCollection = this.commonCaller.fetchChildren(this, PoiModelEnum.AREA_DELIVERERS.getPropertyName());
                this.areaDeliverers.addAll(areaDeliverersCollection);
            }
        }
        return this.areaDeliverers.size();
    }

    @Override
    public Iterator<AreaDelivererModel> iterateAreaDeliverers() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaDeliverers == null) {
            this.areaDeliverers = new LinkedHashSet<AreaDelivererModel>();
            if (this.getId() != null) {
                Collection areaDeliverersCollection = this.commonCaller.fetchChildren(this, PoiModelEnum.AREA_DELIVERERS.getPropertyName());
                this.areaDeliverers.addAll(areaDeliverersCollection);
            }
        }
        return new ImmutableIterator<AreaDelivererModel>(this.areaDeliverers);
    }

    @Override
    public Iterable<AreaDelivererModel> iterableAreaDeliverers() {
        return new IteratorIterable<AreaDelivererModel>(this.iterateAreaDeliverers());
    }

    @Override
    public void addAreaDeliverer(AreaDelivererModel areaDeliverer) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaDeliverers == null) {
            this.areaDeliverers = new LinkedHashSet<AreaDelivererModel>();
            if (this.getId() != null) {
                Collection areaDeliverersCollection = this.commonCaller.fetchChildren(this, PoiModelEnum.AREA_DELIVERERS.getPropertyName());
                this.areaDeliverers.addAll(areaDeliverersCollection);
            }
        }
        if (this.areaDeliverers.contains(areaDeliverer)) {
            return;
        }
        this.areaDeliverers.add(areaDeliverer);
        this.fireValueChanged(PoiModelEnum.AREA_DELIVERERS, areaDeliverer, null);
        if (areaDeliverer != null) {
            areaDeliverer.setPoi(this);
        }
    }

    @Override
    public void removeAreaDeliverer(AreaDelivererModel areaDeliverer) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaDeliverers == null) {
            this.areaDeliverers = new LinkedHashSet<AreaDelivererModel>();
            if (this.getId() != null) {
                Collection areaDeliverersCollection = this.commonCaller.fetchChildren(this, PoiModelEnum.AREA_DELIVERERS.getPropertyName());
                this.areaDeliverers.addAll(areaDeliverersCollection);
            }
        }
        if (!this.areaDeliverers.contains(areaDeliverer)) {
            return;
        }
        this.areaDeliverers.remove(areaDeliverer);
        this.fireValueChanged(PoiModelEnum.AREA_DELIVERERS, areaDeliverer, null);
        if (areaDeliverer != null) {
            areaDeliverer.setPoi(null);
        }
    }

    @Override
    public void clearAreaDeliverers() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaDeliverers == null) {
            this.areaDeliverers = new LinkedHashSet<AreaDelivererModel>();
            if (this.getId() != null) {
                Collection areaDeliverersCollection = this.commonCaller.fetchChildren(this, PoiModelEnum.AREA_DELIVERERS.getPropertyName());
                this.areaDeliverers.addAll(areaDeliverersCollection);
            }
        }
        ArrayList<AreaDelivererModel> oldAreaDeliverers = new ArrayList<AreaDelivererModel>(this.areaDeliverers);
        this.areaDeliverers.clear();
        this.fireValueChanged(PoiModelEnum.AREA_DELIVERERS, null, null);
        for (AreaDelivererModel oldAreaDeliverer : oldAreaDeliverers) {
            if (oldAreaDeliverer == null) continue;
            oldAreaDeliverer.setPoi(null);
        }
    }

    @Override
    public boolean isAreaDeliverersEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaDeliverers == null) {
            this.areaDeliverers = new LinkedHashSet<AreaDelivererModel>();
            if (this.getId() != null) {
                Collection areaDeliverersCollection = this.commonCaller.fetchChildren(this, PoiModelEnum.AREA_DELIVERERS.getPropertyName());
                this.areaDeliverers.addAll(areaDeliverersCollection);
            }
        }
        return this.areaDeliverers.isEmpty();
    }

    @Override
    public boolean containsAreaDeliverer(AreaDelivererModel areaDeliverer) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaDeliverers == null) {
            this.areaDeliverers = new LinkedHashSet<AreaDelivererModel>();
            if (this.getId() != null) {
                Collection areaDeliverersCollection = this.commonCaller.fetchChildren(this, PoiModelEnum.AREA_DELIVERERS.getPropertyName());
                this.areaDeliverers.addAll(areaDeliverersCollection);
            }
        }
        return this.areaDeliverers.contains(areaDeliverer);
    }

    @Override
    public boolean isAreaDeliverersInitialized() {
        return this.areaDeliverers != null;
    }

    @Override
    public int countStops() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.stops == null) {
            this.stops = new LinkedHashSet<StopModel>();
            if (this.getId() != null) {
                Collection stopsCollection = this.commonCaller.fetchChildren(this, PoiModelEnum.STOPS.getPropertyName());
                this.stops.addAll(stopsCollection);
            }
        }
        return this.stops.size();
    }

    @Override
    public Iterator<StopModel> iterateStops() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.stops == null) {
            this.stops = new LinkedHashSet<StopModel>();
            if (this.getId() != null) {
                Collection stopsCollection = this.commonCaller.fetchChildren(this, PoiModelEnum.STOPS.getPropertyName());
                this.stops.addAll(stopsCollection);
            }
        }
        return new ImmutableIterator<StopModel>(this.stops);
    }

    @Override
    public Iterable<StopModel> iterableStops() {
        return new IteratorIterable<StopModel>(this.iterateStops());
    }

    @Override
    public void addStop(StopModel stop) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.stops == null) {
            this.stops = new LinkedHashSet<StopModel>();
            if (this.getId() != null) {
                Collection stopsCollection = this.commonCaller.fetchChildren(this, PoiModelEnum.STOPS.getPropertyName());
                this.stops.addAll(stopsCollection);
            }
        }
        if (this.stops.contains(stop)) {
            return;
        }
        this.stops.add(stop);
        this.fireValueChanged(PoiModelEnum.STOPS, stop, null);
        if (stop != null) {
            stop.setPoi(this);
        }
    }

    @Override
    public void removeStop(StopModel stop) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.stops == null) {
            this.stops = new LinkedHashSet<StopModel>();
            if (this.getId() != null) {
                Collection stopsCollection = this.commonCaller.fetchChildren(this, PoiModelEnum.STOPS.getPropertyName());
                this.stops.addAll(stopsCollection);
            }
        }
        if (!this.stops.contains(stop)) {
            return;
        }
        this.stops.remove(stop);
        this.fireValueChanged(PoiModelEnum.STOPS, stop, null);
        if (stop != null) {
            stop.setPoi(null);
        }
    }

    @Override
    public void clearStops() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.stops == null) {
            this.stops = new LinkedHashSet<StopModel>();
            if (this.getId() != null) {
                Collection stopsCollection = this.commonCaller.fetchChildren(this, PoiModelEnum.STOPS.getPropertyName());
                this.stops.addAll(stopsCollection);
            }
        }
        ArrayList<StopModel> oldStops = new ArrayList<StopModel>(this.stops);
        this.stops.clear();
        this.fireValueChanged(PoiModelEnum.STOPS, null, null);
        for (StopModel oldStop : oldStops) {
            if (oldStop == null) continue;
            oldStop.setPoi(null);
        }
    }

    @Override
    public boolean isStopsEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.stops == null) {
            this.stops = new LinkedHashSet<StopModel>();
            if (this.getId() != null) {
                Collection stopsCollection = this.commonCaller.fetchChildren(this, PoiModelEnum.STOPS.getPropertyName());
                this.stops.addAll(stopsCollection);
            }
        }
        return this.stops.isEmpty();
    }

    @Override
    public boolean containsStop(StopModel stop) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.stops == null) {
            this.stops = new LinkedHashSet<StopModel>();
            if (this.getId() != null) {
                Collection stopsCollection = this.commonCaller.fetchChildren(this, PoiModelEnum.STOPS.getPropertyName());
                this.stops.addAll(stopsCollection);
            }
        }
        return this.stops.contains(stop);
    }

    @Override
    public boolean isStopsInitialized() {
        return this.stops != null;
    }

    @Override
    public int countBranches() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.branches == null) {
            this.branches = new LinkedHashSet<BranchModel>();
            if (this.getId() != null) {
                Collection branchesCollection = this.commonCaller.fetchChildren(this, PoiModelEnum.BRANCHES.getPropertyName());
                this.branches.addAll(branchesCollection);
            }
        }
        return this.branches.size();
    }

    @Override
    public Iterator<BranchModel> iterateBranches() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.branches == null) {
            this.branches = new LinkedHashSet<BranchModel>();
            if (this.getId() != null) {
                Collection branchesCollection = this.commonCaller.fetchChildren(this, PoiModelEnum.BRANCHES.getPropertyName());
                this.branches.addAll(branchesCollection);
            }
        }
        return new ImmutableIterator<BranchModel>(this.branches);
    }

    @Override
    public Iterable<BranchModel> iterableBranches() {
        return new IteratorIterable<BranchModel>(this.iterateBranches());
    }

    @Override
    public void addBranche(BranchModel branche) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.branches == null) {
            this.branches = new LinkedHashSet<BranchModel>();
            if (this.getId() != null) {
                Collection branchesCollection = this.commonCaller.fetchChildren(this, PoiModelEnum.BRANCHES.getPropertyName());
                this.branches.addAll(branchesCollection);
            }
        }
        if (this.branches.contains(branche)) {
            return;
        }
        this.branches.add(branche);
        this.fireValueChanged(PoiModelEnum.BRANCHES, branche, null);
        if (branche != null) {
            branche.setPoi(this);
        }
    }

    @Override
    public void removeBranche(BranchModel branche) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.branches == null) {
            this.branches = new LinkedHashSet<BranchModel>();
            if (this.getId() != null) {
                Collection branchesCollection = this.commonCaller.fetchChildren(this, PoiModelEnum.BRANCHES.getPropertyName());
                this.branches.addAll(branchesCollection);
            }
        }
        if (!this.branches.contains(branche)) {
            return;
        }
        this.branches.remove(branche);
        this.fireValueChanged(PoiModelEnum.BRANCHES, branche, null);
        if (branche != null) {
            branche.setPoi(null);
        }
    }

    @Override
    public void clearBranches() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.branches == null) {
            this.branches = new LinkedHashSet<BranchModel>();
            if (this.getId() != null) {
                Collection branchesCollection = this.commonCaller.fetchChildren(this, PoiModelEnum.BRANCHES.getPropertyName());
                this.branches.addAll(branchesCollection);
            }
        }
        ArrayList<BranchModel> oldBranches = new ArrayList<BranchModel>(this.branches);
        this.branches.clear();
        this.fireValueChanged(PoiModelEnum.BRANCHES, null, null);
        for (BranchModel oldBranche : oldBranches) {
            if (oldBranche == null) continue;
            oldBranche.setPoi(null);
        }
    }

    @Override
    public boolean isBranchesEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.branches == null) {
            this.branches = new LinkedHashSet<BranchModel>();
            if (this.getId() != null) {
                Collection branchesCollection = this.commonCaller.fetchChildren(this, PoiModelEnum.BRANCHES.getPropertyName());
                this.branches.addAll(branchesCollection);
            }
        }
        return this.branches.isEmpty();
    }

    @Override
    public boolean containsBranche(BranchModel branche) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.branches == null) {
            this.branches = new LinkedHashSet<BranchModel>();
            if (this.getId() != null) {
                Collection branchesCollection = this.commonCaller.fetchChildren(this, PoiModelEnum.BRANCHES.getPropertyName());
                this.branches.addAll(branchesCollection);
            }
        }
        return this.branches.contains(branche);
    }

    @Override
    public boolean isBranchesInitialized() {
        return this.branches != null;
    }

    @Override
    public void setProxy(boolean proxy) {
        super.setProxy(proxy);
        if (proxy) {
            this.poiAttributeValues = null;
            this.areaObjects = null;
            this.firstThrowAreaObjects = null;
            this.lastThrowAreaObjects = null;
            this.deliverers = null;
            this.areaDeliverers = null;
            this.stops = null;
            this.branches = null;
        }
    }

    @Override
    protected void updateByDto(PoiFullDto poiDto) {
        BranchDto[] branches;
        StopDto[] stops;
        AreaDelivererDto[] areaDeliverers;
        DelivererDto[] deliverers;
        AreaObjectDto[] lastThrowAreaObjects;
        AreaObjectDto[] firstThrowAreaObjects;
        this.poiNumber = poiDto.getPoiNumber();
        this.name = poiDto.getName();
        this.information = poiDto.getInformation();
        this.location = (LocationModel)this.getModelCache().getModel(poiDto.getLocation());
        this.poiType = poiDto.getPoiType();
        PoiAttributeValueDto[] poiAttributeValues = poiDto.getPoiAttributeValues();
        if (poiAttributeValues != null) {
            if (this.poiAttributeValues == null) {
                this.poiAttributeValues = new LinkedHashSet<PoiAttributeValueModel>();
            } else {
                this.poiAttributeValues.clear();
            }
        }
        this.image = (ImageModel)this.getModelCache().getModel(poiDto.getImage());
        AreaObjectDto[] areaObjects = poiDto.getAreaObjects();
        if (areaObjects != null) {
            if (this.areaObjects == null) {
                this.areaObjects = new LinkedHashSet<AreaObjectModel>();
            } else {
                this.areaObjects.clear();
            }
        }
        if ((firstThrowAreaObjects = poiDto.getFirstThrowAreaObjects()) != null) {
            if (this.firstThrowAreaObjects == null) {
                this.firstThrowAreaObjects = new LinkedHashSet<AreaObjectModel>();
            } else {
                this.firstThrowAreaObjects.clear();
            }
        }
        if ((lastThrowAreaObjects = poiDto.getLastThrowAreaObjects()) != null) {
            if (this.lastThrowAreaObjects == null) {
                this.lastThrowAreaObjects = new LinkedHashSet<AreaObjectModel>();
            } else {
                this.lastThrowAreaObjects.clear();
            }
        }
        if ((deliverers = poiDto.getDeliverers()) != null) {
            if (this.deliverers == null) {
                this.deliverers = new LinkedHashSet<DelivererModel>();
            } else {
                this.deliverers.clear();
            }
        }
        if ((areaDeliverers = poiDto.getAreaDeliverers()) != null) {
            if (this.areaDeliverers == null) {
                this.areaDeliverers = new LinkedHashSet<AreaDelivererModel>();
            } else {
                this.areaDeliverers.clear();
            }
        }
        if ((stops = poiDto.getStops()) != null) {
            if (this.stops == null) {
                this.stops = new LinkedHashSet<StopModel>();
            } else {
                this.stops.clear();
            }
        }
        if ((branches = poiDto.getBranches()) != null) {
            if (this.branches == null) {
                this.branches = new LinkedHashSet<BranchModel>();
            } else {
                this.branches.clear();
            }
        }
    }

    @Override
    protected void updateMasterRelationsByDto(PoiFullDto poiDto) {
        BranchDto[] branches;
        StopDto[] stops;
        AreaDelivererDto[] areaDeliverers;
        DelivererDto[] deliverers;
        AreaObjectDto[] lastThrowAreaObjects;
        AreaObjectDto[] firstThrowAreaObjects;
        AreaObjectDto[] areaObjects;
        PoiAttributeValueDto[] poiAttributeValues = poiDto.getPoiAttributeValues();
        if (poiAttributeValues != null) {
            if (this.poiAttributeValues == null) {
                this.poiAttributeValues = new LinkedHashSet<PoiAttributeValueModel>();
            } else {
                this.poiAttributeValues.clear();
            }
            for (PoiAttributeValueDto poiAttributeValueDto : poiAttributeValues) {
                PoiAttributeValueModel poiAttributeValueModel = (PoiAttributeValueModel)this.getModelCache().getModel(poiAttributeValueDto);
                this.poiAttributeValues.add(poiAttributeValueModel);
            }
        } else {
            this.poiAttributeValues = null;
        }
        if ((areaObjects = poiDto.getAreaObjects()) != null) {
            if (this.areaObjects == null) {
                this.areaObjects = new LinkedHashSet<AreaObjectModel>();
            } else {
                this.areaObjects.clear();
            }
            for (AreaObjectDto areaObjectDto : areaObjects) {
                AreaObjectModel areaObjectModel = (AreaObjectModel)this.getModelCache().getModel(areaObjectDto);
                this.areaObjects.add(areaObjectModel);
            }
        } else {
            this.areaObjects = null;
        }
        if ((firstThrowAreaObjects = poiDto.getFirstThrowAreaObjects()) != null) {
            if (this.firstThrowAreaObjects == null) {
                this.firstThrowAreaObjects = new LinkedHashSet<AreaObjectModel>();
            } else {
                this.firstThrowAreaObjects.clear();
            }
            for (AreaObjectDto firstThrowAreaObjectDto : firstThrowAreaObjects) {
                AreaObjectModel firstThrowAreaObjectModel = (AreaObjectModel)this.getModelCache().getModel(firstThrowAreaObjectDto);
                this.firstThrowAreaObjects.add(firstThrowAreaObjectModel);
            }
        } else {
            this.firstThrowAreaObjects = null;
        }
        if ((lastThrowAreaObjects = poiDto.getLastThrowAreaObjects()) != null) {
            if (this.lastThrowAreaObjects == null) {
                this.lastThrowAreaObjects = new LinkedHashSet<AreaObjectModel>();
            } else {
                this.lastThrowAreaObjects.clear();
            }
            for (AreaObjectDto lastThrowAreaObjectDto : lastThrowAreaObjects) {
                AreaObjectModel lastThrowAreaObjectModel = (AreaObjectModel)this.getModelCache().getModel(lastThrowAreaObjectDto);
                this.lastThrowAreaObjects.add(lastThrowAreaObjectModel);
            }
        } else {
            this.lastThrowAreaObjects = null;
        }
        if ((deliverers = poiDto.getDeliverers()) != null) {
            if (this.deliverers == null) {
                this.deliverers = new LinkedHashSet<DelivererModel>();
            } else {
                this.deliverers.clear();
            }
            for (DelivererDto delivererDto : deliverers) {
                DelivererModel delivererModel = (DelivererModel)this.getModelCache().getModel(delivererDto);
                this.deliverers.add(delivererModel);
            }
        } else {
            this.deliverers = null;
        }
        if ((areaDeliverers = poiDto.getAreaDeliverers()) != null) {
            if (this.areaDeliverers == null) {
                this.areaDeliverers = new LinkedHashSet<AreaDelivererModel>();
            } else {
                this.areaDeliverers.clear();
            }
            for (AreaDelivererDto areaDelivererDto : areaDeliverers) {
                AreaDelivererModel areaDelivererModel = (AreaDelivererModel)this.getModelCache().getModel(areaDelivererDto);
                this.areaDeliverers.add(areaDelivererModel);
            }
        } else {
            this.areaDeliverers = null;
        }
        if ((stops = poiDto.getStops()) != null) {
            if (this.stops == null) {
                this.stops = new LinkedHashSet<StopModel>();
            } else {
                this.stops.clear();
            }
            for (StopDto stopDto : stops) {
                StopModel stopModel = (StopModel)this.getModelCache().getModel(stopDto);
                this.stops.add(stopModel);
            }
        } else {
            this.stops = null;
        }
        if ((branches = poiDto.getBranches()) != null) {
            if (this.branches == null) {
                this.branches = new LinkedHashSet<BranchModel>();
            } else {
                this.branches.clear();
            }
            for (BranchDto brancheDto : branches) {
                BranchModel brancheModel = (BranchModel)this.getModelCache().getModel(brancheDto);
                this.branches.add(brancheModel);
            }
        } else {
            this.branches = null;
        }
    }

    @Override
    protected void checkStaleByDto(PoiFullDto poiDto) throws StaleStateException {
        BranchDto[] brancheDtos;
        StopDto[] stopDtos;
        AreaDelivererDto[] areaDelivererDtos;
        DelivererDto[] delivererDtos;
        AreaObjectDto[] lastThrowAreaObjectDtos;
        AreaObjectDto[] firstThrowAreaObjectDtos;
        AreaObjectDto[] areaObjectDtos;
        ImageModelImpl imageModel;
        ImageDto imageDto;
        PoiAttributeValueDto[] poiAttributeValueDtos;
        LocationModelImpl locationModel;
        LocationDto locationDto = poiDto.getLocation();
        if (locationDto != null && locationDto.getId() != null && (locationModel = (LocationModelImpl)this.getModelCache().getModel(LocationModel.class, locationDto.getId())) != null) {
            locationModel.checkStaleState(locationDto);
        }
        if ((poiAttributeValueDtos = poiDto.getPoiAttributeValues()) != null) {
            for (PoiAttributeValueDto poiAttributeValueDto : poiAttributeValueDtos) {
                PoiAttributeValueModelImpl poiAttributeValueModel = (PoiAttributeValueModelImpl)this.getModelCache().getModel(PoiAttributeValueModel.class, poiAttributeValueDto.getId());
                if (poiAttributeValueModel == null) continue;
                poiAttributeValueModel.checkStaleState(poiAttributeValueDto);
            }
        }
        if ((imageDto = poiDto.getImage()) != null && imageDto.getId() != null && (imageModel = (ImageModelImpl)this.getModelCache().getModel(ImageModel.class, imageDto.getId())) != null) {
            imageModel.checkStaleState(imageDto);
        }
        if ((areaObjectDtos = poiDto.getAreaObjects()) != null) {
            for (AreaObjectDto areaObjectDto : areaObjectDtos) {
                AreaObjectModelImpl areaObjectModel = (AreaObjectModelImpl)this.getModelCache().getModel(AreaObjectModel.class, areaObjectDto.getId());
                if (areaObjectModel == null) continue;
                areaObjectModel.checkStaleState(areaObjectDto);
            }
        }
        if ((firstThrowAreaObjectDtos = poiDto.getFirstThrowAreaObjects()) != null) {
            for (AreaObjectDto firstThrowAreaObjectDto : firstThrowAreaObjectDtos) {
                AreaObjectModelImpl firstThrowAreaObjectModel = (AreaObjectModelImpl)this.getModelCache().getModel(AreaObjectModel.class, firstThrowAreaObjectDto.getId());
                if (firstThrowAreaObjectModel == null) continue;
                firstThrowAreaObjectModel.checkStaleState(firstThrowAreaObjectDto);
            }
        }
        if ((lastThrowAreaObjectDtos = poiDto.getLastThrowAreaObjects()) != null) {
            for (AreaObjectDto lastThrowAreaObjectDto : lastThrowAreaObjectDtos) {
                AreaObjectModelImpl lastThrowAreaObjectModel = (AreaObjectModelImpl)this.getModelCache().getModel(AreaObjectModel.class, lastThrowAreaObjectDto.getId());
                if (lastThrowAreaObjectModel == null) continue;
                lastThrowAreaObjectModel.checkStaleState(lastThrowAreaObjectDto);
            }
        }
        if ((delivererDtos = poiDto.getDeliverers()) != null) {
            for (DelivererDto delivererDto : delivererDtos) {
                DelivererModelImpl delivererModel = (DelivererModelImpl)this.getModelCache().getModel(DelivererModel.class, delivererDto.getId());
                if (delivererModel == null) continue;
                delivererModel.checkStaleState(delivererDto);
            }
        }
        if ((areaDelivererDtos = poiDto.getAreaDeliverers()) != null) {
            for (AreaDelivererDto areaDelivererDto : areaDelivererDtos) {
                AreaDelivererModelImpl areaDelivererModel = (AreaDelivererModelImpl)this.getModelCache().getModel(AreaDelivererModel.class, areaDelivererDto.getId());
                if (areaDelivererModel == null) continue;
                areaDelivererModel.checkStaleState(areaDelivererDto);
            }
        }
        if ((stopDtos = poiDto.getStops()) != null) {
            for (StopDto stopDto : stopDtos) {
                StopModelImpl stopModel = (StopModelImpl)this.getModelCache().getModel(StopModel.class, stopDto.getId());
                if (stopModel == null) continue;
                stopModel.checkStaleState(stopDto);
            }
        }
        if ((brancheDtos = poiDto.getBranches()) != null) {
            for (BranchDto brancheDto : brancheDtos) {
                BranchModelImpl brancheModel = (BranchModelImpl)this.getModelCache().getModel(BranchModel.class, brancheDto.getId());
                if (brancheModel == null) continue;
                brancheModel.checkStaleState(brancheDto);
            }
        }
    }

    @Override
    public PoiFullDto createDto() {
        Long id = this.getId();
        PoiFullDto poiDto = id == null ? new PoiFullDto(this.getTempUUID()) : new PoiFullDto(id, this.getVersion());
        poiDto.setPoiNumber(this.getPoiNumber());
        poiDto.setName(this.getName());
        poiDto.setInformation(this.getInformation());
        LocationModelImpl location = (LocationModelImpl)this.getLocation();
        if (location != null) {
            poiDto.setLocation(location.createProxy());
        }
        poiDto.setPoiType(this.getPoiType());
        ImageModelImpl image = (ImageModelImpl)this.getImage();
        if (image != null) {
            poiDto.setImage(image.createProxy());
        }
        return poiDto;
    }

    @Override
    public PoiProxyDto createProxy() {
        Long id = this.getId();
        PoiProxyDto poiDto = id == null ? new PoiProxyDto(this.getTempUUID()) : new PoiProxyDto(id, this.getVersion());
        return poiDto;
    }

    public static enum PoiModelEnum {
        POI_NUMBER("poiNumber"),
        NAME("name"),
        INFORMATION("information"),
        LOCATION("location"),
        POI_TYPE("poiType"),
        POI_ATTRIBUTE_VALUES("poiAttributeValues"),
        IMAGE("image"),
        AREA_OBJECTS("areaObjects"),
        FIRST_THROW_AREA_OBJECTS("firstThrowAreaObjects"),
        LAST_THROW_AREA_OBJECTS("lastThrowAreaObjects"),
        DELIVERERS("deliverers"),
        AREA_DELIVERERS("areaDeliverers"),
        STOPS("stops"),
        BRANCHES("branches");

        private String propertyName;

        private PoiModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

