/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.base;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.base.PoiFilterPatternParameterModel;
import de.datomino.peppergis.client.model.base.PoiFilterPatternParameterModelImpl;
import de.datomino.peppergis.client.model.base.PoiFilterPatternRelationModel;
import de.datomino.peppergis.client.model.base.PoiFilterPatternSetupModel;
import de.datomino.peppergis.client.model.base.PoiFilterPatternSetupModelImpl;
import de.datomino.peppergis.dto.base.PoiFilterPatternParameterDto;
import de.datomino.peppergis.dto.base.PoiFilterPatternRelationFullDto;
import de.datomino.peppergis.dto.base.PoiFilterPatternRelationProxyDto;
import de.datomino.peppergis.dto.base.PoiFilterPatternSetupDto;
import de.datomino.peppergis.exception.StaleStateException;
import de.datomino.peppergis.type.RendererType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;
import org.ktde.util.conversions.ImmutableIterator;
import org.ktde.util.conversions.IteratorIterable;

public class PoiFilterPatternRelationModelImpl
extends AbstractModel<PoiFilterPatternRelationFullDto, PoiFilterPatternRelationProxyDto>
implements PoiFilterPatternRelationModel {
    private PoiFilterPatternSetupModel patternSetup;
    private RendererType rendererType;
    private Integer sortOrder;
    private List<PoiFilterPatternParameterModel> parameters = null;

    public PoiFilterPatternRelationModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public PoiFilterPatternRelationModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public PoiFilterPatternSetupModel getPatternSetup() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.patternSetup;
    }

    @Override
    public void setPatternSetup(PoiFilterPatternSetupModel patternSetup) {
        this.setPatternSetup(patternSetup, true);
    }

    private void setPatternSetup(PoiFilterPatternSetupModel patternSetup, boolean setDirty) {
        PoiFilterPatternSetupModel oldPatternSetup = this.getPatternSetup();
        if (oldPatternSetup == patternSetup) {
            return;
        }
        if (oldPatternSetup != null) {
            oldPatternSetup.removeRelation(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, PoiFilterPatternRelationModelEnum.PATTERN_SETUP.getPropertyName());
        }
        this.patternSetup = patternSetup;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(PoiFilterPatternRelationModelEnum.PATTERN_SETUP, patternSetup, oldPatternSetup);
        if (this.patternSetup != null) {
            this.patternSetup.addRelation(this);
        }
    }

    @Override
    public RendererType getRendererType() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.rendererType;
    }

    @Override
    public void setRendererType(RendererType rendererType) {
        this.setRendererType(rendererType, true);
    }

    private void setRendererType(RendererType rendererType, boolean setDirty) {
        RendererType oldRendererType = this.getRendererType();
        if (new EqualsBuilder().append((Object)oldRendererType, (Object)rendererType).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, PoiFilterPatternRelationModelEnum.RENDERER_TYPE.getPropertyName());
        }
        this.rendererType = rendererType;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(PoiFilterPatternRelationModelEnum.RENDERER_TYPE, (Object)rendererType, (Object)oldRendererType);
    }

    @Override
    public Integer getSortOrder() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.sortOrder;
    }

    @Override
    public void setSortOrder(Integer sortOrder) {
        this.setSortOrder(sortOrder, true);
    }

    private void setSortOrder(Integer sortOrder, boolean setDirty) {
        Integer oldSortOrder = this.getSortOrder();
        if (new EqualsBuilder().append(oldSortOrder, sortOrder).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, PoiFilterPatternRelationModelEnum.SORT_ORDER.getPropertyName());
        }
        this.sortOrder = sortOrder;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(PoiFilterPatternRelationModelEnum.SORT_ORDER, sortOrder, oldSortOrder);
    }

    @Override
    public int countParameters() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.parameters == null) {
            this.parameters = new ArrayList<PoiFilterPatternParameterModel>();
            if (this.getId() != null) {
                Collection parametersCollection = this.commonCaller.fetchChildren(this, PoiFilterPatternRelationModelEnum.PARAMETERS.getPropertyName());
                this.parameters.addAll(parametersCollection);
            }
        }
        return this.parameters.size();
    }

    @Override
    public Iterator<PoiFilterPatternParameterModel> iterateParameters() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.parameters == null) {
            this.parameters = new ArrayList<PoiFilterPatternParameterModel>();
            if (this.getId() != null) {
                Collection parametersCollection = this.commonCaller.fetchChildren(this, PoiFilterPatternRelationModelEnum.PARAMETERS.getPropertyName());
                this.parameters.addAll(parametersCollection);
            }
        }
        return new ImmutableIterator<PoiFilterPatternParameterModel>(this.parameters);
    }

    @Override
    public Iterable<PoiFilterPatternParameterModel> iterableParameters() {
        return new IteratorIterable<PoiFilterPatternParameterModel>(this.iterateParameters());
    }

    @Override
    public void addParameter(PoiFilterPatternParameterModel parameter) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.parameters == null) {
            this.parameters = new ArrayList<PoiFilterPatternParameterModel>();
            if (this.getId() != null) {
                Collection parametersCollection = this.commonCaller.fetchChildren(this, PoiFilterPatternRelationModelEnum.PARAMETERS.getPropertyName());
                this.parameters.addAll(parametersCollection);
            }
        }
        if (this.parameters.contains(parameter)) {
            return;
        }
        this.parameters.add(parameter);
        this.fireValueChanged(PoiFilterPatternRelationModelEnum.PARAMETERS, parameter, null);
        if (parameter != null) {
            parameter.setRelation(this);
            parameter.setSortOrder(this.parameters.size() - 1);
        }
    }

    @Override
    public void removeParameter(PoiFilterPatternParameterModel parameter) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.parameters == null) {
            this.parameters = new ArrayList<PoiFilterPatternParameterModel>();
            if (this.getId() != null) {
                Collection parametersCollection = this.commonCaller.fetchChildren(this, PoiFilterPatternRelationModelEnum.PARAMETERS.getPropertyName());
                this.parameters.addAll(parametersCollection);
            }
        }
        if (!this.parameters.contains(parameter)) {
            return;
        }
        this.parameters.remove(parameter);
        this.fireValueChanged(PoiFilterPatternRelationModelEnum.PARAMETERS, parameter, null);
        if (parameter != null) {
            parameter.setRelation(null);
            parameter.setSortOrder(null);
        }
        this.reorderParameters(0);
    }

    @Override
    public PoiFilterPatternParameterModel getParameterAt(int index) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.parameters == null) {
            this.parameters = new ArrayList<PoiFilterPatternParameterModel>();
            if (this.getId() != null) {
                Collection parametersCollection = this.commonCaller.fetchChildren(this, PoiFilterPatternRelationModelEnum.PARAMETERS.getPropertyName());
                this.parameters.addAll(parametersCollection);
            }
        }
        return this.parameters.get(index);
    }

    @Override
    public void insertParameter(PoiFilterPatternParameterModel parameter, int index) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.parameters == null) {
            this.parameters = new ArrayList<PoiFilterPatternParameterModel>();
            if (this.getId() != null) {
                Collection parametersCollection = this.commonCaller.fetchChildren(this, PoiFilterPatternRelationModelEnum.PARAMETERS.getPropertyName());
                this.parameters.addAll(parametersCollection);
            }
        }
        if (this.parameters.contains(parameter)) {
            this.removeParameter(parameter);
        }
        this.parameters.add(index, parameter);
        this.fireValueChanged(PoiFilterPatternRelationModelEnum.PARAMETERS, parameter, null);
        if (parameter != null) {
            parameter.setRelation(this);
        }
        this.reorderParameters(index);
    }

    @Override
    public void removeParameterAt(int index) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.parameters == null) {
            this.parameters = new ArrayList<PoiFilterPatternParameterModel>();
            if (this.getId() != null) {
                Collection parametersCollection = this.commonCaller.fetchChildren(this, PoiFilterPatternRelationModelEnum.PARAMETERS.getPropertyName());
                this.parameters.addAll(parametersCollection);
            }
        }
        PoiFilterPatternParameterModel oldParameter = this.parameters.get(index);
        this.parameters.remove(index);
        this.fireValueChanged(PoiFilterPatternRelationModelEnum.PARAMETERS, oldParameter, null);
        if (oldParameter != null) {
            oldParameter.setRelation(null);
            oldParameter.setSortOrder(null);
        }
        this.reorderParameters(index);
    }

    @Override
    public void setParameterAt(PoiFilterPatternParameterModel parameter, int index) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.parameters == null) {
            this.parameters = new ArrayList<PoiFilterPatternParameterModel>();
            if (this.getId() != null) {
                Collection parametersCollection = this.commonCaller.fetchChildren(this, PoiFilterPatternRelationModelEnum.PARAMETERS.getPropertyName());
                this.parameters.addAll(parametersCollection);
            }
        }
        PoiFilterPatternParameterModel oldParameter = this.parameters.get(index);
        this.parameters.set(index, parameter);
        this.fireValueChanged(PoiFilterPatternRelationModelEnum.PARAMETERS, parameter, oldParameter);
        if (oldParameter != null) {
            oldParameter.setRelation(null);
            oldParameter.setSortOrder(null);
        }
        if (parameter != null) {
            parameter.setRelation(this);
            parameter.setSortOrder(index);
        }
    }

    @Override
    public void clearParameters() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.parameters == null) {
            this.parameters = new ArrayList<PoiFilterPatternParameterModel>();
            if (this.getId() != null) {
                Collection parametersCollection = this.commonCaller.fetchChildren(this, PoiFilterPatternRelationModelEnum.PARAMETERS.getPropertyName());
                this.parameters.addAll(parametersCollection);
            }
        }
        ArrayList<PoiFilterPatternParameterModel> oldParameters = new ArrayList<PoiFilterPatternParameterModel>(this.parameters);
        this.parameters.clear();
        this.fireValueChanged(PoiFilterPatternRelationModelEnum.PARAMETERS, null, null);
        for (PoiFilterPatternParameterModel oldParameter : oldParameters) {
            if (oldParameter == null) continue;
            oldParameter.setRelation(null);
            oldParameter.setSortOrder(null);
        }
    }

    @Override
    public boolean isParametersEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.parameters == null) {
            this.parameters = new ArrayList<PoiFilterPatternParameterModel>();
            if (this.getId() != null) {
                Collection parametersCollection = this.commonCaller.fetchChildren(this, PoiFilterPatternRelationModelEnum.PARAMETERS.getPropertyName());
                this.parameters.addAll(parametersCollection);
            }
        }
        return this.parameters.isEmpty();
    }

    @Override
    public boolean containsParameter(PoiFilterPatternParameterModel parameter) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.parameters == null) {
            this.parameters = new ArrayList<PoiFilterPatternParameterModel>();
            if (this.getId() != null) {
                Collection parametersCollection = this.commonCaller.fetchChildren(this, PoiFilterPatternRelationModelEnum.PARAMETERS.getPropertyName());
                this.parameters.addAll(parametersCollection);
            }
        }
        return this.parameters.contains(parameter);
    }

    @Override
    public int indexOfParameter(PoiFilterPatternParameterModel parameter) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.parameters == null) {
            this.parameters = new ArrayList<PoiFilterPatternParameterModel>();
            if (this.getId() != null) {
                Collection parametersCollection = this.commonCaller.fetchChildren(this, PoiFilterPatternRelationModelEnum.PARAMETERS.getPropertyName());
                this.parameters.addAll(parametersCollection);
            }
        }
        return this.parameters.indexOf(parameter);
    }

    @Override
    public boolean isParametersInitialized() {
        return this.parameters != null;
    }

    private void reorderParameters(int startIndex) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.parameters == null) {
            this.parameters = new ArrayList<PoiFilterPatternParameterModel>();
            if (this.getId() != null) {
                Collection parametersCollection = this.commonCaller.fetchChildren(this, PoiFilterPatternRelationModelEnum.PARAMETERS.getPropertyName());
                this.parameters.addAll(parametersCollection);
            }
        }
        ListIterator<PoiFilterPatternParameterModel> listIterator = this.parameters.listIterator(startIndex);
        int index = startIndex;
        while (listIterator.hasNext()) {
            PoiFilterPatternParameterModel parameter = listIterator.next();
            parameter.setSortOrder(index++);
        }
    }

    @Override
    public void setProxy(boolean proxy) {
        super.setProxy(proxy);
        if (proxy) {
            this.parameters = null;
        }
    }

    @Override
    protected void updateByDto(PoiFilterPatternRelationFullDto poiFilterPatternRelationDto) {
        this.patternSetup = (PoiFilterPatternSetupModel)this.getModelCache().getModel(poiFilterPatternRelationDto.getPatternSetup());
        this.rendererType = poiFilterPatternRelationDto.getRendererType();
        this.sortOrder = poiFilterPatternRelationDto.getSortOrder();
        PoiFilterPatternParameterDto[] parameters = poiFilterPatternRelationDto.getParameters();
        if (parameters != null) {
            if (this.parameters == null) {
                this.parameters = new ArrayList<PoiFilterPatternParameterModel>();
            } else {
                this.parameters.clear();
            }
        }
    }

    @Override
    protected void updateMasterRelationsByDto(PoiFilterPatternRelationFullDto poiFilterPatternRelationDto) {
        PoiFilterPatternParameterDto[] parameters = poiFilterPatternRelationDto.getParameters();
        if (parameters != null) {
            if (this.parameters == null) {
                this.parameters = new ArrayList<PoiFilterPatternParameterModel>();
            } else {
                this.parameters.clear();
            }
            for (PoiFilterPatternParameterDto parameterDto : parameters) {
                PoiFilterPatternParameterModel parameterModel = (PoiFilterPatternParameterModel)this.getModelCache().getModel(parameterDto);
                this.parameters.add(parameterModel);
            }
        } else {
            this.parameters = null;
        }
    }

    @Override
    protected void checkStaleByDto(PoiFilterPatternRelationFullDto poiFilterPatternRelationDto) throws StaleStateException {
        PoiFilterPatternParameterDto[] parameterDtos;
        PoiFilterPatternSetupModelImpl patternSetupModel;
        PoiFilterPatternSetupDto patternSetupDto = poiFilterPatternRelationDto.getPatternSetup();
        if (patternSetupDto != null && patternSetupDto.getId() != null && (patternSetupModel = (PoiFilterPatternSetupModelImpl)this.getModelCache().getModel(PoiFilterPatternSetupModel.class, patternSetupDto.getId())) != null) {
            patternSetupModel.checkStaleState(patternSetupDto);
        }
        if ((parameterDtos = poiFilterPatternRelationDto.getParameters()) != null) {
            for (PoiFilterPatternParameterDto parameterDto : parameterDtos) {
                PoiFilterPatternParameterModelImpl parameterModel = (PoiFilterPatternParameterModelImpl)this.getModelCache().getModel(PoiFilterPatternParameterModel.class, parameterDto.getId());
                if (parameterModel == null) continue;
                parameterModel.checkStaleState(parameterDto);
            }
        }
    }

    @Override
    public PoiFilterPatternRelationFullDto createDto() {
        Long id = this.getId();
        PoiFilterPatternRelationFullDto poiFilterPatternRelationDto = id == null ? new PoiFilterPatternRelationFullDto(this.getTempUUID()) : new PoiFilterPatternRelationFullDto(id, this.getVersion());
        PoiFilterPatternSetupModelImpl patternSetup = (PoiFilterPatternSetupModelImpl)this.getPatternSetup();
        if (patternSetup != null) {
            poiFilterPatternRelationDto.setPatternSetup(patternSetup.createProxy());
        }
        poiFilterPatternRelationDto.setRendererType(this.getRendererType());
        poiFilterPatternRelationDto.setSortOrder(this.getSortOrder());
        return poiFilterPatternRelationDto;
    }

    @Override
    public PoiFilterPatternRelationProxyDto createProxy() {
        Long id = this.getId();
        PoiFilterPatternRelationProxyDto poiFilterPatternRelationDto = id == null ? new PoiFilterPatternRelationProxyDto(this.getTempUUID()) : new PoiFilterPatternRelationProxyDto(id, this.getVersion());
        return poiFilterPatternRelationDto;
    }

    public static enum PoiFilterPatternRelationModelEnum {
        PATTERN_SETUP("patternSetup"),
        RENDERER_TYPE("rendererType"),
        SORT_ORDER("sortOrder"),
        PARAMETERS("parameters");

        private String propertyName;

        private PoiFilterPatternRelationModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

