/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.base;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.base.PdfModel;
import de.datomino.peppergis.dto.base.PdfFullDto;
import de.datomino.peppergis.dto.base.PdfProxyDto;
import de.datomino.peppergis.exception.StaleStateException;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;

public class PdfModelImpl
extends AbstractModel<PdfFullDto, PdfProxyDto>
implements PdfModel {
    private String name;
    private byte[] data;

    public PdfModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public PdfModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public String getName() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.setName(name, true);
    }

    private void setName(String name, boolean setDirty) {
        String oldName = this.getName();
        if (new EqualsBuilder().append(oldName, name).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, PdfModelEnum.NAME.getPropertyName());
        }
        this.name = name;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(PdfModelEnum.NAME, name, oldName);
    }

    @Override
    public byte[] getData() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.data;
    }

    @Override
    public void setData(byte[] data) {
        this.setData(data, true);
    }

    private void setData(byte[] data, boolean setDirty) {
        byte[] oldData = this.getData();
        if (new EqualsBuilder().append(oldData, data).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, PdfModelEnum.DATA.getPropertyName());
        }
        this.data = data;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(PdfModelEnum.DATA, data, oldData);
    }

    @Override
    protected void updateByDto(PdfFullDto pdfDto) {
        this.name = pdfDto.getName();
        this.data = pdfDto.getData();
    }

    @Override
    protected void updateMasterRelationsByDto(PdfFullDto pdfDto) {
    }

    @Override
    protected void checkStaleByDto(PdfFullDto pdfDto) throws StaleStateException {
    }

    @Override
    public PdfFullDto createDto() {
        Long id = this.getId();
        PdfFullDto pdfDto = id == null ? new PdfFullDto(this.getTempUUID()) : new PdfFullDto(id, this.getVersion());
        pdfDto.setName(this.getName());
        pdfDto.setData(this.getData());
        return pdfDto;
    }

    @Override
    public PdfProxyDto createProxy() {
        Long id = this.getId();
        PdfProxyDto pdfDto = id == null ? new PdfProxyDto(this.getTempUUID()) : new PdfProxyDto(id, this.getVersion());
        return pdfDto;
    }

    public static enum PdfModelEnum {
        NAME("name"),
        DATA("data");

        private String propertyName;

        private PdfModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

