/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.base;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.admin.UserModel;
import de.datomino.peppergis.client.model.admin.UserModelImpl;
import de.datomino.peppergis.client.model.base.ImportedLocationModel;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.model.base.LocationModelImpl;
import de.datomino.peppergis.dto.admin.UserDto;
import de.datomino.peppergis.dto.base.ImportedLocationFullDto;
import de.datomino.peppergis.dto.base.ImportedLocationProxyDto;
import de.datomino.peppergis.dto.base.LocationDto;
import de.datomino.peppergis.exception.StaleStateException;
import de.datomino.peppergis.type.ImportedLocationProcess;
import de.datomino.peppergis.type.ImportedLocationStatus;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.dto.ImmutablePointDto;
import de.datomino.util.international.country.Country;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;
import org.ktde.util.conversions.ImmutableIterator;
import org.ktde.util.conversions.IteratorIterable;

public class ImportedLocationModelImpl
extends AbstractModel<ImportedLocationFullDto, ImportedLocationProxyDto>
implements ImportedLocationModel {
    private String information;
    private Country country;
    private String city;
    private String district;
    private String postcode;
    private String street;
    private Integer housenumber;
    private String housenumberExtension;
    private ImmutablePoint geoLocation;
    private Set<LocationModel> location = null;
    private ImportedLocationStatus status;
    private ImportedLocationProcess process;
    private UserModel editorUser;
    private UserModel loginUser;

    public ImportedLocationModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public ImportedLocationModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public String getInformation() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.information;
    }

    @Override
    public void setInformation(String information) {
        this.setInformation(information, true);
    }

    private void setInformation(String information, boolean setDirty) {
        String oldInformation = this.getInformation();
        if (new EqualsBuilder().append(oldInformation, information).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ImportedLocationModelEnum.INFORMATION.getPropertyName());
        }
        this.information = information;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ImportedLocationModelEnum.INFORMATION, information, oldInformation);
    }

    @Override
    public Country getCountry() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.country;
    }

    @Override
    public void setCountry(Country country) {
        this.setCountry(country, true);
    }

    private void setCountry(Country country, boolean setDirty) {
        Country oldCountry = this.getCountry();
        if (new EqualsBuilder().append(oldCountry, country).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ImportedLocationModelEnum.COUNTRY.getPropertyName());
        }
        this.country = country;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ImportedLocationModelEnum.COUNTRY, country, oldCountry);
    }

    @Override
    public String getCity() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.city;
    }

    @Override
    public void setCity(String city) {
        this.setCity(city, true);
    }

    private void setCity(String city, boolean setDirty) {
        String oldCity = this.getCity();
        if (new EqualsBuilder().append(oldCity, city).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ImportedLocationModelEnum.CITY.getPropertyName());
        }
        this.city = city;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ImportedLocationModelEnum.CITY, city, oldCity);
    }

    @Override
    public String getDistrict() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.district;
    }

    @Override
    public void setDistrict(String district) {
        this.setDistrict(district, true);
    }

    private void setDistrict(String district, boolean setDirty) {
        String oldDistrict = this.getDistrict();
        if (new EqualsBuilder().append(oldDistrict, district).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ImportedLocationModelEnum.DISTRICT.getPropertyName());
        }
        this.district = district;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ImportedLocationModelEnum.DISTRICT, district, oldDistrict);
    }

    @Override
    public String getPostcode() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.postcode;
    }

    @Override
    public void setPostcode(String postcode) {
        this.setPostcode(postcode, true);
    }

    private void setPostcode(String postcode, boolean setDirty) {
        String oldPostcode = this.getPostcode();
        if (new EqualsBuilder().append(oldPostcode, postcode).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ImportedLocationModelEnum.POSTCODE.getPropertyName());
        }
        this.postcode = postcode;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ImportedLocationModelEnum.POSTCODE, postcode, oldPostcode);
    }

    @Override
    public String getStreet() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.street;
    }

    @Override
    public void setStreet(String street) {
        this.setStreet(street, true);
    }

    private void setStreet(String street, boolean setDirty) {
        String oldStreet = this.getStreet();
        if (new EqualsBuilder().append(oldStreet, street).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ImportedLocationModelEnum.STREET.getPropertyName());
        }
        this.street = street;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ImportedLocationModelEnum.STREET, street, oldStreet);
    }

    @Override
    public Integer getHousenumber() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.housenumber;
    }

    @Override
    public void setHousenumber(Integer housenumber) {
        this.setHousenumber(housenumber, true);
    }

    private void setHousenumber(Integer housenumber, boolean setDirty) {
        Integer oldHousenumber = this.getHousenumber();
        if (new EqualsBuilder().append(oldHousenumber, housenumber).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ImportedLocationModelEnum.HOUSENUMBER.getPropertyName());
        }
        this.housenumber = housenumber;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ImportedLocationModelEnum.HOUSENUMBER, housenumber, oldHousenumber);
    }

    @Override
    public String getHousenumberExtension() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.housenumberExtension;
    }

    @Override
    public void setHousenumberExtension(String housenumberExtension) {
        this.setHousenumberExtension(housenumberExtension, true);
    }

    private void setHousenumberExtension(String housenumberExtension, boolean setDirty) {
        String oldHousenumberExtension = this.getHousenumberExtension();
        if (new EqualsBuilder().append(oldHousenumberExtension, housenumberExtension).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ImportedLocationModelEnum.HOUSENUMBER_EXTENSION.getPropertyName());
        }
        this.housenumberExtension = housenumberExtension;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ImportedLocationModelEnum.HOUSENUMBER_EXTENSION, housenumberExtension, oldHousenumberExtension);
    }

    @Override
    public ImmutablePoint getGeoLocation() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.geoLocation;
    }

    @Override
    public void setGeoLocation(ImmutablePoint geoLocation) {
        this.setGeoLocation(geoLocation, true);
    }

    private void setGeoLocation(ImmutablePoint geoLocation, boolean setDirty) {
        ImmutablePoint oldGeoLocation = this.getGeoLocation();
        if (new EqualsBuilder().append(oldGeoLocation, geoLocation).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ImportedLocationModelEnum.GEO_LOCATION.getPropertyName());
        }
        this.geoLocation = geoLocation;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ImportedLocationModelEnum.GEO_LOCATION, geoLocation, oldGeoLocation);
    }

    @Override
    public int countLocation() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.location == null) {
            this.location = new LinkedHashSet<LocationModel>();
            if (this.getId() != null) {
                Collection locationCollection = this.commonCaller.fetchChildren(this, ImportedLocationModelEnum.LOCATION.getPropertyName());
                this.location.addAll(locationCollection);
            }
        }
        return this.location.size();
    }

    @Override
    public Iterator<LocationModel> iterateLocation() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.location == null) {
            this.location = new LinkedHashSet<LocationModel>();
            if (this.getId() != null) {
                Collection locationCollection = this.commonCaller.fetchChildren(this, ImportedLocationModelEnum.LOCATION.getPropertyName());
                this.location.addAll(locationCollection);
            }
        }
        return new ImmutableIterator<LocationModel>(this.location);
    }

    @Override
    public Iterable<LocationModel> iterableLocation() {
        return new IteratorIterable<LocationModel>(this.iterateLocation());
    }

    @Override
    public void addALocation(LocationModel aLocation) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.location == null) {
            this.location = new LinkedHashSet<LocationModel>();
            if (this.getId() != null) {
                Collection locationCollection = this.commonCaller.fetchChildren(this, ImportedLocationModelEnum.LOCATION.getPropertyName());
                this.location.addAll(locationCollection);
            }
        }
        if (this.location.contains(aLocation)) {
            return;
        }
        this.location.add(aLocation);
        this.fireValueChanged(ImportedLocationModelEnum.LOCATION, aLocation, null);
        if (aLocation != null) {
            aLocation.setImportedLocation(this);
        }
    }

    @Override
    public void removeALocation(LocationModel aLocation) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.location == null) {
            this.location = new LinkedHashSet<LocationModel>();
            if (this.getId() != null) {
                Collection locationCollection = this.commonCaller.fetchChildren(this, ImportedLocationModelEnum.LOCATION.getPropertyName());
                this.location.addAll(locationCollection);
            }
        }
        if (!this.location.contains(aLocation)) {
            return;
        }
        this.location.remove(aLocation);
        this.fireValueChanged(ImportedLocationModelEnum.LOCATION, aLocation, null);
        if (aLocation != null) {
            aLocation.setImportedLocation(null);
        }
    }

    @Override
    public void clearLocation() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.location == null) {
            this.location = new LinkedHashSet<LocationModel>();
            if (this.getId() != null) {
                Collection locationCollection = this.commonCaller.fetchChildren(this, ImportedLocationModelEnum.LOCATION.getPropertyName());
                this.location.addAll(locationCollection);
            }
        }
        ArrayList<LocationModel> oldLocation = new ArrayList<LocationModel>(this.location);
        this.location.clear();
        this.fireValueChanged(ImportedLocationModelEnum.LOCATION, null, null);
        for (LocationModel oldALocation : oldLocation) {
            if (oldALocation == null) continue;
            oldALocation.setImportedLocation(null);
        }
    }

    @Override
    public boolean isLocationEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.location == null) {
            this.location = new LinkedHashSet<LocationModel>();
            if (this.getId() != null) {
                Collection locationCollection = this.commonCaller.fetchChildren(this, ImportedLocationModelEnum.LOCATION.getPropertyName());
                this.location.addAll(locationCollection);
            }
        }
        return this.location.isEmpty();
    }

    @Override
    public boolean containsALocation(LocationModel aLocation) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.location == null) {
            this.location = new LinkedHashSet<LocationModel>();
            if (this.getId() != null) {
                Collection locationCollection = this.commonCaller.fetchChildren(this, ImportedLocationModelEnum.LOCATION.getPropertyName());
                this.location.addAll(locationCollection);
            }
        }
        return this.location.contains(aLocation);
    }

    @Override
    public boolean isLocationInitialized() {
        return this.location != null;
    }

    @Override
    public ImportedLocationStatus getStatus() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.status;
    }

    @Override
    public void setStatus(ImportedLocationStatus status) {
        this.setStatus(status, true);
    }

    private void setStatus(ImportedLocationStatus status, boolean setDirty) {
        ImportedLocationStatus oldStatus = this.getStatus();
        if (new EqualsBuilder().append((Object)oldStatus, (Object)status).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ImportedLocationModelEnum.STATUS.getPropertyName());
        }
        this.status = status;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ImportedLocationModelEnum.STATUS, (Object)status, (Object)oldStatus);
    }

    @Override
    public ImportedLocationProcess getProcess() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.process;
    }

    @Override
    public void setProcess(ImportedLocationProcess process) {
        this.setProcess(process, true);
    }

    private void setProcess(ImportedLocationProcess process, boolean setDirty) {
        ImportedLocationProcess oldProcess = this.getProcess();
        if (new EqualsBuilder().append((Object)oldProcess, (Object)process).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ImportedLocationModelEnum.PROCESS.getPropertyName());
        }
        this.process = process;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ImportedLocationModelEnum.PROCESS, (Object)process, (Object)oldProcess);
    }

    @Override
    public UserModel getEditorUser() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.editorUser;
    }

    @Override
    public void setEditorUser(UserModel editorUser) {
        this.setEditorUser(editorUser, true);
    }

    private void setEditorUser(UserModel editorUser, boolean setDirty) {
        UserModel oldEditorUser = this.getEditorUser();
        if (oldEditorUser == editorUser) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ImportedLocationModelEnum.EDITOR_USER.getPropertyName());
        }
        this.editorUser = editorUser;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ImportedLocationModelEnum.EDITOR_USER, editorUser, oldEditorUser);
    }

    @Override
    public UserModel getLoginUser() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.loginUser;
    }

    @Override
    public void setLoginUser(UserModel loginUser) {
        this.setLoginUser(loginUser, true);
    }

    private void setLoginUser(UserModel loginUser, boolean setDirty) {
        UserModel oldLoginUser = this.getLoginUser();
        if (oldLoginUser == loginUser) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ImportedLocationModelEnum.LOGIN_USER.getPropertyName());
        }
        this.loginUser = loginUser;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ImportedLocationModelEnum.LOGIN_USER, loginUser, oldLoginUser);
    }

    @Override
    public void setProxy(boolean proxy) {
        super.setProxy(proxy);
        if (proxy) {
            this.location = null;
        }
    }

    @Override
    protected void updateByDto(ImportedLocationFullDto importedLocationDto) {
        this.information = importedLocationDto.getInformation();
        this.country = importedLocationDto.getCountry();
        this.city = importedLocationDto.getCity();
        this.district = importedLocationDto.getDistrict();
        this.postcode = importedLocationDto.getPostcode();
        this.street = importedLocationDto.getStreet();
        this.housenumber = importedLocationDto.getHousenumber();
        this.housenumberExtension = importedLocationDto.getHousenumberExtension();
        ImmutablePointDto geoLocation = importedLocationDto.getGeoLocation();
        this.geoLocation = geoLocation == null ? null : (ImmutablePoint)geoLocation.getGeoObject();
        LocationDto[] location = importedLocationDto.getLocation();
        if (location != null) {
            if (this.location == null) {
                this.location = new LinkedHashSet<LocationModel>();
            } else {
                this.location.clear();
            }
        }
        this.status = importedLocationDto.getStatus();
        this.process = importedLocationDto.getProcess();
        this.editorUser = (UserModel)this.getModelCache().getModel(importedLocationDto.getEditorUser());
        this.loginUser = (UserModel)this.getModelCache().getModel(importedLocationDto.getLoginUser());
    }

    @Override
    protected void updateMasterRelationsByDto(ImportedLocationFullDto importedLocationDto) {
        LocationDto[] location = importedLocationDto.getLocation();
        if (location != null) {
            if (this.location == null) {
                this.location = new LinkedHashSet<LocationModel>();
            } else {
                this.location.clear();
            }
            for (LocationDto aLocationDto : location) {
                LocationModel aLocationModel = (LocationModel)this.getModelCache().getModel(aLocationDto);
                this.location.add(aLocationModel);
            }
        } else {
            this.location = null;
        }
    }

    @Override
    protected void checkStaleByDto(ImportedLocationFullDto importedLocationDto) throws StaleStateException {
        UserModelImpl loginUserModel;
        UserDto loginUserDto;
        UserModelImpl editorUserModel;
        UserDto editorUserDto;
        LocationDto[] aLocationDtos = importedLocationDto.getLocation();
        if (aLocationDtos != null) {
            for (LocationDto aLocationDto : aLocationDtos) {
                LocationModelImpl aLocationModel = (LocationModelImpl)this.getModelCache().getModel(LocationModel.class, aLocationDto.getId());
                if (aLocationModel == null) continue;
                aLocationModel.checkStaleState(aLocationDto);
            }
        }
        if ((editorUserDto = importedLocationDto.getEditorUser()) != null && editorUserDto.getId() != null && (editorUserModel = (UserModelImpl)this.getModelCache().getModel(UserModel.class, editorUserDto.getId())) != null) {
            editorUserModel.checkStaleState(editorUserDto);
        }
        if ((loginUserDto = importedLocationDto.getLoginUser()) != null && loginUserDto.getId() != null && (loginUserModel = (UserModelImpl)this.getModelCache().getModel(UserModel.class, loginUserDto.getId())) != null) {
            loginUserModel.checkStaleState(loginUserDto);
        }
    }

    @Override
    public ImportedLocationFullDto createDto() {
        UserModelImpl loginUser;
        Long id = this.getId();
        ImportedLocationFullDto importedLocationDto = id == null ? new ImportedLocationFullDto(this.getTempUUID()) : new ImportedLocationFullDto(id, this.getVersion());
        importedLocationDto.setInformation(this.getInformation());
        importedLocationDto.setCountry(this.getCountry());
        importedLocationDto.setCity(this.getCity());
        importedLocationDto.setDistrict(this.getDistrict());
        importedLocationDto.setPostcode(this.getPostcode());
        importedLocationDto.setStreet(this.getStreet());
        importedLocationDto.setHousenumber(this.getHousenumber());
        importedLocationDto.setHousenumberExtension(this.getHousenumberExtension());
        ImmutablePoint geoLocation = this.getGeoLocation();
        importedLocationDto.setGeoLocation(ImmutablePointDto.create(geoLocation));
        importedLocationDto.setStatus(this.getStatus());
        importedLocationDto.setProcess(this.getProcess());
        UserModelImpl editorUser = (UserModelImpl)this.getEditorUser();
        if (editorUser != null) {
            importedLocationDto.setEditorUser(editorUser.createProxy());
        }
        if ((loginUser = (UserModelImpl)this.getLoginUser()) != null) {
            importedLocationDto.setLoginUser(loginUser.createProxy());
        }
        return importedLocationDto;
    }

    @Override
    public ImportedLocationProxyDto createProxy() {
        Long id = this.getId();
        ImportedLocationProxyDto importedLocationDto = id == null ? new ImportedLocationProxyDto(this.getTempUUID()) : new ImportedLocationProxyDto(id, this.getVersion());
        return importedLocationDto;
    }

    public static enum ImportedLocationModelEnum {
        INFORMATION("information"),
        COUNTRY("country"),
        CITY("city"),
        DISTRICT("district"),
        POSTCODE("postcode"),
        STREET("street"),
        HOUSENUMBER("housenumber"),
        HOUSENUMBER_EXTENSION("housenumberExtension"),
        GEO_LOCATION("geoLocation"),
        LOCATION("location"),
        STATUS("status"),
        PROCESS("process"),
        EDITOR_USER("editorUser"),
        LOGIN_USER("loginUser");

        private String propertyName;

        private ImportedLocationModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

