/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.base;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.base.CustomerFaxContactModel;
import de.datomino.peppergis.client.model.base.CustomerModel;
import de.datomino.peppergis.client.model.base.CustomerModelImpl;
import de.datomino.peppergis.dto.base.CustomerDto;
import de.datomino.peppergis.dto.base.CustomerFaxContactFullDto;
import de.datomino.peppergis.dto.base.CustomerFaxContactProxyDto;
import de.datomino.peppergis.exception.StaleStateException;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;

public class CustomerFaxContactModelImpl
extends AbstractModel<CustomerFaxContactFullDto, CustomerFaxContactProxyDto>
implements CustomerFaxContactModel {
    private String faxNumber;
    private String firstName;
    private String lastName;
    private Integer customerOrder;
    private CustomerModel customer;

    public CustomerFaxContactModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public CustomerFaxContactModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public String getFaxNumber() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.faxNumber;
    }

    @Override
    public void setFaxNumber(String faxNumber) {
        this.setFaxNumber(faxNumber, true);
    }

    private void setFaxNumber(String faxNumber, boolean setDirty) {
        String oldFaxNumber = this.getFaxNumber();
        if (new EqualsBuilder().append(oldFaxNumber, faxNumber).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, CustomerFaxContactModelEnum.FAX_NUMBER.getPropertyName());
        }
        this.faxNumber = faxNumber;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(CustomerFaxContactModelEnum.FAX_NUMBER, faxNumber, oldFaxNumber);
    }

    @Override
    public String getFirstName() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.firstName;
    }

    @Override
    public void setFirstName(String firstName) {
        this.setFirstName(firstName, true);
    }

    private void setFirstName(String firstName, boolean setDirty) {
        String oldFirstName = this.getFirstName();
        if (new EqualsBuilder().append(oldFirstName, firstName).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, CustomerFaxContactModelEnum.FIRST_NAME.getPropertyName());
        }
        this.firstName = firstName;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(CustomerFaxContactModelEnum.FIRST_NAME, firstName, oldFirstName);
    }

    @Override
    public String getLastName() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.lastName;
    }

    @Override
    public void setLastName(String lastName) {
        this.setLastName(lastName, true);
    }

    private void setLastName(String lastName, boolean setDirty) {
        String oldLastName = this.getLastName();
        if (new EqualsBuilder().append(oldLastName, lastName).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, CustomerFaxContactModelEnum.LAST_NAME.getPropertyName());
        }
        this.lastName = lastName;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(CustomerFaxContactModelEnum.LAST_NAME, lastName, oldLastName);
    }

    @Override
    public Integer getCustomerOrder() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.customerOrder;
    }

    @Override
    public void setCustomerOrder(Integer customerOrder) {
        this.setCustomerOrder(customerOrder, true);
    }

    private void setCustomerOrder(Integer customerOrder, boolean setDirty) {
        Integer oldCustomerOrder = this.getCustomerOrder();
        if (new EqualsBuilder().append(oldCustomerOrder, customerOrder).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, CustomerFaxContactModelEnum.CUSTOMER_ORDER.getPropertyName());
        }
        this.customerOrder = customerOrder;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(CustomerFaxContactModelEnum.CUSTOMER_ORDER, customerOrder, oldCustomerOrder);
    }

    @Override
    public CustomerModel getCustomer() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.customer;
    }

    @Override
    public void setCustomer(CustomerModel customer) {
        this.setCustomer(customer, true);
    }

    private void setCustomer(CustomerModel customer, boolean setDirty) {
        CustomerModel oldCustomer = this.getCustomer();
        if (oldCustomer == customer) {
            return;
        }
        if (oldCustomer != null) {
            oldCustomer.removeFaxContact(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, CustomerFaxContactModelEnum.CUSTOMER.getPropertyName());
        }
        this.customer = customer;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(CustomerFaxContactModelEnum.CUSTOMER, customer, oldCustomer);
        if (this.customer != null) {
            this.customer.addFaxContact(this);
        }
    }

    @Override
    protected void updateByDto(CustomerFaxContactFullDto customerFaxContactDto) {
        this.faxNumber = customerFaxContactDto.getFaxNumber();
        this.firstName = customerFaxContactDto.getFirstName();
        this.lastName = customerFaxContactDto.getLastName();
        this.customerOrder = customerFaxContactDto.getCustomerOrder();
        this.customer = (CustomerModel)this.getModelCache().getModel(customerFaxContactDto.getCustomer());
    }

    @Override
    protected void updateMasterRelationsByDto(CustomerFaxContactFullDto customerFaxContactDto) {
    }

    @Override
    protected void checkStaleByDto(CustomerFaxContactFullDto customerFaxContactDto) throws StaleStateException {
        CustomerModelImpl customerModel;
        CustomerDto customerDto = customerFaxContactDto.getCustomer();
        if (customerDto != null && customerDto.getId() != null && (customerModel = (CustomerModelImpl)this.getModelCache().getModel(CustomerModel.class, customerDto.getId())) != null) {
            customerModel.checkStaleState(customerDto);
        }
    }

    @Override
    public CustomerFaxContactFullDto createDto() {
        Long id = this.getId();
        CustomerFaxContactFullDto customerFaxContactDto = id == null ? new CustomerFaxContactFullDto(this.getTempUUID()) : new CustomerFaxContactFullDto(id, this.getVersion());
        customerFaxContactDto.setFaxNumber(this.getFaxNumber());
        customerFaxContactDto.setFirstName(this.getFirstName());
        customerFaxContactDto.setLastName(this.getLastName());
        customerFaxContactDto.setCustomerOrder(this.getCustomerOrder());
        CustomerModelImpl customer = (CustomerModelImpl)this.getCustomer();
        if (customer != null) {
            customerFaxContactDto.setCustomer(customer.createProxy());
        }
        return customerFaxContactDto;
    }

    @Override
    public CustomerFaxContactProxyDto createProxy() {
        Long id = this.getId();
        CustomerFaxContactProxyDto customerFaxContactDto = id == null ? new CustomerFaxContactProxyDto(this.getTempUUID()) : new CustomerFaxContactProxyDto(id, this.getVersion());
        return customerFaxContactDto;
    }

    public static enum CustomerFaxContactModelEnum {
        FAX_NUMBER("faxNumber"),
        FIRST_NAME("firstName"),
        LAST_NAME("lastName"),
        CUSTOMER_ORDER("customerOrder"),
        CUSTOMER("customer");

        private String propertyName;

        private CustomerFaxContactModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

