/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.base;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.base.AttributeGroupModel;
import de.datomino.peppergis.dto.base.AttributeGroupFullDto;
import de.datomino.peppergis.dto.base.AttributeGroupProxyDto;
import de.datomino.peppergis.exception.StaleStateException;
import de.datomino.peppergis.type.AttributeGroupType;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;

public class AttributeGroupModelImpl
extends AbstractModel<AttributeGroupFullDto, AttributeGroupProxyDto>
implements AttributeGroupModel {
    private String name;
    private String description;
    private AttributeGroupType groupType;

    public AttributeGroupModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public AttributeGroupModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public String getName() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.setName(name, true);
    }

    private void setName(String name, boolean setDirty) {
        String oldName = this.getName();
        if (new EqualsBuilder().append(oldName, name).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AttributeGroupModelEnum.NAME.getPropertyName());
        }
        this.name = name;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AttributeGroupModelEnum.NAME, name, oldName);
    }

    @Override
    public String getDescription() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.setDescription(description, true);
    }

    private void setDescription(String description, boolean setDirty) {
        String oldDescription = this.getDescription();
        if (new EqualsBuilder().append(oldDescription, description).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AttributeGroupModelEnum.DESCRIPTION.getPropertyName());
        }
        this.description = description;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AttributeGroupModelEnum.DESCRIPTION, description, oldDescription);
    }

    @Override
    public AttributeGroupType getGroupType() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.groupType;
    }

    @Override
    public void setGroupType(AttributeGroupType groupType) {
        this.setGroupType(groupType, true);
    }

    private void setGroupType(AttributeGroupType groupType, boolean setDirty) {
        AttributeGroupType oldGroupType = this.getGroupType();
        if (new EqualsBuilder().append((Object)oldGroupType, (Object)groupType).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, AttributeGroupModelEnum.GROUP_TYPE.getPropertyName());
        }
        this.groupType = groupType;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(AttributeGroupModelEnum.GROUP_TYPE, (Object)groupType, (Object)oldGroupType);
    }

    @Override
    protected void updateByDto(AttributeGroupFullDto attributeGroupDto) {
        this.name = attributeGroupDto.getName();
        this.description = attributeGroupDto.getDescription();
        this.groupType = attributeGroupDto.getGroupType();
    }

    @Override
    protected void updateMasterRelationsByDto(AttributeGroupFullDto attributeGroupDto) {
    }

    @Override
    protected void checkStaleByDto(AttributeGroupFullDto attributeGroupDto) throws StaleStateException {
    }

    @Override
    public AttributeGroupFullDto createDto() {
        Long id = this.getId();
        AttributeGroupFullDto attributeGroupDto = id == null ? new AttributeGroupFullDto(this.getTempUUID()) : new AttributeGroupFullDto(id, this.getVersion());
        attributeGroupDto.setName(this.getName());
        attributeGroupDto.setDescription(this.getDescription());
        attributeGroupDto.setGroupType(this.getGroupType());
        return attributeGroupDto;
    }

    @Override
    public AttributeGroupProxyDto createProxy() {
        Long id = this.getId();
        AttributeGroupProxyDto attributeGroupDto = id == null ? new AttributeGroupProxyDto(this.getTempUUID()) : new AttributeGroupProxyDto(id, this.getVersion());
        return attributeGroupDto;
    }

    public static enum AttributeGroupModelEnum {
        NAME("name"),
        DESCRIPTION("description"),
        GROUP_TYPE("groupType");

        private String propertyName;

        private AttributeGroupModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

