/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.area;

import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.area.AreaObjectParcelRelModel;
import de.datomino.peppergis.client.model.area.AreaObjectParcelRelModelImpl;
import de.datomino.peppergis.client.model.area.ParcelSortOrderModel;
import de.datomino.peppergis.client.model.tour.DeliveryRoundModel;
import de.datomino.peppergis.client.model.tour.DeliveryRoundModelImpl;
import de.datomino.peppergis.dto.area.AreaObjectParcelRelDto;
import de.datomino.peppergis.dto.area.ParcelSortOrderFullDto;
import de.datomino.peppergis.dto.area.ParcelSortOrderProxyDto;
import de.datomino.peppergis.dto.tour.DeliveryRoundDto;
import de.datomino.peppergis.exception.StaleStateException;
import de.datomino.peppergis.type.ParcelSortOrderType;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;

public class ParcelSortOrderModelImpl
extends AbstractModel<ParcelSortOrderFullDto, ParcelSortOrderProxyDto>
implements ParcelSortOrderModel {
    private Integer value;
    private RouteVehicleType vehicle;
    private DeliveryRoundModel deliveryRound;
    private ParcelSortOrderType type;
    private AreaObjectParcelRelModel areaObjectParcelRel;

    public ParcelSortOrderModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public ParcelSortOrderModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public Integer getValue() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.value;
    }

    @Override
    public void setValue(Integer value) {
        this.setValue(value, true);
    }

    private void setValue(Integer value, boolean setDirty) {
        Integer oldValue = this.getValue();
        if (new EqualsBuilder().append(oldValue, value).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ParcelSortOrderModelEnum.VALUE.getPropertyName());
        }
        this.value = value;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ParcelSortOrderModelEnum.VALUE, value, oldValue);
    }

    @Override
    public RouteVehicleType getVehicle() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.vehicle;
    }

    @Override
    public void setVehicle(RouteVehicleType vehicle) {
        this.setVehicle(vehicle, true);
    }

    private void setVehicle(RouteVehicleType vehicle, boolean setDirty) {
        RouteVehicleType oldVehicle = this.getVehicle();
        if (new EqualsBuilder().append((Object)oldVehicle, (Object)vehicle).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ParcelSortOrderModelEnum.VEHICLE.getPropertyName());
        }
        this.vehicle = vehicle;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ParcelSortOrderModelEnum.VEHICLE, (Object)vehicle, (Object)oldVehicle);
    }

    @Override
    public DeliveryRoundModel getDeliveryRound() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.deliveryRound;
    }

    @Override
    public void setDeliveryRound(DeliveryRoundModel deliveryRound) {
        this.setDeliveryRound(deliveryRound, true);
    }

    private void setDeliveryRound(DeliveryRoundModel deliveryRound, boolean setDirty) {
        DeliveryRoundModel oldDeliveryRound = this.getDeliveryRound();
        if (oldDeliveryRound == deliveryRound) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ParcelSortOrderModelEnum.DELIVERY_ROUND.getPropertyName());
        }
        this.deliveryRound = deliveryRound;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ParcelSortOrderModelEnum.DELIVERY_ROUND, deliveryRound, oldDeliveryRound);
    }

    @Override
    public ParcelSortOrderType getType() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.type;
    }

    @Override
    public void setType(ParcelSortOrderType type) {
        this.setType(type, true);
    }

    private void setType(ParcelSortOrderType type, boolean setDirty) {
        ParcelSortOrderType oldType = this.getType();
        if (new EqualsBuilder().append((Object)oldType, (Object)type).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ParcelSortOrderModelEnum.TYPE.getPropertyName());
        }
        this.type = type;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ParcelSortOrderModelEnum.TYPE, (Object)type, (Object)oldType);
    }

    @Override
    public AreaObjectParcelRelModel getAreaObjectParcelRel() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.areaObjectParcelRel;
    }

    @Override
    public void setAreaObjectParcelRel(AreaObjectParcelRelModel areaObjectParcelRel) {
        this.setAreaObjectParcelRel(areaObjectParcelRel, true);
    }

    private void setAreaObjectParcelRel(AreaObjectParcelRelModel areaObjectParcelRel, boolean setDirty) {
        AreaObjectParcelRelModel oldAreaObjectParcelRel = this.getAreaObjectParcelRel();
        if (oldAreaObjectParcelRel == areaObjectParcelRel) {
            return;
        }
        if (oldAreaObjectParcelRel != null) {
            oldAreaObjectParcelRel.removeSortOrder(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, ParcelSortOrderModelEnum.AREA_OBJECT_PARCEL_REL.getPropertyName());
        }
        this.areaObjectParcelRel = areaObjectParcelRel;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(ParcelSortOrderModelEnum.AREA_OBJECT_PARCEL_REL, areaObjectParcelRel, oldAreaObjectParcelRel);
        if (this.areaObjectParcelRel != null) {
            this.areaObjectParcelRel.addSortOrder(this);
        }
    }

    @Override
    protected void updateByDto(ParcelSortOrderFullDto parcelSortOrderDto) {
        this.value = parcelSortOrderDto.getValue();
        this.vehicle = parcelSortOrderDto.getVehicle();
        this.deliveryRound = (DeliveryRoundModel)this.getModelCache().getModel(parcelSortOrderDto.getDeliveryRound());
        this.type = parcelSortOrderDto.getType();
        this.areaObjectParcelRel = (AreaObjectParcelRelModel)this.getModelCache().getModel(parcelSortOrderDto.getAreaObjectParcelRel());
    }

    @Override
    protected void updateMasterRelationsByDto(ParcelSortOrderFullDto parcelSortOrderDto) {
    }

    @Override
    protected void checkStaleByDto(ParcelSortOrderFullDto parcelSortOrderDto) throws StaleStateException {
        AreaObjectParcelRelModelImpl areaObjectParcelRelModel;
        AreaObjectParcelRelDto areaObjectParcelRelDto;
        DeliveryRoundModelImpl deliveryRoundModel;
        DeliveryRoundDto deliveryRoundDto = parcelSortOrderDto.getDeliveryRound();
        if (deliveryRoundDto != null && deliveryRoundDto.getId() != null && (deliveryRoundModel = (DeliveryRoundModelImpl)this.getModelCache().getModel(DeliveryRoundModel.class, deliveryRoundDto.getId())) != null) {
            deliveryRoundModel.checkStaleState(deliveryRoundDto);
        }
        if ((areaObjectParcelRelDto = parcelSortOrderDto.getAreaObjectParcelRel()) != null && areaObjectParcelRelDto.getId() != null && (areaObjectParcelRelModel = (AreaObjectParcelRelModelImpl)this.getModelCache().getModel(AreaObjectParcelRelModel.class, areaObjectParcelRelDto.getId())) != null) {
            areaObjectParcelRelModel.checkStaleState(areaObjectParcelRelDto);
        }
    }

    @Override
    public ParcelSortOrderFullDto createDto() {
        Long id = this.getId();
        ParcelSortOrderFullDto parcelSortOrderDto = id == null ? new ParcelSortOrderFullDto(this.getTempUUID()) : new ParcelSortOrderFullDto(id, this.getVersion());
        parcelSortOrderDto.setValue(this.getValue());
        parcelSortOrderDto.setVehicle(this.getVehicle());
        DeliveryRoundModelImpl deliveryRound = (DeliveryRoundModelImpl)this.getDeliveryRound();
        if (deliveryRound != null) {
            parcelSortOrderDto.setDeliveryRound(deliveryRound.createProxy());
        }
        parcelSortOrderDto.setType(this.getType());
        AreaObjectParcelRelModelImpl areaObjectParcelRel = (AreaObjectParcelRelModelImpl)this.getAreaObjectParcelRel();
        if (areaObjectParcelRel != null) {
            parcelSortOrderDto.setAreaObjectParcelRel(areaObjectParcelRel.createProxy());
        }
        return parcelSortOrderDto;
    }

    @Override
    public ParcelSortOrderProxyDto createProxy() {
        Long id = this.getId();
        ParcelSortOrderProxyDto parcelSortOrderDto = id == null ? new ParcelSortOrderProxyDto(this.getTempUUID()) : new ParcelSortOrderProxyDto(id, this.getVersion());
        return parcelSortOrderDto;
    }

    public static enum ParcelSortOrderModelEnum {
        VALUE("value"),
        VEHICLE("vehicle"),
        DELIVERY_ROUND("deliveryRound"),
        TYPE("type"),
        AREA_OBJECT_PARCEL_REL("areaObjectParcelRel");

        private String propertyName;

        private ParcelSortOrderModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

