/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.area;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.area.AreaObjectModelImpl;
import de.datomino.peppergis.client.model.area.DetaillessAreaObjectGeometryModel;
import de.datomino.peppergis.dto.area.AreaObjectDto;
import de.datomino.peppergis.dto.area.DetaillessAreaObjectGeometryFullDto;
import de.datomino.peppergis.dto.area.DetaillessAreaObjectGeometryProxyDto;
import de.datomino.peppergis.exception.StaleStateException;
import de.datomino.util.geo.ImmutablePolygonKind;
import de.datomino.util.geo.dto.ImmutablePolygonKindDto;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;

public class DetaillessAreaObjectGeometryModelImpl
extends AbstractModel<DetaillessAreaObjectGeometryFullDto, DetaillessAreaObjectGeometryProxyDto>
implements DetaillessAreaObjectGeometryModel {
    private AreaObjectModel areaObject;
    private Double fromScale;
    private ImmutablePolygonKind geom;

    public DetaillessAreaObjectGeometryModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public DetaillessAreaObjectGeometryModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public AreaObjectModel getAreaObject() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.areaObject;
    }

    @Override
    public void setAreaObject(AreaObjectModel areaObject) {
        this.setAreaObject(areaObject, true);
    }

    private void setAreaObject(AreaObjectModel areaObject, boolean setDirty) {
        AreaObjectModel oldAreaObject = this.getAreaObject();
        if (oldAreaObject == areaObject) {
            return;
        }
        if (oldAreaObject != null) {
            oldAreaObject.removeDetaillessAreaObjectGeometrie(this);
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, DetaillessAreaObjectGeometryModelEnum.AREA_OBJECT.getPropertyName());
        }
        this.areaObject = areaObject;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(DetaillessAreaObjectGeometryModelEnum.AREA_OBJECT, areaObject, oldAreaObject);
        if (this.areaObject != null) {
            this.areaObject.addDetaillessAreaObjectGeometrie(this);
        }
    }

    @Override
    public Double getFromScale() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.fromScale;
    }

    @Override
    public void setFromScale(Double fromScale) {
        this.setFromScale(fromScale, true);
    }

    private void setFromScale(Double fromScale, boolean setDirty) {
        Double oldFromScale = this.getFromScale();
        if (new EqualsBuilder().append(oldFromScale, fromScale).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, DetaillessAreaObjectGeometryModelEnum.FROM_SCALE.getPropertyName());
        }
        this.fromScale = fromScale;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(DetaillessAreaObjectGeometryModelEnum.FROM_SCALE, fromScale, oldFromScale);
    }

    @Override
    public ImmutablePolygonKind getGeom() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.geom;
    }

    @Override
    public void setGeom(ImmutablePolygonKind geom) {
        this.setGeom(geom, true);
    }

    private void setGeom(ImmutablePolygonKind geom, boolean setDirty) {
        ImmutablePolygonKind oldGeom = this.getGeom();
        if (new EqualsBuilder().append(oldGeom, geom).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, DetaillessAreaObjectGeometryModelEnum.GEOM.getPropertyName());
        }
        this.geom = geom;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(DetaillessAreaObjectGeometryModelEnum.GEOM, geom, oldGeom);
    }

    @Override
    protected void updateByDto(DetaillessAreaObjectGeometryFullDto detaillessAreaObjectGeometryDto) {
        this.areaObject = (AreaObjectModel)this.getModelCache().getModel(detaillessAreaObjectGeometryDto.getAreaObject());
        this.fromScale = detaillessAreaObjectGeometryDto.getFromScale();
        ImmutablePolygonKindDto geom = detaillessAreaObjectGeometryDto.getGeom();
        this.geom = geom == null ? null : (ImmutablePolygonKind)geom.getGeoObject();
    }

    @Override
    protected void updateMasterRelationsByDto(DetaillessAreaObjectGeometryFullDto detaillessAreaObjectGeometryDto) {
    }

    @Override
    protected void checkStaleByDto(DetaillessAreaObjectGeometryFullDto detaillessAreaObjectGeometryDto) throws StaleStateException {
        AreaObjectModelImpl areaObjectModel;
        AreaObjectDto areaObjectDto = detaillessAreaObjectGeometryDto.getAreaObject();
        if (areaObjectDto != null && areaObjectDto.getId() != null && (areaObjectModel = (AreaObjectModelImpl)this.getModelCache().getModel(AreaObjectModel.class, areaObjectDto.getId())) != null) {
            areaObjectModel.checkStaleState(areaObjectDto);
        }
    }

    @Override
    public DetaillessAreaObjectGeometryFullDto createDto() {
        Long id = this.getId();
        DetaillessAreaObjectGeometryFullDto detaillessAreaObjectGeometryDto = id == null ? new DetaillessAreaObjectGeometryFullDto(this.getTempUUID()) : new DetaillessAreaObjectGeometryFullDto(id, this.getVersion());
        AreaObjectModelImpl areaObject = (AreaObjectModelImpl)this.getAreaObject();
        if (areaObject != null) {
            detaillessAreaObjectGeometryDto.setAreaObject(areaObject.createProxy());
        }
        detaillessAreaObjectGeometryDto.setFromScale(this.getFromScale());
        ImmutablePolygonKind geom = this.getGeom();
        detaillessAreaObjectGeometryDto.setGeom(ImmutablePolygonKindDto.create(geom));
        return detaillessAreaObjectGeometryDto;
    }

    @Override
    public DetaillessAreaObjectGeometryProxyDto createProxy() {
        Long id = this.getId();
        DetaillessAreaObjectGeometryProxyDto detaillessAreaObjectGeometryDto = id == null ? new DetaillessAreaObjectGeometryProxyDto(this.getTempUUID()) : new DetaillessAreaObjectGeometryProxyDto(id, this.getVersion());
        return detaillessAreaObjectGeometryDto;
    }

    public static enum DetaillessAreaObjectGeometryModelEnum {
        AREA_OBJECT("areaObject"),
        FROM_SCALE("fromScale"),
        GEOM("geom");

        private String propertyName;

        private DetaillessAreaObjectGeometryModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

